/*
 * Decompiled with CFR 0.152.
 */
package binTools;

import binTools.Common;
import binTools.XmlExporter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class BinReader
implements XmlExporter {
    private byte[] _binaryFile = null;
    private int _currentPos = 0;
    private Document _doc;
    private Element _head;
    private boolean _littleEndian;

    public BinReader(boolean littleEndian, String headName) {
        this._littleEndian = littleEndian;
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = null;
        try {
            docBuilder = docFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        if (docBuilder != null) {
            this._doc = docBuilder.newDocument();
            this._head = this._doc.createElement(headName);
            this._doc.appendChild(this._head);
        }
    }

    public BinReader(boolean littleEndian) {
        this(littleEndian, "File");
    }

    public void loadBinary(String filePath) {
        Path path = Paths.get(filePath, new String[0]);
        try {
            this._binaryFile = Files.readAllBytes(path);
            this._currentPos = 0;
        }
        catch (IOException e) {
            throw new UnsupportedOperationException(e.getMessage());
        }
    }

    public void setBinary(byte[] file) {
        this._binaryFile = file;
    }

    public byte[] getSubFile(int offset, int size, String name, Element parent) {
        byte[] res = new byte[size];
        for (int i = 0; i < res.length; ++i) {
            res[i] = this._binaryFile[offset + i];
        }
        if (name != null) {
            Element newElem = this._doc.createElement(name);
            if (size > 0) {
                newElem.setAttribute("Size", String.valueOf(size));
                newElem.setTextContent("<File Content>");
            }
            if (parent != null) {
                parent.appendChild(newElem);
            }
        }
        return res;
    }

    public byte[] readBytes(int size, String name, Element parent) {
        byte[] res = this.getSubFile(this._currentPos, size, name, parent);
        this._currentPos += size;
        return res;
    }

    private void parsingErrorHandler(Exception exception, Node parent) {
        try {
            if (this._doc == null || parent == null) {
                throw new Exception();
            }
            StringBuilder comment = new StringBuilder();
            comment.append("------------------------------------------------\n");
            comment.append("!Parsing Error!\nError: " + exception.getMessage() + "\n================= Stack trace:\n\n");
            for (StackTraceElement element : exception.getStackTrace()) {
                comment.append(element.toString() + "\n");
            }
            comment.append("------------------------------------------------");
            this.addComment(comment.toString(), parent);
        }
        catch (Exception e) {
            System.err.println("Parsing error: '" + e.getMessage() + "'\nCould not add error message to the PDT XML representation.");
            return;
        }
    }

    public Common.Field readString(String name, int size, Node parent) {
        try {
            if (this._binaryFile == null) {
                throw new Exception("File hasn't been initialized.");
            }
            if (this._doc == null) {
                throw new Exception("doc hasn't been initialized.");
            }
            byte[] data = new byte[size];
            for (int i = 0; i < data.length; ++i) {
                data[i] = this._binaryFile[this._currentPos + i];
            }
            this._currentPos += size;
            String value = new String(data);
            Element newElem = null;
            if (name != null) {
                newElem = this._doc.createElement(name);
                if (size > 0) {
                    newElem.setAttribute("Size", String.valueOf(size));
                    newElem.setTextContent(value);
                }
                if (parent != null) {
                    parent.appendChild(newElem);
                }
            }
            Common.Field field = new Common.Field();
            field.size = size;
            field.name = name;
            field.value = -1;
            field.strValue = value;
            field.xmlElement = newElem;
            field.offset = this._currentPos - size;
            return field;
        }
        catch (Exception e) {
            this.parsingErrorHandler(e, parent);
            throw new RuntimeException(e);
        }
    }

    public Common.Field readNewField(String name, int size, boolean signed, Node parent) {
        try {
            long longValue;
            int value;
            if (this._binaryFile == null) {
                throw new Exception("File hasn't been initialized.");
            }
            if (this._doc == null) {
                throw new Exception("doc hasn't been initialized.");
            }
            Common.Field field = new Common.Field();
            byte[] binary = this._littleEndian ? Common.getSubArray(this._binaryFile, this._currentPos, size) : Common.getReversedSubArray(this._binaryFile, this._currentPos, size);
            if (signed) {
                switch (size) {
                    case 1: {
                        value = Common.byteToSignedInt(this._binaryFile[this._currentPos]);
                        break;
                    }
                    case 2: {
                        value = Common.twoBytesFromArrToSignedInt(binary, 0);
                        break;
                    }
                    case 4: {
                        value = Common.fourBytesFromArrToSignedInt(binary, 0);
                        break;
                    }
                    default: {
                        throw new Exception("Invalid number of bytes to read.");
                    }
                }
                longValue = value;
            } else {
                value = Common.byteArrToInt(binary);
                longValue = Common.byteArrToLong(binary);
            }
            this._currentPos += size;
            Element newElem = null;
            if (name != null) {
                newElem = this._doc.createElement(name);
                if (size > 0) {
                    newElem.setAttribute("Size", String.valueOf(size));
                    newElem.setTextContent(String.valueOf((long)value));
                }
                if (parent != null) {
                    parent.appendChild(newElem);
                }
            }
            field.size = size;
            field.name = name;
            field.value = value;
            field.longValue = longValue;
            field.strValue = null;
            field.xmlElement = newElem;
            field.offset = this._currentPos - size;
            return field;
        }
        catch (Exception e) {
            this.parsingErrorHandler(e, parent);
            throw new RuntimeException(e);
        }
    }

    public Common.Field readNewField(String name, Node parent) {
        return this.readNewField(name, 0, false, parent);
    }

    public Common.Field readNewField(int size, boolean signed) {
        return this.readNewField(null, size, signed, null);
    }

    public void addComment(String comment, Node parent) {
        parent.appendChild(this._doc.createComment(comment));
    }

    public Element getHeadElement() {
        return this._head;
    }

    @Override
    public void exportXML(String path) throws TransformerException {
        Common.exportXmlDoc(this._doc, path);
    }

    public int getCurrentPos() {
        return this._currentPos;
    }
}

