/*
 * Decompiled with CFR 0.152.
 */
package binTools;

import java.io.File;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Common {
    public static byte[] getSubArray(byte[] data, int position, int size) {
        byte[] res = new byte[size];
        for (int i = 0; i < size; ++i) {
            res[i] = data[i + position];
        }
        return res;
    }

    public static byte[] getReversedSubArray(byte[] data, int position, int size) {
        byte[] res = new byte[size];
        for (int i = 0; i < size; ++i) {
            res[i] = data[size - 1 - i + position];
        }
        return res;
    }

    public static void exportXmlDoc(Document doc, String fileName) throws TransformerException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        DOMSource source = new DOMSource(doc);
        File dest = new File(fileName);
        StreamResult result = new StreamResult(dest);
        transformer.transform(source, result);
    }

    public static int getSubValueFromValue(int value, int startBit, int length) {
        StringBuilder binaryStr = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            String bit = (value & 1 << startBit + i) != 0 ? "1" : "0";
            binaryStr.insert(0, bit);
        }
        return Integer.parseInt(binaryStr.toString(), 2);
    }

    public static int byteToSignedInt(byte b) {
        int lastBit = b >> 7 & 1;
        int res = (int)((long)b & 0xFFL);
        if (res > 0 && lastBit == 1) {
            res = (int)((double)res - Math.pow(2.0, 8.0));
        }
        return res;
    }

    public static int twoBytesFromArrToSignedInt(byte[] bytes, int start) {
        int lastBit = bytes[start + 1] >> 7 & 1;
        int res = (bytes[start + 1] & 0xFF) << 8 | bytes[start] & 0xFF;
        if (res > 0 && lastBit == 1) {
            res = (int)((double)res - Math.pow(2.0, 16.0));
        }
        return res;
    }

    public static int fourBytesFromArrToSignedInt(byte[] bytes, int start) {
        int lastBit = bytes[bytes.length - 1] >> 7 & 1;
        int res = (bytes[start + 3] & 0xFF) << 24 | (bytes[start + 2] & 0xFF) << 16 | (bytes[start + 1] & 0xFF) << 8 | bytes[start] & 0xFF;
        if (res > 0 && lastBit == 1) {
            res = (int)((double)res - Math.pow(2.0, 16.0));
        }
        return res;
    }

    public static byte[] intToByteArr(int arrSize, int i) {
        byte[] result = new byte[arrSize];
        for (int j = arrSize - 1; j >= 0; --j) {
            result[j] = (byte)(i >> 8 * j);
        }
        return result;
    }

    public static byte[] intToByteArr(int i) {
        byte[] result = new byte[4];
        result[3] = (byte)(i >> 24);
        result[2] = (byte)(i >> 16);
        result[1] = (byte)(i >> 8);
        result[0] = (byte)i;
        return result;
    }

    public static byte[] longToByteArr(long i) {
        byte[] result = new byte[8];
        result[7] = (byte)(i >> 56);
        result[6] = (byte)(i >> 48);
        result[5] = (byte)(i >> 40);
        result[4] = (byte)(i >> 32);
        result[3] = (byte)(i >> 24);
        result[2] = (byte)(i >> 16);
        result[1] = (byte)(i >> 8);
        result[0] = (byte)i;
        return result;
    }

    public static int byteArrToInt(byte[] bytes) {
        int value = 0;
        for (int i = 0; i < bytes.length; ++i) {
            value = (int)((long)value + (((long)bytes[i] & 0xFFL) << 8 * i));
        }
        return value;
    }

    public static long byteArrToLong(byte[] bytes) {
        long value = 0L;
        for (int i = 0; i < bytes.length; ++i) {
            value += ((long)bytes[i] & 0xFFL) << 8 * i;
        }
        return value;
    }

    public static class Field {
        public int size;
        public String name;
        public int value;
        public String strValue;
        public Element xmlElement;
        public int offset;
        public long longValue;
    }
}

