/*
 * Decompiled with CFR 0.152.
 */
package dbgConfig;

import binTools.BinReader;
import binTools.BinWriter;
import binTools.Common;
import java.io.File;
import java.nio.file.AccessDeniedException;
import java.util.Arrays;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import pdtEditor.payloads.BusPayload;
import pdtEditor.payloads.BusPayloadI2c;
import pdtEditor.payloads.BusPayloadI3c;
import pdtEditor.payloads.BusPayloadSpi;
import pdtEditor.payloads.BusPayloadUart;

public class DbgConfig {
    public static final String DEFAULT_FILE_NAME = "trace_config";
    public static final String DEFAULT_XML_FILE_NAME = "trace_config.xml";
    private static final int FULL_DBG_DATA_SIZE = 40;
    private static final int ADDRESS_START_BIT = 17;
    private static final int ADDRESS_SIZE_IN_BITS = 7;
    private static final int I2C_PORT_START_BIT = 24;
    private static final int I2C_PORT_SIZE_IN_BITS = 2;
    private static final int I2C_DBG_ENABLED_BIT = 27;
    private static final int HOST_DBG_ENABLED_BIT = 28;
    private static final int LPK_ENABLED_BIT = 29;
    private static final int I2C_TRACE_ENABLED_BIT = 30;
    private static final int HOST_TRACE_ENABLED_BIT = 31;
    private static final int PARTIAL_DBG_DATA_MASK_DEFAULT_VALUE = -65536;
    private static final int TRACE_ENABLE_INTERFACE_HECI_BIT = 0;
    private static final int TRACE_ENABLE_INTERFACE_I2C_BIT = 1;
    private static final int TRACE_ENABLE_INTERFACE_LPK_BIT = 2;
    private static final int TRACE_ENABLE_INTERFACE_UART_BIT = 3;
    private static final int TRACE_ENABLE_INTERFACE_SPI_BIT = 4;
    private static final int TRACE_ENABLE_INTERFACE_DMA_BIT = 7;
    private static final int TRACE_MODE_BUFFER_ENABLED_BIT = 0;
    private static final int TRACE_MODE_BUFFER_CYCLIC_BIT = 1;
    private static final int TRACE_MODE_BUFFER_SELF_TRIGGERED_BIT = 2;
    private static final int TRACE_MODE_BLOCK_THREAD_BIT = 3;
    public static final int MAJOR_COMP_MAX = 16;
    public static final int MINOR_COMPONENT_MAX = 16;
    public static final int BUFFER_SIZE_MAX_VALUE = 16;
    public static final int I2C_PORT_MAX_VALUE = 3;
    public static final int LOG_EMERG = 0;
    public static final int LOG_ALERT = 1;
    public static final int LOG_CRIT = 2;
    public static final int LOG_ERR = 3;
    public static final int LOG_WARNING = 4;
    public static final int LOG_NOTICE = 5;
    public static final int LOG_INFO = 6;
    public static final int LOG_DEBUG = 7;
    private DbgConfigPlatform _platform;
    private String _fileName = "trace_config";
    private String _binPath;
    private String _xmlDest;
    private int _partialDbgDataMask = -65536;
    private boolean _i2cDbgEnable = false;
    private boolean _hostDbgEnable;
    private boolean _lpkTraceEnabled;
    private boolean _hostTraceEnabled;
    private boolean _dmaTraceEnabled;
    private boolean _traceModeBufferEnabled;
    private boolean _traceModeBufferCyclic;
    private boolean _traceModeBufferSelfTriggered;
    private boolean _traceModeBufferThread;
    private BusPayload _busInfo = null;
    private int _bufferSize;
    private int _lowestPriority;
    private int[] _compFilterMask = new int[16];

    public DbgConfig() {
        Arrays.fill(this._compFilterMask, 65535);
    }

    public boolean fileExists() {
        return new File(this._binPath).exists();
    }

    public BinReader readFile() {
        BinReader reader = new BinReader(true);
        reader.loadBinary(this._binPath);
        return reader;
    }

    public BinReader readBinaryData(byte[] data) {
        BinReader reader = new BinReader(true);
        reader.setBinary(data);
        return reader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readDbgConfig(BinReader reader) throws TransformerException {
        try {
            int speed;
            Element ishDbgConfig = reader.readNewField((String)"IshDbgConfig", (Node)reader.getHeadElement()).xmlElement;
            this.setPartialDbgDataValue(reader.readNewField((String)"PartialDbgData", (int)4, (boolean)false, (Node)ishDbgConfig).value);
            this._partialDbgDataMask = reader.readNewField((String)"PartialDbgDataMask", (int)4, (boolean)false, (Node)ishDbgConfig).value;
            Element fullDbgData = reader.readNewField((String)"FullDbgData", (Node)ishDbgConfig).xmlElement;
            int fullDbgDataSize = reader.readNewField((String)"FullDbgDataSize", (int)1, (boolean)false, (Node)fullDbgData).value;
            if (fullDbgDataSize != 40) {
                throw new RuntimeException("Full debug data size is different then the one recognized by the application");
            }
            int traceInterfaces = reader.readNewField((String)"TraceInterfaces", (int)1, (boolean)false, (Node)fullDbgData).value;
            if (this._hostTraceEnabled != ((traceInterfaces & 1) != 0) || (this._busInfo != null && this._busInfo instanceof BusPayloadI2c) != ((traceInterfaces & 2) != 0) || this._lpkTraceEnabled != ((traceInterfaces & 4) != 0)) {
                throw new RuntimeException("The trace interfaces data is different then the one given in the pratialDbgData.");
            }
            boolean uartEnabled = (traceInterfaces & 8) != 0;
            boolean spiTraceEnabled = (traceInterfaces & 0x10) != 0;
            int portValIssVersion = reader.readNewField((String)"portValAndIssVersion", (int)1, (boolean)false, (Node)fullDbgData).value;
            int i2cPort = Common.getSubValueFromValue(portValIssVersion, 0, 2);
            this._platform = DbgConfigPlatform.values()[Common.getSubValueFromValue(portValIssVersion, 2, 6)];
            int i2cAddress = Common.getSubValueFromValue(reader.readNewField((String)"I2cAddress", (int)1, (boolean)false, (Node)fullDbgData).value, 0, 7);
            if (this._busInfo != null && this._busInfo instanceof BusPayloadI2c && (i2cPort != this._busInfo.getBusIndex() || i2cAddress != this._busInfo.getBusAddress())) {
                throw new RuntimeException("The bus information in the full debug info is different then the one given in the partial debug info.");
            }
            int dbgEnableAndUartCfg = reader.readNewField((String)"HostDbgEnabled", (int)1, (boolean)false, (Node)fullDbgData).value;
            if ((dbgEnableAndUartCfg & 1) == 1 != this._hostDbgEnable) {
                throw new RuntimeException("The host dbg enabled data is different then the one given at host dbg enable.");
            }
            int uartPort = (dbgEnableAndUartCfg & 6) >> 1;
            int uartSpeed = (dbgEnableAndUartCfg & 0xF8) >> 3;
            int traceModeBuffer = reader.readNewField((String)"TraceMode", (int)1, (boolean)false, (Node)fullDbgData).value;
            this._traceModeBufferEnabled = (traceModeBuffer & 1) != 0;
            this._traceModeBufferCyclic = (traceModeBuffer & 2) != 0;
            this._traceModeBufferSelfTriggered = (traceModeBuffer & 4) != 0;
            this._traceModeBufferThread = (traceModeBuffer & 8) != 0;
            this._bufferSize = reader.readNewField((String)"BufferSize", (int)1, (boolean)false, (Node)fullDbgData).value;
            this._lowestPriority = Common.getSubValueFromValue(reader.readNewField((String)"LowestPriority", (int)1, (boolean)false, (Node)fullDbgData).value, 0, 3);
            reader.readNewField("Reserved", 1, false, fullDbgData);
            Element compFilterMask = reader.readNewField((String)"CompFilterMask", (Node)ishDbgConfig).xmlElement;
            for (int i = 0; i < 16; ++i) {
                this._compFilterMask[i] = reader.readNewField((String)new StringBuilder().append((String)"compFilterMask").append((int)(i + 1)).toString(), (int)2, (boolean)false, (Node)compFilterMask).value;
            }
            if (uartEnabled) {
                if (this._platform == DbgConfigPlatform.GALILEO) {
                    Element uartElement = reader.readNewField((String)"UartDetails", (Node)ishDbgConfig).xmlElement;
                    int firstByte = reader.readNewField((String)"UartByte1", (int)1, (boolean)false, (Node)uartElement).value;
                    int port = Common.getSubValueFromValue(firstByte, 0, 4);
                    speed = reader.readNewField((String)"UartSpeed", (int)1, (boolean)false, (Node)uartElement).value;
                    boolean flowControl = Common.getSubValueFromValue(firstByte, 4, 1) != 0;
                    reader.addComment("UartByte1 contents:\nport=" + port + "\nflowControl=" + flowControl, uartElement);
                    this._busInfo = new BusPayloadUart(port, speed, flowControl);
                    reader.readNewField("Reserved", 1, false, uartElement);
                } else {
                    this._busInfo = new BusPayloadUart(uartPort, uartSpeed, false);
                }
            }
            if (spiTraceEnabled) {
                Element spiElement = reader.readNewField((String)"SpiDetails", (Node)ishDbgConfig).xmlElement;
                int address = reader.readNewField((String)"BusAddress", (int)1, (boolean)false, (Node)spiElement).value;
                int secundByte = reader.readNewField((String)"SpiByte2", (int)1, (boolean)false, (Node)spiElement).value;
                speed = reader.readNewField((String)"SpiSpeed", (int)1, (boolean)false, (Node)spiElement).value;
                boolean csNative = Common.getSubValueFromValue(secundByte, 0, 1) != 0;
                int csPin = Common.getSubValueFromValue(secundByte, 1, 4);
                reader.addComment("SpiByte2 contents:\ncs native=" + csNative + "\ncs pin=" + csPin, spiElement);
                this._busInfo = new BusPayloadSpi(0, address, speed, csNative, csPin);
            }
        }
        finally {
            if (this._xmlDest != null) {
                reader.exportXML(this._xmlDest);
            }
        }
    }

    public BinWriter getBinWriter() {
        int dbgEnableAndUartCfg;
        BinWriter writer = new BinWriter(true);
        Element ishDbgConfig = writer.writeNewField((String)"IshDbgConfig", (Node)writer.getHeadElement()).xmlElement;
        writer.writeNewField("PartialDbgData", 4, this.getPartialDbgDataValue(), (Node)ishDbgConfig);
        writer.writeNewField("PartialDbgDataMask", 4, this._partialDbgDataMask, (Node)ishDbgConfig);
        Element fullDbgData = writer.writeNewField((String)"FullDbgData", (Node)ishDbgConfig).xmlElement;
        writer.writeNewField("FullDbgDataSize", 1, 40, (Node)fullDbgData);
        int traceInterfaces = 0;
        traceInterfaces |= this._hostTraceEnabled ? 1 : 0;
        traceInterfaces |= this._busInfo != null && this._busInfo instanceof BusPayloadI2c ? 2 : 0;
        traceInterfaces |= this._lpkTraceEnabled ? 4 : 0;
        traceInterfaces |= this._busInfo != null && this._busInfo instanceof BusPayloadUart ? 8 : 0;
        traceInterfaces |= this._busInfo != null && this._busInfo instanceof BusPayloadSpi ? 16 : 0;
        writer.writeNewField("TraceInterfaces", 1, traceInterfaces |= this._dmaTraceEnabled ? 128 : 0, (Node)fullDbgData);
        int i2cBusAndPlatform = 0;
        i2cBusAndPlatform |= this._busInfo != null && this._busInfo instanceof BusPayloadI2c ? this._busInfo.getBusIndex() : 0;
        if (this._platform != null) {
            i2cBusAndPlatform |= this._platform._value << 2;
        }
        writer.writeNewField("I2cBusAndPlatfrom", 1, i2cBusAndPlatform, (Node)fullDbgData);
        writer.writeNewField("I2cAddress", 1, this._busInfo != null && this._busInfo instanceof BusPayloadI2c ? this._busInfo.getBusAddress() : 0, (Node)fullDbgData);
        int n = dbgEnableAndUartCfg = this._hostDbgEnable ? 1 : 0;
        if (this._busInfo != null) {
            dbgEnableAndUartCfg |= this._busInfo.getBusIndex() << 1;
            dbgEnableAndUartCfg |= this._busInfo.getBusSpeed() << 3;
        }
        writer.writeNewField("HostDbgEnabled", 1, dbgEnableAndUartCfg, (Node)fullDbgData);
        int traceModeBuffer = 0;
        traceModeBuffer |= this._traceModeBufferEnabled ? 1 : 0;
        traceModeBuffer |= this._traceModeBufferCyclic ? 2 : 0;
        traceModeBuffer |= this._traceModeBufferSelfTriggered ? 4 : 0;
        writer.writeNewField("TraceMode", 1, traceModeBuffer |= this._traceModeBufferThread ? 8 : 0, (Node)fullDbgData);
        writer.writeNewField("BufferSize", 1, this._bufferSize, (Node)fullDbgData);
        writer.writeNewField("LowestPriority", 1, this._lowestPriority, (Node)fullDbgData);
        writer.writeNewField("Reserved", 1, 0, (Node)fullDbgData);
        Element compFilterMask = writer.writeNewField((String)"CompFilterMask", (Node)ishDbgConfig).xmlElement;
        for (int i = 0; i < 16; ++i) {
            writer.writeNewField("compFilterMask" + (i + 1), 2, this._compFilterMask[i], (Node)compFilterMask);
        }
        if (this._busInfo != null && this._busInfo instanceof BusPayloadUart && this._platform == DbgConfigPlatform.GALILEO) {
            Element uartElement = writer.writeNewField((String)"UartDetails", (Node)ishDbgConfig).xmlElement;
            int uartByte1 = 0;
            uartByte1 |= this._busInfo.getBusIndex() << 0;
            writer.writeNewField("UartByte1", 1, uartByte1 |= this._busInfo.isEnableRtsCts() ? 1 : 0, (Node)uartElement);
            writer.addComment("UartByte1 contents:\nport=" + this._busInfo.getBusIndex() + "\nflowControl=" + this._busInfo.isEnableRtsCts(), uartElement);
            writer.writeNewField("BaudRate", 1, this._busInfo.getBusSpeed(), (Node)uartElement);
            writer.writeNewField("Reserved", 1, 0, (Node)uartElement);
        }
        if (this._busInfo != null && this._busInfo instanceof BusPayloadSpi) {
            Element spiElement = writer.writeNewField((String)"SpiDetails", (Node)ishDbgConfig).xmlElement;
            writer.writeNewField("BusAddress", 1, this._busInfo.getBusAddress(), (Node)spiElement);
            int secundByte = 0;
            secundByte |= this._busInfo.isCsNative() ? 1 : 0;
            writer.writeNewField("SpiByte2", 1, secundByte |= this._busInfo.getCsPin() << 1, (Node)spiElement);
            writer.addComment("SpiByte2 contents:\ncs native=" + this._busInfo.isCsNative() + "\ncs pin=" + this._busInfo.getCsPin(), spiElement);
            writer.writeNewField("SpiSpeed", 1, this._busInfo.getBusSpeed(), (Node)spiElement);
        }
        if (this._busInfo != null && this._busInfo instanceof BusPayloadI3c) {
            Element spiElement = writer.writeNewField((String)"I3CDetails", (Node)ishDbgConfig).xmlElement;
            writer.writeNewField("AddressType", 1, ((BusPayloadI3c)this._busInfo).getAddressType(), (Node)spiElement);
            writer.writeNewField("DynamicAddress", 1, ((BusPayloadI3c)this._busInfo).getDynamicAddress(), (Node)spiElement);
        }
        return writer;
    }

    public void writeDbgConfig() throws AccessDeniedException, TransformerException {
        BinWriter writer = this.getBinWriter();
        writer.createBin(this._binPath);
        writer.exportXML(this._xmlDest);
    }

    private void setPartialDbgDataValue(int value) {
        int i2cAddress = Common.getSubValueFromValue(value, 17, 7);
        int i2cPort = Common.getSubValueFromValue(value, 24, 2);
        this._i2cDbgEnable = (value & 0x8000000) != 0;
        this._hostDbgEnable = (value & 0x10000000) != 0;
        this._lpkTraceEnabled = (value & 0x20000000) != 0;
        boolean i2cTraceEnabled = (value & 0x40000000) != 0;
        boolean bl = this._hostTraceEnabled = (value & Integer.MIN_VALUE) != 0;
        if (i2cTraceEnabled) {
            this._busInfo = new BusPayloadI2c(i2cPort, i2cAddress, 0);
        }
    }

    private int getPartialDbgDataValue() {
        int res = 0;
        String i2cAddressStr = "00000000" + (this._busInfo != null && this._busInfo instanceof BusPayloadI2c ? Integer.toBinaryString(this._busInfo.getBusAddress()) : "");
        i2cAddressStr = i2cAddressStr.substring(i2cAddressStr.length() - 7);
        for (int i = 0; i < 7; ++i) {
            res |= i2cAddressStr.charAt(i2cAddressStr.length() - 1 - i) == '1' ? 1 << 17 + i : 0;
        }
        String i2cPortStr = "00000000" + Integer.toBinaryString(this._busInfo != null && this._busInfo instanceof BusPayloadI2c ? this._busInfo.getBusIndex() : 0);
        i2cPortStr = i2cPortStr.substring(i2cPortStr.length() - 2 - 1);
        for (int i = 0; i < 2; ++i) {
            res |= i2cPortStr.charAt(i2cPortStr.length() - 1 - i) == '1' ? 1 << 24 + i : 0;
        }
        res |= this._i2cDbgEnable ? 0x8000000 : 0;
        res |= this._hostDbgEnable ? 0x10000000 : 0;
        res |= this._lpkTraceEnabled ? 0x20000000 : 0;
        res |= this._busInfo != null && this._busInfo instanceof BusPayloadI2c ? 0x40000000 : 0;
        return res |= this._hostTraceEnabled ? Integer.MIN_VALUE : 0;
    }

    public DbgConfigPlatform getPlatform() {
        return this._platform;
    }

    public void setPlatfrom(String name) {
        for (DbgConfigPlatform platfrom : DbgConfigPlatform.values()) {
            if (!platfrom.getName().equals(name)) continue;
            this._platform = platfrom;
            return;
        }
        throw new UnsupportedOperationException("No such platfrom name");
    }

    public void setFileName(String fileName) {
        this._fileName = fileName;
    }

    public String getFileName() {
        return this._fileName;
    }

    public void setBinPath(String path) {
        this._binPath = path;
    }

    public String getBinPath() {
        return this._binPath;
    }

    public void setXmlPath(String path) {
        this._xmlDest = path;
    }

    public String getXmlPath() {
        return this._xmlDest;
    }

    public int getPartialDbgDataMask() {
        return this._partialDbgDataMask;
    }

    public void setPartialDbgDataMask(int partialDbgDataMask) {
        this._partialDbgDataMask = partialDbgDataMask;
    }

    public boolean isI2cDbgEnable() {
        return this._i2cDbgEnable;
    }

    public void setI2cDbgEnable(boolean i2cDbgEnable) {
        this._i2cDbgEnable = i2cDbgEnable;
    }

    public boolean isHostDbgEnable() {
        return this._hostDbgEnable;
    }

    public void setHostDbgEnable(boolean hostDbgEnable) {
        this._hostDbgEnable = hostDbgEnable;
    }

    public boolean isLpkEnabled() {
        return this._lpkTraceEnabled;
    }

    public void setLpkEnabled(boolean lpkEnabled) {
        this._lpkTraceEnabled = lpkEnabled;
    }

    public boolean isHostTraceEnabled() {
        return this._hostTraceEnabled;
    }

    public boolean isUartTraceEnabled() {
        return this._busInfo != null && this._busInfo instanceof BusPayloadUart;
    }

    public boolean isSpiTraceEnabled() {
        return this._busInfo != null && this._busInfo instanceof BusPayloadSpi;
    }

    public void setHostTraceEnabled(boolean hostTraceEnabled) {
        this._hostTraceEnabled = hostTraceEnabled;
    }

    public boolean isTraceModeBufferEnabled() {
        return this._traceModeBufferEnabled;
    }

    public void setTraceModeBufferEnabled(boolean traceModeBufferEnabled) {
        this._traceModeBufferEnabled = traceModeBufferEnabled;
    }

    public boolean isTraceModeBufferCyclic() {
        return this._traceModeBufferCyclic;
    }

    public void setTraceModeBufferCyclic(boolean traceModeBufferCyclic) {
        this._traceModeBufferCyclic = traceModeBufferCyclic;
    }

    public boolean isTraceModeBufferSelfTriggered() {
        return this._traceModeBufferSelfTriggered;
    }

    public void setTraceModeBufferSelfTriggered(boolean traceModeBufferSelfTriggered) {
        this._traceModeBufferSelfTriggered = traceModeBufferSelfTriggered;
    }

    public boolean isTraceModeBufferThread() {
        return this._traceModeBufferThread;
    }

    public void setTraceModeBufferThread(boolean traceModeBufferThread) {
        this._traceModeBufferThread = traceModeBufferThread;
    }

    public int getBufferSize() {
        return this._bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        this._bufferSize = bufferSize;
    }

    public int getLowestPriority() {
        return this._lowestPriority;
    }

    public void setLowestPriority(int lowestPriority) {
        this._lowestPriority = lowestPriority;
    }

    public int getComponentFilterSize() {
        return this._compFilterMask.length;
    }

    public BusPayload getBusInfo() {
        return this._busInfo;
    }

    public void setBusInfo(BusPayload bus) {
        this._busInfo = bus;
    }

    public boolean[] getComponentFilterMajorContent(int majorComponentId) {
        boolean[] checkedComponents = new boolean[16];
        int content = this._compFilterMask[majorComponentId];
        for (int i = 0; i < checkedComponents.length; ++i) {
            checkedComponents[i] = (content & 1 << i) != 0;
        }
        return checkedComponents;
    }

    public void setComponentFilterMajorContent(int majorId, boolean[] majorContent) {
        for (int j = 0; j < majorContent.length; ++j) {
            this._compFilterMask[majorId] = majorContent[j] ? this._compFilterMask[majorId] | 1 << j : this._compFilterMask[majorId] & ~(1 << j);
        }
    }

    public byte[] getBinaryContent() {
        BinWriter writer = this.getBinWriter();
        return writer.getBinaryContent();
    }

    public static enum DbgConfigPlatform {
        ISS23(0, "Cherryview / Skylake / Kaby Lake"),
        BROXTON(1, "Broxton / Cannon Lake"),
        GALILEO(2, "Galileo"),
        ICE_LAKE(3, "Ice Lake");

        int _value;
        String _name;

        private DbgConfigPlatform(int value, String name) {
            this._value = value;
            this._name = name;
        }

        public String getName() {
            return this._name;
        }
    }
}

