/*
 * Decompiled with CFR 0.152.
 */
package dbgConfig;

import dbgConfig.DbgConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.wb.swt.SWTResourceManager;
import pdtEditor.BiMap;
import pdtEditor.DataStore;
import pdtEditor.IMainWindow;
import pdtEditor.InformationStore;
import pdtEditor.gui.BusInfo;
import pdtEditor.gui.GuiUtils;
import pdtEditor.payloads.BusPayload;
import resources.CustomSpinner;

public class DbgConfigGui {
    protected Shell shlDebugConfigurations;
    private Button btnSaveAndClose;
    private Button btnCancel;
    private Button btnTraceModeBufferEnabled;
    private Button btnTraceModeBufferCyclic;
    private Button btnTraceModeBlockThread;
    private Button btnEnableTraceOverHost;
    private Button btnEnableTraceOverBus;
    private Button btnEnableTraceOverLPK;
    private Button btnEnableDebugAgentOverHost;
    private DbgConfig _data;
    private Display display;
    private Button btnRemoveAndClose;
    private CustomSpinner spnBufferSize;
    private Label lblBufferSize;
    private Group grpPriority;
    private Button btnPriorityEmergency;
    private Button btnPriorityAlert;
    private Button btnPriorityCritical;
    private Button btnPriorityError;
    private Button btnPriorityWarning;
    private Button btnPriorityNotice;
    private Button btnPriorityInfo;
    private Button btnPriorityDebug;
    private Group grpComponentFilter;
    private CheckboxTreeViewer checkboxTreeViewer;
    private Tree tree;
    private IMainWindow _parent;
    private Combo platform;
    private BusInfo _busInfo;
    GuiUtils.WindowProperties _properties = new GuiUtils.WindowProperties(){

        @Override
        protected void onModification() {
        }
    };

    public static void main(String[] args) {
        try {
            DbgConfigGui window = new DbgConfigGui(DataStore.getInstance().getDbgConfigData(), null);
            window.open();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public DbgConfigGui(IMainWindow parent) {
        this._parent = parent;
    }

    public DbgConfigGui(DbgConfig data, IMainWindow parent) {
        this._data = data;
        this._parent = parent;
    }

    public void open() {
        this.display = Display.getDefault();
        this.createContents();
        this.fillData();
        this.shlDebugConfigurations.open();
        this.shlDebugConfigurations.layout();
        while (!this.shlDebugConfigurations.isDisposed()) {
            if (this.display.readAndDispatch()) continue;
            this.display.sleep();
        }
    }

    public void onTreeItemSelect(TreeItem item) {
        this._properties.setModified(true);
        if (item != null) {
            for (TreeItem subItem : item.getItems()) {
                subItem.setChecked(item.getChecked());
            }
            TreeItem parent = item.getParentItem();
            if (parent != null) {
                for (TreeItem iterItem : parent.getItems()) {
                    if (!iterItem.getChecked()) {
                        parent.setChecked(false);
                        break;
                    }
                    parent.setChecked(true);
                }
            }
        }
    }

    public void buildComponentFilterTree() {
        this.tree.removeAll();
        InformationStore infoStore = null;
        try {
            infoStore = InformationStore.getInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (infoStore == null) {
            System.err.println("Unable to load the information store");
            return;
        }
        HashMap<Integer, String> filterMaskParents = infoStore.getAllDebugConfFilterMaskNames();
        for (Integer id : filterMaskParents.keySet()) {
            TreeItem item = new TreeItem(this.tree, 0);
            item.setText(new String[]{filterMaskParents.get(id)});
            BiMap<Integer, String> subComponents = infoStore.getDebugConfFilterMaskChilds(id);
            if (subComponents != null) {
                for (Integer subId : subComponents.getForwardMap().keySet()) {
                    TreeItem subItem = new TreeItem(item, 0);
                    subItem.setText(new String[]{subComponents.getForward(subId)});
                }
            }
            item.setExpanded(false);
            item.setChecked(true);
            this.onTreeItemSelect(item);
            this.tree.addListener(3, new Listener(){

                public void handleEvent(Event event) {
                    Point point = new Point(event.x, event.y);
                    TreeItem item = DbgConfigGui.this.tree.getItem(point);
                    DbgConfigGui.this.onTreeItemSelect(item);
                }
            });
        }
    }

    public void adjustWindowToPlatfrom() {
        try {
            this.btnSaveAndClose.setEnabled(true);
            ArrayList<String> possibleBusTypes = new ArrayList<String>();
            boolean traceOverHostEnabled = true;
            boolean traceModeEnabled = true;
            if (this.platform.getText().equals(DbgConfig.DbgConfigPlatform.GALILEO.getName())) {
                possibleBusTypes.add("UART");
                possibleBusTypes.add("SPI");
                traceOverHostEnabled = false;
                traceModeEnabled = false;
                this.btnEnableTraceOverHost.setSelection(false);
            } else if (this.platform.getText().equals(DbgConfig.DbgConfigPlatform.ICE_LAKE.getName())) {
                possibleBusTypes.add("I2C");
                possibleBusTypes.add("UART");
            } else {
                possibleBusTypes.add("I2C");
            }
            if (this.platform.getText().equals(DbgConfig.DbgConfigPlatform.BROXTON.getName()) || this.platform.getText().equals(DbgConfig.DbgConfigPlatform.ICE_LAKE.getName())) {
                this.btnEnableTraceOverLPK.setEnabled(true);
            } else {
                this.btnEnableTraceOverLPK.setEnabled(false);
                this.btnEnableTraceOverLPK.setSelection(false);
            }
            InformationStore infoStore = InformationStore.getInstance();
            if (this._busInfo != null) {
                this._busInfo.filterBusTypes(possibleBusTypes);
                this._busInfo.setBusSpeedFilter(infoStore.getDebugConfigRelevantBusSpeeds());
                if (this.btnEnableTraceOverBus.getSelection()) {
                    BusPayload busPayload = this._busInfo.busPayloadFromFields();
                    if (busPayload != null) {
                        if (!possibleBusTypes.contains(busPayload.getBusTypeName())) {
                            this._busInfo.clear();
                        }
                    } else {
                        this._busInfo.clear();
                    }
                } else {
                    this._busInfo.clear();
                }
                this._busInfo.setEnabled(this.btnEnableTraceOverBus.getSelection());
            }
            this.btnEnableTraceOverHost.setEnabled(traceOverHostEnabled);
            this.btnTraceModeBufferEnabled.setEnabled(traceModeEnabled);
            this.btnTraceModeBufferCyclic.setEnabled(traceModeEnabled && this.btnTraceModeBufferEnabled.getSelection());
            this.spnBufferSize.setEnabled(traceModeEnabled && this.btnTraceModeBufferEnabled.getSelection());
            this.lblBufferSize.setEnabled(traceModeEnabled && this.btnTraceModeBufferEnabled.getSelection());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void fillData() {
        this.buildComponentFilterTree();
        if (this._data == null) {
            this.btnRemoveAndClose.setEnabled(false);
            return;
        }
        this.btnRemoveAndClose.setEnabled(true);
        if (this._data.getPlatform() != null) {
            for (int i = 0; i < this.platform.getItemCount(); ++i) {
                if (!this.platform.getItem(i).equals(this._data.getPlatform().getName())) continue;
                this.platform.select(i);
                break;
            }
        }
        this.adjustWindowToPlatfrom();
        this.btnEnableTraceOverHost.setSelection(this._data.isHostTraceEnabled());
        this.btnEnableTraceOverLPK.setSelection(this._data.isLpkEnabled());
        this.btnEnableDebugAgentOverHost.setSelection(this._data.isHostDbgEnable());
        this.btnEnableTraceOverBus.setSelection(this._data.getBusInfo() != null);
        if (this._busInfo != null) {
            this._busInfo.setEnabled(this.btnEnableTraceOverBus.getSelection());
            if (this._data.getBusInfo() != null) {
                this._busInfo.fillData(this._data.getBusInfo());
            }
        }
        this.btnTraceModeBufferEnabled.setSelection(this._data.isTraceModeBufferEnabled());
        this.btnTraceModeBufferCyclic.setSelection(this._data.isTraceModeBufferCyclic());
        this.btnTraceModeBufferCyclic.setEnabled(this.btnTraceModeBufferEnabled.getSelection());
        this.spnBufferSize.setEnabled(this.btnTraceModeBufferEnabled.getSelection());
        this.lblBufferSize.setEnabled(this.btnTraceModeBufferEnabled.getSelection());
        this.btnTraceModeBlockThread.setSelection(this._data.isTraceModeBufferThread());
        this.spnBufferSize.setSelection(this._data.getBufferSize());
        this.btnPriorityEmergency.setSelection(false);
        this.btnPriorityAlert.setSelection(false);
        this.btnPriorityCritical.setSelection(false);
        this.btnPriorityError.setSelection(false);
        this.btnPriorityWarning.setSelection(false);
        this.btnPriorityNotice.setSelection(false);
        this.btnPriorityInfo.setSelection(false);
        this.btnPriorityDebug.setSelection(false);
        switch (this._data.getLowestPriority()) {
            case 0: {
                this.btnPriorityEmergency.setSelection(true);
                break;
            }
            case 1: {
                this.btnPriorityAlert.setSelection(true);
                break;
            }
            case 2: {
                this.btnPriorityCritical.setSelection(true);
                break;
            }
            case 3: {
                this.btnPriorityError.setSelection(true);
                break;
            }
            case 4: {
                this.btnPriorityWarning.setSelection(true);
                break;
            }
            case 5: {
                this.btnPriorityNotice.setSelection(true);
                break;
            }
            case 6: {
                this.btnPriorityInfo.setSelection(true);
                break;
            }
            case 7: {
                this.btnPriorityDebug.setSelection(true);
                break;
            }
        }
        TreeItem[] treeItems = this.tree.getItems();
        for (int i = 0; i < treeItems.length; ++i) {
            boolean[] componenFilterMajor = this._data.getComponentFilterMajorContent(i);
            if (i > componenFilterMajor.length || treeItems[i] == null) continue;
            for (int j = 0; j < treeItems[i].getItemCount(); ++j) {
                TreeItem subItem = treeItems[i].getItem(j);
                subItem.setChecked(componenFilterMajor[j]);
                if (componenFilterMajor[j] && !treeItems[i].getChecked()) {
                    treeItems[i].setExpanded(true);
                }
                this.onTreeItemSelect(subItem);
            }
        }
        this._properties.setModified(false);
    }

    public void saveData() {
        DbgConfig data = new DbgConfig();
        if (this.btnEnableTraceOverBus.getSelection()) {
            try {
                data.setBusInfo(this._busInfo.busPayloadFromFields());
            }
            catch (Exception e) {
                e.printStackTrace();
                MessageBox messageBox = new MessageBox(this.shlDebugConfigurations, 513);
                messageBox.setText("Invalid Bus Information");
                messageBox.setMessage(e.getMessage());
                messageBox.open();
                return;
            }
            if (data.getBusInfo() == null) {
                MessageBox messageBox = new MessageBox(this.shlDebugConfigurations, 513);
                messageBox.setText("Invalid Bus Information");
                messageBox.setMessage("Please enter the bus information.");
                messageBox.open();
                return;
            }
        } else {
            data.setBusInfo(null);
        }
        data.setPlatfrom(this.platform.getText());
        if (this.btnEnableTraceOverHost.isEnabled()) {
            data.setHostTraceEnabled(this.btnEnableTraceOverHost.getSelection());
        }
        if (this.btnEnableTraceOverLPK.isEnabled()) {
            data.setLpkEnabled(this.btnEnableTraceOverLPK.getSelection());
        }
        data.setHostDbgEnable(this.btnEnableDebugAgentOverHost.getSelection());
        if (this.btnTraceModeBufferEnabled.isEnabled()) {
            data.setTraceModeBufferEnabled(this.btnTraceModeBufferEnabled.getSelection());
        }
        if (this.btnTraceModeBufferCyclic.isEnabled()) {
            data.setTraceModeBufferCyclic(this.btnTraceModeBufferCyclic.getSelection());
        }
        data.setTraceModeBufferThread(this.btnTraceModeBlockThread.getSelection());
        if (this.spnBufferSize.isEnabled()) {
            data.setBufferSize(this.spnBufferSize.getSelection());
        }
        if (this.btnPriorityEmergency.getSelection()) {
            data.setLowestPriority(0);
        } else if (this.btnPriorityAlert.getSelection()) {
            data.setLowestPriority(1);
        } else if (this.btnPriorityCritical.getSelection()) {
            data.setLowestPriority(2);
        } else if (this.btnPriorityError.getSelection()) {
            data.setLowestPriority(3);
        } else if (this.btnPriorityWarning.getSelection()) {
            data.setLowestPriority(4);
        } else if (this.btnPriorityNotice.getSelection()) {
            data.setLowestPriority(5);
        } else if (this.btnPriorityInfo.getSelection()) {
            data.setLowestPriority(6);
        } else if (this.btnPriorityDebug.getSelection()) {
            data.setLowestPriority(7);
        }
        TreeItem[] treeItems = this.tree.getItems();
        for (int i = 0; i < treeItems.length; ++i) {
            boolean[] componenFilterMajor = new boolean[16];
            Arrays.fill(componenFilterMajor, true);
            if (i > componenFilterMajor.length) continue;
            if (treeItems[i] != null) {
                for (int j = 0; j < treeItems[i].getItemCount(); ++j) {
                    TreeItem subItem = treeItems[i].getItem(j);
                    componenFilterMajor[j] = subItem.getChecked();
                }
            }
            data.setComponentFilterMajorContent(i, componenFilterMajor);
        }
        DataStore.getInstance().setDbgConfigData(data);
        this._properties.setModified(false);
        this._parent.setModified();
        this.shlDebugConfigurations.close();
    }

    public void removeAndClose() {
        MessageBox messageBox = new MessageBox(this.shlDebugConfigurations, 200);
        messageBox.setText("Removing All The Debug Configurations");
        messageBox.setMessage("Are you sure that you want to remove all the debug configurations?");
        if (messageBox.open() != 64) {
            return;
        }
        DataStore.getInstance().setDbgConfigData(null);
        this._properties.setModified(false);
        this._parent.setModified();
        this.shlDebugConfigurations.close();
    }

    public void onFieldModification() {
        this.btnSaveAndClose.setEnabled(true);
        this._properties.setModified(true);
    }

    protected void createContents() {
        String priorityTooltip = "This is a list of message types, in descending order of importance. The trace agent will receive all messages of the selected type and higher.";
        String componentToolTip = "Only messages originating from the selected components will be transmitted.";
        this.shlDebugConfigurations = new Shell(65760);
        this.shlDebugConfigurations.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent arg0) {
                if (DbgConfigGui.this._properties.isModified()) {
                    MessageBox messageBox = new MessageBox(DbgConfigGui.this.shlDebugConfigurations, 296);
                    messageBox.setText("Unsaved Changes");
                    messageBox.setMessage("Some changes will be lost. Are you sure that you want to close the window?");
                    if (messageBox.open() != 32) {
                        arg0.doit = false;
                        return;
                    }
                }
            }
        });
        this.shlDebugConfigurations.setImage(SWTResourceManager.getImage(DbgConfigGui.class, "/resources/Intel.ico"));
        this.shlDebugConfigurations.setText("Debug Configuration");
        GuiUtils.setGridLayoutToComposite((Composite)this.shlDebugConfigurations, 2);
        Group grpView = GuiUtils.addGroupToComposite("Platform", (Composite)this.shlDebugConfigurations, 0, 4, 4, true, true, 2, 1, 2);
        this.platform = GuiUtils.addComboToComposite((Composite)grpView, 8, 4, 4, false, false, 2, 1);
        Group grpTraceInterface = GuiUtils.addGroupToComposite("Trace Interfaces", (Composite)this.shlDebugConfigurations, 0, 4, 4, true, false, 1, 1, 1);
        this.btnEnableTraceOverHost = GuiUtils.addButtonToComposite("Trace over host", "Transmit trace information to a trace tool located on the same device as the Intel Integrated Sensor Solution.", (Composite)grpTraceInterface, 32, 16384, 0x1000000, false, false, 1, 1);
        this.btnEnableTraceOverLPK = GuiUtils.addButtonToComposite("Trace over Intel\u00ae Trace Hub", "Use the Intel\u00ae Trace Hub connection to transmit trace information to another device that is connected via USB.", (Composite)grpTraceInterface, 32, 16384, 0x1000000, false, false, 1, 1);
        this.btnEnableTraceOverBus = GuiUtils.addButtonToComposite("Trace over I/O bus", "Use an I2C, UART, or SPI bus to transmit trace information.", (Composite)grpTraceInterface, 32, 16384, 0x1000000, false, false, 1, 1);
        this._busInfo = null;
        try {
            this._busInfo = new BusInfo(this._properties);
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        this._busInfo.drawBusInfo(this.shlDebugConfigurations, (Composite)grpTraceInterface);
        this._busInfo.setEnabled(false);
        this._busInfo.disableSpeedForType("I2C");
        this._busInfo.disableInstanceForType("SPI");
        this._busInfo.setIsForceDisableRtsCts(true);
        this.grpPriority = GuiUtils.addGroupToComposite("Lowest Priority", (Composite)this.shlDebugConfigurations, 0, 131072, 4, false, false, 1, 1, 1);
        this.btnPriorityEmergency = GuiUtils.addButtonToComposite("Emergency", "This is a list of message types, in descending order of importance. The trace agent will receive all messages of the selected type and higher.", (Composite)this.grpPriority, 16, 16384, 16384, false, false, 1, 1);
        this.btnPriorityAlert = GuiUtils.addButtonToComposite("Alert", "This is a list of message types, in descending order of importance. The trace agent will receive all messages of the selected type and higher.", (Composite)this.grpPriority, 16, 16384, 16384, false, false, 1, 1);
        this.btnPriorityCritical = GuiUtils.addButtonToComposite("Critical", "This is a list of message types, in descending order of importance. The trace agent will receive all messages of the selected type and higher.", (Composite)this.grpPriority, 16, 16384, 16384, false, false, 1, 1);
        this.btnPriorityError = GuiUtils.addButtonToComposite("Error", "This is a list of message types, in descending order of importance. The trace agent will receive all messages of the selected type and higher.", (Composite)this.grpPriority, 16, 16384, 16384, false, false, 1, 1);
        this.btnPriorityWarning = GuiUtils.addButtonToComposite("Warning", "This is a list of message types, in descending order of importance. The trace agent will receive all messages of the selected type and higher.", (Composite)this.grpPriority, 16, 16384, 16384, false, false, 1, 1);
        this.btnPriorityNotice = GuiUtils.addButtonToComposite("Notice", "This is a list of message types, in descending order of importance. The trace agent will receive all messages of the selected type and higher.", (Composite)this.grpPriority, 16, 16384, 16384, false, false, 1, 1);
        this.btnPriorityInfo = GuiUtils.addButtonToComposite("Info", "This is a list of message types, in descending order of importance. The trace agent will receive all messages of the selected type and higher.", (Composite)this.grpPriority, 16, 16384, 16384, false, false, 1, 1);
        this.btnPriorityDebug = GuiUtils.addButtonToComposite("Debug", "This is a list of message types, in descending order of importance. The trace agent will receive all messages of the selected type and higher.", (Composite)this.grpPriority, 16, 16384, 16384, false, false, 1, 1);
        Composite compositeThirdRow = GuiUtils.addCompositeToComposite((Composite)this.shlDebugConfigurations, 0, 4, 4, true, false, 2, 1, 2);
        Group grpTraceMode = GuiUtils.addGroupToComposite("Trace Mode", compositeThirdRow, 0, 4, 4, false, false, 1, 1, 3);
        this.btnTraceModeBufferEnabled = GuiUtils.addButtonToComposite("Buffer", "The trace module includes a buffer, which can be used to prevent loss of messages that come in too rapidly to be sent.", (Composite)grpTraceMode, 32, 16384, 16384, false, false, 2, 1);
        Label lblHiddenBehindBuffer = GuiUtils.addLabelToComposite("", (Composite)grpTraceMode, 0, 16384, 0x1000000, false, false, 1, 1);
        Label lblHiddenBehindCyclic = GuiUtils.addLabelToComposite("", (Composite)grpTraceMode, 0, 16384, 0x1000000, false, false, 1, 1);
        this.btnTraceModeBufferCyclic = GuiUtils.addButtonToComposite("Cyclic", "If the buffer is full and a new message comes in, overwrite the oldest message instead of discarding the new one.", (Composite)grpTraceMode, 32, 16384, 16384, false, false, 2, 1);
        this.lblBufferSize = GuiUtils.addLabelToComposite("Buffer size:", (Composite)grpTraceMode, 0, 16384, 0x1000000, false, false, 2, 1);
        this.spnBufferSize = GuiUtils.addCustomSpinnerToComposite(16, this.shlDebugConfigurations, (Composite)grpTraceMode, 2048, 4, 16384, true, false, 1, 1);
        GuiUtils.addLabelToComposite("", (Composite)grpTraceMode, 258, 4, 0x1000000, true, false, 3, 1);
        this.btnTraceModeBlockThread = GuiUtils.addButtonToComposite("Thread blocking", "Whenever a trace message is sent, the firmware should wait for it to be received before continuing to run.", (Composite)grpTraceMode, 32, 16384, 16384, false, false, 3, 1);
        this.platform.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                if (DbgConfigGui.this.platform.getSelectionIndex() >= 0) {
                    DbgConfigGui.this.adjustWindowToPlatfrom();
                }
            }
        });
        this.platform.removeAll();
        for (DbgConfig.DbgConfigPlatform platformValue : DbgConfig.DbgConfigPlatform.values()) {
            this.platform.add(platformValue.getName());
        }
        this.platform.select(0);
        SelectionListener onButtonSelect = new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                DbgConfigGui.this.onFieldModification();
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
                DbgConfigGui.this.onFieldModification();
            }
        };
        this.btnTraceModeBufferEnabled.addSelectionListener(onButtonSelect);
        this.btnTraceModeBufferCyclic.addSelectionListener(onButtonSelect);
        lblHiddenBehindBuffer.setVisible(false);
        lblHiddenBehindCyclic.setVisible(false);
        this.spnBufferSize.setToolTipText("The size of the buffer, in bytes.");
        this.spnBufferSize.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                DbgConfigGui.this._properties.setModified(true);
            }
        });
        this.btnTraceModeBufferEnabled.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                DbgConfigGui.this.btnTraceModeBufferCyclic.setEnabled(DbgConfigGui.this.btnTraceModeBufferEnabled.getSelection());
                DbgConfigGui.this.lblBufferSize.setEnabled(DbgConfigGui.this.btnTraceModeBufferEnabled.getSelection());
                DbgConfigGui.this.spnBufferSize.setEnabled(DbgConfigGui.this.btnTraceModeBufferEnabled.getSelection());
            }
        });
        this.btnTraceModeBlockThread.addSelectionListener(onButtonSelect);
        this.grpComponentFilter = GuiUtils.addGroupToComposite("Components", compositeThirdRow, 0, 4, 4, true, false, 1, 2, 1);
        this.tree = GuiUtils.addTreeToComposite("Only messages originating from the selected components will be transmitted.", (Composite)this.grpComponentFilter, 2848, 4, 4, true, true, 1, 1);
        Group grpDebugConfig = GuiUtils.addGroupToComposite("Debug Config", compositeThirdRow, 0, 4, 4, false, false, 1, 1, 1);
        this.btnEnableDebugAgentOverHost = GuiUtils.addButtonToComposite("Enable debug agent over host", "Allow a debugging agent full read and write access to the firmware. (You will also need to separately activate this setting in the BIOS or using a secure token, depending on your platform.) ", (Composite)grpDebugConfig, 32, 16384, 16384, false, false, 1, 1);
        Composite compositeButton = GuiUtils.addCompositeToComposite((Composite)this.shlDebugConfigurations, 0, 131072, 4, true, false, 2, 1, 3);
        this.btnSaveAndClose = GuiUtils.addButtonToComposite("Save and Close", "Save the current debug configuration.", compositeButton, 0, 131072, 0x1000000, false, false, 1, 1);
        this.btnRemoveAndClose = GuiUtils.addButtonToComposite("Remove and Close", "Do not create a trace_config file at all when saving this PDT binary file.", compositeButton, 0, 131072, 0x1000000, false, false, 1, 1);
        this.btnCancel = GuiUtils.addButtonToComposite("Cancel", "Close the window and cancel all changes.", compositeButton, 0, 131072, 0x1000000, false, false, 1, 1);
        this.btnSaveAndClose.setEnabled(false);
        this.btnSaveAndClose.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                DbgConfigGui.this.saveData();
            }
        });
        this.btnCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                DbgConfigGui.this.shlDebugConfigurations.close();
            }
        });
        this.btnRemoveAndClose.setEnabled(false);
        this.btnRemoveAndClose.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                DbgConfigGui.this.removeAndClose();
            }
        });
        this.btnPriorityEmergency.setSelection(true);
        this.grpComponentFilter.setToolTipText("Only messages originating from the selected components will be transmitted.");
        this.btnEnableTraceOverHost.addSelectionListener(onButtonSelect);
        this.btnEnableTraceOverLPK.addSelectionListener(onButtonSelect);
        this.btnEnableTraceOverBus.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                DbgConfigGui.this._busInfo.setEnabled(((Button)arg0.getSource()).getSelection());
                DbgConfigGui.this.onFieldModification();
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
                DbgConfigGui.this._busInfo.setEnabled(((Button)arg0.getSource()).getSelection());
                DbgConfigGui.this.onFieldModification();
            }
        });
        this.btnEnableDebugAgentOverHost.addSelectionListener(onButtonSelect);
        int longButtonMinWidth = (int)((double)GuiUtils.getButtonWidth((Control)this.shlDebugConfigurations) * 1.5);
        int shortButtonMinWidth = GuiUtils.getButtonWidth((Control)this.shlDebugConfigurations);
        ((GridData)this.btnRemoveAndClose.getLayoutData()).minimumWidth = longButtonMinWidth;
        ((GridData)this.btnSaveAndClose.getLayoutData()).minimumWidth = longButtonMinWidth;
        ((GridData)this.btnCancel.getLayoutData()).minimumWidth = shortButtonMinWidth;
        ((GridLayout)compositeThirdRow.getLayout()).marginHeight = 0;
        ((GridLayout)compositeThirdRow.getLayout()).marginWidth = 0;
        ((GridLayout)compositeButton.getLayout()).marginHeight = 0;
        ((GridLayout)compositeButton.getLayout()).marginWidth = 0;
        ((GridLayout)this.shlDebugConfigurations.getLayout()).marginHeight = 4;
        ((GridLayout)this.shlDebugConfigurations.getLayout()).verticalSpacing = 4;
        ((GridLayout)grpView.getLayout()).marginHeight = 4;
        ((GridLayout)grpView.getLayout()).verticalSpacing = 4;
        ((GridLayout)grpTraceInterface.getLayout()).marginHeight = 4;
        ((GridLayout)grpTraceInterface.getLayout()).verticalSpacing = 4;
        ((GridLayout)this.grpPriority.getLayout()).marginHeight = 4;
        ((GridLayout)this.grpPriority.getLayout()).verticalSpacing = 4;
        ((GridLayout)grpTraceMode.getLayout()).marginHeight = 4;
        ((GridLayout)grpTraceMode.getLayout()).verticalSpacing = 6;
        ((GridLayout)this.grpComponentFilter.getLayout()).marginHeight = 4;
        ((GridLayout)this.grpComponentFilter.getLayout()).verticalSpacing = 4;
        ((GridLayout)grpDebugConfig.getLayout()).marginHeight = 4;
        ((GridLayout)grpDebugConfig.getLayout()).verticalSpacing = 4;
        ((GridData)this.tree.getLayoutData()).heightHint = longButtonMinWidth;
        this.shlDebugConfigurations.setSize(this.shlDebugConfigurations.computeSize(-1, -1));
        this.shlDebugConfigurations.setLocation(GuiUtils.getMiddleLocation(this.shlDebugConfigurations, this.display));
        this.adjustWindowToPlatfrom();
        this._properties.setModified(false);
    }
}

