/*
 * Decompiled with CFR 0.152.
 */
package pdtEditor;

import java.io.File;
import java.math.BigInteger;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.eclipse.jface.bindings.keys.ParseException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import pdtEditor.DataStore;
import pdtEditor.Luid;
import pdtEditor.payloads.calibrations.AgmVirtualCalibrationPayload;
import pdtEditor.payloads.calibrations.AlsCalibrationPayload;
import pdtEditor.payloads.calibrations.CalibrationPayload;
import pdtEditor.payloads.calibrations.CustomCalibrationPayload;
import pdtEditor.payloads.calibrations.GeneralCalibrationPayload;
import pdtEditor.payloads.calibrations.VirtualAcclCalibrationPayload;
import pdtEditor.payloads.calibrations.VirtualGyroCalibrationPayload;
import pdtEditor.payloads.calibrations.VirtualMagCalibrationPayload;

public class CalibrationParser {
    private String _path = null;
    ArrayList<CalibrationPayload> _loadedPayloads = new ArrayList();
    ArrayList<Luid> _luidsOfLoadedPayloads = new ArrayList();

    public CalibrationParser(String path) {
        this._path = path;
    }

    public static ArrayList<Byte> getBinaryData(Element dataElement) {
        int dataLength;
        ArrayList<Byte> res = new ArrayList<Byte>();
        try {
            dataLength = Integer.valueOf(dataElement.getAttribute("DataLength"));
        }
        catch (NumberFormatException e) {
            System.err.println("Invalid custom calibration datalength");
            throw e;
        }
        try {
            String hexData = dataElement.getTextContent().trim();
            String binaryData = new BigInteger(hexData, 16).toString(2);
            byte[] data = new BigInteger(binaryData, 2).toByteArray();
            res.clear();
            if (data.length < dataLength) {
                int i;
                int bytesNumToAdd = dataLength - data.length;
                for (i = 0; i < bytesNumToAdd; ++i) {
                    byte zero = 0;
                    res.add(zero);
                }
                for (i = 0; i < data.length; ++i) {
                    res.add(data[i]);
                }
            } else {
                int startToCopyFrom = data.length - dataLength;
                for (int i = 0; i < dataLength; ++i) {
                    res.add(data[startToCopyFrom + i]);
                }
            }
        }
        catch (Exception e) {
            System.err.println("Invalid custom calibration data");
            throw new RuntimeException(e);
        }
        return res;
    }

    public void parse() throws XPathExpressionException, ParseException {
        Document calibrationFile;
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            File srcXmlFile = new File(this._path);
            calibrationFile = dBuilder.parse(srcXmlFile);
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        XPath xpath = XPathFactory.newInstance().newXPath();
        XPathExpression xpr = xpath.compile("//ISS/Calibration");
        Node calibrationNode = (Node)xpr.evaluate(calibrationFile, XPathConstants.NODE);
        if (calibrationNode == null) {
            throw new ParseException("Bad XML file.");
        }
        xpr = xpath.compile("//ISS/Calibration/Sensor");
        NodeList sensorNodes = (NodeList)xpr.evaluate(calibrationFile, XPathConstants.NODESET);
        for (int i = 0; i < sensorNodes.getLength(); ++i) {
            int formatID;
            int version;
            Luid luid;
            Element sensorNode = (Element)sensorNodes.item(i);
            try {
                luid = new Luid(Integer.valueOf(sensorNode.getAttribute("SensorTypeId")), Integer.valueOf(sensorNode.getAttribute("SubTypeId")), Integer.valueOf(sensorNode.getAttribute("VendorId")), Integer.valueOf(sensorNode.getAttribute("InstanceId")), Integer.valueOf(sensorNode.getAttribute("Flags")));
            }
            catch (NumberFormatException e) {
                System.err.println("Invalid value in one of the LUID attributes");
                throw e;
            }
            Element calibData = (Element)DataStore.getChildNodeByName(sensorNode, "CalibrationData");
            try {
                version = Integer.valueOf(calibData.getAttribute("Version"));
                formatID = Integer.valueOf(calibData.getAttribute("FormatId"));
            }
            catch (NumberFormatException e) {
                System.err.println("Invalid value in one of the calibration data attributes");
                throw e;
            }
            switch (CalibrationPayload.getCalibrationType((Luid)luid, (int)formatID, (boolean)false).get((int)0).format) {
                case 0: {
                    CalibrationPayload payload = new GeneralCalibrationPayload();
                    ((GeneralCalibrationPayload)payload).setFormatID(formatID);
                    ((GeneralCalibrationPayload)payload).setVersion(version);
                    ((GeneralCalibrationPayload)payload).setDataFromXalibrationXML(calibData);
                    this._loadedPayloads.add(payload);
                    break;
                }
                case 1: {
                    CalibrationPayload payload = new AlsCalibrationPayload();
                    ((AlsCalibrationPayload)payload).setFormatID(formatID);
                    ((AlsCalibrationPayload)payload).setVersion(version);
                    ((AlsCalibrationPayload)payload).setDataFromXalibrationXML(calibData);
                    this._loadedPayloads.add(payload);
                    break;
                }
                case 2: {
                    CalibrationPayload payload = new VirtualAcclCalibrationPayload();
                    ((VirtualAcclCalibrationPayload)payload).setFormatID(formatID);
                    ((VirtualAcclCalibrationPayload)payload).setVersion(version);
                    ((AgmVirtualCalibrationPayload)payload).setDataFromXalibrationXML(calibData);
                    this._loadedPayloads.add(payload);
                    break;
                }
                case 3: {
                    CalibrationPayload payload = new VirtualGyroCalibrationPayload();
                    ((VirtualGyroCalibrationPayload)payload).setFormatID(formatID);
                    ((VirtualGyroCalibrationPayload)payload).setVersion(version);
                    ((AgmVirtualCalibrationPayload)payload).setDataFromXalibrationXML(calibData);
                    this._loadedPayloads.add(payload);
                    break;
                }
                case 4: {
                    CalibrationPayload payload = new VirtualMagCalibrationPayload();
                    ((VirtualMagCalibrationPayload)payload).setFormatID(formatID);
                    ((VirtualMagCalibrationPayload)payload).setVersion(version);
                    ((AgmVirtualCalibrationPayload)payload).setDataFromXalibrationXML(calibData);
                    this._loadedPayloads.add(payload);
                    break;
                }
                default: {
                    CalibrationPayload payload = new CustomCalibrationPayload();
                    ((CustomCalibrationPayload)payload).setFormatID(formatID);
                    ((CustomCalibrationPayload)payload).setVersion(version);
                    ((CustomCalibrationPayload)payload).setDataFromXalibrationXML(calibData);
                    this._loadedPayloads.add(payload);
                }
            }
            this._luidsOfLoadedPayloads.add(luid);
        }
    }

    public ArrayList<CalibrationPayload> getLoadedPayloads() {
        return this._loadedPayloads;
    }

    public ArrayList<Luid> getLuidsOfLoadedPayloads() {
        return this._luidsOfLoadedPayloads;
    }

    public static void main(String[] args) {
        CalibrationParser a = new CalibrationParser("C:\\Users\\ovinitze\\Desktop\\New folder\\Calibration.xml");
        try {
            a.parse();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

