/*
 * Decompiled with CFR 0.152.
 */
package pdtEditor;

import java.util.ArrayList;
import pdtEditor.AbstractValidatable;
import pdtEditor.DataStore;
import pdtEditor.IComponent;
import pdtEditor.Logger;
import pdtEditor.Luid;
import pdtEditor.PdtFile;
import pdtEditor.Sensor;
import pdtEditor.gui.DeviceProperties;
import pdtEditor.payloads.calibrations.CalibrationPayload;
import pdtEditor.validation.Fixer;
import pdtEditor.validation.Issue;

public class Device
extends AbstractValidatable
implements IComponent {
    public static final int EXPOSE_DEVICE_TO_HOST_BIT = 0;
    public static final int EXPOSE_DEVICE_TO_CSME_BIT = 1;
    public static final int EXPOSE_DEVICE_TO_INTERNAL_ALGOS_BIT = 2;
    public static final int[] INTEL_RESERVED_VENDOR_IDS = new int[]{32903};
    public static final int MINIMAL_PRODUCT_ID = 1;
    public static final int MAXIMAL_PRODUCT_ID = Short.MAX_VALUE;
    public static final int MINIMAL_VENDOR_ID = 1;
    public static final int MAXIMAL_VENDOR_ID = (int)Math.pow(2.0, 16.0) - 1;
    public static final int EXPOSE_DEVICE_TWICE_DUPLICATED_DEVICE_PID_GAP = 32768;
    public static final int DEFAULT_HOST_MASK_ID = 1;
    public static final int DEFAULT_FLAGS = 0;
    public static final DeviceDefaults defaultDeviceConfiguration = DeviceDefaults.INTEL_BASELINE_SENSORS;
    private DataStore _dataStore = null;
    private ArrayList<Sensor> _sensors = null;
    private int _productId;
    private int _vendorId;
    private int _hostIdMask;
    private Flags _flags;
    private int _interruptPurpose;
    private int _interruptPinNumber;
    private int _interruptMode;
    private int _controlId;
    private int _controlValue;
    private ArrayList<Issue> _issues;

    public Device(int productId, int vendorId) {
        this._productId = Device.defaultDeviceConfiguration.productID;
        this._vendorId = Device.defaultDeviceConfiguration.vendorID;
        this._hostIdMask = 1;
        this._flags = new Flags();
        this._issues = new ArrayList();
        this._sensors = new ArrayList();
        this._productId = productId;
        this._vendorId = vendorId;
        this._dataStore = DataStore.getInstance();
    }

    public Device(int productId, int vendorId, int hostMaskId, int flags, DataStore dataStore) {
        this._productId = Device.defaultDeviceConfiguration.productID;
        this._vendorId = Device.defaultDeviceConfiguration.vendorID;
        this._hostIdMask = 1;
        this._flags = new Flags();
        this._issues = new ArrayList();
        this._sensors = new ArrayList();
        this._productId = productId;
        this._vendorId = vendorId;
        this._hostIdMask = hostMaskId;
        this.setFlags(flags);
        this._dataStore = dataStore;
    }

    public Device(Device other) {
        this._productId = Device.defaultDeviceConfiguration.productID;
        this._vendorId = Device.defaultDeviceConfiguration.vendorID;
        this._hostIdMask = 1;
        this._flags = new Flags();
        this._issues = new ArrayList();
        if (other._sensors != null) {
            this._sensors = new ArrayList();
            for (Sensor sensor : other._sensors) {
                this._sensors.add(sensor.clone());
            }
        }
        this._productId = other._productId;
        this._vendorId = other._vendorId;
        this._hostIdMask = other._hostIdMask;
        this.setFlags(other.getFlags());
    }

    public boolean equals(Object arg0) {
        if (arg0 == null || !(arg0 instanceof Device)) {
            return false;
        }
        Device other = (Device)arg0;
        return (this._sensors == null && other._sensors == null || this._sensors != null && this._sensors.equals(other._sensors)) && this._productId == other._productId && this._vendorId == other._vendorId && this._hostIdMask == other._hostIdMask && this.getFlags() == other.getFlags();
    }

    public Device clone() {
        return new Device(this);
    }

    public boolean isIntelDevice() {
        for (int vid : INTEL_RESERVED_VENDOR_IDS) {
            if (this._vendorId != vid) continue;
            return true;
        }
        return false;
    }

    public void setFlags(int flags) {
        String binFlags = Integer.toBinaryString(flags);
        StringBuilder zeroPadding = new StringBuilder();
        for (int i = binFlags.length(); i < 8; ++i) {
            zeroPadding.append("0");
        }
        binFlags = zeroPadding.toString() + binFlags;
        this._flags._exposeTwice = binFlags.charAt(binFlags.length() - 1) == '1';
        this._flags._detachable = binFlags.charAt(binFlags.length() - 2) == '1';
        this._flags._reserved2 = binFlags.charAt(binFlags.length() - 3) == '1';
        this._flags._reserved3 = binFlags.charAt(binFlags.length() - 4) == '1';
        this._flags._reserved4 = binFlags.charAt(binFlags.length() - 5) == '1';
        this._flags._reserved5 = binFlags.charAt(binFlags.length() - 6) == '1';
        this._flags._reserved6 = binFlags.charAt(binFlags.length() - 7) == '1';
        this._flags._reserved7 = binFlags.charAt(binFlags.length() - 8) == '1';
    }

    public int getFlags() {
        String binFlags = "";
        binFlags = binFlags + (this._flags._reserved7 ? "1" : "0");
        binFlags = binFlags + (this._flags._reserved6 ? "1" : "0");
        binFlags = binFlags + (this._flags._reserved5 ? "1" : "0");
        binFlags = binFlags + (this._flags._reserved4 ? "1" : "0");
        binFlags = binFlags + (this._flags._reserved3 ? "1" : "0");
        binFlags = binFlags + (this._flags._reserved2 ? "1" : "0");
        binFlags = binFlags + (this._flags._detachable ? "1" : "0");
        binFlags = binFlags + (this._flags._exposeTwice ? "1" : "0");
        return Integer.parseInt(binFlags, 2);
    }

    public boolean hasSensors() {
        return this._sensors != null && this._sensors.size() > 0;
    }

    public int addSensor(Sensor newSensor) {
        if (this._sensors.contains(newSensor)) {
            return this._sensors.indexOf(newSensor);
        }
        if (newSensor.getLuid().getIsPhysical()) {
            for (int i = 0; i < this._sensors.size(); ++i) {
                if (this._sensors.get(i).getLuid().getIsPhysical()) continue;
                this._sensors.add(i, newSensor);
                return i;
            }
        }
        this._sensors.add(newSensor);
        return this._sensors.size() - 1;
    }

    public int addSensor(int index, Sensor newSensor) {
        if (this._sensors.contains(newSensor)) {
            return this._sensors.indexOf(newSensor);
        }
        if (this._sensors.size() < index) {
            this._sensors.add(newSensor);
            index = this._sensors.size();
        } else {
            this._sensors.add(index, newSensor);
        }
        return index;
    }

    public void addAllSensors(ArrayList<Sensor> newSensors) {
        for (Sensor sensor : newSensors) {
            this.addSensor(sensor);
            Logger.instance().log(this, "Added sensor: " + sensor);
        }
    }

    public void removeSensor(Sensor sensor) {
        this._sensors.remove(sensor);
    }

    public Sensor getSensor(int position) {
        return this._sensors.get(position);
    }

    public void deleteSensor(int position) {
        this._sensors.remove(position);
    }

    public void deleteSensor(Sensor sensor) {
        this._sensors.remove(sensor);
    }

    public ArrayList<Sensor> getSensors() {
        return this._sensors;
    }

    public ArrayList<Sensor> getPhysicalSensors() {
        ArrayList<Sensor> res = new ArrayList<Sensor>();
        for (Sensor sensor : this._sensors) {
            if (!sensor.getLuid().getIsPhysical()) continue;
            res.add(sensor);
        }
        return res;
    }

    public ArrayList<Sensor> getAlgorithms() {
        ArrayList<Sensor> res = new ArrayList<Sensor>();
        for (Sensor sensor : this._sensors) {
            if (sensor.getLuid().getIsPhysical()) continue;
            res.add(sensor);
        }
        return res;
    }

    public ArrayList<Sensor> getSensorsThatHasCalibrations() {
        ArrayList<Sensor> res = new ArrayList<Sensor>();
        for (Sensor sensor : this._sensors) {
            CalibrationPayload payload = (CalibrationPayload)sensor.getPayloadByClass(CalibrationPayload.class);
            if (payload == null) continue;
            res.add(sensor);
        }
        return res;
    }

    public ArrayList<Sensor> getSensorsThatDosntHaveCalibrations() {
        ArrayList<Sensor> res = new ArrayList<Sensor>();
        for (Sensor sensor : this._sensors) {
            CalibrationPayload payload = (CalibrationPayload)sensor.getPayloadByClass(CalibrationPayload.class);
            if (payload != null) continue;
            res.add(sensor);
        }
        return res;
    }

    public void deleteAllOtherSensors(ArrayList<Luid> keepList) {
        ArrayList<Sensor> removeList = new ArrayList<Sensor>();
        for (Sensor sensor : this._sensors) {
            boolean skip = false;
            for (Luid luid : keepList) {
                if (!luid.staticEquals(sensor.getLuid())) continue;
                skip = true;
                break;
            }
            if (skip) continue;
            removeList.add(sensor);
        }
        for (Sensor sensor : removeList) {
            this._sensors.remove(sensor);
        }
    }

    public void replaceSensor(Sensor oldSensor, Sensor newSensor) {
        if (!this._sensors.contains(oldSensor)) {
            return;
        }
        Sensor newSensorClone = newSensor.clone();
        newSensorClone.setSdtOrderIndex(oldSensor.getSdtOrderIndex());
        this._sensors.set(this._sensors.lastIndexOf(oldSensor), newSensorClone);
    }

    public void moveSensor(Sensor sensor, int steps) {
        int targetIndex = this.getSensors().indexOf(sensor) + steps;
        if (targetIndex >= this.getSensors().size()) {
            targetIndex = this.getSensors().size() - 1;
        } else if (targetIndex < 0) {
            targetIndex = 0;
        }
        this._sensors.remove(sensor);
        this._sensors.add(targetIndex, sensor);
    }

    public void onPdtFormatVersionUpdate(PdtFile pdtFile, int oldVersion, int newVersion, DataStore.FlowResults flowRes) {
        StringBuilder errors = new StringBuilder();
        boolean version5Changes = oldVersion < 5 && newVersion >= 5;
        boolean luidsModified = false;
        ArrayList<Sensor> toRemove = new ArrayList<Sensor>();
        ArrayList<Sensor> toAdd = new ArrayList<Sensor>();
        for (Sensor sensor : this._sensors) {
            Luid preUpgradeLuid = sensor.getLuid().clone();
            try {
                sensor.onPdtFormatVersionUpdate(pdtFile, oldVersion, newVersion, flowRes);
            }
            catch (UnsupportedOperationException e) {
                flowRes.hasErrors = true;
                errors.append("\n" + e.getMessage());
            }
            if (!version5Changes) continue;
            if (sensor.getLuid().getSensorTypeId() == 529) {
                toRemove.add(sensor);
                boolean vendorId = false;
                boolean modelId = false;
                int instanceId = sensor.getLuid().getInstanceId();
                int flags = sensor.getLuid().getFlags();
                toAdd.add(new Sensor(new Luid(536, 0, 0, instanceId, flags)));
                toAdd.add(new Sensor(new Luid(537, 0, 0, instanceId, flags)));
            }
            if (preUpgradeLuid.equals(sensor.getLuid())) continue;
            luidsModified = true;
        }
        if (version5Changes && luidsModified && !this.isIntelDevice()) {
            Logger.instance().log(Logger.LogLevel.WARNING, this, "A number of sensors have had their LUIDs changed as a result of this upgrade. Review the changes to these sensor definitions above, and make sure your software driver is equipped to handle the new LUIDs.");
            flowRes.hasWarnings = true;
        }
        this._sensors.removeAll(toRemove);
        for (Sensor sensor : toRemove) {
            Logger.instance().log(this, "Removed sensor: " + sensor);
        }
        this._sensors.addAll(toAdd);
        for (Sensor sensor : toAdd) {
            Logger.instance().log(this, "Added sensor: " + sensor);
        }
        if (errors.length() > 0) {
            Logger.instance().log(Logger.LogLevel.ERROR, this, errors.toString());
            throw new UnsupportedOperationException(errors.substring(1));
        }
        if (version5Changes && this._flags._exposeTwice) {
            Logger.instance().log(this, "Clearing the 'expose twice to host' flag.");
            this._flags._exposeTwice = false;
        }
    }

    public ArrayList<Sensor> getSensorsOfTypes(ArrayList<Integer> sensorTypeIds, boolean inList) {
        ArrayList<Sensor> sensors = new ArrayList<Sensor>();
        for (Sensor sensor : this._sensors) {
            boolean typeInList = false;
            for (int type : sensorTypeIds) {
                if (sensor.getLuid().getSensorTypeId() != type) continue;
                if (inList) {
                    sensors.add(sensor);
                }
                typeInList = true;
                break;
            }
            if (typeInList || inList) continue;
            sensors.add(sensor);
        }
        return sensors;
    }

    public ArrayList<Sensor> cutSensors(ArrayList<Integer> sensorTypeIds, boolean cutMatch) {
        ArrayList<Sensor> sensors = this.getSensorsOfTypes(sensorTypeIds, cutMatch);
        this._sensors.removeAll(sensors);
        for (Sensor sensor : sensors) {
            Logger.instance().log(this, "Removed sensor: " + sensor);
        }
        return sensors;
    }

    @Override
    public void checkValidity() {
        Object issue;
        this._issues.clear();
        if (this._productId < 1) {
            issue = new Issue(Issue.IssueType.CRITICAL, this);
            ((Issue)issue).element = this.getDeviceShortName();
            ((Issue)issue).setMessage("This device has an invalid Product ID number.");
            ((Issue)issue).description = "Change the ID to a hexadecimal value in the range [" + Integer.toHexString(1) + "," + Integer.toHexString(Short.MAX_VALUE) + "]";
            ((Issue)issue).fixer = new Fixer(this){

                @Override
                public String getFixDescription() {
                    return "Double-click this issue to open the Device Properties window, where you can change the Product ID number.";
                }

                @Override
                public void fix() {
                    new DeviceProperties(null, this._device).open();
                }
            };
            this._issues.add((Issue)issue);
        }
        if (this._vendorId < 1) {
            issue = new Issue(Issue.IssueType.CRITICAL, this);
            ((Issue)issue).element = this.getDeviceShortName();
            ((Issue)issue).setMessage("This device has an invalid Vendor ID number.");
            ((Issue)issue).description = "Change the ID to a hexadecimal value in the range [" + Integer.toHexString(1) + "," + Integer.toHexString(MAXIMAL_VENDOR_ID) + "]";
            ((Issue)issue).fixer = new Fixer(this){

                @Override
                public String getFixDescription() {
                    return "Double-click this issue to open the Device Properties window, where you can change the Vendor ID number.";
                }

                @Override
                public void fix() {
                    new DeviceProperties(null, this._device).open();
                }
            };
            this._issues.add((Issue)issue);
        }
        for (Object reservedVendorId : (Object)INTEL_RESERVED_VENDOR_IDS) {
            if (this._vendorId != reservedVendorId) continue;
            if (DeviceDefaults.areValidProperties(this._vendorId, this._productId)) break;
            Issue issue2 = new Issue(Issue.IssueType.WARNING, this);
            issue2.element = this.getDeviceShortName();
            issue2.setMessage("This device has an outdated Product ID and Vendor ID pair.");
            issue2.description = "This device contains a Vendor ID that was reserved for use by Intel, but its Product ID does not match the ones expected by the Intel or Microsoft UMDF drivers.";
            issue2.fixer = new Fixer(this){

                @Override
                public String getFixDescription() {
                    return "Double-click this issue to open the Device Properties window, where you can select your desired UMDF driver or change the Vendor ID.";
                }

                @Override
                public void fix() {
                    new DeviceProperties(null, this._device).open();
                }
            };
            this._issues.add(issue2);
            break;
        }
        if (this.getSensors().size() == 0) {
            issue = new Issue(Issue.IssueType.CRITICAL, this);
            ((Issue)issue).element = this.getDeviceShortName();
            ((Issue)issue).setMessage("This device has no sensors.");
            ((Issue)issue).description = "Consider deleting the device, or adding/moving sensors to the device.";
            this._issues.add((Issue)issue);
        }
        if (this._flags._exposeTwice) {
            issue = new Issue(Issue.IssueType.CRITICAL, this);
            ((Issue)issue).element = this.getDeviceShortName();
            ((Issue)issue).setMessage("The outdated 'Expose twice to host' field is still active for this device.");
            ((Issue)issue).description = "This device\u2019s configuration includes an active 'Expose twice to host' flag, but this flag is no longer supported.";
            ((Issue)issue).fixer = new Fixer(this){

                @Override
                public String getFixDescription() {
                    return "Double-click this issue to remove the flag from the device configuration.";
                }

                @Override
                public void fix() {
                    ((Device)this._device)._flags._exposeTwice = false;
                }
            };
            this._issues.add((Issue)issue);
        }
        for (Sensor sensor : this._sensors) {
            sensor.checkValidity();
        }
    }

    public void addIssue(Issue issue) {
        this._issues.add(issue);
    }

    @Override
    public ArrayList<Issue> getIssues() {
        return this._issues;
    }

    @Override
    public ArrayList<Issue> getAllIssues() {
        ArrayList<Issue> allIssues = new ArrayList<Issue>();
        allIssues.addAll(this._issues);
        for (Sensor sensor : this._sensors) {
            allIssues.addAll(sensor.getAllIssues());
        }
        return allIssues;
    }

    public int getDevicePosition() {
        int totalNumOfDevices = this._dataStore.getDevices().size();
        int devicePosition = -1;
        for (int i = 0; i < totalNumOfDevices; ++i) {
            if (this._dataStore.getDevices().get(i) != this) continue;
            devicePosition = i;
            break;
        }
        return devicePosition;
    }

    public String getDeviceName() {
        int totalNumOfDevices = this._dataStore.getDevices().size();
        return "Device " + (this.getDevicePosition() + 1) + " of " + totalNumOfDevices;
    }

    public String getDeviceShortName() {
        return "Device " + (this.getDevicePosition() + 1);
    }

    public String getDeviceNameWithPdtPath() {
        PdtFile pdt = this._dataStore.getPdtOfDevice(this);
        if (pdt == null) {
            return this.getDeviceName();
        }
        return this.getDeviceShortName() + " (" + pdt.getDisplayedPath() + ")";
    }

    public int getProductId() {
        return this._productId;
    }

    public String getHexProductId() {
        return Integer.toHexString(this._productId);
    }

    public void setProductId(int productId) {
        this._productId = productId;
    }

    public int getVendorId() {
        return this._vendorId;
    }

    public void setVendorId(int vendorId) {
        this._vendorId = vendorId;
    }

    public String getHexVendorId() {
        return Integer.toHexString(this._vendorId);
    }

    public int getHostIdMask() {
        return this._hostIdMask;
    }

    public void setHostIdMask(int hostIdMask) {
        this._hostIdMask = hostIdMask;
    }

    public void updateHostIdMask(int bit, boolean turnOn) {
        this._hostIdMask = turnOn ? (this._hostIdMask |= 1 << bit) : (this._hostIdMask &= ~(1 << bit));
    }

    public void setExposeDeviceToHost(boolean expose) {
        this.updateHostIdMask(0, expose);
    }

    public boolean getExposeDeviceTohost() {
        return (this._hostIdMask & 1) > 0;
    }

    public void setExposeDeviceToCsme(boolean expose) {
        this.updateHostIdMask(1, expose);
    }

    public boolean getExposeDeviceToCsme() {
        return (this._hostIdMask & 2) > 0;
    }

    public void setExposeDeviceToInternalAlgos(boolean expose) {
        this.updateHostIdMask(2, expose);
    }

    public boolean getExposeDeviceToInternalAlgos() {
        return (this._hostIdMask & 4) > 0;
    }

    public Sensor getSensorByLuid(Luid luid) {
        for (Sensor sensor : this._sensors) {
            if (!sensor.getLuid().equals(luid)) continue;
            return sensor;
        }
        return null;
    }

    public Sensor getSensorByStaticLuid(Luid luid) {
        for (Sensor sensor : this._sensors) {
            if (!sensor.getLuid().staticEquals(luid)) continue;
            return sensor;
        }
        return null;
    }

    public boolean getExposeTwice() {
        return this._flags._exposeTwice;
    }

    public void setExposeTwice(boolean value) {
        this._flags._exposeTwice = value;
    }

    public boolean getDetachable() {
        return this._flags._detachable;
    }

    public void setDetachable(boolean value) {
        this._flags._detachable = value;
    }

    public int getInterruptPurpose() {
        return this._interruptPurpose;
    }

    public void setInterruptPurpose(int _interruptPurpose) {
        this._interruptPurpose = _interruptPurpose;
    }

    public int getInterruptPinNumber() {
        return this._interruptPinNumber;
    }

    public void setInterruptPinNumber(int _interruptPinNumber) {
        this._interruptPinNumber = _interruptPinNumber;
    }

    public int getInterruptMode() {
        return this._interruptMode;
    }

    public void setInterruptMode(int _interruptMode) {
        this._interruptMode = _interruptMode;
    }

    public int getControlId() {
        return this._controlId;
    }

    public void setControlId(int _controlId) {
        this._controlId = _controlId;
    }

    public int getControlValue() {
        return this._controlValue;
    }

    public void setControlValue(int _controlValue) {
        this._controlValue = _controlValue;
    }

    @Override
    public String getElementName() {
        return this.getDeviceName();
    }

    public String toString() {
        return this.getDeviceShortName() + " (0x" + Integer.toHexString(this._vendorId) + ",0x" + Integer.toHexString(this._productId) + ")";
    }

    public int hashCode() {
        return super.hashCode();
    }

    public class Flags {
        public boolean _exposeTwice;
        public boolean _detachable;
        public boolean _reserved2;
        public boolean _reserved3;
        public boolean _reserved4;
        public boolean _reserved5;
        public boolean _reserved6;
        public boolean _reserved7;
    }

    public static enum DepricatedDeviceDefaults {
        INTEL_ADVANCED_SENSORS(32903, 2756);

        public final int productID;
        public final int vendorID;

        private DepricatedDeviceDefaults(int vendorID, int productID) {
            this.productID = productID;
            this.vendorID = vendorID;
        }
    }

    public static enum DeviceDefaults {
        INTEL_BASELINE_SENSORS("all versions of Windows", true, 32903, 2754),
        RS1_SUPPORTED_SENSORS("Windows 10 RS1 only", true, 32903, 2755),
        EXTERNAL_VENDR_DRIVER("a custom UMDF driver", false, 1, 1);

        public final boolean forceDefaults;
        public final String friendlyName;
        public final int productID;
        public final int vendorID;

        private DeviceDefaults(String friendlyName, boolean forceDefaults, int vendorID, int productID) {
            this.forceDefaults = forceDefaults;
            this.friendlyName = friendlyName;
            this.productID = productID;
            this.vendorID = vendorID;
        }

        public static DeviceDefaults getDeviceDefaults(String name) {
            for (DeviceDefaults deviceDefault : DeviceDefaults.values()) {
                if (!deviceDefault.friendlyName.equals(name)) continue;
                return deviceDefault;
            }
            return null;
        }

        public static boolean areValidProperties(int VID, int PID) {
            for (DeviceDefaults deviceDefault : DeviceDefaults.values()) {
                if (VID != deviceDefault.vendorID || PID != deviceDefault.productID) continue;
                return true;
            }
            return false;
        }
    }
}

