/*
 * Decompiled with CFR 0.152.
 */
package pdtEditor;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import manager.WinRegistry;
import manager.sensor.SensorData;
import manager.utils.ManagerEnums;
import org.eclipse.jface.bindings.keys.ParseException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import pdtEditor.BiMap;
import pdtEditor.Luid;
import pdtEditor.Sensor;
import pdtEditor.payloads.configurations.DevicePostureConfigurationPayload;
import pdtEditor.payloads.configurations.HingeAngleConfigurationPayload;
import pdtEditor.payloads.configurations.LidModeConfigurationPayload;

public class InformationStore {
    private static final String SENSOR_DEF_FILE = "ISS_Sensor_Definitions.xml";
    public static final String SENSORS_DEFINITIONS_FILE_NAME = "ISS_Sensor_Definitions.xml";
    private static final String FIELDS_DEF_FILE = "fields_definitions.xml";
    private static final String FW_DEF_FILE = "fw_definitions.xml";
    private static final String TRACE_COMPONENTS_FILE = "TraceComponents.xml";
    public static final String CALIBRATION_DEFINITONS_FILE = "calibration_definitions.xml";
    public static final String[] mandatoryFiles = new String[]{"ISS_Sensor_Definitions.xml", "fields_definitions.xml", "calibration_definitions.xml"};
    public static final String PROPRETY_NAME_VERSION = "Version";
    public static final String FW_FLAGS_DEVICE_FLAG_PREFIX = "DEV_0X";
    private static final int DBG_CONFIG_COMPONENT_VALUE_BASE = 16;
    private static InformationStore _instance = null;
    private Document _sensorDef;
    private Document _userSensorDef;
    private Document _fieldsDef;
    private Document _fwDef;
    private HashMap<String, String> _properties = new HashMap();
    private BiMap<Integer, String> _physicalSensorTypes = new BiMap();
    private BiMap<Integer, String> _virtualSensorTypes = new BiMap();
    private HashMap<Integer, ArrayList<String>> _sensorTypeFwFlags = new HashMap();
    private BiMap<Integer, String> _vendors = new BiMap();
    private HashMap<Integer, HashMap<Integer, BiMap<Integer, ArrayList<ModelInfo>>>> _physicalModelsByVendorAndType = new HashMap();
    private HashMap<Integer, HashMap<Integer, BiMap<Integer, ArrayList<ModelInfo>>>> _virtualModelsByVendorAndType = new HashMap();
    private BiMap<Integer, String> _busTypes = new BiMap();
    private BiMap<Integer, String> _busInstances = new BiMap();
    private BiMap<Integer, String> _i2cBusSpeeds = new BiMap();
    private BiMap<Integer, String> _uartBusSpeeds = new BiMap();
    private BiMap<Integer, String> _spiBusSpeeds = new BiMap();
    private BiMap<Integer, String> _i3cBusSpeeds = new BiMap();
    private ArrayList<String> _busTypesOfSensors = new ArrayList();
    private ArrayList<String> _busTypesOfHeciConfig = new ArrayList();
    private HashMap<String, ArrayList<Integer>> _busSpeedsOfHeciConfig = new HashMap();
    private HashMap<String, ArrayList<Integer>> _busSpeedsOfDebugConfig = new HashMap();
    private HashMap<String, Boolean> _enabledAddressForBusType = new HashMap();
    private HashMap<String, Boolean> _enabledSpeedForBusType = new HashMap();
    private HashMap<String, Boolean> _enabledRtsCtsBusType = new HashMap();
    private HashMap<String, Boolean> _enabledCsNativeForBusType = new HashMap();
    private HashMap<String, Boolean> _enabledCsPinForBusType = new HashMap();
    private HashMap<String, Boolean> _enabledAddressTypeForBusType = new HashMap();
    private HashMap<String, Boolean> _enabledIbiPurposeForBusType = new HashMap();
    private BiMap<Integer, String> _gpioPorpuses = new BiMap();
    private BiMap<Integer, String> _gpioModes = new BiMap();
    private BiMap<Integer, String> _i3cAddressType = new BiMap();
    private BiMap<String, Integer> _i3cAddressSize = new BiMap();
    private BiMap<Integer, String> _i3cIbiPurpose = new BiMap();
    private ArrayList<LidModeConfigurationPayload.ActionInfo> _PlmActions = new ArrayList();
    private ArrayList<DevicePostureConfigurationPayload.ActionInfo> _devicePostureActions = new ArrayList();
    private ArrayList<LidModeConfigurationPayload.PlmSupportSensorType> _plmSupportSensorType = new ArrayList();
    private ArrayList<HingeAngleConfigurationPayload.HallSupportSensorType> _hingeAngleHallSupportSensorType = new ArrayList();
    private static boolean isOldTraceComponent = false;
    private BiMap<Integer, Parent> _debugConfFilterMaskParents = new BiMap();

    public static InformationStore getInstance() throws ParseException, ParserConfigurationException, SAXException, IOException {
        if (_instance == null) {
            File file = new File(TRACE_COMPONENTS_FILE);
            if (file.exists()) {
                _instance = new InformationStore("ISS_Sensor_Definitions.xml", InformationStore.getUserDefPath(), FIELDS_DEF_FILE, TRACE_COMPONENTS_FILE);
            } else {
                isOldTraceComponent = true;
                _instance = new InformationStore("ISS_Sensor_Definitions.xml", InformationStore.getUserDefPath(), FIELDS_DEF_FILE, FW_DEF_FILE);
            }
        }
        return _instance;
    }

    public static void verifyMandatoryFiles() throws FileNotFoundException {
        StringBuilder missingFiles = new StringBuilder();
        for (int i = 0; i < mandatoryFiles.length; ++i) {
            File file = new File(mandatoryFiles[i]);
            if (file.exists()) continue;
            missingFiles.append("\n\"" + new File(".").toURI().relativize(file.toURI()).getPath() + "\"");
        }
        if (missingFiles.length() > 0) {
            throw new FileNotFoundException("The following files are missing at \"" + new File("").getAbsolutePath() + "\":" + missingFiles + "\n\nThe application cannot run without those files. Please recover the files and try again.");
        }
    }

    private InformationStore(String sensorDefFile, String userDefFile, String fieldsDefFile, String fwDefFile) throws ParseException, ParserConfigurationException, SAXException, IOException {
        Node ishNode;
        XPathExpression xpr;
        XPath xpath;
        this.getVersion();
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
        File srcXmlFile = new File(sensorDefFile);
        this._sensorDef = dBuilder.parse(srcXmlFile);
        try {
            xpath = XPathFactory.newInstance().newXPath();
            xpr = xpath.compile("//ISS");
            Node baseLineNode = (Node)xpr.evaluate(this._sensorDef, XPathConstants.NODE);
            if (baseLineNode == null) {
                throw new ParseException("Bad XML file.");
            }
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
            throw new ParseException("Bad XML file.");
        }
        if (userDefFile != null && (srcXmlFile = new File(userDefFile)).exists()) {
            this._userSensorDef = dBuilder.parse(srcXmlFile);
        }
        srcXmlFile = new File(fieldsDefFile);
        this._fieldsDef = dBuilder.parse(srcXmlFile);
        try {
            xpath = XPathFactory.newInstance().newXPath();
            xpr = xpath.compile("//ISH");
            ishNode = (Node)xpr.evaluate(this._fieldsDef, XPathConstants.NODE);
            if (ishNode == null) {
                throw new ParseException("Bad XML file.");
            }
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
            throw new ParseException("Bad XML file.");
        }
        srcXmlFile = new File(fwDefFile);
        this._fwDef = dBuilder.parse(srcXmlFile);
        try {
            xpath = XPathFactory.newInstance().newXPath();
            xpr = isOldTraceComponent ? xpath.compile("//ISH") : xpath.compile("//components");
            ishNode = (Node)xpr.evaluate(this._fwDef, XPathConstants.NODE);
            if (ishNode == null) {
                throw new ParseException("Bad XML file.");
            }
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
            throw new ParseException("Bad XML file.");
        }
        this.importSensorTypesInformation(this._sensorDef);
        this.importVendorsInformation(this._sensorDef);
        if (this._userSensorDef != null) {
            this.importSensorTypesInformation(this._userSensorDef);
            this.importVendorsInformation(this._userSensorDef);
        }
        this.importBusInformation();
        this.importGPIOInformation();
        this.importActionInformation();
        this.importDevicePostureActionInformation();
        this.importPlmSupportSensorTypeInformation();
        this.importHingeAngelHallSupportSensorTypeInformation();
        this.importDebugConfigurationInfo();
        this.importI3CAddressInfo();
    }

    public static String getFDKPath() {
        try {
            return WinRegistry.readString((int)-2147483647, (String)"Environment", (String)"INTEL_ISS_FDK");
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getUserDefPath() {
        try {
            return WinRegistry.readString((int)-2147483647, (String)"Environment", (String)"INTEL_ISS_FDK_USER_DATA") + "\\EclipsePlugin\\" + "ISS_Sensor_Definitions.xml";
        }
        catch (Exception e) {
            return null;
        }
    }

    private void getVersion() {
        String pdtversion = this.getClass().getPackage().getImplementationVersion();
        this._properties.put(PROPRETY_NAME_VERSION, pdtversion);
    }

    private void importSensorTypesInformation(Document defDoc) throws ParseException {
        NodeList sensorTypes;
        if (defDoc == null) {
            return;
        }
        try {
            XPath xpath = XPathFactory.newInstance().newXPath();
            XPathExpression xpr = xpath.compile("//ISS/SensorTypes/SensorType");
            sensorTypes = (NodeList)xpr.evaluate(defDoc, XPathConstants.NODESET);
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
            throw new ParseException("Bad XML file.");
        }
        for (int i = 0; i < sensorTypes.getLength(); ++i) {
            String fwFlags;
            Integer sensorTypeId;
            if (sensorTypes.item(i).getNodeType() != 1 || !sensorTypes.item(i).getNodeName().equals("SensorType")) continue;
            Element sensorTypeElement = (Element)sensorTypes.item(i);
            try {
                sensorTypeId = Integer.valueOf(sensorTypeElement.getAttribute("SensorTypeId"));
                if (sensorTypeId < 0) {
                    throw new NumberFormatException("Negative sensor type ID");
                }
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
                throw new ParseException("Bad XML file, SensorTypeId must be a valid non-negative integer");
            }
            String name = sensorTypeElement.getAttribute("Name");
            if (name == null) {
                throw new ParseException("Cannot read sensor name");
            }
            String flag = sensorTypeElement.getAttribute("flag");
            if (flag != null) {
                if (flag.equals("PHYSICAL")) {
                    this._physicalSensorTypes.put(sensorTypeId, name);
                    this._virtualSensorTypes.put(sensorTypeId, name);
                } else if (flag.equals("VIRTUAL")) {
                    this._virtualSensorTypes.put(sensorTypeId, name);
                }
            }
            if ((fwFlags = sensorTypeElement.getAttribute("FwFlags")) == null || fwFlags.isEmpty()) continue;
            String[] fwFlagsArray = fwFlags.split(";");
            ArrayList<String> list = new ArrayList<String>();
            for (int j = 0; j < fwFlagsArray.length; ++j) {
                list.add(fwFlagsArray[j]);
            }
            this._sensorTypeFwFlags.put(sensorTypeId, list);
        }
    }

    private void importVendorsInformation(Document defDoc) throws ParseException {
        NodeList vendors;
        if (defDoc == null) {
            return;
        }
        try {
            XPath xpath = XPathFactory.newInstance().newXPath();
            XPathExpression xpr = xpath.compile("//ISS/SensorVendors/Vendor");
            vendors = (NodeList)xpr.evaluate(defDoc, XPathConstants.NODESET);
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
            throw new ParseException("Bad XML file.");
        }
        for (int i = 0; i < vendors.getLength(); ++i) {
            Integer vendorId;
            if (vendors.item(i).getNodeType() != 1 || !vendors.item(i).getNodeName().equals("Vendor")) continue;
            Element vendorElement = (Element)vendors.item(i);
            try {
                vendorId = Integer.valueOf(vendorElement.getAttribute("VendorId"));
                if (vendorId < 0) {
                    throw new NumberFormatException("Negative vendor ID");
                }
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
                throw new ParseException("Bad XML file, VendorId must be a valid non-negative integer");
            }
            String name = vendorElement.getAttribute("VendorName");
            if (name == null) {
                throw new ParseException("Cannot read vendor name");
            }
            this._vendors.put(vendorId, name);
            NodeList vendorChildNodes = vendorElement.getChildNodes();
            for (int j = 0; j < vendorChildNodes.getLength(); ++j) {
                int sensorTypeId;
                Element sensorTypeElement;
                if (vendorChildNodes.item(j).getNodeType() != 1 || !vendorChildNodes.item(j).getNodeName().equals("SensorType") || (sensorTypeElement = (Element)vendorChildNodes.item(j)) == null) continue;
                String sensorTypeIdStr = sensorTypeElement.getAttribute("SensorTypeId");
                if (sensorTypeIdStr == null) {
                    throw new ParseException("Cannot read the sensor type ID");
                }
                try {
                    sensorTypeId = Integer.valueOf(sensorTypeIdStr);
                }
                catch (NumberFormatException e) {
                    throw new ParseException("Cannot parse the sensor type ID value from: " + sensorTypeIdStr);
                }
                NodeList modelNodes = sensorTypeElement.getChildNodes();
                for (int k = 0; k < modelNodes.getLength(); ++k) {
                    ArrayList<ModelInfo> modelList;
                    BiMap<Integer, ArrayList<ModelInfo>> modelsMap;
                    if (modelNodes.item(k).getNodeType() != 1 || !modelNodes.item(k).getNodeName().equals("Model")) continue;
                    Element sensorElement = (Element)modelNodes.item(k);
                    ModelInfo modelInfo = new ModelInfo();
                    int sensorModelId = -1;
                    try {
                        sensorModelId = Integer.valueOf(sensorElement.getAttribute("ModelId"));
                    }
                    catch (NumberFormatException e) {
                        e.printStackTrace();
                    }
                    String isPhysical = sensorElement.getAttribute("isPhysical");
                    boolean physicalModel = isPhysical != null && isPhysical.equals("true");
                    String modelName = sensorElement.getAttribute("ModelName");
                    if (!(modelName != null && !modelName.isEmpty() || (modelName = sensorElement.getAttribute("FriendlyName")) != null && !modelName.isEmpty())) continue;
                    modelInfo.name = modelName;
                    String flags = sensorElement.getAttribute("Flags");
                    if (flags != null && !flags.isEmpty()) {
                        try {
                            modelInfo.flags = Integer.valueOf(flags);
                        }
                        catch (NumberFormatException e) {
                            System.err.println("Invalid flags value: " + flags);
                        }
                    }
                    NodeList modelSubElements = sensorElement.getChildNodes();
                    for (int l = 0; l < modelSubElements.getLength(); ++l) {
                        if (modelSubElements.item(l).getNodeType() != 1 || !modelSubElements.item(l).getNodeName().equals("Dependency")) continue;
                        this.setDependecyInfo(modelInfo, (Element)modelSubElements.item(l));
                    }
                    HashMap<Integer, HashMap<Integer, BiMap<Integer, ArrayList<ModelInfo>>>> dataBase = physicalModel ? this._physicalModelsByVendorAndType : this._virtualModelsByVendorAndType;
                    HashMap<Integer, BiMap<Integer, ArrayList<ModelInfo>>> typeToModelMap = dataBase.get(vendorId);
                    if (typeToModelMap == null) {
                        typeToModelMap = new HashMap();
                        dataBase.put(vendorId, typeToModelMap);
                    }
                    if ((modelsMap = typeToModelMap.get(sensorTypeId)) == null) {
                        modelsMap = new BiMap();
                        typeToModelMap.put(sensorTypeId, modelsMap);
                    }
                    if ((modelList = modelsMap.getForward(sensorModelId)) == null) {
                        modelList = new ArrayList();
                        modelsMap.put(sensorModelId, modelList);
                    }
                    modelList.add(modelInfo);
                }
            }
        }
    }

    private void setDependecyInfo(ModelInfo modelInfo, Element dependencyElement) {
        try {
            SensorData sensorData = new SensorData();
            String dependSensorType = dependencyElement.getAttribute("SensorTypeId");
            String dependVendor = dependencyElement.getAttribute("Vendor");
            String dependModel = dependencyElement.getAttribute("Model");
            String dependInstance = dependencyElement.getAttribute("InstanceId");
            String dependFlags = dependencyElement.getAttribute("Flags");
            String dependType = dependencyElement.getAttribute("DependencyType");
            if (dependSensorType != null) {
                sensorData.setTypeId(Integer.valueOf(dependSensorType).intValue());
            }
            if (dependVendor != null && !dependVendor.isEmpty()) {
                sensorData.setVendorId(Integer.valueOf(dependVendor).intValue());
            } else {
                sensorData.setVendorId(-1);
            }
            if (dependModel != null && !dependModel.isEmpty()) {
                sensorData.setModelId(Integer.valueOf(dependModel).intValue());
            } else {
                sensorData.setModelId(-1);
            }
            if (dependInstance != null) {
                sensorData.setInstanceId(Integer.valueOf(dependInstance).intValue());
            }
            if (dependFlags != null) {
                sensorData.setFlags(Integer.valueOf(dependFlags).intValue());
            }
            if (dependType != null) {
                int dependTypeValue = Integer.valueOf(dependType);
                sensorData.setDependencyType(ManagerEnums.DependencyTypes.values()[dependTypeValue]);
            }
            if (modelInfo.dependecies == null) {
                modelInfo.dependecies = new ArrayList();
            }
            modelInfo.dependecies.add(sensorData);
        }
        catch (NumberFormatException e) {
            System.err.println("Cannot add dependency info to the model [" + modelInfo.name + "], some of the values are not valid integers.");
        }
    }

    private void importSimpleFieldInfo(String sectionName, String parentNodeName, String childNodeName, boolean signedValue, BiMap<Integer, String> dataHolder) throws ParseException {
        NodeList nodes;
        try {
            XPath xpath = XPathFactory.newInstance().newXPath();
            XPathExpression xpr = xpath.compile("//ISH/" + sectionName + "/" + parentNodeName + "/" + childNodeName);
            nodes = (NodeList)xpr.evaluate(this._fieldsDef, XPathConstants.NODESET);
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
            throw new ParseException("Bad XML file.");
        }
        for (int i = 0; i < nodes.getLength(); ++i) {
            Integer value;
            if (nodes.item(i).getNodeType() != 1 || !nodes.item(i).getNodeName().equals(childNodeName)) continue;
            Element childElement = (Element)nodes.item(i);
            try {
                value = Integer.valueOf(childElement.getAttribute("Value"));
                if (!signedValue && value < 0) {
                    throw new NumberFormatException("Negative " + childNodeName);
                }
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
                throw new ParseException("Bad XML file, Value of " + childNodeName + " must be a valid non-negative integer");
            }
            String name = childElement.getAttribute("Name");
            if (name == null) {
                throw new ParseException("Cannot read " + childNodeName);
            }
            dataHolder.put(value, name);
        }
    }

    private void importIsBusFiledsEnabled() throws ParseException {
        NodeList nodes;
        try {
            XPath xpath = XPathFactory.newInstance().newXPath();
            XPathExpression xpr = xpath.compile("//ISH/Bus/BusTypes/BusType");
            nodes = (NodeList)xpr.evaluate(this._fieldsDef, XPathConstants.NODESET);
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
            throw new ParseException("Bad XML file.");
        }
        for (int i = 0; i < nodes.getLength(); ++i) {
            boolean hasIbiPurpose;
            boolean hasAddressType;
            boolean hasCsPin;
            boolean hasCsNative;
            boolean hasRtsCts;
            boolean hasSpeed;
            boolean hasAddress;
            String name;
            if (nodes.item(i).getNodeType() != 1 || !nodes.item(i).getNodeName().equals("BusType")) continue;
            Element childElement = (Element)nodes.item(i);
            try {
                name = childElement.getAttribute("Name");
                if (name == null) {
                    throw new ParseException("Cannot read the bus type's name");
                }
                hasAddress = childElement.getAttribute("HasAddress").equals("True");
                hasSpeed = childElement.getAttribute("HasSpeed").equals("True");
                hasRtsCts = childElement.getAttribute("HasRtsCts").equals("True");
                hasCsNative = childElement.getAttribute("HasCsNative").equals("True");
                hasCsPin = childElement.getAttribute("HasCsPin").equals("True");
                hasAddressType = childElement.getAttribute("HasAddressType").equals("True");
                hasIbiPurpose = childElement.getAttribute("HasIbiPurpose").equals("True");
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
                throw new ParseException("Bad XML file");
            }
            this._enabledAddressForBusType.put(name, hasAddress);
            this._enabledSpeedForBusType.put(name, hasSpeed);
            this._enabledRtsCtsBusType.put(name, hasRtsCts);
            this._enabledCsNativeForBusType.put(name, hasCsNative);
            this._enabledCsPinForBusType.put(name, hasCsPin);
            this._enabledAddressTypeForBusType.put(name, hasAddressType);
            this._enabledIbiPurposeForBusType.put(name, hasIbiPurpose);
        }
    }

    private void importBusInformation() throws ParseException {
        this.importSimpleFieldInfo("Bus", "BusTypes", "BusType", false, this._busTypes);
        this.importSimpleFieldInfo("Bus", "BusInstances", "BusInstance", false, this._busInstances);
        this.importSimpleFieldInfo("Bus", "BusSpeeds/I2C", "BusSpeed", false, this._i2cBusSpeeds);
        this.importSimpleFieldInfo("Bus", "BusSpeeds/UART", "BusSpeed", false, this._uartBusSpeeds);
        this.importSimpleFieldInfo("Bus", "BusSpeeds/SPI", "BusSpeed", false, this._spiBusSpeeds);
        this.importSimpleFieldInfo("Bus", "BusSpeeds/I3C", "BusSpeed", false, this._i3cBusSpeeds);
        this.importIsBusFiledsEnabled();
        this.importSensorInfo();
        this.importHeciConfigInformation();
        this.importDebugConfigBusSpeedInformation();
        this.importSimpleFieldInfo("Bus", "IBIPurposes", "Purpose", false, this._i3cIbiPurpose);
    }

    private void importSensorInfo() throws ParseException {
        NodeList nodes;
        try {
            XPath xpath = XPathFactory.newInstance().newXPath();
            XPathExpression xpr = xpath.compile("//ISH/SensorData/BusTypes/BusType");
            nodes = (NodeList)xpr.evaluate(this._fieldsDef, XPathConstants.NODESET);
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
            throw new ParseException("Bad XML file.");
        }
        this._busTypesOfSensors = new ArrayList();
        for (int i = 0; i < nodes.getLength(); ++i) {
            if (nodes.item(i).getNodeType() != 1 || !nodes.item(i).getNodeName().equals("BusType")) continue;
            Element element = (Element)nodes.item(i);
            String busType = element.getAttribute("Name");
            this._busTypesOfSensors.add(busType);
        }
    }

    private void importDebugConfigBusSpeedInformation() throws ParseException {
        NodeList nodes;
        try {
            XPath xpath = XPathFactory.newInstance().newXPath();
            XPathExpression xpr = xpath.compile("//ISH/DebugConfiguration/BusSpeeds/*");
            nodes = (NodeList)xpr.evaluate(this._fieldsDef, XPathConstants.NODESET);
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
            throw new ParseException("Bad XML file.");
        }
        for (int i = 0; i < nodes.getLength(); ++i) {
            if (nodes.item(i).getNodeType() != 1) continue;
            String busTypeName = nodes.item(i).getNodeName();
            ArrayList<Integer> currentBusSpeeds = new ArrayList<Integer>();
            NodeList speedNodes = nodes.item(i).getChildNodes();
            for (int j = 0; j < speedNodes.getLength(); ++j) {
                Integer speed;
                if (speedNodes.item(j).getNodeType() != 1 || !speedNodes.item(j).getNodeName().equalsIgnoreCase("BusSpeed")) continue;
                try {
                    speed = Integer.valueOf(speedNodes.item(j).getTextContent());
                    if (speed < 0) {
                        throw new NumberFormatException("Not a non negative integer value.");
                    }
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                    throw new ParseException("Bad XML file, Id 'value' be a valid non-negative value");
                }
                currentBusSpeeds.add(speed);
            }
            this._busSpeedsOfDebugConfig.put(busTypeName, currentBusSpeeds);
        }
    }

    private void importHeciConfigInformation() throws ParseException {
        NodeList nodes;
        try {
            XPath xpath = XPathFactory.newInstance().newXPath();
            XPathExpression xpr = xpath.compile("//ISH/HeciConfiguration/BusTypes/BusType");
            nodes = (NodeList)xpr.evaluate(this._fieldsDef, XPathConstants.NODESET);
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
            throw new ParseException("Bad XML file.");
        }
        this._busTypesOfHeciConfig = new ArrayList();
        for (int i = 0; i < nodes.getLength(); ++i) {
            if (nodes.item(i).getNodeType() != 1 || !nodes.item(i).getNodeName().equals("BusType")) continue;
            Element element = (Element)nodes.item(i);
            String busType = element.getAttribute("Name");
            this._busTypesOfHeciConfig.add(busType);
        }
        this._busSpeedsOfHeciConfig = new HashMap();
        this._busSpeedsOfHeciConfig.put("UART", this.getSpeedsOfHeciByBusType("UART"));
        this._busSpeedsOfHeciConfig.put("SPI", this.getSpeedsOfHeciByBusType("SPI"));
    }

    private ArrayList<Integer> getSpeedsOfHeciByBusType(String busTypeElementName) throws ParseException {
        NodeList nodes;
        ArrayList<Integer> res = new ArrayList<Integer>();
        try {
            XPath xpath = XPathFactory.newInstance().newXPath();
            XPathExpression xpr = xpath.compile("//ISH/HeciConfiguration/BusSpeeds/" + busTypeElementName + "/BusSpeed");
            nodes = (NodeList)xpr.evaluate(this._fieldsDef, XPathConstants.NODESET);
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
            throw new ParseException("Bad XML file.");
        }
        for (int i = 0; i < nodes.getLength(); ++i) {
            Integer id;
            if (nodes.item(i).getNodeType() != 1 || !nodes.item(i).getNodeName().equals("BusSpeed")) continue;
            Element element = (Element)nodes.item(i);
            try {
                id = Integer.valueOf(element.getTextContent());
                if (id < 0) {
                    throw new NumberFormatException("Not a non negative integer value.");
                }
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
                throw new ParseException("Bad XML file, Id 'value' be a valid non-negative value");
            }
            res.add(id);
        }
        return res;
    }

    private void importGPIOInformation() throws ParseException {
        this.importSimpleFieldInfo("GPIO", "Modes", "Mode", false, this._gpioModes);
        this.importSimpleFieldInfo("GPIO", "Purposes", "Purpose", false, this._gpioPorpuses);
    }

    private void importActionInformation() throws ParseException {
        NodeList nodes;
        try {
            XPath xpath = XPathFactory.newInstance().newXPath();
            XPathExpression xpr = xpath.compile("//ISH/Actions/Action");
            nodes = (NodeList)xpr.evaluate(this._fieldsDef, XPathConstants.NODESET);
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
            throw new ParseException("Bad XML file.");
        }
        for (int i = 0; i < nodes.getLength(); ++i) {
            Integer value;
            if (nodes.item(i).getNodeType() != 1 || !nodes.item(i).getNodeName().equals("Action")) continue;
            Element childElement = (Element)nodes.item(i);
            try {
                value = Integer.valueOf(childElement.getAttribute("Value"));
                if (value < 0) {
                    throw new NumberFormatException("Negative action value");
                }
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
                throw new ParseException("Bad XML file, Value of 'Action' must be a valid non-negative integer");
            }
            String name = childElement.getAttribute("Name");
            if (name == null) {
                throw new ParseException("Cannot read the action name");
            }
            String needGpio = childElement.getAttribute("NeedGpio");
            LidModeConfigurationPayload.ActionInfo actionInfo = new LidModeConfigurationPayload.ActionInfo();
            actionInfo.name = name;
            actionInfo.value = value;
            actionInfo.needGpio = needGpio != null && needGpio.equals("True");
            this._PlmActions.add(actionInfo);
        }
    }

    private void importDevicePostureActionInformation() throws ParseException {
        NodeList nodes;
        try {
            XPath xpath = XPathFactory.newInstance().newXPath();
            XPathExpression xpr = xpath.compile("//ISH/DevicePostureActions/Action");
            nodes = (NodeList)xpr.evaluate(this._fieldsDef, XPathConstants.NODESET);
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
            throw new ParseException("Bad XML file.");
        }
        for (int i = 0; i < nodes.getLength(); ++i) {
            Integer value;
            if (nodes.item(i).getNodeType() != 1 || !nodes.item(i).getNodeName().equals("Action")) continue;
            Element childElement = (Element)nodes.item(i);
            try {
                value = Integer.valueOf(childElement.getAttribute("Value"));
                if (value < 0) {
                    throw new NumberFormatException("Negative action value");
                }
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
                throw new ParseException("Bad XML file, Value of 'Action' must be a valid non-negative integer");
            }
            String name = childElement.getAttribute("Name");
            if (name == null) {
                throw new ParseException("Cannot read the action name");
            }
            String needGpio = childElement.getAttribute("NeedGpio");
            DevicePostureConfigurationPayload.ActionInfo actionInfo = new DevicePostureConfigurationPayload.ActionInfo();
            actionInfo.name = name;
            actionInfo.value = value;
            actionInfo.needGpio = needGpio != null && needGpio.equals("True");
            this._devicePostureActions.add(actionInfo);
        }
    }

    private void importPlmSupportSensorTypeInformation() throws ParseException {
        NodeList nodes;
        try {
            XPath xpath = XPathFactory.newInstance().newXPath();
            XPathExpression xpr = xpath.compile("//ISH/Plm/HallConfigs/SupportSensorType");
            nodes = (NodeList)xpr.evaluate(this._fieldsDef, XPathConstants.NODESET);
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
            throw new ParseException("Bad XML file.");
        }
        for (int i = 0; i < nodes.getLength(); ++i) {
            Integer value;
            if (nodes.item(i).getNodeType() != 1 || !nodes.item(i).getNodeName().equals("SupportSensorType")) continue;
            Element childElement = (Element)nodes.item(i);
            try {
                value = Integer.valueOf(childElement.getAttribute("Value"));
                if (value < 0) {
                    throw new NumberFormatException("Negative action value");
                }
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
                throw new ParseException("Bad XML file, Value of 'Action' must be a valid non-negative integer");
            }
            String name = this._virtualSensorTypes.getForward(value);
            if (name == null) {
                name = this._physicalSensorTypes.getForward(value);
            }
            if (name == null) {
                name = String.valueOf(value);
            }
            LidModeConfigurationPayload.PlmSupportSensorType supportSensorType = new LidModeConfigurationPayload.PlmSupportSensorType();
            supportSensorType.sensorType = value;
            supportSensorType.sensorName = name;
            this._plmSupportSensorType.add(supportSensorType);
        }
    }

    private void importHingeAngelHallSupportSensorTypeInformation() throws ParseException {
        NodeList nodes;
        try {
            XPath xpath = XPathFactory.newInstance().newXPath();
            XPathExpression xpr = xpath.compile("//ISH/HingeAngle/HallConfigs/SupportSensorType");
            nodes = (NodeList)xpr.evaluate(this._fieldsDef, XPathConstants.NODESET);
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
            throw new ParseException("Bad XML file.");
        }
        for (int i = 0; i < nodes.getLength(); ++i) {
            Integer value;
            if (nodes.item(i).getNodeType() != 1 || !nodes.item(i).getNodeName().equals("SupportSensorType")) continue;
            Element childElement = (Element)nodes.item(i);
            try {
                value = Integer.valueOf(childElement.getAttribute("Value"));
                if (value < 0) {
                    throw new NumberFormatException("Negative action value");
                }
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
                throw new ParseException("Bad XML file, Value of 'Action' must be a valid non-negative integer");
            }
            String name = this._virtualSensorTypes.getForward(value);
            if (name == null) {
                name = this._physicalSensorTypes.getForward(value);
            }
            if (name == null) {
                name = String.valueOf(value);
            }
            HingeAngleConfigurationPayload.HallSupportSensorType supportSensorType = new HingeAngleConfigurationPayload.HallSupportSensorType();
            supportSensorType.sensorType = value;
            supportSensorType.sensorName = name;
            this._hingeAngleHallSupportSensorType.add(supportSensorType);
        }
    }

    private void importDebugConfigurationInfo() throws ParseException {
        NodeList parents;
        try {
            XPath xpath = XPathFactory.newInstance().newXPath();
            XPathExpression xpr = isOldTraceComponent ? xpath.compile("//ISH/DebugConfiguration/ComponentFilter//MajorComponents//MajorComponent") : xpath.compile("//components//major_component");
            parents = (NodeList)xpr.evaluate(this._fwDef, XPathConstants.NODESET);
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
            throw new ParseException("Bad XML file.");
        }
        for (int i = 0; i < parents.getLength(); ++i) {
            Integer id;
            if (parents.item(i).getNodeType() != 1 || isOldTraceComponent && !parents.item(i).getNodeName().equals("MajorComponent") || !isOldTraceComponent && !parents.item(i).getNodeName().equals("major_component")) continue;
            Element parentElement = (Element)parents.item(i);
            try {
                id = Integer.parseInt(parentElement.getAttribute("value").substring(2), 16);
                if (id < 0) {
                    throw new NumberFormatException("Negative Value");
                }
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
                throw new ParseException("Bad XML file, Id 'value' be a valid non-negative hex value");
            }
            Parent parentObj = new Parent();
            parentObj.name = isOldTraceComponent ? parentElement.getAttribute("Name") : parentElement.getAttribute("string");
            if (parentObj.name == null) {
                throw new ParseException("Cannot read field name");
            }
            this._debugConfFilterMaskParents.put(id, parentObj);
            NodeList childs = parentElement.getChildNodes();
            for (int j = 0; j < childs.getLength(); ++j) {
                Integer childId;
                if (childs.item(j).getNodeType() != 1 || isOldTraceComponent && !childs.item(j).getNodeName().equals("SubComponent") || !isOldTraceComponent && !childs.item(j).getNodeName().equals("sub_component")) continue;
                Element childElement = (Element)childs.item(j);
                try {
                    childId = Integer.parseInt(childElement.getAttribute("value").substring(2), 16);
                    if (id < 0) {
                        throw new NumberFormatException("Negative Value");
                    }
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                    throw new ParseException("Bad XML file, 'value' must be a valid non-negative hex value");
                }
                String childName = isOldTraceComponent ? childElement.getAttribute("Name") : childElement.getAttribute("string");
                if (childName == null) {
                    throw new ParseException("Cannot read field name");
                }
                parentObj.childs.put(childId, childName);
            }
        }
    }

    public String getProperty(String property) {
        return this._properties.get(property);
    }

    public ArrayList<String> getAllSensorTypeNames(boolean physical) {
        ArrayList<String> res = new ArrayList<String>((physical ? this._physicalSensorTypes : this._virtualSensorTypes).getValueList());
        Collections.sort(res);
        return res;
    }

    public String getSensorTypeName(int sensorTypeId, boolean physical) {
        String res = (physical ? this._physicalSensorTypes : this._virtualSensorTypes).getForward(sensorTypeId);
        return res != null ? res : String.valueOf(sensorTypeId);
    }

    public Integer getSensorTypeId(String sensorTypeName, boolean physical) {
        Integer res = (physical ? this._physicalSensorTypes : this._virtualSensorTypes).getBackward(sensorTypeName);
        if (res == null) {
            try {
                return Integer.valueOf(sensorTypeName);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return res;
    }

    public ArrayList<String> getAllVendorNames() {
        ArrayList<String> res = new ArrayList<String>(this._vendors.getValueList());
        Collections.sort(res);
        return res;
    }

    public String getVendorName(int sensorTypeId) {
        String res = this._vendors.getForward(sensorTypeId);
        return res != null ? res : String.valueOf(sensorTypeId);
    }

    public Integer getVendorId(String sensorTypeName) {
        Integer res = this._vendors.getBackward(sensorTypeName);
        if (res == null) {
            try {
                return Integer.valueOf(sensorTypeName);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return res;
    }

    public ArrayList<String> getAllModelsOfVendorAndSensorType(boolean physical, int sensorType, int vendorId) {
        HashMap<Integer, HashMap<Integer, BiMap<Integer, ArrayList<ModelInfo>>>> dataBase = physical ? this._physicalModelsByVendorAndType : this._virtualModelsByVendorAndType;
        HashMap<Integer, BiMap<Integer, ArrayList<ModelInfo>>> typeToModel = dataBase.get(vendorId);
        if (typeToModel == null) {
            return null;
        }
        BiMap<Integer, ArrayList<ModelInfo>> modelMap = typeToModel.get(sensorType);
        if (modelMap == null) {
            return null;
        }
        ArrayList<ModelInfo> modelsInfo = new ArrayList<ModelInfo>();
        for (ArrayList<ModelInfo> modelList : modelMap.getValueList()) {
            modelsInfo.addAll(modelList);
        }
        ArrayList<String> res = new ArrayList<String>();
        for (ModelInfo modelInfo : modelsInfo) {
            res.add(modelInfo.name);
        }
        Collections.sort(res);
        return res;
    }

    public ArrayList<ModelInfo> getModelInfo(boolean physical, int sensorType, int vendorId, int modelId) {
        HashMap<Integer, HashMap<Integer, BiMap<Integer, ArrayList<ModelInfo>>>> dataBase = physical ? this._physicalModelsByVendorAndType : this._virtualModelsByVendorAndType;
        HashMap<Integer, BiMap<Integer, ArrayList<ModelInfo>>> typeToModel = dataBase.get(vendorId);
        if (typeToModel == null) {
            return null;
        }
        BiMap<Integer, ArrayList<ModelInfo>> modelMap = typeToModel.get(sensorType);
        if (modelMap == null) {
            return null;
        }
        return modelMap.getForward(modelId);
    }

    public ModelInfo getModelInfo(boolean physical, int sensorType, int vendorId, int modelId, int flags) {
        ArrayList<ModelInfo> models = this.getModelInfo(physical, sensorType, vendorId, modelId);
        if (models == null) {
            return null;
        }
        for (ModelInfo modelInfo : models) {
            if (!new Luid(0, 0, 0, 0, modelInfo.flags).staticEqualFlags(new Luid(0, 0, 0, 0, flags))) continue;
            return modelInfo;
        }
        return null;
    }

    public String getModelName(boolean physical, int sensorType, int vendorId, int modelId) {
        ArrayList<ModelInfo> modelInfo = this.getModelInfo(physical, sensorType, vendorId, modelId);
        String res = modelInfo != null && modelInfo.size() > 0 ? modelInfo.get((int)0).name : null;
        return res != null ? res : String.valueOf(modelId);
    }

    public String getModelName(boolean physical, int sensorType, int vendorId, int modelId, int flags) {
        if (flags < 0) {
            return this.getModelName(physical, sensorType, vendorId, modelId);
        }
        ModelInfo modelInfo = this.getModelInfo(physical, sensorType, vendorId, modelId, flags);
        String res = modelInfo != null ? modelInfo.name : null;
        return res != null ? res : String.valueOf(modelId);
    }

    public Integer getModelId(boolean physical, int sensorType, int vendorId, String modelName) {
        HashMap<Integer, HashMap<Integer, BiMap<Integer, ArrayList<ModelInfo>>>> dataBase = physical ? this._physicalModelsByVendorAndType : this._virtualModelsByVendorAndType;
        HashMap<Integer, BiMap<Integer, ArrayList<ModelInfo>>> typeToModel = dataBase.get(vendorId);
        if (typeToModel == null) {
            return null;
        }
        BiMap<Integer, ArrayList<ModelInfo>> modelMap = typeToModel.get(sensorType);
        if (modelMap == null) {
            return null;
        }
        for (Integer key : modelMap.getForwardMap().keySet()) {
            ArrayList<ModelInfo> modelsOfKey = modelMap.getForward(key);
            if (modelsOfKey == null) continue;
            for (ModelInfo modelInfo : modelsOfKey) {
                if (!modelInfo.name.equals(modelName)) continue;
                return key;
            }
        }
        return -1;
    }

    public ArrayList<Integer> getSensorTypeWithFwFlag(String flag) {
        ArrayList<Integer> res = new ArrayList<Integer>();
        for (Integer typeId : this._sensorTypeFwFlags.keySet()) {
            if (this._sensorTypeFwFlags.get(typeId) == null || !this._sensorTypeFwFlags.get(typeId).contains(flag)) continue;
            res.add(typeId);
        }
        return res;
    }

    public void setDependeciesInfoToSensor(Sensor sensor) {
        Luid luid = sensor.getLuid();
        ModelInfo modelInfo = this.getModelInfo(luid.getIsPhysical(), luid.getSensorTypeId(), luid.getVendorId(), luid.getSensorSubTypeId(), luid.getFlags());
        if (modelInfo != null) {
            sensor.setDependencies(modelInfo.dependecies);
        } else {
            sensor.setDependencies(null);
        }
    }

    public ArrayList<String> getAllBusTypeNames() {
        return new ArrayList<String>(this._busTypes.getValueList());
    }

    public String getBusTypeName(int busTypeId) {
        String res = this._busTypes.getForward(busTypeId);
        return res != null ? res : String.valueOf(busTypeId);
    }

    public Integer getBusTypeId(String busTypeName) {
        return this._busTypes.getBackwardMap().getOrDefault(busTypeName, 0);
    }

    public ArrayList<String> getAllBusInstanceNames() {
        return new ArrayList<String>(this._busInstances.getValueList());
    }

    public String getBusInstanceName(int instanceValue) {
        String res = this._busInstances.getForward(instanceValue);
        return res != null ? res : String.valueOf(instanceValue);
    }

    public Integer getBusInstanceValue(String InstanceName) {
        return this._busInstances.getBackward(InstanceName);
    }

    public ArrayList<String> getAllBusSpeedNames(int busType) {
        ArrayList<String> res = new ArrayList<String>();
        if (busType == 0) {
            res.addAll(this._i2cBusSpeeds.getValueList());
        } else if (busType == 1) {
            res.addAll(this._uartBusSpeeds.getValueList());
        } else if (busType == 2) {
            res.addAll(this._spiBusSpeeds.getValueList());
        } else if (busType == 3) {
            res.addAll(this._i3cBusSpeeds.getValueList());
        }
        return res;
    }

    public String getBusSpeedName(int busType, int busSpeedValue) {
        String res = null;
        if (busType == 0) {
            res = this._i2cBusSpeeds.getForward(busSpeedValue);
        } else if (busType == 1) {
            res = this._uartBusSpeeds.getForward(busSpeedValue);
        } else if (busType == 2) {
            res = this._spiBusSpeeds.getForward(busSpeedValue);
        } else if (busType == 3) {
            res = this._i3cBusSpeeds.getForward(busSpeedValue);
        }
        return res != null ? res : String.valueOf(busSpeedValue);
    }

    public Integer getBusSpeedValue(int busType, String SpeedName) {
        if (busType == 0) {
            return this._i2cBusSpeeds.getBackwardMap().getOrDefault(SpeedName, -1);
        }
        if (busType == 1) {
            return this._uartBusSpeeds.getBackwardMap().getOrDefault(SpeedName, -1);
        }
        if (busType == 2) {
            return this._spiBusSpeeds.getBackwardMap().getOrDefault(SpeedName, -1);
        }
        if (busType == 3) {
            return this._i3cBusSpeeds.getBackwardMap().getOrDefault(SpeedName, -1);
        }
        return -1;
    }

    public ArrayList<String> getAllGpioPurposeNames() {
        return new ArrayList<String>(this._gpioPorpuses.getValueList());
    }

    public String getGpioPurposeName(int gpioPurposeId) {
        String res = this._gpioPorpuses.getForward(gpioPurposeId);
        return res != null ? res : String.valueOf(gpioPurposeId);
    }

    public Integer getGpioPurposeId(String gpioPurposeName) {
        return this._gpioPorpuses.getBackward(gpioPurposeName);
    }

    public ArrayList<String> getAllGpioModesNames() {
        return new ArrayList<String>(this._gpioModes.getValueList());
    }

    public String getGpioModeName(int gpioModeId) {
        String res = this._gpioModes.getForward(gpioModeId);
        return res != null ? res : String.valueOf(gpioModeId);
    }

    public Integer getGpioModeId(String gpioModeName) {
        return this._gpioModes.getBackwardMap().getOrDefault(gpioModeName, -1);
    }

    public ArrayList<LidModeConfigurationPayload.ActionInfo> getAllPlmActions() {
        return this._PlmActions;
    }

    public LidModeConfigurationPayload.ActionInfo getPlmActionById(int actionId) {
        for (LidModeConfigurationPayload.ActionInfo plmAction : this._PlmActions) {
            if (plmAction.value != actionId) continue;
            return plmAction;
        }
        return null;
    }

    public LidModeConfigurationPayload.ActionInfo getPlmActionByName(String actionName) {
        for (LidModeConfigurationPayload.ActionInfo plmAction : this._PlmActions) {
            if (!plmAction.name.equals(actionName)) continue;
            return plmAction;
        }
        return null;
    }

    public ArrayList<DevicePostureConfigurationPayload.ActionInfo> getAllDevicePostureActions() {
        return this._devicePostureActions;
    }

    public ArrayList<LidModeConfigurationPayload.PlmSupportSensorType> getAllPlmSupportSensorTypes() {
        return this._plmSupportSensorType;
    }

    public ArrayList<HingeAngleConfigurationPayload.HallSupportSensorType> getAllHingeAngleHallSupportSensorTypes() {
        return this._hingeAngleHallSupportSensorType;
    }

    public DevicePostureConfigurationPayload.ActionInfo getDevicePostureActionById(int actionId) {
        for (DevicePostureConfigurationPayload.ActionInfo devicePostureAction : this._devicePostureActions) {
            if (devicePostureAction.value != actionId) continue;
            return devicePostureAction;
        }
        return null;
    }

    public DevicePostureConfigurationPayload.ActionInfo getDevicePostureActionByName(String actionName) {
        for (DevicePostureConfigurationPayload.ActionInfo devicePostureAction : this._devicePostureActions) {
            if (!devicePostureAction.name.equals(actionName)) continue;
            return devicePostureAction;
        }
        return null;
    }

    public LidModeConfigurationPayload.PlmSupportSensorType getPlmSupportSensorTypeById(int sensorId) {
        for (LidModeConfigurationPayload.PlmSupportSensorType supportSensorType : this._plmSupportSensorType) {
            if (supportSensorType.sensorType != sensorId) continue;
            return supportSensorType;
        }
        return null;
    }

    public LidModeConfigurationPayload.PlmSupportSensorType getPlmSupportSensorTypeByName(String sensorName) {
        for (LidModeConfigurationPayload.PlmSupportSensorType supportSensorType : this._plmSupportSensorType) {
            if (!supportSensorType.sensorName.equals(sensorName)) continue;
            return supportSensorType;
        }
        return null;
    }

    public HingeAngleConfigurationPayload.HallSupportSensorType getHingeAngleHallSupportSensorTypeById(int sensorId) {
        for (HingeAngleConfigurationPayload.HallSupportSensorType supportSensorType : this._hingeAngleHallSupportSensorType) {
            if (supportSensorType.sensorType != sensorId) continue;
            return supportSensorType;
        }
        return null;
    }

    public HingeAngleConfigurationPayload.HallSupportSensorType getHingeAngleHallSupportSensorTypeByName(String sensorName) {
        for (HingeAngleConfigurationPayload.HallSupportSensorType supportSensorType : this._hingeAngleHallSupportSensorType) {
            if (!supportSensorType.sensorName.equals(sensorName)) continue;
            return supportSensorType;
        }
        return null;
    }

    public boolean isAddressEnabledForBusType(String busTypeName) {
        Boolean res = this._enabledAddressForBusType.get(busTypeName);
        return res != null ? res : false;
    }

    public boolean isSpeedEnabledForBusType(String busTypeName) {
        Boolean res = this._enabledSpeedForBusType.get(busTypeName);
        return res != null ? res : false;
    }

    public boolean isRtsCtsEnabledForBusType(String busTypeName) {
        Boolean res = this._enabledRtsCtsBusType.get(busTypeName);
        return res != null ? res : false;
    }

    public boolean isCsNativeEnabledForBusType(String busTypeName) {
        Boolean res = this._enabledCsNativeForBusType.get(busTypeName);
        return res != null ? res : false;
    }

    public boolean isCsPinEnabledForBusType(String busTypeName) {
        Boolean res = this._enabledCsPinForBusType.get(busTypeName);
        return res != null ? res : false;
    }

    public ArrayList<String> getSensorRelevantBusTypes() {
        return this._busTypesOfSensors;
    }

    public ArrayList<String> getHeciConfigRelevantBusTypes() {
        return this._busTypesOfHeciConfig;
    }

    public HashMap<String, ArrayList<Integer>> getHeciConfigRelevantBusSpeeds() {
        return this._busSpeedsOfHeciConfig;
    }

    public HashMap<String, ArrayList<Integer>> getDebugConfigRelevantBusSpeeds() {
        return this._busSpeedsOfDebugConfig;
    }

    public HashMap<Integer, String> getAllDebugConfFilterMaskNames() {
        HashMap<Integer, String> res = new HashMap<Integer, String>();
        if (this._debugConfFilterMaskParents.getForwardMap() != null) {
            for (Map.Entry<Integer, Parent> entry : this._debugConfFilterMaskParents.getForwardMap().entrySet()) {
                int parentId = entry.getKey();
                Parent parent = entry.getValue();
                res.put(parentId, parent.name);
            }
        }
        return res;
    }

    public BiMap<Integer, String> getDebugConfFilterMaskChilds(int parentId) {
        Parent parent = this._debugConfFilterMaskParents.getForward(parentId);
        if (parent == null) {
            return null;
        }
        return parent.childs;
    }

    private void importI3CAddressInfo() throws ParseException {
        NodeList nodes;
        try {
            XPath xpath = XPathFactory.newInstance().newXPath();
            XPathExpression xpr = xpath.compile("//ISH/I3C/AddressTypes/AddressType");
            nodes = (NodeList)xpr.evaluate(this._fieldsDef, XPathConstants.NODESET);
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
            throw new ParseException("Bad XML file.");
        }
        for (int i = 0; i < nodes.getLength(); ++i) {
            Integer size;
            Integer value;
            String name;
            if (nodes.item(i).getNodeType() != 1 || !nodes.item(i).getNodeName().equals("AddressType")) continue;
            Element childElement = (Element)nodes.item(i);
            try {
                name = childElement.getAttribute("Name");
                if (name == null) {
                    throw new ParseException("Cannot read the I3C address's name");
                }
                value = Integer.valueOf(childElement.getAttribute("Value"));
                size = Integer.valueOf(childElement.getAttribute("AddressSize"));
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
                throw new ParseException("Bad XML file");
            }
            this._i3cAddressType.put(value, name);
            this._i3cAddressSize.put(name, size);
        }
    }

    public ArrayList<String> getAllI3CAddressType() {
        ArrayList<String> res = new ArrayList<String>(this._i3cAddressType.getValueList());
        return res;
    }

    public Integer getI3CAddressSizeByTypeName(String name) {
        Integer size = this._i3cAddressSize.getForwardMap().getOrDefault(name, 1);
        return size;
    }

    public Integer getI3CAddressTypeByName(String name) {
        return this._i3cAddressType.getBackwardMap().getOrDefault(name, 1);
    }

    public String getI3CAddressTypeNameById(int id) {
        return this._i3cAddressType.getForward(id);
    }

    public boolean isAddressTypeEnabledForBusType(String busTypeName) {
        Boolean res = this._enabledAddressTypeForBusType.get(busTypeName);
        return res != null ? res : false;
    }

    public boolean isIbiPurposeEnabledForBusType(String busTypeName) {
        Boolean res = this._enabledIbiPurposeForBusType.get(busTypeName);
        return res != null ? res : false;
    }

    public ArrayList<String> getAllI3CIbiPurpose() {
        ArrayList<String> res = new ArrayList<String>(this._i3cIbiPurpose.getValueList());
        return res;
    }

    public Integer getI3CIbiPurposeIdByName(String name) {
        return this._i3cIbiPurpose.getBackwardMap().getOrDefault(name, 0);
    }

    public String getI3CIbiPurposeNameById(int id) {
        return this._i3cIbiPurpose.getForward(id);
    }

    public static class Parent {
        public String name;
        public BiMap<Integer, String> childs = new BiMap();
    }

    public static class ModelInfo {
        String name = null;
        int flags = -1;
        ArrayList<SensorData> dependecies = null;

        public boolean equals(Object arg0) {
            if (!(arg0 instanceof ModelInfo)) {
                return false;
            }
            ModelInfo other = (ModelInfo)arg0;
            return this.name.equals(other.name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }
    }
}

