/*
 * Decompiled with CFR 0.152.
 */
package pdtEditor;

import binTools.Common;
import java.io.IOException;
import java.util.ArrayList;
import javax.xml.bind.DatatypeConverter;
import javax.xml.parsers.ParserConfigurationException;
import manager.sensor.SensorData;
import manager.utils.ManagerEnums;
import org.eclipse.jface.bindings.keys.ParseException;
import org.xml.sax.SAXException;
import pdtEditor.DataStore;
import pdtEditor.Device;
import pdtEditor.IComponent;
import pdtEditor.InformationStore;
import pdtEditor.Logger;
import pdtEditor.Sensor;
import pdtEditor.validation.Validator;

public class Luid
implements IComponent {
    public static final int[] SENSOR_TYPE_INTEL_MANAGED_RANGE = new int[]{0, Short.MAX_VALUE};
    public static final int[] VENDOR_ID_INTEL_MANAGED_RANGE = new int[]{0, 255};
    public static final int[] MODEL_ID_INTEL_MANAGED_RANGE = new int[]{0, 255};
    public static final int SENSOR_TYPE_FIELD_SIZE = 2;
    public static final int VENDOR_FIELD_SIZE = 2;
    public static final int MODEL_FIELD_SIZE = 2;
    public static final int INSTANCE_FIELD_SIZE = 1;
    public static final int FLAGS_FIELD_SIZE = 1;
    public static final int SENSOR_TYPE_FIELD_MAX_VALUE = (int)Math.pow(2.0, 16.0) - 1;
    public static final int VENDOR_FIELD_MAX_VALUE = (int)Math.pow(2.0, 16.0) - 1;
    public static final int MODEL_FIELD_MAX_VALUE = (int)Math.pow(2.0, 16.0) - 1;
    public static final int INSTANCE_FIELD_MAX_VALUE = (int)Math.pow(2.0, 8.0) - 1;
    public static final int VENDOR_ID_INTEL = 0;
    public static final int BITS_IN_BYTE = 8;
    private int _sensorTypeId;
    private int _sensorSubTypeId;
    private int _vendorId;
    private int _instanceId;
    private Flags _flagsContent = new Flags();
    private boolean _flagsModified = true;
    private SensorData _givenMetadata = null;
    private boolean _codeDefinesNotExposedFlag = false;
    private boolean _codeDefinesCustomFlag = false;

    public Luid(int sensorTypeId, int sensorSubTypeId, int vendorId, int instanceId, int flags) {
        this._sensorTypeId = sensorTypeId;
        this._sensorSubTypeId = sensorSubTypeId;
        this._vendorId = vendorId;
        this._instanceId = instanceId;
        this.setFlags(flags);
    }

    public Luid(SensorData sensorData) {
        this._givenMetadata = sensorData;
        this._sensorTypeId = sensorData.getTypeId();
        this._sensorSubTypeId = sensorData.getModelId();
        this._vendorId = sensorData.getVendorId();
        this._instanceId = sensorData.getInstanceId();
        this.setMetadataFlags(sensorData);
        this.setFlagsModified(false);
    }

    public Luid(Luid other) {
        this._sensorTypeId = other._sensorTypeId;
        this._sensorSubTypeId = other._sensorSubTypeId;
        this._vendorId = other._vendorId;
        this._instanceId = other._instanceId;
        this.setFlags(other.getFlags());
        this._flagsModified = other._flagsModified;
    }

    public Luid clone() {
        return new Luid(this);
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof Luid)) {
            return false;
        }
        Luid otherLuid = (Luid)other;
        return this._sensorTypeId == otherLuid._sensorTypeId && this._sensorSubTypeId == otherLuid._sensorSubTypeId && this._vendorId == otherLuid._vendorId && this._instanceId == otherLuid._instanceId && this.getFlags() == otherLuid.getFlags();
    }

    public boolean staticEquals(Luid otherLuid) {
        return this._sensorTypeId == otherLuid._sensorTypeId && this._sensorSubTypeId == otherLuid._sensorSubTypeId && this._vendorId == otherLuid._vendorId && this.staticEqualFlags(otherLuid);
    }

    public boolean staticEqualFlags(Luid otherLuid) {
        return this.getIsCalibrated() == otherLuid.getIsCalibrated() && this.getIsPhysical() == otherLuid.getIsPhysical() && this.getIsMsExt() == otherLuid.getIsMsExt() && this.getIsAndroidExt() == otherLuid.getIsAndroidExt() && this.getIsSynthetic() == otherLuid.getIsSynthetic();
    }

    public void clearMetaDataInto() {
        this._givenMetadata = null;
        this._codeDefinesNotExposedFlag = false;
        this._codeDefinesCustomFlag = false;
    }

    public int getSensorTypeId() {
        return this._sensorTypeId;
    }

    public String getSensorTypeIdStr() {
        try {
            return InformationStore.getInstance().getSensorTypeName(this._sensorTypeId, this._flagsContent._physical);
        }
        catch (Exception e) {
            e.printStackTrace();
            return String.valueOf(this._sensorTypeId);
        }
    }

    public void setSensorTypeId(int sensorTypeId) {
        this.clearMetaDataInto();
        this._sensorTypeId = sensorTypeId;
    }

    public int getSensorSubTypeId() {
        return this._sensorSubTypeId;
    }

    public String getSensorSubTypeIdStr() {
        if (this._givenMetadata != null && this._givenMetadata.getModelName() != null && !this._givenMetadata.getModelName().isEmpty()) {
            return this._givenMetadata.getModelName();
        }
        try {
            return InformationStore.getInstance().getModelName(this.getIsPhysical(), this._sensorTypeId, this._vendorId, this._sensorSubTypeId, this.getFlags());
        }
        catch (Exception e) {
            e.printStackTrace();
            return String.valueOf(this._sensorTypeId);
        }
    }

    public void setSensorSubTypeId(int sensorSubTypeId) {
        this.clearMetaDataInto();
        this._sensorSubTypeId = sensorSubTypeId;
    }

    public int getVendorId() {
        return this._vendorId;
    }

    public String getVendorIdStr() {
        try {
            return InformationStore.getInstance().getVendorName(this.getVendorId());
        }
        catch (Exception e) {
            e.printStackTrace();
            return String.valueOf(this.getVendorId());
        }
    }

    public void setVendorId(int vendorId) {
        this.clearMetaDataInto();
        this._vendorId = vendorId;
    }

    public int getInstanceId() {
        return this._instanceId;
    }

    public void setInstanceId(int instanceId) {
        this._instanceId = instanceId;
    }

    public int getFlags() {
        String binFlags = "";
        binFlags = binFlags + (this._flagsContent._custom ? "1" : "0");
        binFlags = binFlags + (this._flagsContent._not_exposed ? "1" : "0");
        binFlags = binFlags + (this._flagsContent._wakeable ? "1" : "0");
        binFlags = binFlags + (this._flagsContent._reserved1 ? "1" : "0");
        binFlags = binFlags + (this._flagsContent._android_ext ? "1" : "0");
        binFlags = binFlags + (this._flagsContent._ms_ext ? "1" : "0");
        binFlags = binFlags + (this._flagsContent._physical ? "1" : "0");
        binFlags = binFlags + (this._flagsContent._calibrated ? "1" : "0");
        return Integer.parseInt(binFlags, 2);
    }

    public void setFlags(int flags, boolean setDynamic) {
        String binFlags = Integer.toBinaryString(flags);
        StringBuilder zeroPadding = new StringBuilder();
        for (int i = binFlags.length(); i < 8; ++i) {
            zeroPadding.append("0");
        }
        binFlags = zeroPadding.toString() + binFlags;
        this._flagsContent._calibrated = binFlags.charAt(binFlags.length() - 1) == '1';
        this._flagsContent._physical = binFlags.charAt(binFlags.length() - 2) == '1';
        this._flagsContent._ms_ext = binFlags.charAt(binFlags.length() - 3) == '1';
        this._flagsContent._android_ext = binFlags.charAt(binFlags.length() - 4) == '1';
        boolean bl = this._flagsContent._reserved1 = binFlags.charAt(binFlags.length() - 5) == '1';
        if (setDynamic) {
            this._flagsContent._wakeable = binFlags.charAt(binFlags.length() - 6) == '1';
            this._flagsContent._not_exposed = binFlags.charAt(binFlags.length() - 7) == '1';
            this._flagsContent._custom = binFlags.charAt(binFlags.length() - 8) == '1';
        }
    }

    public void setFlags(int flags) {
        this.setFlags(flags, true);
    }

    public boolean getIsWakeable() {
        return this._flagsContent._wakeable;
    }

    public boolean setIsWakeable(boolean value) {
        this._flagsContent._wakeable = value;
        return this._flagsContent._wakeable;
    }

    public boolean getIsCalibrated() {
        return this._flagsContent._calibrated;
    }

    public void setIsCalibrated(boolean value) {
        this._flagsContent._calibrated = value;
    }

    public boolean getIsPhysical() {
        return this._flagsContent._physical;
    }

    public void setIsPhysical(boolean value) {
        this._flagsContent._physical = value;
    }

    public boolean getIsMsExt() {
        return this._flagsContent._ms_ext;
    }

    public void setIsMsExt(boolean value) {
        this._flagsContent._ms_ext = value;
    }

    public boolean getIsAndroidExt() {
        return this._flagsContent._android_ext;
    }

    public void setIsAndroidExt(boolean value) {
        this._flagsContent._android_ext = value;
    }

    public boolean getIsSynthetic() {
        return this._flagsContent._reserved1;
    }

    public void setIsSynthetic(boolean value) {
        this._flagsContent._reserved1 = value;
    }

    public boolean getIsNotExposed() {
        return this._flagsContent._not_exposed;
    }

    public void setIsNotExposed(boolean value) {
        this._flagsContent._not_exposed = value;
    }

    public boolean getIsCustom() {
        return this._flagsContent._custom;
    }

    public void setIsCustom(boolean value) {
        this._flagsContent._custom = value;
    }

    public boolean isCodeDefinesNotExposed() {
        return this._codeDefinesNotExposedFlag;
    }

    public boolean isCodeDefinesCustom() {
        return this._codeDefinesCustomFlag;
    }

    public void setMetadataFlags(Luid other) {
        this.setFlags(other.getFlags(), false);
        this._codeDefinesNotExposedFlag = other._codeDefinesNotExposedFlag;
        this._codeDefinesCustomFlag = other._codeDefinesCustomFlag;
    }

    public void setMetadataFlags(SensorData sensorData) {
        boolean customFlag;
        int flags = sensorData.getFlagsAsInteger();
        if (flags < 0) {
            return;
        }
        this.setFlags(flags, false);
        boolean notExposedFlag = (flags & 0x40) > 0;
        boolean bl = customFlag = (flags & 0x80) > 0;
        if (sensorData.getCustomFlagvalue() == null) {
            this._codeDefinesCustomFlag = customFlag;
            this._flagsContent._custom = customFlag || this._flagsContent._custom;
        } else {
            boolean bl2 = this._codeDefinesCustomFlag = !sensorData.getCustomFlagvalue().equals((Object)ManagerEnums.FlagValues.DEFINE_IN_PDT);
            if (this._codeDefinesCustomFlag) {
                this._flagsContent._custom = customFlag;
            }
        }
        if (sensorData.getNotExposedFlagvalue() == null) {
            this._codeDefinesNotExposedFlag = notExposedFlag;
            this._flagsContent._not_exposed = notExposedFlag || this._flagsContent._not_exposed;
        } else {
            boolean bl3 = this._codeDefinesNotExposedFlag = !sensorData.getNotExposedFlagvalue().equals((Object)ManagerEnums.FlagValues.DEFINE_IN_PDT);
            if (this._codeDefinesNotExposedFlag) {
                this._flagsContent._not_exposed = notExposedFlag;
            }
        }
    }

    public boolean isModelIdEqualToMetadatas(int modelId) {
        return this._givenMetadata != null && modelId == this._givenMetadata.getModelId();
    }

    public SensorData getGivenMetadata() {
        return this._givenMetadata;
    }

    public static ArrayList<Integer> getRS1SupportedSensorTypesList() throws ParseException, ParserConfigurationException, SAXException, IOException {
        String RS1SuppoirtingDeviceFlag = "DEV_0X" + Integer.toHexString(Device.DeviceDefaults.RS1_SUPPORTED_SENSORS.productID).toUpperCase();
        return InformationStore.getInstance().getSensorTypeWithFwFlag(RS1SuppoirtingDeviceFlag);
    }

    public void onPdtFormatVersionUpdate(int oldVersion, int newVersion, DataStore.FlowResults flowRes) {
        Luid oldLuid = this.clone();
        if (oldVersion < 4 && newVersion >= 4) {
            if (this._sensorTypeId == 118 && this._flagsContent._android_ext) {
                this._sensorTypeId = 577;
            } else if (this._sensorTypeId == 527 && this._flagsContent._android_ext) {
                this._sensorTypeId = 578;
            }
            this._flagsContent._ms_ext = false;
            this._flagsContent._android_ext = false;
            this._flagsContent._reserved1 = false;
        }
        if (oldVersion < 5 && newVersion >= 5 && this._vendorId == 0) {
            int oldType = this._sensorTypeId;
            switch (this._sensorTypeId) {
                case 562: {
                    this._sensorTypeId = 177;
                    break;
                }
                case 560: {
                    this._sensorTypeId = 180;
                    break;
                }
                case 517: {
                    this._sensorTypeId = 143;
                    break;
                }
                case 512: {
                    this._sensorTypeId = 142;
                    break;
                }
                case 513: {
                    this._sensorTypeId = 193;
                    break;
                }
                case 521: {
                    this._sensorTypeId = 123;
                    break;
                }
                case 514: {
                    this._sensorTypeId = 124;
                }
            }
            if (this._sensorTypeId != oldType) {
                this.setIsCustom(false);
            }
        }
        if (!oldLuid.equals(this)) {
            Logger.instance().log(this, "***Sensor definition changed: [Old: " + oldLuid + "] [New: " + this + "]***");
        }
    }

    public void checkValidity(Validator sensorValidator, Sensor sensor) {
    }

    public String getHexValue() {
        byte[] sensorType = Common.intToByteArr(2, this._sensorTypeId);
        byte[] vendorId = Common.intToByteArr(2, this._vendorId);
        byte[] subTypeId = Common.intToByteArr(2, this._sensorSubTypeId);
        byte[] instanceId = Common.intToByteArr(1, this._instanceId);
        byte[] flags = Common.intToByteArr(1, this.getFlags());
        byte[] luid = new byte[]{sensorType[1], sensorType[0], vendorId[1], vendorId[0], subTypeId[1], subTypeId[0], instanceId[0], flags[0]};
        return DatatypeConverter.printHexBinary((byte[])luid);
    }

    public String getStaticFlagsStr() {
        String res = "";
        res = res + (this.getIsCalibrated() ? ", Calibrated" : "");
        res = res + (this.getIsPhysical() ? ", Physical" : "");
        res = res + (this.getIsMsExt() ? ", Microsoft extanded" : "");
        res = res + (this.getIsAndroidExt() ? ", Android extanded" : "");
        if ((res = res + (this.getIsSynthetic() ? ", Sythetic" : "")).startsWith(",")) {
            res = res.substring(2);
        }
        return res;
    }

    public String getFlagsStr() {
        String res = "";
        res = res + this.getStaticFlagsStr();
        res = res + (this.getIsNotExposed() ? ", Not exposed" : "");
        res = res + (this.getIsCustom() ? ", Custom" : "");
        if ((res = res + (this.getIsWakeable() ? ", Wakeable" : "")).startsWith(",")) {
            res = res.substring(2);
        }
        return res;
    }

    public static String getStaticFlagsStr(int flags) {
        Luid luid = new Luid(0, 0, 0, 0, flags);
        return luid.getStaticFlagsStr();
    }

    public static String getFlagsStr(int flags) {
        Luid luid = new Luid(0, 0, 0, 0, flags);
        return luid.getFlagsStr();
    }

    public String toString() {
        String sensorTypeStr = String.valueOf(this._sensorTypeId).equals(this.getSensorTypeIdStr()) ? "" : " (" + this.getSensorTypeIdStr() + ")";
        String sensorVendorStr = String.valueOf(this._vendorId).equals(this.getVendorIdStr()) ? "" : " (" + this.getVendorIdStr() + ")";
        String sensorModelStr = String.valueOf(this._sensorSubTypeId).equals(this.getSensorSubTypeIdStr()) ? "" : " (" + this.getSensorSubTypeIdStr() + ")";
        return "type: " + this._sensorTypeId + sensorTypeStr + ", model: " + this._sensorSubTypeId + sensorModelStr + ", vendor: " + this._vendorId + sensorVendorStr + ", instance: " + this._instanceId + ", flags: {" + this.getFlagsStr() + "}";
    }

    public static void main(String[] args) {
        Luid luid = new Luid(115, 1, 1, 0, 130);
        System.out.println(luid.getHexValue());
    }

    public boolean isFlagsModified() {
        return this._flagsModified;
    }

    public void setFlagsModified(boolean flagsModified) {
        this._flagsModified = flagsModified;
    }

    public int hashCode() {
        return super.hashCode();
    }

    private class Flags {
        public boolean _calibrated;
        public boolean _physical;
        public boolean _ms_ext;
        public boolean _android_ext;
        public boolean _reserved1;
        public boolean _wakeable;
        public boolean _not_exposed;
        public boolean _custom;

        private Flags() {
        }
    }
}

