/*
 * Decompiled with CFR 0.152.
 */
package pdtEditor;

import binTools.BinWriter;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.channels.FileLock;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import manager.sensor.SensorData;
import manager.utils.ManagerEnums;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import pdtEditor.AbstractValidatable;
import pdtEditor.BoardDescriptionTable;
import pdtEditor.CustomDataEntryTable;
import pdtEditor.DataStore;
import pdtEditor.Device;
import pdtEditor.FormFactorTable;
import pdtEditor.HeciConfigurationTable;
import pdtEditor.I2cBoardDescriptionTable;
import pdtEditor.IComponent;
import pdtEditor.InformationStore;
import pdtEditor.Logger;
import pdtEditor.Luid;
import pdtEditor.PDTExternalInfo;
import pdtEditor.PdtPropertiesTable;
import pdtEditor.PdtWriter;
import pdtEditor.PlatformIdTable;
import pdtEditor.Sensor;
import pdtEditor.gui.DependenciesUtils;
import pdtEditor.gui.DeviceProperties;
import pdtEditor.gui.SensorModifier;
import pdtEditor.payloads.GpioPayload;
import pdtEditor.validation.Fixer;
import pdtEditor.validation.Issue;

public class PdtFile
extends AbstractValidatable
implements IComponent {
    public static final int MAX_DEVICES_NUM = 6;
    public static final int MAX_SENSOR_NUM = 64;
    private static final String SENSOR_COUNT_EXCEED_MSG = "The total number of sensors in the PDT file cannot exceed 64";
    private static final String FILE_LOCKED_ERROR_MESSAGE = "This file cannot be opened because it is currently in use by another process.";
    private static final int MAX_GPIO_NUM = 20;
    private String _path;
    private FileLock _lock = null;
    private int _skuId;
    private ArrayList<BoardDescriptionTable> _boardDescriptionTables = null;
    private ArrayList<Device> _devices = new ArrayList();
    private ArrayList<Issue> _issues = new ArrayList();
    private ArrayList<Issue> _allIgnoredIssues = null;
    private ArrayList<Luid> _sensorFilter = null;

    public PdtFile(String pdtPath) {
        this._path = pdtPath;
        this._skuId = 0;
        this._boardDescriptionTables = new ArrayList();
        this.addBdtObject(new I2cBoardDescriptionTable());
        this.addBdtObject(new FormFactorTable());
        this.addBdtObject(new PdtPropertiesTable());
        this.addBdtObject(new PlatformIdTable());
    }

    public PdtFile(PdtFile other) {
        this._path = other._path != null ? (this._path = other._path) : null;
        this._skuId = other._skuId;
        if (other._devices != null) {
            this._devices = new ArrayList();
            for (Device device : other._devices) {
                this._devices.add(device.clone());
            }
        }
        this._boardDescriptionTables = other._boardDescriptionTables;
    }

    public PdtFile clone() {
        return new PdtFile(this);
    }

    public void accessAttempt() throws UnsupportedOperationException, IOException {
        try (InputStreamReader reader = null;){
            File file;
            if (this._path != null && (file = new File(this._path)).exists()) {
                reader = new FileReader(file);
                reader.read();
                return;
            }
        }
    }

    public void lock() {
    }

    public boolean unlock() throws IOException {
        if (this._lock == null) {
            return false;
        }
        this._lock.release();
        return true;
    }

    public String getPath() {
        return this._path;
    }

    public void setPath(String path) {
        this._path = path;
    }

    public int hashCode() {
        if (this._path != null) {
            return this._path.hashCode();
        }
        return super.hashCode();
    }

    public boolean equals(Object arg0) {
        if (arg0 == null || !(arg0 instanceof PdtFile)) {
            return false;
        }
        PdtFile other = (PdtFile)arg0;
        return (this._path == null && other._path == null || this._path != null && this._path.equals(other._path)) && this._skuId == other._skuId && (this._devices == null && other._devices == null || this._devices != null && this._devices.equals(other._devices)) && (this._boardDescriptionTables == null && other._boardDescriptionTables == null || this._boardDescriptionTables != null && this._boardDescriptionTables.equals(other._boardDescriptionTables));
    }

    public int getSkuId() {
        return this._skuId;
    }

    public void setSkuId(int skuId) {
        this._skuId = skuId;
    }

    public void addBdtObject(BoardDescriptionTable object) {
        for (BoardDescriptionTable bdt : this._boardDescriptionTables) {
            if (bdt.getType() != object.getType()) continue;
            this._boardDescriptionTables.remove(bdt);
            break;
        }
        this._boardDescriptionTables.add(object);
    }

    public ArrayList<BoardDescriptionTable> getBdtObjects() {
        return this._boardDescriptionTables;
    }

    public I2cBoardDescriptionTable getI2cBdt() {
        for (BoardDescriptionTable bdt : this._boardDescriptionTables) {
            if (!(bdt instanceof I2cBoardDescriptionTable)) continue;
            return (I2cBoardDescriptionTable)bdt;
        }
        return null;
    }

    public CustomDataEntryTable getCustomDataEntryTable() {
        for (BoardDescriptionTable bdt : this._boardDescriptionTables) {
            if (!(bdt instanceof CustomDataEntryTable)) continue;
            return (CustomDataEntryTable)bdt;
        }
        return null;
    }

    public HeciConfigurationTable getHeciConfigurationTable() {
        for (BoardDescriptionTable bdt : this._boardDescriptionTables) {
            if (!(bdt instanceof HeciConfigurationTable)) continue;
            return (HeciConfigurationTable)bdt;
        }
        return null;
    }

    public FormFactorTable getFormFactorTable() {
        for (BoardDescriptionTable bdt : this._boardDescriptionTables) {
            if (!(bdt instanceof FormFactorTable)) continue;
            return (FormFactorTable)bdt;
        }
        return null;
    }

    public PdtPropertiesTable getPdtPropertiesTable() {
        for (BoardDescriptionTable bdt : this._boardDescriptionTables) {
            if (!(bdt instanceof PdtPropertiesTable)) continue;
            return (PdtPropertiesTable)bdt;
        }
        return null;
    }

    public PlatformIdTable getPlatformIdTable() {
        for (BoardDescriptionTable bdt : this._boardDescriptionTables) {
            if (!(bdt instanceof PlatformIdTable)) continue;
            return (PlatformIdTable)bdt;
        }
        return null;
    }

    public ArrayList<Device> getDevicesByParameters(Integer PID, Integer VID) {
        ArrayList<Device> res = new ArrayList<Device>();
        for (Device device : this._devices) {
            if (PID != null && device.getProductId() != PID.intValue() || VID != null && device.getVendorId() != VID.intValue()) continue;
            res.add(device);
        }
        return res;
    }

    public void addDevice(Device device) {
        this._devices.add(device);
    }

    public ArrayList<Device> getDevices() {
        return this._devices;
    }

    public boolean hasDevice(Device device) {
        return this._devices.contains(device);
    }

    public ArrayList<Sensor> getAllSensors() {
        ArrayList<Sensor> res = new ArrayList<Sensor>();
        for (Device device : this._devices) {
            res.addAll(device.getSensors());
        }
        return res;
    }

    public boolean containsSensorWithEquivalentLuid(Luid luid, Sensor exclude, boolean staticCompare) {
        for (Device device : this._devices) {
            Sensor match = staticCompare ? device.getSensorByStaticLuid(luid) : device.getSensorByLuid(luid);
            if (match == null || match.equals(exclude)) continue;
            return true;
        }
        return false;
    }

    public int addImportedSensorToDevice(Sensor sensor, Device device, boolean staticCompare) {
        if (device == null && this._devices.size() > 0) {
            device = this._devices.get(0);
        }
        if (device == null) {
            return -1;
        }
        if (!this.hasDevice(device)) {
            return -1;
        }
        if (this.containsSensorWithEquivalentLuid(sensor.getLuid(), null, staticCompare)) {
            for (Device iterDev : this._devices) {
                Sensor matchingSensor = iterDev.getSensorByStaticLuid(sensor.getLuid());
                if (matchingSensor == null) continue;
                matchingSensor.updateMetaData(sensor);
            }
            return -1;
        }
        if (this.getAllSensors().size() >= 64) {
            throw new UnsupportedOperationException(SENSOR_COUNT_EXCEED_MSG);
        }
        return device.addSensor(sensor);
    }

    public void deleteAllOtherSensors(ArrayList<Luid> keepList) {
        for (Device device : this._devices) {
            device.deleteAllOtherSensors(keepList);
        }
    }

    public ArrayList<Sensor> getSensorsThatHasPayloads() {
        ArrayList<Sensor> res = new ArrayList<Sensor>();
        for (Device dev : this.getDevices()) {
            for (Sensor sens : dev.getSensors()) {
                if (!sens.hasPayloads()) continue;
                res.add(sens);
            }
        }
        Collections.sort(res, new Sensor.SdtOrderComparator());
        return res;
    }

    public void replaceSensor(Sensor oldSensor, Sensor newSensor) {
        for (Device device : this._devices) {
            device.replaceSensor(oldSensor, newSensor);
        }
    }

    public void removeDevice(Device device) {
        this._devices.remove(device);
    }

    public void filterSensors(String sensorFilteringXmlPath) throws ParserConfigurationException, SAXException, IOException, XPathExpressionException {
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
        File srcXmlFile = new File(sensorFilteringXmlPath);
        Document srcXmlDoc = dBuilder.parse(srcXmlFile);
        XPath xpath = XPathFactory.newInstance().newXPath();
        XPathExpression xpr = xpath.compile("//SelectedSensors/Sensor");
        NodeList sensors = (NodeList)xpr.evaluate(srcXmlDoc, XPathConstants.NODESET);
        if (sensors.getLength() == 0) {
            xpr = xpath.compile("//Sensors/Sensor");
            sensors = (NodeList)xpr.evaluate(srcXmlDoc, XPathConstants.NODESET);
        }
        ArrayList<Luid> keepList = new ArrayList<Luid>();
        for (int i = 0; i < sensors.getLength(); ++i) {
            if (sensors.item(i).getNodeType() != 1 || !sensors.item(i).getNodeName().equals("Sensor")) continue;
            Element sensorElement = (Element)sensors.item(i);
            try {
                int sensorTypeId = Integer.valueOf(sensorElement.getAttribute("SensorTypeId"));
                int vendorId = Integer.valueOf(sensorElement.getAttribute("VendorId"));
                int modelId = Integer.valueOf(sensorElement.getAttribute("ModelId"));
                int flags = Integer.valueOf(sensorElement.getAttribute("Flags"));
                Luid luid = new Luid(sensorTypeId, modelId, vendorId, 0, flags);
                keepList.add(luid);
                continue;
            }
            catch (NumberFormatException e) {
                throw new RuntimeException("Corrupted sensor filter XML file, one of the fields is not a valid integer.");
            }
        }
        this._sensorFilter = keepList;
        this.deleteAllOtherSensors(keepList);
    }

    public void onPdtFormatVersionUpdate(int oldVersion, int newVersion, DataStore.FlowResults flowRes) {
        StringBuilder sbErrors = new StringBuilder();
        boolean version5Changes = oldVersion < 5 && newVersion >= 5;
        Device firstRS1SupportedDevice = null;
        Device firstBaseLineDevice = null;
        Logger.instance().log(this, "PDT format upgrade");
        if (version5Changes) {
            Iterator<Device> iterator = this.getDevicesByParameters(Device.DeviceDefaults.INTEL_BASELINE_SENSORS.productID, Device.DeviceDefaults.INTEL_BASELINE_SENSORS.vendorID).iterator();
            if (iterator.hasNext()) {
                Device device;
                firstBaseLineDevice = device = iterator.next();
            }
            for (Device device : this.getDevicesByParameters(Device.DepricatedDeviceDefaults.INTEL_ADVANCED_SENSORS.productID, Device.DepricatedDeviceDefaults.INTEL_ADVANCED_SENSORS.vendorID)) {
                if (firstRS1SupportedDevice == null) {
                    firstRS1SupportedDevice = device;
                }
                device.setProductId(Device.DeviceDefaults.RS1_SUPPORTED_SENSORS.productID);
                device.setVendorId(Device.DeviceDefaults.RS1_SUPPORTED_SENSORS.vendorID);
            }
        }
        for (Device device : this.getDevices()) {
            try {
                device.onPdtFormatVersionUpdate(this, oldVersion, newVersion, flowRes);
            }
            catch (UnsupportedOperationException e) {
                flowRes.hasErrors = true;
                sbErrors.append("\n" + device.getDeviceName() + ":\n" + e.getMessage());
            }
            if (!version5Changes) continue;
            boolean inRS1SupportingDevice = device.getProductId() == Device.DeviceDefaults.RS1_SUPPORTED_SENSORS.productID && device.getVendorId() == Device.DeviceDefaults.RS1_SUPPORTED_SENSORS.vendorID;
            try {
                ArrayList<Integer> rs1SupportedSensorTypes = Luid.getRS1SupportedSensorTypesList();
                if (firstRS1SupportedDevice == null) {
                    firstRS1SupportedDevice = new Device(Device.DeviceDefaults.RS1_SUPPORTED_SENSORS.productID, Device.DeviceDefaults.RS1_SUPPORTED_SENSORS.vendorID);
                }
                if (!inRS1SupportingDevice && device.isIntelDevice()) {
                    firstRS1SupportedDevice.addAllSensors(device.cutSensors(rs1SupportedSensorTypes, true));
                    continue;
                }
                if (firstBaseLineDevice == null || !inRS1SupportingDevice) continue;
                firstBaseLineDevice.addAllSensors(device.cutSensors(rs1SupportedSensorTypes, false));
            }
            catch (Exception e) {
                e.printStackTrace();
                flowRes.hasErrors = true;
                sbErrors.append("\n" + e.getMessage());
                Logger.instance().log(Logger.LogLevel.ERROR, this, sbErrors.toString());
            }
        }
        if (version5Changes && firstRS1SupportedDevice != null && !this._devices.contains(firstRS1SupportedDevice) && firstRS1SupportedDevice.getSensors().size() > 0) {
            Logger.instance().log(this, "Creating a new device for sensors that are not supported before Windows 10 RS1: " + firstRS1SupportedDevice);
            this._devices.add(firstRS1SupportedDevice);
        }
        if (sbErrors.length() > 0) {
            Logger.instance().log(Logger.LogLevel.ERROR, this, sbErrors.substring(1));
            throw new UnsupportedOperationException(sbErrors.substring(1));
        }
    }

    public void completeAllSensorDependencies() {
        InformationStore infoStore;
        try {
            infoStore = InformationStore.getInstance();
        }
        catch (Exception e) {
            System.err.println("Cannot get the instance of the information store. cannot update the dependencies of the sensors.");
            e.printStackTrace();
            return;
        }
        for (Sensor sensor : this.getAllSensors()) {
            if (sensor.getDependencies() != null) continue;
            infoStore.setDependeciesInfoToSensor(sensor);
        }
    }

    public boolean checkDependecy(Sensor checkedSensor, SensorData dependency) {
        for (Sensor dependecyCandidate : this.getAllSensors()) {
            if (dependecyCandidate.equals(checkedSensor) || dependecyCandidate.getLuid().getSensorTypeId() != dependency.getTypeId() || dependency.getModelId() != -1 && dependecyCandidate.getLuid().getSensorSubTypeId() != dependency.getModelId() || dependency.getVendorId() != -1 && dependecyCandidate.getLuid().getVendorId() != dependency.getVendorId() || dependecyCandidate.getLuid().getInstanceId() != dependency.getInstanceId() && (dependency.getInstanceId() != DependenciesUtils.SAME_AS_ALGO_INSTANCE[0] && dependency.getInstanceId() != DependenciesUtils.SAME_AS_ALGO_INSTANCE[1] || checkedSensor.getLuid().getInstanceId() != dependecyCandidate.getLuid().getInstanceId()) || dependency.getFlagsAsInteger() > 0 && !dependecyCandidate.getLuid().staticEqualFlags(new Luid(0, 0, 0, 0, dependency.getFlagsAsInteger()))) continue;
            return true;
        }
        return false;
    }

    public ArrayList<SensorData> getUnfulfilledDependecies(Sensor sensor) {
        ArrayList<SensorData> sensorDependencies = sensor.getDependencies();
        ArrayList<SensorData> sensorUnfulfilled = new ArrayList<SensorData>();
        if (sensorDependencies != null) {
            for (SensorData dependency : sensorDependencies) {
                if (this.checkDependecy(sensor, dependency)) continue;
                sensorUnfulfilled.add(dependency);
            }
        }
        return sensorUnfulfilled;
    }

    public HashMap<Sensor, ArrayList<SensorData>> getUnfulfilledDependecies() {
        HashMap<Sensor, ArrayList<SensorData>> res = new HashMap<Sensor, ArrayList<SensorData>>();
        this.completeAllSensorDependencies();
        for (Sensor sensor : this.getAllSensors()) {
            ArrayList<SensorData> sensorUnfulfilled = this.getUnfulfilledDependecies(sensor);
            if (sensorUnfulfilled.size() <= 0) continue;
            res.put(sensor, this.getUnfulfilledDependecies(sensor));
        }
        return res;
    }

    private void detectClashingSensors() {
        ArrayList<Sensor> allSensors = this.getAllSensors();
        for (Sensor iter1 : allSensors) {
            for (Sensor iter2 : allSensors) {
                if (iter1.equals(iter2) || iter1.getLuid().getSensorTypeId() != iter2.getLuid().getSensorTypeId() || iter1.getLuid().getInstanceId() != iter2.getLuid().getInstanceId() || !iter1.getLuid().staticEqualFlags(iter2.getLuid())) continue;
                Issue issue = new Issue(Issue.IssueType.NOTIFICATION, iter1);
                issue.setMessage("Clashing sensor: Another sensor shares the same sensor type, instance, and flags.");
                issue.description = "This sensor has the same sensor type, instance number, and flags as one or more other sensors. \nYou will need to give each sensor a unique instance number.";
                issue.fixer = new Fixer(iter1, issue){

                    @Override
                    public String getFixDescription() {
                        return "Double-click this issue to open the Sensor Modifier window. ";
                    }

                    @Override
                    public void fix() {
                        SensorModifier modifier = new SensorModifier(this, null, this._sensor, true);
                        modifier.highlightSensorInstance(this._issue._issueType);
                        modifier.setFixDescription(this._issue.description);
                        modifier.open();
                    }
                };
                iter1.addIssue(issue);
            }
        }
    }

    private void checkGpios() {
        int gpioCount = 0;
        for (Device device : this._devices) {
            for (Sensor sensor : device.getSensors()) {
                GpioPayload gpioPayload = (GpioPayload)sensor.getPayloadByClass(GpioPayload.class);
                if (gpioPayload == null || gpioPayload.getGpios() == null) continue;
                gpioCount += gpioPayload.getGpios().size();
            }
        }
        if (gpioCount > 20) {
            int gpioNumToRemove = gpioCount - 20;
            Issue gpioIssue = new Issue(Issue.IssueType.CRITICAL, this);
            gpioIssue.setBasicMessage("You have more than the maximum 20 defined GPIO interrupts. You must remove GPIO interrupts from some of the sensors.");
            gpioIssue.description = gpioIssue.getBasicMessage() + "You must remove a total of " + gpioNumToRemove + " GPIO interrupts from among the sensors.";
            this._issues.add(gpioIssue);
        }
    }

    private void checkDevicesProperties() {
        for (Device device1 : this.getDevices()) {
            for (Device device2 : this.getDevices()) {
                if (device2.equals(device1) || device1.getVendorId() != device2.getVendorId() || device2.getProductId() != device1.getProductId()) continue;
                Issue issue = new Issue(Issue.IssueType.WARNING, device1);
                issue.setMessage(device1.getDeviceShortName() + " has the same product ID and vendor ID numbers as " + device2.getDeviceShortName() + ".");
                issue.description = "Two devices shouldn\u2019t have the same product ID and vendor ID numbers; you are advised to change at least one of the two.";
                issue.fixer = new Fixer(device1, issue){

                    @Override
                    public String getFixDescription() {
                        return "Double-click this issue to open the " + this._device.getDeviceShortName() + " Properties window, where you can change either the product ID or the vendor ID.";
                    }

                    @Override
                    public void fix() {
                        new DeviceProperties(null, this._device).open();
                    }
                };
                device1.addIssue(issue);
            }
        }
    }

    @Override
    public void checkValidity() {
        this._issues.clear();
        this.checkGpios();
        for (Device device : this._devices) {
            device.checkValidity();
        }
        this.detectClashingSensors();
        HashMap<Sensor, ArrayList<SensorData>> unfulfilledDependecies = this.getUnfulfilledDependecies();
        for (Sensor sensor : unfulfilledDependecies.keySet()) {
            ArrayList<SensorData> sensorUnfulfilled = unfulfilledDependecies.get(sensor);
            for (SensorData dependency : sensorUnfulfilled) {
                Issue issue = new Issue(Issue.IssueType.NOTIFICATION, sensor);
                if (dependency.getDependencyType() != null && dependency.getDependencyType() == ManagerEnums.DependencyTypes.MANDATORY) {
                    issue.setType(Issue.IssueType.CRITICAL);
                    issue.description = "This sensor is missing a required reporter with the following details. You must add a sensor to your project that meets these requirements:";
                } else {
                    issue.description = "A defined reporter for this sensor could not be found. Though the reporter is not strictly required, you will obtain better results if a sensor that meets the following requirements is added to your project:";
                }
                String dependencyText = DependenciesUtils.getDependencyText(dependency, sensor);
                String message = "Missing reporter" + dependencyText;
                issue.description = issue.description + "\n" + dependencyText.trim();
                issue.setMessage(message);
                sensor.addIssue(issue);
            }
        }
        if (DataStore.getInstance().isFdkRun() && this._sensorFilter != null) {
            for (Sensor sensor : this.getAllSensors()) {
                boolean match = false;
                for (Luid luid : this._sensorFilter) {
                    if (!luid.staticEquals(sensor.getLuid())) continue;
                    match = true;
                    break;
                }
                if (match) continue;
                Issue issue = new Issue(Issue.IssueType.CRITICAL, sensor);
                issue.setMessage("This sensor was not selected to be part of your firmware image.");
                issue.description = "To add a sensor to your project, you must first create or import it using the Eclipse plugin, then select it to be burned onto your firmware as part of your firmware image.\nAny sensors not present in your firmware image will be erased when the PDT file is edited or the project is run.";
                sensor.addIssue(issue);
            }
        }
        this.checkDevicesProperties();
        this.cleanIgnoredIssues();
    }

    @Override
    public ArrayList<Issue> getIssues() {
        return this._issues;
    }

    @Override
    public ArrayList<Issue> getAllIssues() {
        ArrayList<Issue> allIssues = new ArrayList<Issue>();
        allIssues.addAll(this._issues);
        for (Device device : this._devices) {
            allIssues.addAll(device.getAllIssues());
        }
        return allIssues;
    }

    private void loadSavedIgnoredIssues() {
        if (this._allIgnoredIssues == null) {
            if (this._path == null || this._path.isEmpty()) {
                return;
            }
            try {
                PDTExternalInfo externalInfo = DataStore.getInstance().getPDTExternalInfo();
                if (externalInfo != null) {
                    this._allIgnoredIssues = externalInfo.getIgnoredIssuesList();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
        }
    }

    public void ignoreIssue(Issue issue) {
        this.loadSavedIgnoredIssues();
        if (this._allIgnoredIssues == null) {
            this._allIgnoredIssues = new ArrayList();
        }
        this._allIgnoredIssues.add(issue);
    }

    public void removeIgnoredIssues(ArrayList<Issue> issues) {
        if (this._allIgnoredIssues != null) {
            this._allIgnoredIssues.removeAll(issues);
        }
    }

    public ArrayList<Issue> getAllIgnoredIssues() {
        this.loadSavedIgnoredIssues();
        return this._allIgnoredIssues;
    }

    public boolean hasIgnoredIssues() {
        ArrayList<Issue> allIgnoredIssues = this.getAllIgnoredIssues();
        return allIgnoredIssues != null && allIgnoredIssues.size() > 0;
    }

    public boolean hasActiveIssues() {
        return this.getAllActiveIssues().size() > 0;
    }

    public boolean hasCriticalIssues() {
        ArrayList<Issue> allIssues = this.getAllActiveIssues();
        for (Issue issue : allIssues) {
            if (!issue.isCritical()) continue;
            return true;
        }
        return false;
    }

    public void saveAllIgnoredIssues() throws ParserConfigurationException {
        PDTExternalInfo externalInfo = DataStore.getInstance().getPDTExternalInfo();
        if (externalInfo != null) {
            externalInfo.writeIgnoredIssuesXml(this._allIgnoredIssues);
        }
    }

    public void cleanIgnoredIssues() {
        ArrayList<Issue> allIgnoredIssues = this.getAllIgnoredIssues();
        if (allIgnoredIssues != null) {
            ArrayList<Issue> allPdtIssues = this.getAllIssues();
            ArrayList<Issue> IgnoredToRemove = new ArrayList<Issue>();
            for (Issue ignoredIssue : allIgnoredIssues) {
                if (allPdtIssues.contains(ignoredIssue)) continue;
                IgnoredToRemove.add(ignoredIssue);
            }
            this.removeIgnoredIssues(IgnoredToRemove);
        }
    }

    public void clearAllIgnroedIssues() {
        if (this._allIgnoredIssues != null) {
            this._allIgnoredIssues.clear();
        }
    }

    public String getDisplayedPath() {
        if (this._path == null) {
            return "";
        }
        File file = new File(this._path);
        return file.getName();
    }

    public String getDirectoryPath() {
        if (this.getPath() == null) {
            return null;
        }
        return this.getPath() + File.separator + ".." + File.separator;
    }

    public String getPDTName() {
        if (this._path == null) {
            return null;
        }
        String res = new File(this._path).getName();
        if (res.contains(".")) {
            res = res.substring(0, res.lastIndexOf("."));
        }
        return res;
    }

    public byte[] getPdtBinaryContent() {
        BinWriter writer = new BinWriter(true);
        PdtWriter pdtWriter = new PdtWriter(writer, this);
        pdtWriter.writePdtContent();
        return writer.getBinaryContent();
    }

    public String toString() {
        return this.getElementName();
    }

    @Override
    public String getElementName() {
        return "PdtFile";
    }
}

