/*
 * Decompiled with CFR 0.152.
 */
package pdtEditor;

import binTools.BinReader;
import java.util.Iterator;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import pdtEditor.CustomDataEntryTable;
import pdtEditor.DataStore;
import pdtEditor.Device;
import pdtEditor.FormFactorTable;
import pdtEditor.HeciConfigurationTable;
import pdtEditor.I2cBoardDescriptionTable;
import pdtEditor.Luid;
import pdtEditor.PdtFile;
import pdtEditor.PdtPropertiesTable;
import pdtEditor.PlatformIdTable;
import pdtEditor.Sensor;
import pdtEditor.exceptions.FeatureNotSupportedYetException;

public class PdtReader {
    public static final int PDT_ENTRY_NUM = 2;
    private BinReader _reader;
    private PdtFile _pdtFile;

    public PdtReader(BinReader reader, PdtFile pdtFile) {
        this._reader = reader;
        this._pdtFile = pdtFile;
    }

    private void readbdtInfoContent(Element parent) throws FeatureNotSupportedYetException {
        int numBdtElements = this._reader.readNewField((String)"NumBdtElements", (int)1, (boolean)false, (Node)parent).value;
        block8: for (int i = 1; i <= numBdtElements; ++i) {
            Element bdtElement = this._reader.readNewField((String)new StringBuilder().append((String)"BdtElement").append((int)i).toString(), (Node)parent).xmlElement;
            int bdtType = this._reader.readNewField((String)"Type", (int)1, (boolean)false, (Node)bdtElement).value;
            int length = this._reader.readNewField((String)"Length", (int)2, (boolean)false, (Node)bdtElement).value;
            if (length <= 0) continue;
            switch (bdtType) {
                case 0: {
                    I2cBoardDescriptionTable i2cBdtObject = new I2cBoardDescriptionTable(this._reader, bdtElement);
                    this._pdtFile.addBdtObject(i2cBdtObject);
                    continue block8;
                }
                case 1: {
                    HeciConfigurationTable heciBdtObject = new HeciConfigurationTable(this._reader, bdtElement);
                    this._pdtFile.addBdtObject(heciBdtObject);
                    continue block8;
                }
                case 2: {
                    FormFactorTable formFactorBdtObject = new FormFactorTable(this._reader, bdtElement);
                    this._pdtFile.addBdtObject(formFactorBdtObject);
                    continue block8;
                }
                case 3: {
                    PdtPropertiesTable pdtPropertiesBdtObject = new PdtPropertiesTable(this._reader, bdtElement);
                    this._pdtFile.addBdtObject(pdtPropertiesBdtObject);
                    continue block8;
                }
                case 4: {
                    CustomDataEntryTable customDataEntryBdtObject = new CustomDataEntryTable(this._reader, bdtElement, length);
                    this._pdtFile.addBdtObject(customDataEntryBdtObject);
                    continue block8;
                }
                case 6: {
                    PlatformIdTable platformObject = new PlatformIdTable(this._reader, bdtElement);
                    this._pdtFile.addBdtObject(platformObject);
                    continue block8;
                }
                default: {
                    throw new RuntimeException("Unreconized BDT type");
                }
            }
        }
    }

    private Luid readLuidInfo(Element luidElement) {
        int sensorType = this._reader.readNewField((String)"SensorType", (int)2, (boolean)false, (Node)luidElement).value;
        int sensorVendor = this._reader.readNewField((String)"SensorVendorId", (int)2, (boolean)false, (Node)luidElement).value;
        int sensorModel = this._reader.readNewField((String)"SensorSubType", (int)2, (boolean)false, (Node)luidElement).value;
        int sensorInstance = this._reader.readNewField((String)"InstanceID", (int)1, (boolean)false, (Node)luidElement).value;
        int sensorFlags = this._reader.readNewField((String)"Flags", (int)1, (boolean)false, (Node)luidElement).value;
        Luid luid = new Luid(sensorType, sensorModel, sensorVendor, sensorInstance, sensorFlags);
        this._reader.addComment(luid.toString(), luidElement);
        return luid;
    }

    private void readSensorInfoContent(Node parent) throws FeatureNotSupportedYetException {
        Element hdtElement = this._reader.readNewField((String)"HDT", (Node)parent).xmlElement;
        int devicesNum = this._reader.readNewField((String)"NumDevices", (int)1, (boolean)false, (Node)hdtElement).value;
        this._reader.readNewField("Reserved", 1, false, hdtElement);
        this._pdtFile.getDevices().clear();
        for (int i = 1; i <= devicesNum; ++i) {
            Element devElement = this._reader.readNewField((String)new StringBuilder().append((String)"Device").append((int)i).toString(), (Node)hdtElement).xmlElement;
            this._reader.readNewField("Length", 2, false, devElement);
            int productId = this._reader.readNewField((String)"ProductId", (int)2, (boolean)false, (Node)devElement).value;
            int vendorId = this._reader.readNewField((String)"VendorId", (int)2, (boolean)false, (Node)devElement).value;
            int hostMaskId = this._reader.readNewField((String)"HostIdMask", (int)2, (boolean)false, (Node)devElement).value;
            this._reader.readNewField("Reserved", 2, false, devElement);
            int flags = this._reader.readNewField((String)"Flags", (int)1, (boolean)false, (Node)devElement).value;
            Device device = new Device(productId, vendorId, hostMaskId, flags, DataStore.getInstance());
            this._pdtFile.addDevice(device);
            int numOfSensors = this._reader.readNewField((String)"NumOfSensors", (int)1, (boolean)false, (Node)devElement).value;
            for (int j = 1; j <= numOfSensors; ++j) {
                Element luidElement = this._reader.readNewField((String)new StringBuilder().append((String)"Luid").append((int)j).toString(), (Node)devElement).xmlElement;
                Sensor sensor = new Sensor(this.readLuidInfo(luidElement));
                device.addSensor(sensor);
                DataStore.getInstance().addGlobalSensor(sensor);
            }
            if (!device.getDetachable()) continue;
            Element detachableElement = this._reader.readNewField((String)"Dockable", (Node)devElement).xmlElement;
            Element interruptElement = this._reader.readNewField((String)"Interrupt", (Node)detachableElement).xmlElement;
            this._reader.readNewField("Reserved", 1, false, interruptElement);
            int purpose = this._reader.readNewField((String)"Purpose", (int)1, (boolean)false, (Node)interruptElement).value;
            int pinNumber = this._reader.readNewField((String)"PinNumber", (int)1, (boolean)false, (Node)interruptElement).value;
            int mode = this._reader.readNewField((String)"ModeGPIO", (int)1, (boolean)false, (Node)interruptElement).value;
            Element controlElement = this._reader.readNewField((String)"Control", (Node)detachableElement).xmlElement;
            int controlId = this._reader.readNewField((String)"Id", (int)1, (boolean)false, (Node)controlElement).value;
            int controlValue = this._reader.readNewField((String)"Value", (int)1, (boolean)false, (Node)controlElement).value;
            device.setInterruptPurpose(purpose);
            device.setInterruptPinNumber(pinNumber);
            device.setInterruptMode(mode);
            device.setControlId(controlId);
            device.setControlValue(controlValue);
        }
        Element sdtElement = this._reader.readNewField((String)"SDT", (Node)parent).xmlElement;
        int numOfSensorEnties = this._reader.readNewField((String)"NumSensorEntries", (int)1, (boolean)false, (Node)sdtElement).value;
        this._reader.readNewField("Reserved", 1, false, sdtElement);
        for (int i = 1; i <= numOfSensorEnties; ++i) {
            Device device;
            Element sensEntryNode = this._reader.readNewField((String)new StringBuilder().append((String)"SensorEntry").append((int)i).toString(), (Node)sdtElement).xmlElement;
            Element luidElement = this._reader.readNewField((String)"Luid", (Node)sensEntryNode).xmlElement;
            Luid luid = this.readLuidInfo(luidElement);
            Sensor sensor = null;
            Iterator<Device> iterator = this._pdtFile.getDevices().iterator();
            while (iterator.hasNext() && (sensor = (device = iterator.next()).getSensorByLuid(luid)) == null) {
            }
            if (sensor == null) {
                System.err.println("Warning: SensorEntry's Luid doesn't have any match in the HDT. Luid: [" + luid + "] Ignoring..");
                continue;
            }
            sensor.readSdtInfo(this._reader, sensEntryNode);
        }
    }

    public void parsePdtContent() throws FeatureNotSupportedYetException {
        Element ishElement = this._reader.getHeadElement();
        this._reader.addComment("Please notice: this XML representation of the PDT binary file has been created for internal use only. The structure and names in this file may be changed in future releases of the PDT editor without advance notice.", this._reader.getHeadElement());
        DataStore.getInstance().setPdtFormatVersion(this._reader.readNewField((String)"FormatVersion", (int)1, (boolean)false, (Node)ishElement).value, null);
        this._pdtFile.setSkuId(this._reader.readNewField((String)"SkuId", (int)1, (boolean)false, (Node)ishElement).value);
        this._reader.readNewField("PdtTotalSize", 2, false, ishElement);
        DataStore.getInstance().checkPDTFormatVersion(DataStore.getInstance().getPdtFormatVersion());
        if (DataStore.getInstance().getPdtFormatVersion() <= 3) {
            this.readSensorInfoContent(ishElement);
        } else {
            block4: for (int i = 1; i <= 2; ++i) {
                Element pdtEntryElement = this._reader.readNewField((String)new StringBuilder().append((String)"PdtEntry").append((int)i).toString(), (Node)ishElement).xmlElement;
                int pdtEntryType = this._reader.readNewField((String)"pdtEntryType", (int)1, (boolean)false, (Node)pdtEntryElement).value;
                int length = this._reader.readNewField((String)"Length", (int)2, (boolean)false, (Node)pdtEntryElement).value;
                if (length <= 0) continue;
                switch (pdtEntryType) {
                    case 0: {
                        Element bdtInfoElement = this._reader.readNewField((String)"BdtInfo", (Node)pdtEntryElement).xmlElement;
                        this.readbdtInfoContent(bdtInfoElement);
                        continue block4;
                    }
                    case 1: {
                        Element sensorInfoElement = this._reader.readNewField((String)"SensorInfo", (Node)pdtEntryElement).xmlElement;
                        this.readSensorInfoContent(sensorInfoElement);
                        continue block4;
                    }
                    default: {
                        throw new RuntimeException("Invalid PDT entry type");
                    }
                }
            }
        }
    }
}

