/*
 * Decompiled with CFR 0.152.
 */
package pdtEditor;

import binTools.BinReader;
import binTools.BinWriter;
import binTools.Common;
import java.util.ArrayList;
import java.util.Comparator;
import manager.common.Interrupt;
import manager.sensor.SensorData;
import manager.utils.ManagerEnums;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import pdtEditor.AbstractValidatable;
import pdtEditor.DataStore;
import pdtEditor.IComponent;
import pdtEditor.InformationStore;
import pdtEditor.Logger;
import pdtEditor.Luid;
import pdtEditor.PdtFile;
import pdtEditor.PdtUpdateModes;
import pdtEditor.exceptions.FeatureNotSupportedYetException;
import pdtEditor.gui.SensorModifier;
import pdtEditor.gui.calibration.NewCalibration;
import pdtEditor.gui.configuration.LidModeConfiguration;
import pdtEditor.payloads.BusPayload;
import pdtEditor.payloads.GpioPayload;
import pdtEditor.payloads.GuidPayload;
import pdtEditor.payloads.Payload;
import pdtEditor.payloads.PayloadUtils;
import pdtEditor.payloads.calibrations.CalibrationPayload;
import pdtEditor.payloads.calibrations.VirtualAcclCalibrationPayload;
import pdtEditor.payloads.calibrations.VirtualGyroCalibrationPayload;
import pdtEditor.payloads.calibrations.VirtualMagCalibrationPayload;
import pdtEditor.payloads.configurations.ConfigurationPayload;
import pdtEditor.validation.Fixer;
import pdtEditor.validation.Issue;
import pdtEditor.validation.Validator;

public class Sensor
extends AbstractValidatable
implements IComponent {
    private Luid _luid = null;
    private ArrayList<Payload> _payloads = new ArrayList();
    private PdtUpdateModes.SensorUpdateModes _updateModes = new PdtUpdateModes.SensorUpdateModes();
    private static int sortingCounter = 0;
    private int _sdtOrder = Integer.MAX_VALUE;
    private ArrayList<SensorData> _missingReporters = null;
    private boolean _metaDataAvalible = false;
    private ArrayList<SensorData> _dependencies = null;
    private ArrayList<ManagerEnums.BusTypes> _possibleBusTypes = null;
    private String[] _possibleBusAdresses = null;
    private ArrayList<Interrupt> _possibleGpio = null;
    private ArrayList<Integer> _possibleCalibrationFormats = null;
    private ArrayList<Issue> _issues = new ArrayList();

    public Sensor(Luid luid) {
        this._luid = luid;
    }

    public Sensor(SensorData sensorData) {
        this._metaDataAvalible = true;
        this._luid = new Luid(sensorData);
        this._dependencies = sensorData.getDependencies();
        this._possibleBusTypes = sensorData.getBusTypes();
        String[] busAddressesToCopy = sensorData.getAddressesAsHexStringList();
        if (busAddressesToCopy != null) {
            this._possibleBusAdresses = new String[busAddressesToCopy.length];
            for (int i = 0; i < busAddressesToCopy.length; ++i) {
                this._possibleBusAdresses[i] = busAddressesToCopy[i].startsWith("0x") ? busAddressesToCopy[i].substring(2) : busAddressesToCopy[i];
            }
        }
        this._possibleGpio = new ArrayList();
        if (sensorData.getGPInputs() != null) {
            this._possibleGpio.addAll(sensorData.getGPInputs());
        }
        if (sensorData.getGPOutputs() != null) {
            this._possibleGpio.addAll(sensorData.getGPOutputs());
        }
        this._possibleCalibrationFormats = sensorData.getCalibrationFormats();
    }

    public Sensor(Sensor other) {
        this._luid = other._luid.clone();
        for (Payload payload : other._payloads) {
            this.addPayload(payload.clone());
        }
        this._dependencies = new ArrayList();
        if (other._dependencies != null) {
            this._dependencies.addAll(other._dependencies);
        }
    }

    public boolean equals(Object arg0) {
        if (arg0 == null || !(arg0 instanceof Sensor)) {
            return false;
        }
        Sensor otherSens = (Sensor)arg0;
        if (!(this.getLuid() == null && otherSens.getLuid() == null || this.getLuid() != null && this.getLuid().equals(otherSens.getLuid()))) {
            return false;
        }
        return this._payloads == null && otherSens._payloads == null || this._payloads != null && this._payloads.equals(otherSens._payloads);
    }

    private String getComponentUpdateModeText() {
        if (this._updateModes == null) {
            return "Error";
        }
        return "updateModeByte content:\nbusUpdateMode=" + this._updateModes.busUpdateMode.getValue() + " (" + this._updateModes.busUpdateMode.getFriendlyName() + ")\ngpioUpdateMode=" + this._updateModes.gpioUpdateMode.getValue() + " (" + this._updateModes.gpioUpdateMode.getFriendlyName() + ")\ncalibrationUpdateMode=" + this._updateModes.calibrationUpdateMode.getValue() + " (" + this._updateModes.calibrationUpdateMode.getFriendlyName() + ")\n";
    }

    public void readSdtInfo(BinReader reader, Element parent) throws FeatureNotSupportedYetException {
        reader.readNewField("DataLength", 2, false, parent);
        int updateModeByte = reader.readNewField((String)"updateModeByte", (int)1, (boolean)false, (Node)parent).value;
        this._updateModes.busUpdateMode = PdtUpdateModes.BusGpioUpdateMode.getObjectOfValue(Common.getSubValueFromValue(updateModeByte, 0, 2));
        this._updateModes.gpioUpdateMode = PdtUpdateModes.BusGpioUpdateMode.getObjectOfValue(Common.getSubValueFromValue(updateModeByte, 2, 2));
        this._updateModes.calibrationUpdateMode = PdtUpdateModes.CalibrationUpdateMode.getObjectOfValue(Common.getSubValueFromValue(updateModeByte, 4, 2));
        reader.addComment(this.getComponentUpdateModeText(), parent);
        int numOfPayloads = reader.readNewField((String)"NumPayloads", (int)1, (boolean)false, (Node)parent).value;
        for (int j = 1; j <= numOfPayloads; ++j) {
            Element payloadElement = reader.readNewField((String)new StringBuilder().append((String)"Payload").append((int)j).toString(), (Node)parent).xmlElement;
            this.addPayload(reader, payloadElement);
        }
    }

    public void writeSdtInfo(BinWriter writer, Element parent) {
        Common.Field allDataLength = writer.writeNewField("DataLength", 2, 0, (Node)parent);
        int updateModeByte = 0;
        if (this._updateModes != null) {
            updateModeByte |= this._updateModes.busUpdateMode.getValue() << 0;
            updateModeByte |= this._updateModes.gpioUpdateMode.getValue() << 2;
            updateModeByte |= this._updateModes.calibrationUpdateMode.getValue() << 4;
        }
        writer.writeNewField("updateModeByte", 1, updateModeByte, (Node)parent);
        writer.addComment(this.getComponentUpdateModeText(), parent);
        ArrayList<Payload> payloads = this.getPayloads();
        writer.writeNewField("NumPayloads", 1, payloads.size(), (Node)parent);
        writer.addSizeCounter(allDataLength);
        for (int j = 1; j <= payloads.size(); ++j) {
            Payload payload = payloads.get(j - 1);
            Element payloadElement = writer.writeNewField((String)new StringBuilder().append((String)"Payload").append((int)j).toString(), (Node)parent).xmlElement;
            payload.writeToPdt(writer, payloadElement);
        }
        writer.removeSizeCounter(allDataLength);
    }

    public Sensor clone() {
        return new Sensor(this);
    }

    public Luid getLuid() {
        return this._luid;
    }

    public void setLuid(Luid luid) {
        this._luid = luid;
    }

    public boolean hasPayloads() {
        return this._payloads != null && this._payloads.size() > 0;
    }

    public ArrayList<Payload> getPayloads() {
        return this._payloads;
    }

    public void addPayload(Payload payload) {
        this._sdtOrder = sortingCounter++;
        if (this._payloads.size() > 0 && this._payloads.get(this._payloads.size() - 1) instanceof GuidPayload) {
            this._payloads.add(this._payloads.size() - 1, payload);
        } else {
            this._payloads.add(payload);
        }
    }

    public void addPayload(BinReader reader, Element payloadXmlNode) throws FeatureNotSupportedYetException {
        this.addPayload(PayloadUtils.createNewPayload(this._luid, reader, payloadXmlNode));
    }

    public String getCalibrationStatus() {
        for (Payload payload : this._payloads) {
            if (!(payload instanceof CalibrationPayload)) continue;
            return "Yes";
        }
        return "No";
    }

    public Payload getPayloadByClass(Class<?> payloadClass) {
        for (Payload payload : this._payloads) {
            if (!payloadClass.isInstance(payload)) continue;
            return payload;
        }
        return null;
    }

    public void removeAllPayloadsByClass(Class<?> payloadClass) {
        ArrayList<Payload> toRemove = new ArrayList<Payload>();
        for (Payload payload : this._payloads) {
            if (!payloadClass.isInstance(payload)) continue;
            toRemove.add(payload);
        }
        this._payloads.removeAll(toRemove);
    }

    public void replacePayload(Payload toRemove, Payload toAdd) {
        if (this._payloads.contains(toRemove)) {
            int index = this._payloads.lastIndexOf(toRemove);
            this._payloads.remove(index);
            this._payloads.add(index, toAdd);
        } else {
            this._payloads.add(toAdd);
        }
    }

    public String getUsedGPIOsStr() {
        for (Payload payload : this._payloads) {
            if (!(payload instanceof GpioPayload)) continue;
            return ((GpioPayload)payload).getGPIOsString();
        }
        return "0";
    }

    public Integer getSdtOrderIndex() {
        return this._sdtOrder;
    }

    public void setSdtOrderIndex(int index) {
        this._sdtOrder = index;
    }

    public ArrayList<SensorData> getDependencies() {
        return this._dependencies;
    }

    public void setDependencies(ArrayList<SensorData> dependencies) {
        this._dependencies = dependencies;
    }

    public void updateMetaData(Sensor other) {
        if (other._metaDataAvalible) {
            this._dependencies = other._dependencies;
            this._possibleBusAdresses = other._possibleBusAdresses;
            this._possibleBusTypes = other._possibleBusTypes;
            this._possibleCalibrationFormats = other._possibleCalibrationFormats;
            this._possibleGpio = other._possibleGpio;
            this._metaDataAvalible = true;
        }
        if (other.getLuid().getGivenMetadata() != null) {
            this._luid.setMetadataFlags(other.getLuid().getGivenMetadata());
        }
    }

    public ArrayList<ManagerEnums.BusTypes> getPossibleBusTypes() {
        return this._possibleBusTypes;
    }

    public String[] getPossibleBusAddresses() {
        return this._possibleBusAdresses;
    }

    public ArrayList<Interrupt> getPossibleGpio() {
        return this._possibleGpio;
    }

    public ArrayList<Integer> getPossibleCalibrationFormats() {
        return this._possibleCalibrationFormats;
    }

    public PdtUpdateModes.SensorUpdateModes getSensorUpdateMode() {
        return this._updateModes;
    }

    public void setSensorUpdateMode(PdtUpdateModes.SensorUpdateModes updateModes) {
        this._updateModes = updateModes;
    }

    public boolean isMetadataAvalible() {
        return this._metaDataAvalible;
    }

    public ArrayList<SensorData> getMissingReporters() {
        PdtFile pdt;
        if (this._missingReporters == null) {
            this._missingReporters = new ArrayList();
        }
        if ((pdt = DataStore.getInstance().getCurrentPdtFile()) == null) {
            return null;
        }
        this._missingReporters.clear();
        this._missingReporters.addAll(pdt.getUnfulfilledDependecies(this));
        return this._missingReporters;
    }

    public String getMissingReportersStr() {
        ArrayList<SensorData> missingReporters = this.getMissingReporters();
        if (missingReporters != null && missingReporters.size() > 0) {
            return missingReporters.size() + " sensors out of " + this._dependencies.size();
        }
        return "";
    }

    public void onPdtFormatVersionUpdate(PdtFile pdtFile, int oldVersion, int newVersion, DataStore.FlowResults flowRes) {
        Luid newLuid = this._luid.clone();
        newLuid.onPdtFormatVersionUpdate(oldVersion, newVersion, flowRes);
        if (!newLuid.equals(this._luid)) {
            if (pdtFile.containsSensorWithEquivalentLuid(newLuid, this, false)) {
                flowRes.hasErrors = true;
                throw new UnsupportedOperationException("A LUID duplication will be created: " + newLuid.toString());
            }
            this._luid = newLuid;
            try {
                InformationStore.getInstance().setDependeciesInfoToSensor(this);
            }
            catch (Exception e) {
                this.setDependencies(null);
            }
        }
        if (oldVersion < 4 && newVersion >= 4 && this.getPayloadByClass(CalibrationPayload.class) == null) {
            try {
                switch (CalibrationPayload.getCalibrationType((Luid)this._luid, (int)-1, (boolean)true).get((int)0).format) {
                    case 2: {
                        Logger.instance().log(this, "New Calibration: Calibrated Accelerometer Calibration");
                        this.addPayload(new VirtualAcclCalibrationPayload());
                        break;
                    }
                    case 3: {
                        Logger.instance().log(this, "New Calibration: Calibrated Gyrometer Calibration");
                        this.addPayload(new VirtualGyroCalibrationPayload());
                        break;
                    }
                    case 4: {
                        Logger.instance().log(this, "New Calibration: Calibrated Magnetometer Calibration");
                        this.addPayload(new VirtualMagCalibrationPayload());
                    }
                }
            }
            catch (Exception e) {
                flowRes.hasErrors = true;
                Logger.instance().log(Logger.LogLevel.ERROR, this, e.getMessage());
                e.printStackTrace();
            }
        }
    }

    @Override
    public void checkValidity() {
        ConfigurationPayload configPayload;
        Issue issue3;
        Validator sensorValidator = new Validator();
        BusPayload busPayload = (BusPayload)this.getPayloadByClass(BusPayload.class);
        this._luid.checkValidity(sensorValidator, this);
        for (Payload payload : this.getPayloads()) {
            payload.checkValidity(sensorValidator, this);
        }
        if (this._luid.getIsPhysical()) {
            if (busPayload == null) {
                Issue issue2 = new Issue(Issue.IssueType.CRITICAL, this);
                sensorValidator.addIssue(issue2);
                GpioPayload gpioPayload = (GpioPayload)this.getPayloadByClass(GpioPayload.class);
                if (gpioPayload == null || gpioPayload.getGpios().size() == 0) {
                    issue2.setMessage("There is currently no way to receive data from this sensor.");
                    issue2.description = "You must define this sensor's bus and/or GPIO information.";
                } else {
                    issue2.setMessage("This sensor has GPIO interrupts defined but no bus information.");
                    issue2.description = "It is rare for a sensor to use only GPIO interrupts for communication. Consider adding bus information.";
                    issue2.setType(Issue.IssueType.WARNING);
                }
                issue2.fixer = new Fixer(this, issue2){

                    @Override
                    public String getFixDescription() {
                        GpioPayload gpioPayload = (GpioPayload)this._sensor.getPayloadByClass(GpioPayload.class);
                        return "Double-click this issue to open the Sensor Modifier window, where you can add the sensor's bus " + (gpioPayload == null ? "or GPIO " : "") + "information.";
                    }

                    @Override
                    public void fix() {
                        SensorModifier modifier = new SensorModifier(this, null, this._sensor, true);
                        modifier.setBusInfoFromMetadata(true);
                        modifier.highlightBusInfo(this._issue._issueType);
                        modifier.highlightGpioInfo(this._issue._issueType);
                        modifier.setFixDescription(this._issue.description);
                        modifier.open();
                    }
                };
            } else if (DataStore.getInstance().getRunType() == DataStore.RunType.FDK_RUN_PROJECT && DataStore.getInstance().getFdkExcutionEnv() != null && busPayload.getBusType() == ManagerEnums.BusTypes.I2C.getValue()) {
                int expectedBusInstance = -1;
                switch (DataStore.getInstance().getFdkExcutionEnv()) {
                    case GALILEO_FULL: 
                    case GALILEO_LITE: {
                        expectedBusInstance = 0;
                        break;
                    }
                    case SIMICS: {
                        expectedBusInstance = 1;
                        break;
                    }
                }
                if (expectedBusInstance >= 0 && busPayload.getBusIndex() != expectedBusInstance) {
                    issue3 = new Issue(Issue.IssueType.CRITICAL, this);
                    sensorValidator.addIssue(issue3);
                    issue3.setMessage("There is a mismatch between the bus instance number and the execution environment.");
                    issue3.description = "Sensors that use an I2C bus must use bus instance 0 if their execution environment is the Galileo board; otherwise they must use bus instance 1. \nThis sensor's bus instance is incorrect; its metadata indicates that it should use a bus instance of " + expectedBusInstance + ".";
                    issue3.fixer = new Fixer(this, issue3){

                        @Override
                        public String getFixDescription() {
                            return "Double-click this issue to open the sensor modifier window, where you can change the bus instance.";
                        }

                        @Override
                        public void fix() {
                            SensorModifier modifier = new SensorModifier(this, null, this._sensor, true);
                            modifier.highlightBusInstance(this._issue._issueType);
                            modifier.setFixDescription(this._issue.description);
                            modifier.open();
                        }
                    };
                }
            }
        }
        if (this.getPayloadByClass(CalibrationPayload.class) == null) {
            try {
                int calibrationSuggenstion = CalibrationPayload.getCalibrationType((Luid)this._luid, (int)-1, (boolean)true).get((int)0).format;
                switch (calibrationSuggenstion) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        issue3 = new Issue(Issue.IssueType.CRITICAL, this);
                        issue3.setMessage("You must provide calibration data for this sensor.");
                        issue3.description = "Sensors of this type require calibration.";
                        issue3.fixer = new Fixer(this){

                            @Override
                            public void fix() {
                                new NewCalibration(0, this, this._sensor).open();
                            }

                            @Override
                            public String getFixDescription() {
                                return "Double-click this issue to add calibration data for this sensor.";
                            }
                        };
                        sensorValidator.addIssue(issue3);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this._luid.getSensorTypeIdStr().equals("INTEL_PLATFORM_LID_MODE") && (configPayload = (ConfigurationPayload)this.getPayloadByClass(ConfigurationPayload.class)) == null) {
            issue3 = new Issue(Issue.IssueType.CRITICAL, this);
            issue3.setMessage("You must provide configuration data for this sensor.");
            issue3.description = "Sensors of this type require configuration.";
            issue3.fixer = new Fixer(this){

                @Override
                public void fix() {
                    new LidModeConfiguration(null, null, this._sensor).open();
                }

                @Override
                public String getFixDescription() {
                    return "Double-click this issue to add configuration data for this sensor.";
                }
            };
            sensorValidator.addIssue(issue3);
        }
        for (Issue issue3 : sensorValidator.getIssues()) {
            issue3.element = this.getElementName() + (issue3.element != null ? " - " + issue3.element : "");
        }
        this._issues.clear();
        this._issues.addAll(sensorValidator.getIssues());
    }

    @Override
    public ArrayList<Issue> getIssues() {
        return this._issues;
    }

    @Override
    public ArrayList<Issue> getAllIssues() {
        ArrayList<Issue> allIssues = new ArrayList<Issue>();
        allIssues.addAll(this._issues);
        return allIssues;
    }

    public void addIssue(Issue issue) {
        if (!this._issues.contains(issue)) {
            this._issues.add(issue);
        }
    }

    @Override
    public String getElementName() {
        return this._luid.getHexValue();
    }

    public String toString() {
        return (this._luid.getIsPhysical() ? "Physical" : "Virtual") + " sensor: " + this._luid.toString();
    }

    public int hashCode() {
        return super.hashCode();
    }

    public static class SdtOrderComparator
    implements Comparator<Sensor> {
        @Override
        public int compare(Sensor s1, Sensor s2) {
            return s1.getSdtOrderIndex().compareTo(s2.getSdtOrderIndex());
        }
    }
}

