/*
 * Decompiled with CFR 0.152.
 */
package pdtEditor.gui;

import java.util.ArrayList;
import java.util.HashMap;
import manager.utils.ManagerEnums;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import pdtEditor.DataStore;
import pdtEditor.InformationStore;
import pdtEditor.Sensor;
import pdtEditor.gui.GuiUtils;
import pdtEditor.payloads.BusPayload;
import pdtEditor.payloads.BusPayloadI2c;
import pdtEditor.payloads.BusPayloadI3c;
import pdtEditor.payloads.BusPayloadSpi;
import pdtEditor.payloads.BusPayloadUart;
import resources.CustomSpinner;

public class BusInfo {
    private static final String NO_BUS_INFO_TEXT = "N/A";
    GuiUtils.WindowProperties _parentProperties = null;
    private Group grpBusInfo = null;
    private Combo cmbBusType;
    private CustomSpinner spnBusInstance;
    private Text txtBusAddress;
    private Label lblBusAddress;
    private Combo cmbBusAddress;
    private Label lblBusInstance;
    private Label lblBusType;
    private Combo cmbBusSpeed;
    private Label lblBusSpeed;
    private Label lbl0x;
    private Label lblhexFormat;
    private Label lblCsPin;
    private Combo cmbCsPin;
    private Label lblAddressType;
    private Combo cmbAddressType;
    private Button btnCbxIbiEnable;
    private Label lblIbiPurpose;
    private Combo cmbIbiPurpose;
    private Shell _shell;
    private Button btnCbxRtsCts;
    private Button btnCbxCsNative;
    private boolean _modified = false;
    private boolean _isForceDisableRtsCts = false;
    private InformationStore infoStore = null;
    private Sensor _sensor = null;
    private String prevBusType = "";
    private Composite _parent;
    private GridData gd_txtBusAddress;
    private GridData gd_cmbBusAddress;
    private ArrayList<String> _possibleBusTypes = null;
    private HashMap<String, ArrayList<Integer>> _possibleSpeedsForBusType = null;
    private ArrayList<String> _disableSpeedForTypes = new ArrayList();
    private ArrayList<String> _disableInstanceForTypes = new ArrayList();
    private ArrayList<String> _excludeBusSpeed = new ArrayList();

    public BusInfo(GuiUtils.WindowProperties parentProperties) throws Exception {
        this.infoStore = InformationStore.getInstance();
        this._parentProperties = parentProperties;
    }

    public void copyBusInfo(BusInfo other) {
        if (this.cmbBusType == null || this.cmbBusType.isDisposed()) {
            throw new UnsupportedOperationException("You must draw the bus info before coping data into it.");
        }
        this.cmbBusType.setText(other.cmbBusType.getText());
        GuiUtils.chooseComboItemByValue(this.cmbBusType);
        this.cmbBusAddress.setText(other.cmbBusAddress.getText());
        GuiUtils.chooseComboItemByValue(this.cmbBusAddress);
        this.cmbBusSpeed.setText(other.cmbBusSpeed.getText());
        GuiUtils.chooseComboItemByValue(this.cmbBusSpeed);
        this.txtBusAddress.setText(other.txtBusAddress.getText());
        this.spnBusInstance.setSelection(other.spnBusInstance.getSelection());
        this.btnCbxRtsCts.setSelection(other.btnCbxRtsCts.getSelection());
        this.btnCbxCsNative.setSelection(other.btnCbxCsNative.getSelection());
        this.cmbCsPin.setText(other.cmbCsPin.getText());
        this.cmbIbiPurpose.setText(other.cmbIbiPurpose.getText());
        this._sensor = other._sensor;
        this._parentProperties = other._parentProperties;
    }

    public void setModified() {
        this._modified = true;
        this._parentProperties.setModified(true);
    }

    public void fillData(BusPayload bus) {
        this.fillData(bus, null);
    }

    public void fillData(BusPayload bus, Sensor sensor) {
        this._sensor = sensor;
        ArrayList<ManagerEnums.BusTypes> possibleBusTypes = null;
        String[] possibleAddresses = null;
        if (sensor != null) {
            possibleBusTypes = sensor.getPossibleBusTypes();
            possibleAddresses = sensor.getPossibleBusAddresses();
        }
        if (possibleBusTypes != null) {
            this.cmbBusType.removeAll();
            this.cmbBusType.add(NO_BUS_INFO_TEXT);
            this.cmbBusType.select(0);
            for (ManagerEnums.BusTypes busType : possibleBusTypes) {
                this.cmbBusType.add(busType.name());
                if (bus == null || bus.getBusType() != busType.getValue()) continue;
                this.cmbBusType.select(this.cmbBusType.getItemCount() - 1);
            }
        }
        if (possibleAddresses != null) {
            GridData busAddressData = (GridData)this.txtBusAddress.getLayoutData();
            GridData busAddressComboData = (GridData)this.cmbBusAddress.getLayoutData();
            busAddressData.exclude = true;
            busAddressComboData.exclude = false;
            this.txtBusAddress.setVisible(false);
            this.cmbBusAddress.setVisible(true);
            this.grpBusInfo.pack();
            this.cmbBusAddress.removeAll();
            for (int i = 0; i < possibleAddresses.length; ++i) {
                this.cmbBusAddress.add(possibleAddresses[i]);
                if (bus == null || !bus.getHexBusAddress().equals(possibleAddresses[i])) continue;
                this.cmbBusAddress.select(this.cmbBusAddress.getItemCount() - 1);
            }
        }
        if (bus != null) {
            if (possibleBusTypes == null) {
                this.cmbBusType.setText(this.infoStore.getBusTypeName(bus.getBusType()));
                GuiUtils.chooseComboItemByValue(this.cmbBusType);
            }
            this.spnBusInstance.setSelection(bus.getBusIndex());
            if (possibleBusTypes == null) {
                if (this.txtBusAddress.getEnabled()) {
                    this.txtBusAddress.append(String.valueOf(bus.getHexBusAddress()));
                }
            } else if (this.cmbBusAddress.getText().length() == 0 && this.cmbBusAddress.getEnabled()) {
                this.cmbBusAddress.setText(String.valueOf(bus.getHexBusAddress()));
            }
            if (bus.getBusType() == 3) {
                int addressType = ((BusPayloadI3c)bus).getAddressType();
                this.cmbAddressType.setText(this.infoStore.getI3CAddressTypeNameById(addressType));
                int addressSize = this.infoStore.getI3CAddressSizeByTypeName(this.cmbAddressType.getText().trim());
                if (this.txtBusAddress.getEnabled() && addressSize > 1) {
                    this.txtBusAddress.setText(((BusPayloadI3c)bus).getDynamicAddress());
                } else {
                    this.txtBusAddress.setText(bus.getHexBusAddress());
                }
            }
            this.cmbBusSpeed.setText(this.infoStore.getBusSpeedName(bus.getBusType(), bus.getBusSpeed()));
            GuiUtils.chooseComboItemByValue(this.cmbBusSpeed);
            this.btnCbxRtsCts.setSelection(bus.isEnableRtsCts());
            this.btnCbxCsNative.setSelection(bus.isCsNative());
            this.cmbCsPin.removeAll();
            for (int i = 0; i < 16; ++i) {
                this.cmbCsPin.add(String.valueOf(i));
                if (bus.isCsNative() || bus.getCsPin() != i) continue;
                this.cmbCsPin.select(this.cmbCsPin.getItemCount() - 1);
            }
            if (bus.isCsNative()) {
                this.lblCsPin.setEnabled(false);
                this.cmbCsPin.setEnabled(false);
                this.cmbCsPin.deselectAll();
            }
            String selectIbiPurpose = "";
            this.cmbIbiPurpose.removeAll();
            ArrayList<String> ibiPurpose = this.infoStore.getAllI3CIbiPurpose();
            if (bus.isIbiEnable()) {
                selectIbiPurpose = this.infoStore.getI3CIbiPurposeNameById(bus.getIbiPurpose());
            }
            for (String purpose : ibiPurpose) {
                this.cmbIbiPurpose.add(purpose);
                if (purpose.compareTo(selectIbiPurpose) != 0) continue;
                this.cmbIbiPurpose.select(this.cmbIbiPurpose.getItemCount() - 1);
            }
            this.btnCbxIbiEnable.setSelection(bus.isIbiEnable());
            if (!bus.isIbiEnable()) {
                this.lblIbiPurpose.setEnabled(false);
                this.cmbIbiPurpose.setEnabled(false);
                this.cmbIbiPurpose.deselectAll();
            } else {
                this.lblIbiPurpose.setEnabled(true);
                this.cmbIbiPurpose.setEnabled(true);
            }
        }
    }

    public BusPayload busPayloadFromFields() {
        String busAdrressValue;
        if (this.cmbBusType.getSelectionIndex() < 0) {
            this.cmbBusType.setFocus();
            throw new RuntimeException("Invalid bus type. Please choose a value from the list.");
        }
        if (this.cmbBusType.getSelectionIndex() == 0) {
            return null;
        }
        int busSpeedVal = -1;
        int addressType = -1;
        String dynamicAddress = "000000000000";
        int ibiPurpose = 0;
        BusPayload bus = null;
        ArrayList<ManagerEnums.BusTypes> possibleBusTypes = null;
        String[] possibleAddresses = null;
        if (this._sensor != null) {
            bus = (BusPayload)this._sensor.getPayloadByClass(BusPayload.class);
            possibleBusTypes = this._sensor.getPossibleBusTypes();
            possibleAddresses = this._sensor.getPossibleBusAddresses();
        }
        try {
            int busCsPinVal;
            int busTypeVal = possibleBusTypes != null ? ManagerEnums.BusTypes.getValueByName((String)this.cmbBusType.getText()).getValue() : this.infoStore.getBusTypeId(this.cmbBusType.getText().trim()).intValue();
            int busInstanceVal = this.spnBusInstance.getSelection();
            if (this.cmbBusSpeed.isEnabled()) {
                if (this.cmbBusSpeed.isEnabled()) {
                    if (this.cmbBusSpeed.getSelectionIndex() < 0) {
                        this.cmbBusSpeed.setFocus();
                        throw new Exception("Invalid bus speed value. Please choose a value from the list.");
                    }
                    busSpeedVal = this.infoStore.getBusSpeedValue(busTypeVal, this.cmbBusSpeed.getText().trim());
                } else {
                    busSpeedVal = this.infoStore.getBusSpeedValue(busTypeVal, this.cmbBusSpeed.getItem(0).trim());
                }
            }
            busAdrressValue = !this.txtBusAddress.isEnabled() && !this.cmbBusAddress.isEnabled() ? "0" : (possibleAddresses != null ? this.cmbBusAddress.getText() : this.txtBusAddress.getText());
            if (this.cmbCsPin.isEnabled()) {
                if (this.cmbCsPin.getSelectionIndex() < 0) {
                    this.cmbCsPin.setFocus();
                    throw new Exception("Invalid bus cs pin value. Please choose a value from the list.");
                }
                busCsPinVal = Integer.valueOf(this.cmbCsPin.getText());
            } else {
                busCsPinVal = 0;
            }
            if (this.cmbAddressType.getEnabled()) {
                addressType = this.infoStore.getI3CAddressTypeByName(this.cmbAddressType.getText().trim());
                int addressSize = this.infoStore.getI3CAddressSizeByTypeName(this.cmbAddressType.getText().trim());
                if (addressSize > 1) {
                    busAdrressValue = "0";
                    dynamicAddress = this.txtBusAddress.getText();
                }
            }
            if (this.cmbIbiPurpose.isEnabled()) {
                if (this.cmbIbiPurpose.getSelectionIndex() < 0) {
                    this.cmbIbiPurpose.setFocus();
                    throw new Exception("Invalid bus cs pin value. Please choose a value from the list.");
                }
                ibiPurpose = this.infoStore.getI3CIbiPurposeIdByName(this.cmbIbiPurpose.getText());
            }
            if (bus == null || bus.getBusType() != busTypeVal) {
                switch (busTypeVal) {
                    case 0: {
                        bus = new BusPayloadI2c(busInstanceVal, -1, busSpeedVal);
                        break;
                    }
                    case 1: {
                        bus = new BusPayloadUart(busInstanceVal, busSpeedVal, this.btnCbxRtsCts.getSelection());
                        break;
                    }
                    case 2: {
                        bus = new BusPayloadSpi(busInstanceVal, -1, busSpeedVal, this.btnCbxCsNative.getSelection(), busCsPinVal);
                        break;
                    }
                    case 3: {
                        bus = new BusPayloadI3c(busInstanceVal, -1, busSpeedVal, addressType, dynamicAddress, this.btnCbxIbiEnable.getSelection(), ibiPurpose);
                    }
                }
            } else {
                bus.setBusType(busTypeVal);
                bus.setBusIndex(busInstanceVal);
                bus.setBusSpeed(busSpeedVal);
                switch (busTypeVal) {
                    case 1: {
                        ((BusPayloadUart)bus).setEnableRtsCts(this.btnCbxRtsCts.getSelection());
                        break;
                    }
                    case 2: {
                        ((BusPayloadSpi)bus).setCsNative(this.btnCbxCsNative.getSelection());
                        ((BusPayloadSpi)bus).setCsPin(busCsPinVal);
                        break;
                    }
                    case 3: {
                        ((BusPayloadI3c)bus).setAddressType(addressType);
                        ((BusPayloadI3c)bus).setDynamicAddress(dynamicAddress);
                        ((BusPayloadI3c)bus).setIbiEnable(this.btnCbxIbiEnable.getSelection());
                        ((BusPayloadI3c)bus).setIbiPurpose(ibiPurpose);
                    }
                }
            }
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("One of the Bus details fields does not contain a valid number");
        }
        catch (Exception ex) {
            this.txtBusAddress.setFocus();
            throw new RuntimeException(ex);
        }
        try {
            if (bus != null) {
                bus.setHexBusAddress(busAdrressValue);
            }
        }
        catch (Exception e) {
            this.txtBusAddress.setFocus();
            throw new RuntimeException(e);
        }
        return bus;
    }

    public void init() {
        ArrayList<String> busTypes = this.infoStore.getAllBusTypeNames();
        ArrayList<String> addressTypes = this.infoStore.getAllI3CAddressType();
        this.cmbBusType.add(NO_BUS_INFO_TEXT);
        this.cmbBusType.select(0);
        for (String busType : busTypes) {
            if (this._possibleBusTypes != null && !this._possibleBusTypes.contains(busType)) continue;
            this.cmbBusType.add(busType);
        }
        for (String addressType : addressTypes) {
            this.cmbAddressType.add(addressType);
        }
    }

    public void setBusAvailability() {
        boolean addressEnabled = this.infoStore.isAddressEnabledForBusType(this.cmbBusType.getText());
        boolean instanceEnabled = !this._disableInstanceForTypes.contains(this.cmbBusType.getText());
        boolean speedEnabled = this.infoStore.isSpeedEnabledForBusType(this.cmbBusType.getText());
        speedEnabled &= !this._disableSpeedForTypes.contains(this.cmbBusType.getText());
        boolean enableRtsCtsEnabled = this._isForceDisableRtsCts ? false : this.infoStore.isRtsCtsEnabledForBusType(this.cmbBusType.getText());
        boolean csNativeEnabled = this.infoStore.isCsNativeEnabledForBusType(this.cmbBusType.getText());
        boolean csPinEnabled = this.infoStore.isCsPinEnabledForBusType(this.cmbBusType.getText());
        boolean addressTypeEnabled = this.infoStore.isAddressTypeEnabledForBusType(this.cmbBusType.getText());
        boolean ibiPurposeEnabled = this.infoStore.isIbiPurposeEnabledForBusType(this.cmbBusType.getText());
        if (this.cmbBusType.getSelectionIndex() == 0) {
            addressEnabled = false;
            speedEnabled = false;
            instanceEnabled = false;
            this.spnBusInstance.setSelection(0);
            this.txtBusAddress.setText("");
            this.cmbBusAddress.deselectAll();
            this.cmbBusSpeed.deselectAll();
            this.btnCbxRtsCts.setSelection(false);
            this.btnCbxCsNative.setSelection(false);
            this.cmbCsPin.deselectAll();
            this.cmbAddressType.deselectAll();
            this.cmbIbiPurpose.deselectAll();
        }
        this.spnBusInstance.setEnabled(instanceEnabled);
        this.lblBusInstance.setEnabled(instanceEnabled);
        this.txtBusAddress.setEnabled(addressEnabled);
        this.cmbBusAddress.setEnabled(addressEnabled);
        this.lblBusAddress.setEnabled(addressEnabled);
        this.lbl0x.setEnabled(addressEnabled);
        this.lblhexFormat.setEnabled(addressEnabled);
        this.cmbBusSpeed.setEnabled(speedEnabled);
        this.lblBusSpeed.setEnabled(speedEnabled);
        this.cmbAddressType.setEnabled(addressTypeEnabled);
        if (this.cmbBusType.getText().compareTo(this.prevBusType) != 0) {
            this.txtBusAddress.setText("");
            this.cmbBusAddress.deselectAll();
        }
        if (!addressTypeEnabled) {
            this.cmbAddressType.deselectAll();
        }
        if (speedEnabled) {
            int busTypeId = this.infoStore.getBusTypeId(this.cmbBusType.getText());
            ArrayList<String> busSpeeds = this.infoStore.getAllBusSpeedNames(busTypeId);
            this.cmbBusSpeed.removeAll();
            for (String speedName : busSpeeds) {
                ArrayList<Integer> possibleBusSpeeds = null;
                if (this._possibleSpeedsForBusType != null) {
                    possibleBusSpeeds = this._possibleSpeedsForBusType.get(this.cmbBusType.getText());
                }
                if (possibleBusSpeeds != null && !possibleBusSpeeds.contains(this.infoStore.getBusSpeedValue(busTypeId, speedName))) continue;
                this.cmbBusSpeed.add(speedName);
            }
        } else {
            this.cmbBusSpeed.deselectAll();
        }
        this.btnCbxRtsCts.setEnabled(enableRtsCtsEnabled);
        this.btnCbxCsNative.setEnabled(csNativeEnabled);
        this.lblCsPin.setEnabled(csPinEnabled);
        this.cmbCsPin.setEnabled(csPinEnabled);
        if (csPinEnabled) {
            this.cmbCsPin.removeAll();
            for (int i = 0; i < 16; ++i) {
                this.cmbCsPin.add(String.valueOf(i));
            }
        } else {
            this.cmbCsPin.deselectAll();
        }
        this.btnCbxIbiEnable.setEnabled(ibiPurposeEnabled);
        if (!ibiPurposeEnabled) {
            this.btnCbxIbiEnable.setSelection(false);
            this.lblIbiPurpose.setEnabled(false);
            this.cmbIbiPurpose.setEnabled(false);
            this.cmbIbiPurpose.deselectAll();
        } else {
            this.cmbIbiPurpose.removeAll();
            ArrayList<String> ibiPurpose = this.infoStore.getAllI3CIbiPurpose();
            for (String purpose : ibiPurpose) {
                this.cmbIbiPurpose.add(purpose);
            }
            this.lblIbiPurpose.setEnabled(this.btnCbxIbiEnable.getSelection());
            this.cmbIbiPurpose.setEnabled(this.btnCbxIbiEnable.getSelection());
        }
        this.prevBusType = this.cmbBusType.getText();
    }

    public void setEnabled(boolean enabled) {
        if (enabled && !this.grpBusInfo.isEnabled()) {
            this.clear();
            return;
        }
        if (enabled) {
            this.setBusAvailability();
        } else {
            this.clear();
            this.grpBusInfo.setEnabled(false);
            for (Control control : this.grpBusInfo.getChildren()) {
                control.setEnabled(false);
            }
        }
    }

    public void autofillBusFromMetadata(Sensor sensor) {
        if (sensor == null) {
            return;
        }
        if (this.cmbBusType.getItemCount() != 2) {
            return;
        }
        this.cmbBusType.select(1);
        if (DataStore.getInstance().isFdkRun() && DataStore.getInstance().getFdkExcutionEnv() != null) {
            switch (DataStore.getInstance().getFdkExcutionEnv()) {
                case GALILEO_FULL: 
                case GALILEO_LITE: {
                    this.spnBusInstance.setSelection(0);
                    break;
                }
                case SIMICS: {
                    this.spnBusInstance.setSelection(1);
                    break;
                }
            }
        }
        if (this.cmbBusAddress.getItemCount() == 1) {
            this.cmbBusAddress.select(0);
        }
    }

    public void filterBusTypes(ArrayList<String> types) {
        this._possibleBusTypes = new ArrayList();
        this._possibleBusTypes.addAll(types);
    }

    public void setBusSpeedFilter(HashMap<String, ArrayList<Integer>> possibleSpeedsForBusType) {
        this._possibleSpeedsForBusType = new HashMap();
        for (String busType : possibleSpeedsForBusType.keySet()) {
            ArrayList currBusSpeeds = new ArrayList();
            currBusSpeeds.addAll(possibleSpeedsForBusType.get(busType));
            this._possibleSpeedsForBusType.put(busType, currBusSpeeds);
        }
    }

    public void setSensor(Sensor sensor) {
        this._sensor = sensor;
    }

    public void disableSpeedForType(String type) {
        this._disableSpeedForTypes.add(type);
    }

    public void disableInstanceForType(String type) {
        this._disableInstanceForTypes.add(type);
    }

    public void setIsForceDisableRtsCts(boolean isDisable) {
        this._isForceDisableRtsCts = isDisable;
    }

    public CustomSpinner getBusInstanceControl() {
        return this.spnBusInstance;
    }

    public void clear() {
        Control[] children;
        for (Control child : children = this.grpBusInfo.getChildren()) {
            child.dispose();
        }
        this.drawBusInfo(this._shell, this._parent);
        this.grpBusInfo.layout();
    }

    public void setLayoutData(Object layoutData) {
        this.grpBusInfo.setLayoutData(layoutData);
    }

    public Group drawBusInfo(Shell shell, Composite parent) {
        this._shell = shell;
        this._parent = parent;
        if (this.grpBusInfo == null) {
            this.grpBusInfo = GuiUtils.addGroupToComposite("Bus Information", parent, 0, 4, 4, true, true, 1, 1, 4);
        } else {
            this.grpBusInfo.setEnabled(true);
        }
        this.lblBusType = GuiUtils.addLabelToComposite("Bus Type:", (Composite)this.grpBusInfo, 0, 16384, 0x1000000, false, false, 1, 1);
        this.cmbBusType = GuiUtils.addComboToComposite((Composite)this.grpBusInfo, 8, 4, 16384, true, false, 3, 1);
        this.lblBusInstance = GuiUtils.addLabelToComposite("Bus Instance:", (Composite)this.grpBusInfo, 0, 16384, 0x1000000, false, false, 1, 1);
        this.spnBusInstance = GuiUtils.addCustomSpinnerToComposite(BusPayload.BUS_INSTANCE_FIELD_MAX_VALUE, shell, (Composite)this.grpBusInfo, 2048, 4, 16384, true, false, 3, 1);
        this.lblAddressType = GuiUtils.addLabelToComposite("Address Type:", (Composite)this.grpBusInfo, 0, 16384, 0x1000000, false, false, 1, 1);
        this.cmbAddressType = GuiUtils.addComboToComposite((Composite)this.grpBusInfo, 8, 4, 16384, true, false, 3, 1);
        this.lblBusAddress = GuiUtils.addLabelToComposite("Bus Address:", (Composite)this.grpBusInfo, 0, 16384, 0x1000000, false, false, 1, 1);
        this.lbl0x = GuiUtils.addLabelToComposite("0x", (Composite)this.grpBusInfo, 0, 131072, 0x1000000, false, false, 1, 1);
        this.txtBusAddress = GuiUtils.addTextToComposite((Composite)this.grpBusInfo, 2048, 4, 0x1000000, true, false, 1, 1);
        this.cmbBusAddress = GuiUtils.addComboToComposite((Composite)this.grpBusInfo, 0, 4, 16384, true, false, 1, 1);
        this.lblhexFormat = GuiUtils.addLabelToComposite("0 Byte(Hex format)", (Composite)this.grpBusInfo, 0, 16384, 0x1000000, true, false, 1, 1);
        this.lblBusSpeed = GuiUtils.addLabelToComposite("Bus Speed:", (Composite)this.grpBusInfo, 0, 16384, 0x1000000, false, false, 1, 1);
        this.cmbBusSpeed = GuiUtils.addComboToComposite((Composite)this.grpBusInfo, 8, 4, 0x1000000, true, false, 3, 1);
        this.btnCbxRtsCts = GuiUtils.addButtonToComposite("Enable RTS/CTS", "Enables you to implement flow controls over this bus.", (Composite)this.grpBusInfo, 32, 16384, 0x1000000, false, false, 1, 1);
        this.btnCbxCsNative = GuiUtils.addButtonToComposite("CS Native", "When selected, sets CPHA=1", (Composite)this.grpBusInfo, 32, 16384, 0x1000000, false, false, 1, 1);
        this.lblCsPin = GuiUtils.addLabelToComposite("CS Pin:", (Composite)this.grpBusInfo, 0, 0x1000000, 0x1000000, false, false, 1, 1);
        this.cmbCsPin = GuiUtils.addComboToComposite((Composite)this.grpBusInfo, 8, 4, 0x1000000, true, false, 1, 1);
        Composite grpAdditionalOptions = GuiUtils.addCompositeToComposite((Composite)this.grpBusInfo, 0, 4, 4, true, true, 4, 1, 3);
        this.btnCbxIbiEnable = GuiUtils.addButtonToComposite("IBI Enable", "", grpAdditionalOptions, 32, 131072, 0x1000000, false, false, 1, 1);
        this.lblIbiPurpose = GuiUtils.addLabelToComposite("IBI Purpose:", grpAdditionalOptions, 0, 0x1000000, 0x1000000, false, false, 1, 1);
        this.cmbIbiPurpose = GuiUtils.addComboToComposite(grpAdditionalOptions, 8, 4, 0x1000000, true, false, 1, 1);
        this.cmbBusType.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                GuiUtils.chooseComboItemByValue(BusInfo.this.cmbBusType);
            }
        });
        this.cmbBusType.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                BusInfo.this.setModified();
                BusInfo.this.setBusAvailability();
                if (BusInfo.this._sensor != null && BusInfo.this.cmbBusType.getSelectionIndex() > 0) {
                    BusInfo.this.autofillBusFromMetadata(BusInfo.this._sensor);
                }
            }
        });
        this.cmbAddressType.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                BusInfo.this.setModified();
                if (BusInfo.this.cmbAddressType.getSelectionIndex() >= 0) {
                    Integer size = BusInfo.this.infoStore.getI3CAddressSizeByTypeName(BusInfo.this.cmbAddressType.getText());
                    if (size > 1) {
                        BusInfo.this.lblhexFormat.setText(size + " Bytes(Hex format)");
                    } else {
                        BusInfo.this.lblhexFormat.setText(size + " Byte(Hex format)");
                    }
                    BusInfo.this.txtBusAddress.setText("");
                    BusInfo.this.txtBusAddress.setTextLimit(size * 2);
                } else {
                    BusInfo.this.lblhexFormat.setText("1 Byte(Hex format)");
                    BusInfo.this.txtBusAddress.setTextLimit(2);
                }
            }
        });
        this.spnBusInstance.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                BusInfo.this.setModified();
            }
        });
        this.txtBusAddress.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                BusInfo.this.setModified();
            }
        });
        this.cmbBusSpeed.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent arg0) {
                GuiUtils.chooseComboItemByValue(BusInfo.this.cmbBusSpeed);
            }
        });
        this.cmbBusSpeed.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                BusInfo.this.setModified();
            }
        });
        this.cmbCsPin.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent arg0) {
                GuiUtils.chooseComboItemByValue(BusInfo.this.cmbCsPin);
            }
        });
        this.cmbCsPin.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                BusInfo.this.setModified();
            }
        });
        this.cmbIbiPurpose.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent arg0) {
                GuiUtils.chooseComboItemByValue(BusInfo.this.cmbIbiPurpose);
            }
        });
        this.cmbIbiPurpose.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                BusInfo.this.setModified();
            }
        });
        this.btnCbxCsNative.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                BusInfo.this.cmbCsPin.setEnabled(!((Button)arg0.getSource()).getSelection());
                BusInfo.this.lblCsPin.setEnabled(BusInfo.this.cmbCsPin.getEnabled());
                if (!BusInfo.this.cmbCsPin.getEnabled()) {
                    BusInfo.this.cmbCsPin.deselectAll();
                }
                BusInfo.this.setModified();
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
                BusInfo.this.cmbCsPin.setEnabled(!((Button)arg0.getSource()).getSelection());
                BusInfo.this.lblCsPin.setEnabled(BusInfo.this.cmbCsPin.getEnabled());
                if (!BusInfo.this.cmbCsPin.getEnabled()) {
                    BusInfo.this.cmbCsPin.deselectAll();
                }
                BusInfo.this.setModified();
            }
        });
        this.btnCbxIbiEnable.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                BusInfo.this.cmbIbiPurpose.setEnabled(((Button)arg0.getSource()).getSelection());
                BusInfo.this.lblIbiPurpose.setEnabled(BusInfo.this.cmbIbiPurpose.getEnabled());
                if (!BusInfo.this.cmbIbiPurpose.getEnabled()) {
                    BusInfo.this.cmbIbiPurpose.deselectAll();
                }
                BusInfo.this.setModified();
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
                BusInfo.this.cmbIbiPurpose.setEnabled(((Button)arg0.getSource()).getSelection());
                BusInfo.this.lblIbiPurpose.setEnabled(BusInfo.this.cmbIbiPurpose.getEnabled());
                if (!BusInfo.this.cmbIbiPurpose.getEnabled()) {
                    BusInfo.this.cmbIbiPurpose.deselectAll();
                }
                BusInfo.this.setModified();
            }
        });
        ((GridData)this.lblhexFormat.getLayoutData()).minimumWidth = (int)((double)GuiUtils.getButtonWidth((Control)this.lblhexFormat) * 1.2);
        GridLayout grdAddtionOptionsLayout = (GridLayout)grpAdditionalOptions.getLayout();
        grdAddtionOptionsLayout.verticalSpacing = 0;
        grdAddtionOptionsLayout.marginWidth = 0;
        grdAddtionOptionsLayout.marginHeight = 0;
        GridData comboData = (GridData)this.cmbBusAddress.getLayoutData();
        comboData.exclude = true;
        this.cmbBusAddress.setVisible(false);
        this.grpBusInfo.layout();
        this.init();
        return this.grpBusInfo;
    }
}

