/*
 * Decompiled with CFR 0.152.
 */
package pdtEditor.gui;

import manager.sensor.SensorData;
import manager.utils.ManagerEnums;
import pdtEditor.InformationStore;
import pdtEditor.Luid;
import pdtEditor.Sensor;

public class DependenciesUtils {
    private static InformationStore infoStore = null;
    public static final int[] SAME_AS_ALGO_INSTANCE = new int[]{255, -1};

    public static void initInfoStore() {
        infoStore = null;
        try {
            infoStore = InformationStore.getInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String getDependencySensorType(SensorData dependency) {
        String sensorType = dependency.getTypeName();
        if (sensorType == null && dependency.getFlags() != null) {
            boolean physical = dependency.getFlags().contains(ManagerEnums.Flags.SC_LUID_FLAG_PHYSICAL);
            String string = sensorType = infoStore != null ? infoStore.getSensorTypeName(dependency.getTypeId(), physical) : String.valueOf(dependency.getTypeId());
        }
        if (sensorType == null) {
            sensorType = String.valueOf(dependency.getTypeId());
        }
        return sensorType;
    }

    public static String getDependencyVendor(SensorData dependency) {
        String vendor = dependency.getVendorName();
        if (vendor == null) {
            String string = vendor = infoStore != null ? infoStore.getVendorName(dependency.getVendorId()) : String.valueOf(dependency.getVendorId());
        }
        if (vendor.equals("-1")) {
            return "---";
        }
        return vendor;
    }

    public static String getDependencyModel(SensorData dependency) {
        String model = dependency.getModelName();
        if (model == null) {
            if (infoStore != null) {
                boolean physical;
                boolean bl = physical = dependency.getFlags() != null && dependency.getFlags().contains(ManagerEnums.Flags.SC_LUID_FLAG_PHYSICAL);
                model = dependency.getFlags() != null ? infoStore.getModelName(physical, dependency.getTypeId(), dependency.getVendorId(), dependency.getModelId(), dependency.getFlagsAsInteger()) : infoStore.getModelName(physical, dependency.getTypeId(), dependency.getVendorId(), dependency.getModelId());
            } else {
                model = String.valueOf(dependency.getModelId());
            }
        }
        if (model.equals("-1")) {
            return "---";
        }
        return model;
    }

    public static int getDependencyInstance(SensorData dependency, Sensor sensor) {
        return dependency.getInstanceId() == SAME_AS_ALGO_INSTANCE[0] || dependency.getInstanceId() == SAME_AS_ALGO_INSTANCE[1] ? sensor.getLuid().getInstanceId() : dependency.getInstanceId();
    }

    public static String getDependencyFlags(SensorData dependency) {
        if (dependency.getFlags() == null || dependency.getFlags().size() == 0 || dependency.getFlags().size() == 1 && dependency.getFlags().contains(ManagerEnums.Flags.SC_LUID_FLAG_NONE)) {
            return "---";
        }
        return Luid.getFlagsStr(dependency.getFlagsAsInteger());
    }

    public static String getDependencyText(SensorData dependency, Sensor sensor) {
        DependenciesUtils.initInfoStore();
        int expectedInstanceId = DependenciesUtils.getDependencyInstance(dependency, sensor);
        String expectedFlags = dependency.getFlagsNames() != null && dependency.getFlagsNames().length > 0 && (dependency.getFlags().size() > 1 || !dependency.getFlags().contains(ManagerEnums.Flags.SC_LUID_FLAG_NONE)) ? ", Flags: {" + DependenciesUtils.getDependencyFlags(dependency) + "}." : "";
        String description = "";
        if (dependency.getDependencyType() != null) {
            description = description + " [" + dependency.getDependencyType().name() + "]:";
        }
        description = description + " Sensor type: " + dependency.getTypeId() + " (" + DependenciesUtils.getDependencySensorType(dependency) + ")" + (dependency.getVendorId() >= 0 ? ", Vendor: " + DependenciesUtils.getDependencyVendor(dependency) : "") + (dependency.getModelId() >= 0 ? ", Model: " + DependenciesUtils.getDependencyModel(dependency) : "") + ", Instance ID: " + expectedInstanceId + expectedFlags;
        return description;
    }
}

