/*
 * Decompiled with CFR 0.152.
 */
package pdtEditor.gui;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import javax.swing.JOptionPane;
import manager.utils.ManagerEnums;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.swt.widgets.Display;
import packaging.NvarPackage;
import packaging.PdtPackage;
import pdtEditor.CLIUtils;
import pdtEditor.DataStore;
import pdtEditor.InformationStore;
import pdtEditor.PdtFile;
import pdtEditor.gui.MainWindow;
import pdtEditor.gui.MultiPdtEdit;

public class Launcher {
    private static final String INPUT_PDT_PATH_ARG_TEXT = "INPUT_PDT_PATH";
    private static final String INPUT_PDT_PATH_TO_MERGE_ARG_TEXT = "INPUT_PDT_PATH_TO_MERGE";
    private static final String OUTPUT_PDT_PATH_ARG_TEXT = "OUTPUT_PDT_PATH";
    private static final String MULTI_PDT_ARG_TEXT = "multi";
    private static final String USAGE_MESSAGE = "Valid arguments: INPUT_PDT_PATH=<input pdt path>, OUTPUT_PDT_PATH=<output pdt path>.";
    private static final String CONFIG_FILE_PATH = "config.txt";
    private static final String PRINT_VERSION_ARG = "version";
    private static final String EXPORT_XML_FROM_FILE_ARG = "xml_from";
    private static final String AUTO_XML_EXPORT_TEXT = "auto_xml";
    private static final String IMPORT_SENSORS_FROM_ARG = "import_sensors_from";
    private static final Object KEEP_ONLY_IMPORTED_SENSORS_ARG = "import_and_replace";
    private static final String PDT_PACKAGE_FROM_ARG = "pdt_package_from";
    private static final String PDT_PACKAGE_TO_ARG = "pdt_package_to";
    private static final String SILENT_VALIDATION_ARG = "silent_validation";
    private static final String SENSOR_FILTERING_XML_ARG = "sensor_filtering";
    private static final String EXCUTION_ENV_ARG = "ex_env";
    private static final String FDK_RUN_ARG = "fdk_run";
    private static final String EXTERNAL_INFO_XML_ARG = "external_info";
    private static final String SET_FORMAT_ARG = "set_format";
    private static final String UPDATE_VERSION_ARG = "update_version";
    private static String inputPdtPath = null;
    private static String inputPdtPathToMerge = null;
    private static String outputPdtPath = null;
    private static String _importExternalFilesPath = null;
    private static boolean _keepOnlyImportedSensors = false;
    private static boolean _mergePdtEnabled = false;
    private static boolean _exportXmlEnabled = false;
    private static boolean _multiEditEnabled = false;
    private static String _inputForXmlExport = null;
    private static boolean _loadGUI = true;
    private static boolean _multi = false;
    private static boolean _autoExportXml = false;
    private static String _pdtPackageXml = null;
    private static String _pdtPackageDest = null;
    private static boolean _silentValidation = false;
    private static String _sensorFilteringXmlPath = null;
    private static boolean _fdkRun = false;
    private static String _externalInfoXmlPath = null;
    private static boolean _suppressEngWarning;
    private static Integer _new_format;
    private static Integer _custom_version;

    public static void printProperty(String propretyName) {
        try {
            InformationStore infoStore = InformationStore.getInstance();
            System.out.println(propretyName + "=\"" + infoStore.getProperty(propretyName) + "\"");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void parseArguments(String[] args) {
        boolean error = false;
        for (String arg : args) {
            if (arg.toLowerCase().equals(PRINT_VERSION_ARG)) {
                Launcher.printProperty("Version");
                _loadGUI = false;
                continue;
            }
            if (_multiEditEnabled && arg.toLowerCase().equals(MULTI_PDT_ARG_TEXT)) {
                _multi = true;
                continue;
            }
            if (_exportXmlEnabled && arg.toLowerCase().equals(AUTO_XML_EXPORT_TEXT)) {
                _autoExportXml = true;
                continue;
            }
            if (arg.toLowerCase().equals(KEEP_ONLY_IMPORTED_SENSORS_ARG)) {
                _keepOnlyImportedSensors = true;
                continue;
            }
            if (arg.toLowerCase().equals(SILENT_VALIDATION_ARG)) {
                _silentValidation = true;
                continue;
            }
            if (arg.toLowerCase().equals(FDK_RUN_ARG)) {
                _fdkRun = true;
                continue;
            }
            String[] splitedArgs = arg.split("=");
            if (splitedArgs.length == 2) {
                String key = splitedArgs[0].trim().toUpperCase();
                String value = splitedArgs[1];
                if (inputPdtPath == null && key.equals(INPUT_PDT_PATH_ARG_TEXT.trim().toUpperCase())) {
                    inputPdtPath = value;
                    continue;
                }
                if (_mergePdtEnabled && inputPdtPathToMerge == null && key.equals(INPUT_PDT_PATH_TO_MERGE_ARG_TEXT.trim().toUpperCase())) {
                    inputPdtPathToMerge = value;
                    continue;
                }
                if (outputPdtPath == null && key.toUpperCase().trim().equals(OUTPUT_PDT_PATH_ARG_TEXT.trim().toUpperCase())) {
                    outputPdtPath = value;
                    continue;
                }
                if (_exportXmlEnabled && key.toUpperCase().equals(EXPORT_XML_FROM_FILE_ARG.toUpperCase())) {
                    _inputForXmlExport = value;
                    _loadGUI = false;
                    continue;
                }
                if (key.toUpperCase().equals(IMPORT_SENSORS_FROM_ARG.toUpperCase())) {
                    _importExternalFilesPath = value;
                    continue;
                }
                if (key.toUpperCase().equals(PDT_PACKAGE_FROM_ARG.toUpperCase())) {
                    _pdtPackageXml = value;
                    continue;
                }
                if (key.toUpperCase().equals(PDT_PACKAGE_TO_ARG.toUpperCase())) {
                    _pdtPackageDest = value;
                    continue;
                }
                if (key.toUpperCase().equals(SENSOR_FILTERING_XML_ARG.toUpperCase())) {
                    _sensorFilteringXmlPath = value;
                    continue;
                }
                if (key.toUpperCase().equals(EXCUTION_ENV_ARG.toUpperCase())) {
                    try {
                        DataStore.getInstance().setFdkExcutionEnv(ManagerEnums.ExecutionEnvironments.getValueByPDTExName((String)value));
                    }
                    catch (Exception e) {
                        System.err.println("Error while trying to parse the excution env. arguemnt: " + value);
                    }
                    continue;
                }
                if (key.toUpperCase().equals(EXTERNAL_INFO_XML_ARG.toUpperCase())) {
                    _externalInfoXmlPath = value;
                    continue;
                }
                if (key.toUpperCase().equals(SET_FORMAT_ARG.toUpperCase())) {
                    try {
                        _new_format = Integer.valueOf(value);
                        continue;
                    }
                    catch (NumberFormatException e) {
                        System.err.println("Invalid integer: [" + value + "].");
                        error = true;
                        break;
                    }
                }
                if (key.toUpperCase().equals(UPDATE_VERSION_ARG.toUpperCase())) {
                    _loadGUI = false;
                    try {
                        _custom_version = Integer.valueOf(value);
                        if (_custom_version <= 255 && _custom_version >= 0) continue;
                        System.err.println("Invalid version range: [" + value + "]. Only support 0~255.");
                        error = true;
                    }
                    catch (NumberFormatException e) {
                        System.err.println("Invalid integer: [" + value + "].");
                        error = true;
                    }
                    break;
                }
                System.err.println("ERROR: Unknown Argument: [" + splitedArgs[0] + "].");
                error = true;
                break;
            }
            System.err.println("ERROR: Unknown Argument: [" + arg + "].");
            error = true;
            break;
        }
        if (error) {
            System.err.println(USAGE_MESSAGE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void readConfigFile() throws IOException {
        File file = new File(CONFIG_FILE_PATH);
        if (!file.exists()) {
            return;
        }
        BufferedReader br = null;
        FileReader fr = null;
        try {
            String currLine;
            fr = new FileReader(file.getAbsolutePath());
            br = new BufferedReader(fr);
            while ((currLine = br.readLine()) != null) {
                String content;
                String[] tag;
                String[] commentSplitted = currLine.split("#");
                if (commentSplitted.length == 0 || (tag = (content = commentSplitted[0]).split("\\s+")).length != 2) continue;
                String key = tag[0].toUpperCase();
                String value = tag[1].toUpperCase();
                if (key.equals("EXPORT_XML") && value.equals("TRUE")) {
                    _exportXmlEnabled = true;
                }
                if (key.equals("MULTI_EDIT") && value.equals("TRUE")) {
                    _multiEditEnabled = true;
                }
                if (key.equals("ENG_VERSION") && value.equals("TRUE")) {
                    _suppressEngWarning = true;
                }
                if (!key.equals("MERGE") || !value.equals("TRUE")) continue;
                _mergePdtEnabled = true;
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (fr != null) {
                fr.close();
            }
            if (br != null) {
                br.close();
            }
        }
    }

    public static void showException(Throwable e) {
        e.printStackTrace();
        JOptionPane.showMessageDialog(null, e.getMessage(), "Error", 0);
    }

    public static void main(String[] args) {
        block21: {
            try {
                Launcher.readConfigFile();
                Launcher.parseArguments(args);
                if (_new_format != null) {
                    CLIUtils.changePDTFormat(inputPdtPath, _new_format);
                    return;
                }
                if (inputPdtPath != null && inputPdtPathToMerge != null) {
                    CLIUtils.mergePdts(inputPdtPath, inputPdtPathToMerge);
                    return;
                }
                if (inputPdtPath != null && _custom_version != null) {
                    CLIUtils.updateCustomVersion(inputPdtPath, outputPdtPath, _custom_version);
                    return;
                }
                if (_pdtPackageXml != null && _pdtPackageDest != null) {
                    _loadGUI = false;
                    PdtPackage pdtPackage = new PdtPackage();
                    pdtPackage.setExportXml(_autoExportXml);
                    try {
                        pdtPackage.buildPackage(_pdtPackageXml);
                    }
                    catch (Exception e) {
                        System.err.println("Package building has failed: " + e.getMessage());
                        System.exit(ExitCode.PACKAGE_BUILD_FAILED.getValue());
                        return;
                    }
                    pdtPackage.writePackage(_pdtPackageDest);
                }
                if (_inputForXmlExport != null) {
                    DataStore dataStore = DataStore.getInstance();
                    DataStore.getInstance().clearData();
                    try {
                        if (NvarPackage.isNVARPackage(_inputForXmlExport)) {
                            DataStore.getInstance().setNVARPackageXml(_inputForXmlExport);
                            DataStore.getInstance().loadNVARPAckage(_inputForXmlExport);
                            PdtFile nvarPdtFile = DataStore.getInstance().getCurrentPdtFile();
                            if (nvarPdtFile == null) {
                                throw new Exception("Bad PDT file");
                            }
                        } else {
                            dataStore.setXmlDestPath(new File(_inputForXmlExport + ".xml"));
                            dataStore.loadFromPdtBin(new PdtFile(_inputForXmlExport));
                        }
                    }
                    catch (Exception e) {
                        System.out.println("Failed to export The XML representation: " + e.getMessage());
                    }
                }
                if (_loadGUI) {
                    Display display = null;
                    try {
                        display = Display.getDefault();
                    }
                    catch (UnsatisfiedLinkError e) {
                        if (e.getMessage().contains("SWT")) {
                            Launcher.showException(new Exception("Could not load the application.\nPlease verify that your version of Java and your machine's architecture use the same word size (32-bit or 64-bit)."));
                            System.exit(ExitCode.UNMATCHING_JVM.getValue());
                        } else {
                            Launcher.showException(e);
                            System.exit(ExitCode.ERROR.getValue());
                        }
                        return;
                    }
                    catch (NoClassDefFoundError e) {
                        Launcher.showException(new Exception("One or more files necessary for the running of the PDT Editor are missing.\nIf any files have been deleted or moved, please recover them and try again."));
                        System.exit(ExitCode.MISSIMG_SWT.getValue());
                        return;
                    }
                    System.err.println("Initialization Succeeded");
                    Realm.runWithDefault((Realm)SWTObservables.getRealm((Display)display), (Runnable)new Runnable(){

                        @Override
                        public void run() {
                            if (!_suppressEngWarning) {
                                try {
                                    InformationStore infoStore = InformationStore.getInstance();
                                    String versionString = infoStore.getProperty("Version");
                                    if (versionString == null || !versionString.contains(".")) {
                                        JOptionPane.showMessageDialog(null, "This is an engeneering version of the PDT editor and is for internal use only.", "Engeneering version", 1);
                                    }
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }
                            if (_fdkRun) {
                                if (_silentValidation) {
                                    DataStore.getInstance().setRunType(DataStore.RunType.FDK_RUN_PROJECT);
                                } else {
                                    DataStore.getInstance().setRunType(DataStore.RunType.FDK_EDIT_PDT);
                                }
                                DataStore.getInstance().initPDTExternalInfo(_externalInfoXmlPath);
                            } else if (_externalInfoXmlPath != null) {
                                try {
                                    DataStore.getInstance().initPDTExternalInfo(_externalInfoXmlPath);
                                }
                                catch (Exception e) {
                                    System.out.println("Failed loading the external info file: " + e.getMessage());
                                }
                            }
                            if (_multi) {
                                MultiPdtEdit multiWindow = new MultiPdtEdit(_autoExportXml);
                                multiWindow.open();
                            } else {
                                try {
                                    MainWindow mainWindow = new MainWindow(inputPdtPath, outputPdtPath, _silentValidation, _autoExportXml);
                                    mainWindow.setImportProperties(_importExternalFilesPath, _keepOnlyImportedSensors);
                                    mainWindow.setSensorFilteringProperties(_sensorFilteringXmlPath);
                                    mainWindow.open();
                                    System.exit(ExitCode.OK.getValue());
                                }
                                catch (Exception e) {
                                    Launcher.showException(e);
                                    System.exit(ExitCode.ERROR.getValue());
                                }
                            }
                        }
                    });
                    break block21;
                }
                System.err.println("Initialization Succeeded");
            }
            catch (Exception e) {
                Launcher.showException(e);
                System.exit(ExitCode.ERROR.getValue());
            }
            catch (Throwable e) {
                Launcher.showException(new Exception("Unexpected error: " + e.getMessage()));
                System.exit(ExitCode.ERROR.getValue());
            }
        }
    }

    static {
        _new_format = null;
        _custom_version = null;
    }

    public static enum ExitCode {
        OK(0),
        ERROR(1),
        PACKAGE_BUILD_FAILED(2),
        UNMATCHING_JVM(3),
        MISSIMG_SWT(4);

        private int value;

        private ExitCode(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

