/*
 * Decompiled with CFR 0.152.
 */
package pdtEditor.gui.calibration;

import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.SWTResourceManager;
import pdtEditor.Sensor;
import pdtEditor.gui.GuiUtils;
import pdtEditor.gui.SensorModifier;
import pdtEditor.gui.calibration.CalibrationEditor;
import pdtEditor.gui.calibration.CalibrationEditorOpener;
import pdtEditor.gui.configuration.AngleRegulatorConfiguration;
import pdtEditor.payloads.calibrations.CalibrationPayload;
import pdtEditor.payloads.calibrations.OnTableDetectionCalibrationPayload;
import resources.CustomSpinner;
import resources.DoubleHolder;

public class OnTableDetectionCalibration
implements CalibrationEditor {
    private static final int DOUBLE_PRECISION = 4;
    protected Shell shlEditConfiguration;
    private Display display;
    private boolean _modified = false;
    private CalibrationEditorOpener _parent = null;
    private Sensor _sensor = null;
    private OnTableDetectionCalibrationPayload _data = null;
    private Text formatID;
    private CustomSpinner spnVersion;
    private CustomSpinner spnEnterHysteresis;
    private CustomSpinner spnExitHysteresis;
    private DoubleHolder dbhEnterThresh;
    private DoubleHolder dbhExitThreshBase;
    private DoubleHolder dbhExitThreshMax;
    private DoubleHolder dbhStepFactor;

    public static void main(String[] args) {
        try {
            OnTableDetectionCalibration window = new OnTableDetectionCalibration(null, null);
            window.open();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public OnTableDetectionCalibration(CalibrationEditorOpener parent, OnTableDetectionCalibrationPayload data, Sensor sensor) {
        this._data = data;
        this._sensor = sensor;
        this._parent = parent;
    }

    public OnTableDetectionCalibration(SensorModifier parent, Sensor sensor) {
        this._parent = parent;
        this._sensor = sensor;
    }

    @Override
    public String getCalibrationFormatName() {
        return "On Table Detection Calibration";
    }

    @Override
    public void open() {
        this.display = Display.getDefault();
        this.createContents();
        this.fillData();
        this.shlEditConfiguration.open();
        this.shlEditConfiguration.layout();
        while (!this.shlEditConfiguration.isDisposed()) {
            if (this.display.readAndDispatch()) continue;
            this.display.sleep();
        }
    }

    public void fillData() {
        if (this._data == null) {
            this.formatID.setText(String.valueOf(1));
            this.spnVersion.setSelection(0);
            this.dbhEnterThresh.setValue(1.5);
            this.dbhExitThreshBase.setValue(5.0);
            this.dbhExitThreshMax.setValue(15.0);
            this.dbhStepFactor.setValue(0.002);
            this.spnEnterHysteresis.setSelection(20);
            this.spnExitHysteresis.setSelection(0);
        } else {
            this.formatID.setText(String.valueOf(this._data.getFormatID()));
            this.spnVersion.setSelection(this._data.getVersion());
            this.dbhEnterThresh.setValue(this._data.getEnterThresh());
            this.dbhExitThreshBase.setValue(this._data.getExitThreshBase());
            this.dbhExitThreshMax.setValue(this._data.getExitThreshMax());
            this.dbhStepFactor.setValue(this._data.getStepFactor());
            this.spnEnterHysteresis.setSelection(this._data.getEnterHysteresis());
            this.spnExitHysteresis.setSelection(this._data.getExitHysteresis());
        }
        this._modified = false;
    }

    public void saveData() {
        if (this.dbhExitThreshBase.getValue() < this.dbhEnterThresh.getValue()) {
            MessageBox messageBox = new MessageBox(this.shlEditConfiguration, 513);
            messageBox.setText("Invalid Threshold Values");
            messageBox.setMessage("The exit threshold base's value cannot be less than the enter threshold's value.");
            messageBox.open();
            return;
        }
        if (this.dbhExitThreshMax.getValue() < this.dbhExitThreshBase.getValue()) {
            MessageBox messageBox = new MessageBox(this.shlEditConfiguration, 513);
            messageBox.setText("Invalid Threshold Values");
            messageBox.setMessage("The exit threshold max's value cannot be less than the exit threshold base's value.");
            messageBox.open();
            return;
        }
        if (this._data == null) {
            this._data = new OnTableDetectionCalibrationPayload();
            this._parent.addNewCalibration(this._sensor, this._data);
        }
        this._data.setFormatID(Integer.valueOf(this.formatID.getText()));
        this._data.setVersion(this.spnVersion.getSelection());
        this._data.setEnterThresh(this.dbhEnterThresh.getValue());
        this._data.setExitThreshBase(this.dbhExitThreshBase.getValue());
        this._data.setExitThreshMax(this.dbhExitThreshMax.getValue());
        this._data.setStepFactor(this.dbhStepFactor.getValue());
        this._data.setEnterHysteresis(Short.valueOf(this.spnEnterHysteresis.getText()));
        this._data.setExitHysteresis(Short.valueOf(this.spnExitHysteresis.getText()));
        this._modified = false;
        this._parent.setModified();
        this._parent.refreshCalibrationData();
        this.shlEditConfiguration.close();
    }

    protected void createContents() {
        int longSpinnerMinWidth;
        this.shlEditConfiguration = new Shell(65632);
        this.shlEditConfiguration.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                if (OnTableDetectionCalibration.this._modified) {
                    MessageBox messageBox = new MessageBox(OnTableDetectionCalibration.this.shlEditConfiguration, 296);
                    messageBox.setText("Closing The Configuration Window");
                    messageBox.setMessage("Some changes will be lost. Are you sure that you want to continue?");
                    if (messageBox.open() != 32) {
                        e.doit = false;
                        return;
                    }
                }
            }
        });
        this.shlEditConfiguration.setImage(SWTResourceManager.getImage(AngleRegulatorConfiguration.class, "/resources/Intel.ico"));
        this.shlEditConfiguration.setText("On Table Detection Calibration");
        GuiUtils.setGridLayoutToComposite((Composite)this.shlEditConfiguration, 1);
        Group group = GuiUtils.addGroupToComposite("", (Composite)this.shlEditConfiguration, 0, 4, 128, true, false, 1, 1, 2);
        GuiUtils.addLabelToComposite("Calibration Format ID:", (Composite)group, 0, 16384, 0x1000000, false, false, 1, 1);
        this.formatID = GuiUtils.addTextToComposite((Composite)group, 2048, 16384, 0x1000000, true, false, 1, 1);
        GuiUtils.addLabelToComposite("Calibration Version:", (Composite)group, 0, 16384, 0x1000000, false, false, 1, 1);
        this.spnVersion = GuiUtils.addCustomSpinnerToComposite(CalibrationPayload.VERSION_MAX_VALUE, this.shlEditConfiguration, (Composite)group, 2048, 16384, 0x1000000, true, false, 1, 1);
        Group grpThreshold = GuiUtils.addGroupToComposite("Threshold Configuration", (Composite)this.shlEditConfiguration, 0, 4, 128, true, false, 1, 1, 2);
        GuiUtils.addLabelToComposite("Enther Threshold:", (Composite)grpThreshold, 0, 16384, 0x1000000, false, false, 1, 1);
        this.dbhEnterThresh = GuiUtils.addDoubleHolderToComposite(0, 100, 4, this.shlEditConfiguration, (Composite)grpThreshold, 2048, 131072, 0x1000000, true, false, 1, 1);
        GuiUtils.addLabelToComposite("Exit Threshold Base:", (Composite)grpThreshold, 0, 16384, 0x1000000, false, false, 1, 1);
        this.dbhExitThreshBase = GuiUtils.addDoubleHolderToComposite(0, 200, 4, this.shlEditConfiguration, (Composite)grpThreshold, 2048, 131072, 0x1000000, true, false, 1, 1);
        GuiUtils.addLabelToComposite("Exit Threshold Max:", (Composite)grpThreshold, 0, 16384, 0x1000000, false, false, 1, 1);
        this.dbhExitThreshMax = GuiUtils.addDoubleHolderToComposite(0, 200, 4, this.shlEditConfiguration, (Composite)grpThreshold, 2048, 131072, 0x1000000, true, false, 1, 1);
        GuiUtils.addLabelToComposite("Step Factor:", (Composite)grpThreshold, 0, 16384, 0x1000000, false, false, 1, 1);
        this.dbhStepFactor = GuiUtils.addDoubleHolderToComposite(0, 1, 4, this.shlEditConfiguration, (Composite)grpThreshold, 2048, 131072, 0x1000000, true, false, 1, 1);
        GuiUtils.addLabelToComposite("Enter Hysteresis:", (Composite)grpThreshold, 0, 16384, 0x1000000, false, false, 1, 1);
        this.spnEnterHysteresis = GuiUtils.addCustomSpinnerToComposite(Short.MAX_VALUE, this.shlEditConfiguration, (Composite)grpThreshold, 2048, 131072, 0x1000000, true, false, 1, 1);
        GuiUtils.addLabelToComposite("Exit Hysteresis:", (Composite)grpThreshold, 0, 16384, 0x1000000, false, false, 1, 1);
        this.spnExitHysteresis = GuiUtils.addCustomSpinnerToComposite(Short.MAX_VALUE, this.shlEditConfiguration, (Composite)grpThreshold, 2048, 131072, 0x1000000, true, false, 1, 1);
        this.spnEnterHysteresis.setMinimum(0);
        this.spnExitHysteresis.setMinimum(0);
        this.formatID.setEnabled(false);
        this.dbhEnterThresh.setMinClosedInterval(false);
        this.dbhExitThreshBase.setMinClosedInterval(false);
        this.dbhExitThreshMax.setMinClosedInterval(false);
        Composite compositeShellButton = GuiUtils.addCompositeToComposite((Composite)this.shlEditConfiguration, 0, 131072, 0x1000000, false, false, 1, 1, 2);
        Button btnSave = GuiUtils.addButtonToComposite("Save and Close", "", compositeShellButton, 0, 131072, 0x1000000, true, false, 1, 1);
        Button btnCancel = GuiUtils.addButtonToComposite("Cancel", "", compositeShellButton, 0, 131072, 0x1000000, true, false, 1, 1);
        this.formatID.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                OnTableDetectionCalibration.this._modified = true;
            }
        });
        this.spnVersion.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                OnTableDetectionCalibration.this._modified = true;
            }
        });
        this.dbhEnterThresh.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                OnTableDetectionCalibration.this._modified = true;
            }
        });
        this.dbhExitThreshBase.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                OnTableDetectionCalibration.this._modified = true;
            }
        });
        this.dbhExitThreshMax.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                OnTableDetectionCalibration.this._modified = true;
            }
        });
        this.dbhStepFactor.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                OnTableDetectionCalibration.this._modified = true;
            }
        });
        btnSave.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OnTableDetectionCalibration.this.saveData();
            }
        });
        btnCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OnTableDetectionCalibration.this.shlEditConfiguration.close();
            }
        });
        ((GridData)this.spnVersion.getLayoutData()).minimumWidth = longSpinnerMinWidth = (int)((double)GuiUtils.getButtonWidth((Control)this.shlEditConfiguration) * 1.5);
        ((GridData)this.dbhEnterThresh.getLayoutData()).minimumWidth = longSpinnerMinWidth;
        ((GridData)this.dbhExitThreshBase.getLayoutData()).minimumWidth = longSpinnerMinWidth;
        ((GridData)this.dbhExitThreshMax.getLayoutData()).minimumWidth = longSpinnerMinWidth;
        ((GridData)this.dbhStepFactor.getLayoutData()).minimumWidth = longSpinnerMinWidth;
        ((GridData)this.spnEnterHysteresis.getLayoutData()).minimumWidth = longSpinnerMinWidth;
        ((GridData)this.spnExitHysteresis.getLayoutData()).minimumWidth = longSpinnerMinWidth;
        this.shlEditConfiguration.setSize(this.shlEditConfiguration.computeSize(-1, -1));
        this.shlEditConfiguration.setLocation(GuiUtils.getMiddleLocation(this.shlEditConfiguration, this.display));
    }
}

