/*
 * Decompiled with CFR 0.152.
 */
package pdtEditor.gui.configuration;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.wb.swt.SWTResourceManager;
import pdtEditor.DataStore;
import pdtEditor.InformationStore;
import pdtEditor.Sensor;
import pdtEditor.gui.GuiUtils;
import pdtEditor.gui.InterruptsModifierOpener;
import pdtEditor.gui.InteruptsModifier;
import pdtEditor.gui.SensorModifier;
import pdtEditor.gui.configuration.DevicePostureActionModifier;
import pdtEditor.gui.configuration.DevicePostureConfigurationModifier;
import pdtEditor.gui.configuration.LidModeConfiguration;
import pdtEditor.payloads.GpioPayload;
import pdtEditor.payloads.Payload;
import pdtEditor.payloads.configurations.DevicePostureConfigurationPayload;
import pdtEditor.payloads.configurations.LidModeConfigurationPayload;

public class DevicePostureConfiguration
implements InterruptsModifierOpener {
    private static final int GPIO_PURPOSE_ID_COL_INDEX = 1;
    private Sensor _sensor = null;
    protected Shell shell;
    private Display display;
    private SensorModifier parent;
    private boolean _modified = false;
    private InformationStore infoStore = null;
    private Table configTable;
    private Table interruptsTable;
    private Table actionTable;
    private Button btnAddConfig;
    private Button btnDeleteConfig;
    private Button btnEditConfig;
    private Button btnAddGpio;
    private Button btnEditGpio;
    private Button btnRemoveGpio;
    private Button btnDeleteAction;
    private Button btnAddAction;
    private Button btnEditAction;
    private DataStore _dataStore;
    private DevicePostureConfigurationPayload _payload;
    private DevicePostureConfiguration _thisInstance = this;

    public static void main(String[] args) {
        try {
            DevicePostureConfiguration window = new DevicePostureConfiguration(null, null, null);
            window.open();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public DevicePostureConfiguration(SensorModifier parentWindow, DevicePostureConfigurationPayload payload, Sensor sensor) {
        this.parent = parentWindow;
        this._dataStore = DataStore.getInstance();
        this._payload = payload;
        this.getSupportPlmModeIds();
    }

    @Override
    public void setModified() {
        this._modified = true;
    }

    public ArrayList<Integer> getSupportPlmModeIds() {
        ArrayList<Payload> payloads = null;
        ArrayList<LidModeConfigurationPayload.TableEntry> tableEntries = null;
        ArrayList<Integer> supportPlmModeIds = new ArrayList<Integer>();
        if (this._dataStore.getCurrentDevice() == null) {
            return supportPlmModeIds;
        }
        ArrayList<Sensor> sensors = this._dataStore.getCurrentDevice().getSensors();
        for (Sensor sensor : sensors) {
            if (sensor.getLuid().getSensorTypeId() != 768) continue;
            payloads = sensor.getPayloads();
            break;
        }
        if (payloads == null) {
            return supportPlmModeIds;
        }
        for (Payload payload : payloads) {
            if (payload.getClass() != LidModeConfigurationPayload.class) continue;
            tableEntries = ((LidModeConfigurationPayload)payload).getTableEntries();
            break;
        }
        if (tableEntries == null) {
            return supportPlmModeIds;
        }
        for (LidModeConfigurationPayload.TableEntry entry : tableEntries) {
            supportPlmModeIds.add(entry.modeId);
        }
        return supportPlmModeIds;
    }

    public void addConfigurationRow(String[] data, DevicePostureConfigurationPayload.ConditionTable condition) {
        TableItem item = new TableItem(this.configTable, 0);
        item.setText(data);
        item.setData((Object)condition);
        this.refreshButtonsAfterConfNumChange();
    }

    public void addActionLine(String[] data) {
        TableItem item = new TableItem(this.actionTable, 0);
        item.setText(data);
        this.refreshActionButtonsEnablility();
    }

    public void checkNewConfiguration(String[] data) {
        for (int i = 0; i < this.configTable.getItemCount(); ++i) {
            if (this.configTable.getSelectionIndex() == i || !this.configTable.getItem(i).getText(0).equals(data[0])) continue;
            throw new RuntimeException("The configuration table cannot contain two entries with the same device posture ID.");
        }
    }

    public void checkActionValues(int modeId) {
        this.checkActionValues(modeId, -1);
    }

    public void checkActionValues(int modeId, int purposeId) {
        TableItem[] actions = this.actionTable.getItems();
        for (int i = 0; i < actions.length; ++i) {
            if (i == this.actionTable.getSelectionIndex() || !actions[i].getText(0).equals(String.valueOf(modeId))) continue;
            if (purposeId == -1) {
                throw new RuntimeException("An action has already been selected for this Mode ID.");
            }
            if (!actions[i].getText(1).trim().equals("-") && !actions[i].getText(1).equals(String.valueOf(purposeId))) continue;
            throw new RuntimeException("An action has already been selected for this Mode ID and GPIO Purpose ID pair.");
        }
        boolean notFound = true;
        TableItem[] configs = this.configTable.getItems();
        for (int i = 0; i < configs.length; ++i) {
            if (!configs[i].getText(0).equals(String.valueOf(modeId))) continue;
            notFound = false;
            break;
        }
        if (notFound) {
            throw new RuntimeException("The Mode ID does not exist in the configuration table");
        }
        if (purposeId >= 0) {
            notFound = true;
            TableItem[] gpios = this.interruptsTable.getItems();
            for (int i = 0; i < gpios.length; ++i) {
                if (!gpios[i].getText(1).equals(String.valueOf(purposeId))) continue;
                notFound = false;
                break;
            }
            if (notFound) {
                throw new RuntimeException("The purpose ID does not exist in the GPIO table");
            }
        }
    }

    public void refreshButtonsAfterConfNumChange() {
        if (this.configTable.getItemCount() < 1) {
            // empty if block
        }
        if (this.configTable.getItemCount() >= 15) {
            this.btnAddConfig.setEnabled(false);
        } else {
            this.btnAddConfig.setEnabled(true);
        }
    }

    public void refreshActionButtonsEnablility() {
        if (this.actionTable.getItemCount() >= 64) {
            this.btnAddAction.setEnabled(false);
        } else {
            this.btnAddAction.setEnabled(true);
        }
        if (this.actionTable.getSelectionCount() == 0) {
            this.btnEditAction.setEnabled(false);
            this.btnDeleteAction.setEnabled(false);
        } else {
            this.btnEditAction.setEnabled(true);
            this.btnDeleteAction.setEnabled(true);
        }
    }

    public void editConfigurationTableItem() {
        TableItem[] selectedItems = this.configTable.getSelection();
        for (int i = 0; i < selectedItems.length; ++i) {
            for (int j = 0; j < this.actionTable.getItemCount(); ++j) {
                if (!this.actionTable.getItem(j).getText(0).equals(selectedItems[i].getText(0))) continue;
                MessageBox messageBox = new MessageBox(this.shell, 513);
                messageBox.setText("Cannot Edit The Configuration Row");
                messageBox.setMessage("The 'Action Table' contains an entry with the 'mode ID' of the modified entry. Please remove the entry from the action table first.");
                messageBox.open();
                return;
            }
        }
        if (selectedItems.length != 1) {
            return;
        }
        new DevicePostureConfigurationModifier(this._thisInstance, this.getSupportPlmModeIds(), selectedItems[0]).open();
    }

    public void editActionTableItem() {
        TableItem[] selectedItems = this.actionTable.getSelection();
        if (selectedItems.length != 1) {
            return;
        }
        new DevicePostureActionModifier(this._thisInstance, selectedItems[0]).open();
    }

    public void editGPIO() {
        TableItem[] selectedItems = this.interruptsTable.getSelection();
        for (int i = 0; i < selectedItems.length; ++i) {
            for (int j = 0; j < this.actionTable.getItemCount(); ++j) {
                if (!this.actionTable.getItem(j).getText(1).equals(selectedItems[i].getText(1))) continue;
                MessageBox messageBox = new MessageBox(this.shell, 513);
                messageBox.setText("Cannot Edit The GPIO Row");
                messageBox.setMessage("The 'Action Table' contains an entry with the 'purpose' value of the modified entry. Please remove the entry from the action table first.");
                messageBox.open();
                return;
            }
        }
        int selectedLine = this.interruptsTable.getSelectionIndex();
        if (selectedLine == -1) {
            return;
        }
        InteruptsModifier interMod = new InteruptsModifier(this, this._sensor, selectedLine);
        interMod.open();
    }

    public void addGPIO() {
        InteruptsModifier interMod = new InteruptsModifier(this, this._sensor);
        this.interruptsTable.deselectAll();
        interMod.open();
    }

    public void removeGPIO() {
        this.interruptsTable.remove(this.interruptsTable.getSelectionIndices());
        this.btnRemoveGpio.setEnabled(false);
        this.btnEditGpio.setEnabled(false);
        this.refreshAddGpioEnablility();
    }

    public void addGpioLine(String[] data) {
        TableItem item = new TableItem(this.interruptsTable, 0);
        item.setText(data);
        this.refreshAddGpioEnablility();
    }

    @Override
    public HashMap<String, String> getLineValues(int lineIndex) {
        HashMap<String, String> res = new HashMap<String, String>();
        TableItem item = this.interruptsTable.getItem(lineIndex);
        res.put("purpose", item.getText(0));
        res.put("purposeID", item.getText(1));
        res.put("pinNumber", item.getText(2));
        res.put("modeGpio", item.getText(3));
        return res;
    }

    @Override
    public void addGpioToTable(String purposeID, String pinNumber, String modelGpio) {
        this.addGpioLine(new String[]{InteruptsModifier.getPurposeById(this._sensor, Integer.valueOf(purposeID)), String.valueOf(purposeID), String.valueOf(pinNumber), String.valueOf(modelGpio)});
    }

    @Override
    public void updateGpioLine(int lineIndex, HashMap<String, String> values) {
        TableItem item = this.interruptsTable.getItem(lineIndex);
        item.setText(0, InteruptsModifier.getPurposeById(this._sensor, Integer.valueOf(values.get("purposeID"))));
        item.setText(1, values.get("purposeID"));
        item.setText(2, values.get("pinNumber"));
        item.setText(3, values.get("modeGpio"));
    }

    @Override
    public int[] getGpioSelectionIndices() {
        return this.interruptsTable.getSelectionIndices();
    }

    @Override
    public int getGpioCount() {
        return this.interruptsTable.getItemCount();
    }

    @Override
    public Shell getShell() {
        return this.shell;
    }

    public void refreshAddGpioEnablility() {
        if (this.interruptsTable.getItemCount() >= 15) {
            this.btnAddGpio.setEnabled(false);
        } else {
            this.btnAddGpio.setEnabled(true);
        }
    }

    public void saveData() {
        int i;
        boolean newConfiguration = false;
        if (this._payload == null) {
            this._payload = new DevicePostureConfigurationPayload();
            newConfiguration = true;
        }
        ArrayList<DevicePostureConfigurationPayload.ConditionTable> conditionList = new ArrayList<DevicePostureConfigurationPayload.ConditionTable>();
        ArrayList<DevicePostureConfigurationPayload.ActionEntry> actionEntries = new ArrayList<DevicePostureConfigurationPayload.ActionEntry>();
        if (this.configTable.getColumnCount() > 0) {
            DevicePostureConfigurationPayload.ConditionTable condition = new DevicePostureConfigurationPayload.ConditionTable();
            condition.postureId = 0;
            condition.plmModeId = 0;
            condition.sdoStatePrimary = 1;
            condition.sdoStateSecondary = 1;
            condition.tabletMode = 255;
            conditionList.add(condition);
        }
        for (i = 0; i < this.configTable.getItemCount(); ++i) {
            TableItem configTableItem = this.configTable.getItem(i);
            DevicePostureConfigurationPayload.ConditionTable condition = (DevicePostureConfigurationPayload.ConditionTable)configTableItem.getData();
            conditionList.add(condition);
        }
        for (i = 0; i < this.actionTable.getItemCount(); ++i) {
            TableItem actionItem = this.actionTable.getItem(i);
            DevicePostureConfigurationPayload.ActionInfo actionInfo = this.infoStore.getDevicePostureActionByName(actionItem.getText(2));
            if (actionInfo == null) continue;
            DevicePostureConfigurationPayload.ActionEntry actionEntry = new DevicePostureConfigurationPayload.ActionEntry();
            actionEntry.value = actionInfo.value;
            actionEntry.mode = Integer.valueOf(actionItem.getText(0));
            if (actionInfo.needGpio) {
                actionEntry.gpioPurposeId = Integer.valueOf(actionItem.getText(1));
            }
            actionEntries.add(actionEntry);
        }
        this._payload.setConditionList(conditionList);
        this._payload.setActionList(actionEntries);
        if (this.parent != null) {
            this.parent.getGpioInfo().clear();
            for (i = 0; i < this.interruptsTable.getItemCount(); ++i) {
                TableItem gpioItem = this.interruptsTable.getItem(i);
                this.parent.getGpioInfo().addGpioToTable(gpioItem.getText(1), gpioItem.getText(2), gpioItem.getText(3));
            }
        } else {
            GpioPayload gpioPayload = (GpioPayload)this._sensor.getPayloadByClass(GpioPayload.class);
            if (gpioPayload == null) {
                gpioPayload = new GpioPayload(new ArrayList<GpioPayload.Gpio>());
            }
            for (int i2 = 0; i2 < this.interruptsTable.getItemCount(); ++i2) {
                int mode;
                TableItem gpioItem = this.interruptsTable.getItem(i2);
                try {
                    mode = Integer.valueOf(gpioItem.getText(3));
                }
                catch (NumberFormatException e) {
                    mode = this.infoStore.getGpioModeId(gpioItem.getText(3));
                }
                gpioPayload.addGpio(Integer.valueOf(gpioItem.getText(1)), Integer.valueOf(gpioItem.getText(2)), mode);
                this._sensor.addPayload(gpioPayload);
            }
        }
        if (newConfiguration) {
            if (this._sensor != null) {
                this._sensor.addPayload(this._payload);
            }
            if (this.parent != null) {
                this.parent.addNewConfiguration(this._payload);
            }
        }
        this._modified = false;
        if (this.parent != null) {
            this.parent.setModified();
        }
        this.shell.close();
    }

    public String getSdoStateTextByValue(int value) {
        StringBuffer sbSdoState = new StringBuffer();
        if (value == 255) {
            sbSdoState.append("Not Available").append(",");
        } else {
            if ((value & 1) > 0) {
                sbSdoState.append("Not Rotated").append(",");
            }
            if ((value & 2) > 0) {
                sbSdoState.append("Rotated 90").append(",");
            }
            if ((value & 4) > 0) {
                sbSdoState.append("Rotated 180").append(",");
            }
            if ((value & 8) > 0) {
                sbSdoState.append("Rotated 270").append(",");
            }
            if ((value & 0x10) > 0) {
                sbSdoState.append("Face up").append(",");
            }
            if ((value & 0x20) > 0) {
                sbSdoState.append("Face down").append(",");
            }
        }
        if (sbSdoState.length() > 0) {
            return sbSdoState.substring(0, sbSdoState.length() - 1);
        }
        return "";
    }

    public String getTabletModeTextByValue(int value) {
        StringBuffer sbTabletMode = new StringBuffer();
        if (value == 255) {
            sbTabletMode.append("Not Available");
        } else if (value == 1) {
            sbTabletMode.append("Yes");
        } else if (value == 0) {
            sbTabletMode.append("No");
        }
        return sbTabletMode.toString();
    }

    public void fillData() {
        String[] data;
        if (this._payload == null) {
            return;
        }
        this.configTable.removeAll();
        this.interruptsTable.removeAll();
        this.actionTable.removeAll();
        ArrayList<DevicePostureConfigurationPayload.ConditionTable> conditionList = this._payload.getConditionList();
        ArrayList<DevicePostureConfigurationPayload.ActionEntry> actionEntries = this._payload.getActionList();
        for (DevicePostureConfigurationPayload.ConditionTable conditionTable : conditionList) {
            if (conditionTable.postureId == 0) continue;
            StringBuffer sbPlmModeId = new StringBuffer();
            String plmModeId = "";
            if (conditionTable.plmModeId == -1) {
                plmModeId = "Not Available";
            } else {
                for (int i = 1; i < 32; ++i) {
                    if ((1 << i & conditionTable.plmModeId) <= 0) continue;
                    sbPlmModeId.append(i).append(",");
                }
                if (sbPlmModeId.length() > 0) {
                    plmModeId = sbPlmModeId.substring(0, sbPlmModeId.length() - 1);
                }
            }
            data = new String[]{String.valueOf(conditionTable.postureId), String.valueOf(plmModeId), this.getSdoStateTextByValue(conditionTable.sdoStatePrimary), this.getSdoStateTextByValue(conditionTable.sdoStateSecondary), this.getTabletModeTextByValue(conditionTable.tabletMode)};
            this.addConfigurationRow(data, conditionTable);
        }
        if (this.parent != null) {
            TableItem[] gpioLines;
            for (TableItem gpioEntry : gpioLines = this.parent.getGpioInfo().getAllGpioLines()) {
                String[] data2 = new String[]{String.valueOf(gpioEntry.getText(0)), String.valueOf(gpioEntry.getText(1)), String.valueOf(gpioEntry.getText(2)), gpioEntry.getText(3)};
                this.addGpioLine(data2);
            }
        }
        for (DevicePostureConfigurationPayload.ActionEntry actionEntry : actionEntries) {
            DevicePostureConfigurationPayload.ActionInfo actionInfo = this.infoStore.getDevicePostureActionById(actionEntry.value);
            if (actionInfo == null) continue;
            String gpioPurposeId = actionInfo.needGpio ? String.valueOf(actionEntry.gpioPurposeId) : "-";
            data = new String[]{String.valueOf(actionEntry.mode), gpioPurposeId, actionInfo.name};
            this.addActionLine(data);
        }
        this._modified = false;
    }

    public void open() {
        this.display = Display.getDefault();
        this.createContents();
        try {
            this.infoStore = InformationStore.getInstance();
        }
        catch (Exception e) {
            MessageBox messageBox = new MessageBox(this.shell, 513);
            messageBox.setText("Cannot load file");
            messageBox.setMessage("Cannot load the sensor definitions file - the file is missing or damaged. Aborting.");
            messageBox.open();
            return;
        }
        this.fillData();
        this.shell.open();
        this.shell.layout();
        while (!this.shell.isDisposed()) {
            if (this.display.readAndDispatch()) continue;
            this.display.sleep();
        }
    }

    protected void createContents() {
        this.shell = new Shell(65760);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent arg0) {
                if (DevicePostureConfiguration.this._modified) {
                    MessageBox messageBox = new MessageBox(DevicePostureConfiguration.this.shell, 296);
                    messageBox.setText("Closing The Configuration Window");
                    messageBox.setMessage("Some changes will be lost. Are you sure that you want to continue?");
                    if (messageBox.open() != 32) {
                        arg0.doit = false;
                        return;
                    }
                }
            }
        });
        this.shell.setImage(SWTResourceManager.getImage(LidModeConfiguration.class, "/resources/Intel.ico"));
        this.shell.setText("Device Posture Configuration");
        GridLayout shlLidModegridLayout = new GridLayout(2, true);
        shlLidModegridLayout.marginWidth = 10;
        shlLidModegridLayout.marginHeight = 10;
        shlLidModegridLayout.horizontalSpacing = 10;
        shlLidModegridLayout.verticalSpacing = 10;
        this.shell.setLayout((Layout)shlLidModegridLayout);
        Group grpTable = new Group((Composite)this.shell, 0);
        grpTable.setText("Device Posture Configuration Table");
        grpTable.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        GridLayout gridLayoutgrpTable = new GridLayout(3, false);
        gridLayoutgrpTable.marginWidth = 10;
        gridLayoutgrpTable.marginHeight = 10;
        gridLayoutgrpTable.horizontalSpacing = 10;
        gridLayoutgrpTable.verticalSpacing = 10;
        grpTable.setLayout((Layout)gridLayoutgrpTable);
        TableViewer tableViewer = new TableViewer((Composite)grpTable, 67586);
        this.configTable = tableViewer.getTable();
        this.configTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                int itemsSelected = DevicePostureConfiguration.this.configTable.getSelectionCount();
                if (itemsSelected == 1) {
                    DevicePostureConfiguration.this.btnEditConfig.setEnabled(true);
                    DevicePostureConfiguration.this.btnDeleteConfig.setEnabled(true);
                } else {
                    DevicePostureConfiguration.this.btnEditConfig.setEnabled(false);
                    if (itemsSelected > 1) {
                        DevicePostureConfiguration.this.btnDeleteConfig.setEnabled(true);
                    } else {
                        DevicePostureConfiguration.this.btnDeleteConfig.setEnabled(false);
                    }
                }
            }
        });
        this.configTable.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent arg0) {
                DevicePostureConfiguration.this.editConfigurationTableItem();
            }
        });
        this.configTable.setLayoutData((Object)new GridData(4, 4, true, true, 3, 1));
        this.configTable.setHeaderVisible(true);
        this.configTable.setLinesVisible(true);
        ControlAdapter resizeColHandler = new ControlAdapter(){

            public void controlResized(ControlEvent arg0) {
                if (((TableColumn)arg0.getSource()).getWidth() < 50) {
                    ((TableColumn)arg0.getSource()).setWidth(50);
                }
            }
        };
        TableViewerColumn tvcModeId = new TableViewerColumn(tableViewer, 0);
        final TableColumn tblclmnModeId = tvcModeId.getColumn();
        tblclmnModeId.addControlListener((ControlListener)resizeColHandler);
        tblclmnModeId.setText("Mode ID");
        TableViewerColumn tvcPlmModeId = new TableViewerColumn(tableViewer, 0);
        final TableColumn tblclmnPlmModeId = tvcPlmModeId.getColumn();
        tblclmnPlmModeId.addControlListener((ControlListener)resizeColHandler);
        tblclmnPlmModeId.setText("PLM Mode ID");
        TableViewerColumn tableViewerColumn_6 = new TableViewerColumn(tableViewer, 0);
        final TableColumn tblclmnPrimarySdo = tableViewerColumn_6.getColumn();
        tblclmnPrimarySdo.addControlListener((ControlListener)resizeColHandler);
        tblclmnPrimarySdo.setText("Primary SDO");
        TableViewerColumn tableViewerColumn_5 = new TableViewerColumn(tableViewer, 0);
        final TableColumn tblclmnSecondarySdo = tableViewerColumn_5.getColumn();
        tblclmnSecondarySdo.addControlListener((ControlListener)resizeColHandler);
        tblclmnSecondarySdo.setText("Secondary SDO");
        TableViewerColumn tableViewerColumn_4 = new TableViewerColumn(tableViewer, 0);
        final TableColumn tblclmnTabletMode = tableViewerColumn_4.getColumn();
        tblclmnTabletMode.addControlListener((ControlListener)resizeColHandler);
        tblclmnTabletMode.setText("Tablet Mode");
        this.configTable.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                int oneWidth = ((DevicePostureConfiguration)DevicePostureConfiguration.this).configTable.getClientArea().width / 7;
                tblclmnModeId.setWidth(oneWidth);
                tblclmnPlmModeId.setWidth(oneWidth);
                tblclmnPrimarySdo.setWidth(oneWidth * 2);
                tblclmnSecondarySdo.setWidth(oneWidth * 2);
                tblclmnTabletMode.setWidth(oneWidth);
            }
        });
        this.btnAddConfig = new Button((Composite)grpTable, 0);
        GridData gd_btnAddEntry = new GridData(131072, 4, true, false, 1, 1);
        gd_btnAddEntry.widthHint = GuiUtils.getButtonWidth((Control)grpTable);
        this.btnAddConfig.setText("Add");
        this.btnAddConfig.setLayoutData((Object)gd_btnAddEntry);
        this.btnAddConfig.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                DevicePostureConfiguration.this.configTable.setSelection(new int[0]);
                new DevicePostureConfigurationModifier(DevicePostureConfiguration.this._thisInstance, DevicePostureConfiguration.this.getSupportPlmModeIds(), null).open();
            }
        });
        this.btnEditConfig = new Button((Composite)grpTable, 0);
        GridData gd_btnEditEntry = new GridData(131072, 0x1000000, false, false, 1, 1);
        gd_btnEditEntry.widthHint = GuiUtils.getButtonWidth((Control)grpTable);
        this.btnEditConfig.setLayoutData((Object)gd_btnEditEntry);
        this.btnEditConfig.setEnabled(false);
        this.btnEditConfig.setText("Edit");
        this.btnEditConfig.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                DevicePostureConfiguration.this.editConfigurationTableItem();
            }
        });
        this.btnDeleteConfig = new Button((Composite)grpTable, 0);
        this.btnDeleteConfig.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        GridData gd_btnDeleteEntry = new GridData(4, 0x1000000, false, false, 1, 1);
        gd_btnDeleteEntry.widthHint = GuiUtils.getButtonWidth((Control)grpTable);
        this.btnDeleteConfig.setText("Delete");
        this.btnDeleteConfig.setLayoutData((Object)gd_btnDeleteEntry);
        this.btnDeleteConfig.setEnabled(false);
        this.btnDeleteConfig.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                int[] selectedIndices = DevicePostureConfiguration.this.configTable.getSelectionIndices();
                TableItem[] selectedItems = DevicePostureConfiguration.this.configTable.getSelection();
                for (int i = 0; i < selectedItems.length; ++i) {
                    for (int j = 0; j < DevicePostureConfiguration.this.actionTable.getItemCount(); ++j) {
                        if (!DevicePostureConfiguration.this.actionTable.getItem(j).getText(0).equals(selectedItems[i].getText(0))) continue;
                        MessageBox messageBox = new MessageBox(DevicePostureConfiguration.this.shell, 513);
                        messageBox.setText("Cannot Delete The Configuration Row");
                        messageBox.setMessage("The 'Action Table' contains an entry with the 'mode ID' of one of the deleted entries. Please remove the entry from the action table first.");
                        messageBox.open();
                        return;
                    }
                }
                if (selectedIndices.length > 0) {
                    DevicePostureConfiguration.this.configTable.remove(selectedIndices);
                }
                DevicePostureConfiguration.this.btnEditConfig.setEnabled(false);
                DevicePostureConfiguration.this.btnDeleteConfig.setEnabled(false);
                DevicePostureConfiguration.this.refreshButtonsAfterConfNumChange();
                DevicePostureConfiguration.this.setModified();
            }
        });
        Group grpInterrupts = new Group((Composite)this.shell, 0);
        grpInterrupts.setLayout((Layout)new GridLayout(3, false));
        grpInterrupts.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        grpInterrupts.setText("GPIO");
        TableViewer tableViewer_2 = new TableViewer((Composite)grpInterrupts, 67586);
        this.interruptsTable = tableViewer_2.getTable();
        this.interruptsTable.setLayoutData((Object)new GridData(4, 4, true, true, 3, 1));
        this.interruptsTable.setLinesVisible(true);
        this.interruptsTable.setHeaderVisible(true);
        this.interruptsTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (DevicePostureConfiguration.this.interruptsTable.getSelectionCount() > 0) {
                    DevicePostureConfiguration.this.btnRemoveGpio.setEnabled(true);
                    if (DevicePostureConfiguration.this.interruptsTable.getSelectionCount() == 1) {
                        DevicePostureConfiguration.this.btnEditGpio.setEnabled(true);
                    } else {
                        DevicePostureConfiguration.this.btnEditGpio.setEnabled(false);
                    }
                }
            }
        });
        this.interruptsTable.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                DevicePostureConfiguration.this.editGPIO();
            }
        });
        final TableColumn tblclmnPurposeName = new TableColumn(this.interruptsTable, 0);
        tblclmnPurposeName.addControlListener((ControlListener)resizeColHandler);
        tblclmnPurposeName.setText("Purpose");
        final TableColumn tblclmnPurposeId = new TableColumn(this.interruptsTable, 0);
        tblclmnPurposeId.addControlListener((ControlListener)resizeColHandler);
        tblclmnPurposeId.setText("Purpose ID");
        final TableColumn tblclmnGPIOID = new TableColumn(this.interruptsTable, 0);
        tblclmnGPIOID.addControlListener((ControlListener)resizeColHandler);
        tblclmnGPIOID.setText("ISS GPIO ID");
        final TableColumn tblclmnMode = new TableColumn(this.interruptsTable, 0);
        tblclmnMode.addControlListener((ControlListener)resizeColHandler);
        tblclmnMode.setText("Mode");
        this.interruptsTable.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                int oneWidth = ((DevicePostureConfiguration)DevicePostureConfiguration.this).interruptsTable.getClientArea().width / 4;
                tblclmnPurposeName.setWidth(oneWidth);
                tblclmnPurposeId.setWidth(oneWidth);
                tblclmnGPIOID.setWidth(oneWidth);
                tblclmnMode.setWidth(oneWidth);
            }
        });
        this.btnAddGpio = new Button((Composite)grpInterrupts, 0);
        GridData gd_btnAddGpio = new GridData(131072, 4, false, false, 1, 1);
        gd_btnAddGpio.widthHint = GuiUtils.getButtonWidth((Control)grpInterrupts);
        this.btnAddGpio.setText("Add");
        this.btnAddGpio.setLayoutData((Object)gd_btnAddGpio);
        this.btnAddGpio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DevicePostureConfiguration.this.addGPIO();
            }
        });
        this.btnEditGpio = new Button((Composite)grpInterrupts, 0);
        GridData gd_btnEditGpio = new GridData(131072, 4, false, false, 1, 1);
        gd_btnEditGpio.widthHint = GuiUtils.getButtonWidth((Control)grpInterrupts);
        this.btnEditGpio.setText("Edit");
        this.btnEditGpio.setEnabled(false);
        this.btnEditGpio.setLayoutData((Object)gd_btnEditGpio);
        this.btnEditGpio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DevicePostureConfiguration.this.editGPIO();
            }
        });
        this.btnRemoveGpio = new Button((Composite)grpInterrupts, 0);
        GridData gd_btnRemoveGpio = new GridData(4, 4, false, false, 1, 1);
        gd_btnRemoveGpio.widthHint = GuiUtils.getButtonWidth((Control)grpInterrupts);
        this.btnRemoveGpio.setText("Delete");
        this.btnRemoveGpio.setEnabled(false);
        this.btnRemoveGpio.setLayoutData((Object)gd_btnRemoveGpio);
        this.btnRemoveGpio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem[] selectedItems = DevicePostureConfiguration.this.interruptsTable.getSelection();
                for (int i = 0; i < selectedItems.length; ++i) {
                    for (int j = 0; j < DevicePostureConfiguration.this.actionTable.getItemCount(); ++j) {
                        if (!DevicePostureConfiguration.this.actionTable.getItem(j).getText(1).equals(selectedItems[i].getText(1))) continue;
                        MessageBox messageBox = new MessageBox(DevicePostureConfiguration.this.shell, 513);
                        messageBox.setText("Cannot Delete The GPIO Row");
                        messageBox.setMessage("The 'Action Table' contains an entry with the 'purpose' of one of the deleted entries. Please remove the entry from the action table first.");
                        messageBox.open();
                        return;
                    }
                }
                DevicePostureConfiguration.this.removeGPIO();
            }
        });
        Group grpActions = new Group((Composite)this.shell, 0);
        grpActions.setText("Action Table");
        grpActions.setLayout((Layout)new GridLayout(3, false));
        grpActions.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        TableViewer tableViewer_1 = new TableViewer((Composite)grpActions, 67586);
        this.actionTable = tableViewer_1.getTable();
        this.actionTable.setLayoutData((Object)new GridData(4, 4, true, true, 3, 1));
        this.actionTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                int itemsSelected = DevicePostureConfiguration.this.actionTable.getSelectionCount();
                if (itemsSelected == 1) {
                    DevicePostureConfiguration.this.btnEditAction.setEnabled(true);
                    DevicePostureConfiguration.this.btnDeleteAction.setEnabled(true);
                } else {
                    DevicePostureConfiguration.this.btnEditAction.setEnabled(false);
                    if (itemsSelected > 1) {
                        DevicePostureConfiguration.this.btnDeleteAction.setEnabled(true);
                    } else {
                        DevicePostureConfiguration.this.btnDeleteAction.setEnabled(false);
                    }
                }
            }
        });
        this.actionTable.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent arg0) {
                DevicePostureConfiguration.this.editActionTableItem();
            }
        });
        this.actionTable.setLinesVisible(true);
        this.actionTable.setHeaderVisible(true);
        final TableColumn tblclmnModeId_1 = new TableColumn(this.actionTable, 0);
        tblclmnModeId_1.addControlListener((ControlListener)resizeColHandler);
        tblclmnModeId_1.setText("Mode ID");
        final TableColumn tblclmnGpioPurposeId = new TableColumn(this.actionTable, 0);
        tblclmnGpioPurposeId.addControlListener((ControlListener)resizeColHandler);
        tblclmnGpioPurposeId.setText("GPIO Purpose ID");
        TableViewerColumn tableViewerColumn_7 = new TableViewerColumn(tableViewer_1, 0);
        final TableColumn tblclmnGPIOValue = tableViewerColumn_7.getColumn();
        tblclmnGPIOValue.addControlListener((ControlListener)resizeColHandler);
        tblclmnGPIOValue.setText("Action");
        this.actionTable.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                int oneWidth = ((DevicePostureConfiguration)DevicePostureConfiguration.this).actionTable.getClientArea().width / 3;
                tblclmnModeId_1.setWidth(oneWidth);
                tblclmnGpioPurposeId.setWidth(oneWidth);
                tblclmnGPIOValue.setWidth(oneWidth);
            }
        });
        this.btnAddAction = new Button((Composite)grpActions, 0);
        GridData gd_btnAddAction = new GridData(131072, 4, true, false, 1, 1);
        gd_btnAddAction.widthHint = GuiUtils.getButtonWidth((Control)grpActions);
        this.btnAddAction.setLayoutData((Object)gd_btnAddAction);
        this.btnAddAction.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                DevicePostureConfiguration.this.actionTable.deselectAll();
                new DevicePostureActionModifier(DevicePostureConfiguration.this._thisInstance, null).open();
            }
        });
        this.btnAddAction.setText("Add");
        this.btnEditAction = new Button((Composite)grpActions, 0);
        GridData gd_btnEditAction = new GridData(4, 4, false, false, 1, 1);
        gd_btnEditAction.widthHint = GuiUtils.getButtonWidth((Control)grpActions);
        this.btnEditAction.setLayoutData((Object)gd_btnEditAction);
        this.btnEditAction.setEnabled(false);
        this.btnEditAction.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                DevicePostureConfiguration.this.editActionTableItem();
            }
        });
        this.btnEditAction.setText("Edit");
        this.btnDeleteAction = new Button((Composite)grpActions, 0);
        GridData gd_btnDeleteAction = new GridData(4, 4, false, false, 1, 1);
        gd_btnDeleteAction.widthHint = GuiUtils.getButtonWidth((Control)grpActions);
        this.btnDeleteAction.setLayoutData((Object)gd_btnDeleteAction);
        this.btnDeleteAction.setEnabled(false);
        this.btnDeleteAction.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                int[] selectedIndices = DevicePostureConfiguration.this.actionTable.getSelectionIndices();
                if (selectedIndices.length > 0) {
                    DevicePostureConfiguration.this.actionTable.remove(selectedIndices);
                }
                DevicePostureConfiguration.this.refreshActionButtonsEnablility();
                DevicePostureConfiguration.this.setModified();
            }
        });
        this.btnDeleteAction.setText("Delete");
        Composite ButtonComposite = new Composite((Composite)this.shell, 0);
        ButtonComposite.setLayoutData((Object)new GridData(4, 4, true, false, 3, 1));
        GridLayout gridLayoutButtonComposite = new GridLayout(2, false);
        ButtonComposite.setLayout((Layout)gridLayoutButtonComposite);
        Button btnSaveAndClose = new Button(ButtonComposite, 0);
        GridData gd_btnSaveAndClose = new GridData(131072, 4, true, false, 1, 1);
        gd_btnSaveAndClose.widthHint = GuiUtils.getButtonWidth((Control)ButtonComposite);
        btnSaveAndClose.setLayoutData((Object)gd_btnSaveAndClose);
        btnSaveAndClose.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                DevicePostureConfiguration.this.saveData();
            }
        });
        btnSaveAndClose.setText("Save and Close");
        Button btnCancel = new Button(ButtonComposite, 0);
        GridData gd_btnCancel = new GridData(131072, 0x1000000, false, false, 1, 1);
        gd_btnCancel.widthHint = GuiUtils.getButtonWidth((Control)ButtonComposite);
        btnCancel.setLayoutData((Object)gd_btnCancel);
        btnCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                DevicePostureConfiguration.this.shell.close();
            }
        });
        btnCancel.setText("Cancel");
        ((GridData)this.configTable.getLayoutData()).heightHint = GuiUtils.getPixelSizeHeight((Control)this.configTable) * 10;
        ((GridData)this.interruptsTable.getLayoutData()).heightHint = GuiUtils.getPixelSizeHeight((Control)this.interruptsTable) * 10;
        ((GridData)this.actionTable.getLayoutData()).heightHint = GuiUtils.getPixelSizeHeight((Control)this.actionTable) * 10;
        this.shell.setSize(this.shell.computeSize(-1, -1));
        this.shell.setLocation(GuiUtils.getMiddleLocation(this.shell, this.display));
    }
}

