/*
 * Decompiled with CFR 0.152.
 */
package pdtEditor.gui.configuration;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wb.swt.SWTResourceManager;
import pdtEditor.DataStore;
import pdtEditor.InformationStore;
import pdtEditor.Sensor;
import pdtEditor.gui.GuiUtils;
import pdtEditor.gui.InterruptsModifierOpener;
import pdtEditor.gui.SensorModifier;
import pdtEditor.payloads.Payload;
import pdtEditor.payloads.configurations.DynamicKeyboardLightingPayload;
import pdtEditor.payloads.configurations.LidModeConfigurationPayload;
import resources.CustomSpinner;

public class DynamicKeyboardLightingConfiguration
implements InterruptsModifierOpener {
    private Sensor _sensor = null;
    protected Shell shell;
    private Display display;
    private SensorModifier parent;
    private boolean _modified = false;
    private InformationStore infoStore = null;
    private DataStore _dataStore;
    private DynamicKeyboardLightingPayload _payload;
    private ArrayList<Integer> modeIdList = new ArrayList();
    private Button chkDisableAlwaysOn;
    private Button chkPlmModeIdGroup;
    private Group grpPlmModeId;
    private CustomSpinner cspnDklFalling1;
    private CustomSpinner cspnDklRising1;
    private CustomSpinner cspnDklDelay1;
    private CustomSpinner cspnDklFalling2;
    private CustomSpinner cspnDklRising2;
    private CustomSpinner cspnDklDelay2;
    private CustomSpinner cspnDklFalling3;
    private CustomSpinner cspnDklRising3;
    private CustomSpinner cspnDklDelay3;
    private static final int DEFAULT_PLM_ROW_CONTROL_COUNT = 8;
    private static final int DEFAULT_PLM_ROW_COUNT = 1;

    public static void main(String[] args) {
        try {
            DynamicKeyboardLightingConfiguration window = new DynamicKeyboardLightingConfiguration(null, null, null);
            window.open();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public DynamicKeyboardLightingConfiguration(SensorModifier parentWindow, DynamicKeyboardLightingPayload payload, Sensor sensor) {
        this.parent = parentWindow;
        this._dataStore = DataStore.getInstance();
        this._payload = payload;
        this.modeIdList = this.getSupportPlmModeIds();
    }

    public void open() {
        this.display = Display.getDefault();
        this.createContents();
        try {
            this.infoStore = InformationStore.getInstance();
        }
        catch (Exception e) {
            MessageBox messageBox = new MessageBox(this.shell, 513);
            messageBox.setText("Cannot load file");
            messageBox.setMessage("Cannot load the sensor definitions file - the file is missing or damaged. Aborting.");
            messageBox.open();
            return;
        }
        this.fillData();
        this.shell.open();
        this.shell.layout();
        while (!this.shell.isDisposed()) {
            if (this.display.readAndDispatch()) continue;
            this.display.sleep();
        }
    }

    public void fillData() {
        if (this._payload == null) {
            return;
        }
        if (this._payload.getDisableAlwaysOn() == 1) {
            this.chkDisableAlwaysOn.setSelection(true);
        } else {
            this.chkDisableAlwaysOn.setSelection(false);
        }
        if (this._payload.plmModeId == -1) {
            this.chkPlmModeIdGroup.setSelection(false);
            this.chkPlmModeIdGroup.notifyListeners(13, new Event());
        } else {
            this.chkPlmModeIdGroup.setSelection(true);
            this.setChildrenCheckboxBySelectedData((Composite)this.grpPlmModeId, this._payload.getPlmModeId());
        }
        this.cspnDklFalling1.setSelection(this._payload.getFallingThreshold1());
        this.cspnDklRising1.setSelection(this._payload.getRisingThreshold1());
        this.cspnDklDelay1.setSelection(this._payload.getDelay1());
        this.cspnDklFalling2.setSelection(this._payload.getFallingThreshold2());
        this.cspnDklRising2.setSelection(this._payload.getRisingThreshold2());
        this.cspnDklDelay2.setSelection(this._payload.getDelay2());
        this.cspnDklFalling3.setSelection(this._payload.getFallingThreshold3());
        this.cspnDklRising3.setSelection(this._payload.getRisingThreshold3());
        this.cspnDklDelay3.setSelection(this._payload.getDelay3());
        this._modified = false;
    }

    public void setChildrenCheckboxBySelectedData(Composite parentControl, int data) {
        Control[] child = parentControl.getChildren();
        boolean ret = false;
        for (Control control : child) {
            if (control.getClass() != Button.class || (control.getStyle() & 0x20) <= 0) continue;
            int bitValue = (Integer)control.getData();
            if ((bitValue & data) > 0) {
                ((Button)control).setSelection(true);
                continue;
            }
            ((Button)control).setSelection(false);
        }
    }

    protected void createContents() {
        int longSpinnerMinWidth;
        this.shell = new Shell(65760);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent arg0) {
                if (DynamicKeyboardLightingConfiguration.this._modified) {
                    MessageBox messageBox = new MessageBox(DynamicKeyboardLightingConfiguration.this.shell, 296);
                    messageBox.setText("Closing The Configuration Window");
                    messageBox.setMessage("Some changes will be lost. Are you sure that you want to continue?");
                    if (messageBox.open() != 32) {
                        arg0.doit = false;
                        return;
                    }
                }
            }
        });
        this.shell.setImage(SWTResourceManager.getImage(DynamicKeyboardLightingConfiguration.class, "/resources/Intel.ico"));
        this.shell.setText("Dynamic Keyboard Lighting Configuration");
        this.shell.setLayout((Layout)new GridLayout(1, false));
        Group grpAlwaysOn = GuiUtils.addGroupToComposite("", (Composite)this.shell, 4, 4, 0x1000000, false, false, 1, 1, 1);
        this.chkDisableAlwaysOn = GuiUtils.addButtonToComposite("Disable Always On", "", (Composite)grpAlwaysOn, 32, 4, 0x1000000, false, false, 1, 1);
        Composite cmpPlmModelId = new Composite((Composite)this.shell, 4);
        FormLayout cmpPlmModeIdLayout = new FormLayout();
        cmpPlmModeIdLayout.marginWidth = 2;
        cmpPlmModeIdLayout.marginHeight = 5;
        cmpPlmModelId.setLayout((Layout)cmpPlmModeIdLayout);
        cmpPlmModelId.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.chkPlmModeIdGroup = new Button(cmpPlmModelId, 32);
        this.chkPlmModeIdGroup.setText("PLM Mode ID");
        FormData formData = new FormData();
        this.chkPlmModeIdGroup.setLayoutData((Object)formData);
        formData.left = new FormAttachment();
        formData.left.offset = 8;
        this.grpPlmModeId = new Group(cmpPlmModelId, 4);
        FormData grpPlmModeIdGroupData = new FormData();
        GridLayout plmModeIdGroupLayout = new GridLayout(8, true);
        plmModeIdGroupLayout.verticalSpacing = 15;
        plmModeIdGroupLayout.horizontalSpacing = 15;
        this.grpPlmModeId.setLayout((Layout)plmModeIdGroupLayout);
        if (this.modeIdList == null || this.modeIdList.size() == 0) {
            this.chkPlmModeIdGroup.setSelection(false);
            this.chkPlmModeIdGroup.setEnabled(false);
            Button tempButton = new Button(cmpPlmModelId, 32);
            tempButton.setText("1");
            tempButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
            grpPlmModeIdGroupData.width = 8 * tempButton.computeSize((int)-1, (int)-1).x + plmModeIdGroupLayout.horizontalSpacing * 8 + 2 * plmModeIdGroupLayout.marginWidth;
            grpPlmModeIdGroupData.height = 1 * tempButton.computeSize((int)-1, (int)-1).y + plmModeIdGroupLayout.verticalSpacing * 1 + 2 * plmModeIdGroupLayout.marginHeight;
            tempButton.dispose();
        } else {
            if (this.modeIdList.size() < 8) {
                Button tempButton = new Button(cmpPlmModelId, 32);
                tempButton.setText("1");
                tempButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
                grpPlmModeIdGroupData.width = 8 * tempButton.computeSize((int)-1, (int)-1).x + plmModeIdGroupLayout.horizontalSpacing * 8 + 2 * plmModeIdGroupLayout.marginWidth;
                tempButton.dispose();
            }
            this.chkPlmModeIdGroup.setSelection(true);
            for (int i = 0; i < this.modeIdList.size(); ++i) {
                Button addBtn = new Button((Composite)this.grpPlmModeId, 32);
                addBtn.setText(this.modeIdList.get(i).toString());
                addBtn.setData((Object)(1 << this.modeIdList.get(i)));
                addBtn.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
            }
        }
        this.grpPlmModeId.setLayoutData((Object)grpPlmModeIdGroupData);
        this.chkPlmModeIdGroup.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!DynamicKeyboardLightingConfiguration.this.chkPlmModeIdGroup.getSelection()) {
                    DynamicKeyboardLightingConfiguration.this.setSubCheckboxSelection((Composite)DynamicKeyboardLightingConfiguration.this.grpPlmModeId, false);
                    DynamicKeyboardLightingConfiguration.this.setChildrenEnable((Composite)DynamicKeyboardLightingConfiguration.this.grpPlmModeId, false);
                } else {
                    DynamicKeyboardLightingConfiguration.this.setChildrenEnable((Composite)DynamicKeyboardLightingConfiguration.this.grpPlmModeId, true);
                }
            }
        });
        Group grpDklThreshold1 = GuiUtils.addGroupToComposite("Dynamic Keyboard Lighting Threshold 0", (Composite)this.shell, 4, 4, 0x1000000, false, false, 1, 1, 3);
        Label lblDklFalling1 = GuiUtils.addLabelToComposite("Falling Threshold", (Composite)grpDklThreshold1, 4, 16384, 0x1000000, true, false, 1, 1);
        this.cspnDklFalling1 = GuiUtils.addCustomSpinnerToComposite(Integer.MAX_VALUE, this.shell, (Composite)grpDklThreshold1, 2048, 131072, 0x1000000, true, false, 1, 1);
        GuiUtils.addLabelToComposite("lux", (Composite)grpDklThreshold1, 4, 16384, 0x1000000, true, false, 1, 1);
        Label lblDklRising1 = GuiUtils.addLabelToComposite("Rising Threshold", (Composite)grpDklThreshold1, 4, 16384, 0x1000000, true, false, 1, 1);
        this.cspnDklRising1 = GuiUtils.addCustomSpinnerToComposite(65535, this.shell, (Composite)grpDklThreshold1, 2048, 131072, 0x1000000, true, false, 1, 1);
        GuiUtils.addLabelToComposite("lux", (Composite)grpDklThreshold1, 4, 16384, 0x1000000, true, false, 1, 1);
        Label lblDklDelay1 = GuiUtils.addLabelToComposite("Delay", (Composite)grpDklThreshold1, 4, 16384, 0x1000000, true, false, 1, 1);
        this.cspnDklDelay1 = GuiUtils.addCustomSpinnerToComposite(65535, this.shell, (Composite)grpDklThreshold1, 2048, 131072, 0x1000000, true, false, 1, 1);
        GuiUtils.addLabelToComposite("ms", (Composite)grpDklThreshold1, 4, 16384, 0x1000000, true, false, 1, 1);
        Group grpDklThreshold2 = GuiUtils.addGroupToComposite("Dynamic Keyboard Lighting Threshold 1", (Composite)this.shell, 4, 4, 0x1000000, false, false, 1, 1, 3);
        Label lblDklFalling2 = GuiUtils.addLabelToComposite("Falling Threshold", (Composite)grpDklThreshold2, 4, 16384, 0x1000000, true, false, 1, 1);
        this.cspnDklFalling2 = GuiUtils.addCustomSpinnerToComposite(Integer.MAX_VALUE, this.shell, (Composite)grpDklThreshold2, 2048, 131072, 0x1000000, true, false, 1, 1);
        GuiUtils.addLabelToComposite("lux", (Composite)grpDklThreshold2, 4, 16384, 0x1000000, true, false, 1, 1);
        Label lblDklRising2 = GuiUtils.addLabelToComposite("Rising Threshold", (Composite)grpDklThreshold2, 4, 16384, 0x1000000, true, false, 1, 1);
        this.cspnDklRising2 = GuiUtils.addCustomSpinnerToComposite(65535, this.shell, (Composite)grpDklThreshold2, 2048, 131072, 0x1000000, true, false, 1, 1);
        GuiUtils.addLabelToComposite("lux", (Composite)grpDklThreshold2, 4, 16384, 0x1000000, true, false, 1, 1);
        Label lblDklDelay2 = GuiUtils.addLabelToComposite("Delay", (Composite)grpDklThreshold2, 4, 16384, 0x1000000, true, false, 1, 1);
        this.cspnDklDelay2 = GuiUtils.addCustomSpinnerToComposite(65535, this.shell, (Composite)grpDklThreshold2, 2048, 131072, 0x1000000, true, false, 1, 1);
        GuiUtils.addLabelToComposite("ms", (Composite)grpDklThreshold2, 4, 16384, 0x1000000, true, false, 1, 1);
        Group grpDklThreshold3 = GuiUtils.addGroupToComposite("Dynamic Keyboard Lighting Threshold 2", (Composite)this.shell, 4, 4, 0x1000000, false, false, 1, 1, 3);
        Label lblDklFalling3 = GuiUtils.addLabelToComposite("Falling Threshold", (Composite)grpDklThreshold3, 4, 16384, 0x1000000, true, false, 1, 1);
        this.cspnDklFalling3 = GuiUtils.addCustomSpinnerToComposite(Integer.MAX_VALUE, this.shell, (Composite)grpDklThreshold3, 2048, 131072, 0x1000000, true, false, 1, 1);
        GuiUtils.addLabelToComposite("lux", (Composite)grpDklThreshold3, 4, 16384, 0x1000000, true, false, 1, 1);
        Label lblDklRising3 = GuiUtils.addLabelToComposite("Rising Threshold", (Composite)grpDklThreshold3, 4, 16384, 0x1000000, true, false, 1, 1);
        this.cspnDklRising3 = GuiUtils.addCustomSpinnerToComposite(65535, this.shell, (Composite)grpDklThreshold3, 2048, 131072, 0x1000000, true, false, 1, 1);
        GuiUtils.addLabelToComposite("lux", (Composite)grpDklThreshold3, 4, 16384, 0x1000000, true, false, 1, 1);
        Label lblDklDelay3 = GuiUtils.addLabelToComposite("Delay", (Composite)grpDklThreshold3, 4, 16384, 0x1000000, true, false, 1, 1);
        this.cspnDklDelay3 = GuiUtils.addCustomSpinnerToComposite(65535, this.shell, (Composite)grpDklThreshold3, 2048, 131072, 0x1000000, true, false, 1, 1);
        GuiUtils.addLabelToComposite("ms", (Composite)grpDklThreshold3, 4, 16384, 0x1000000, true, false, 1, 1);
        this.cspnDklFalling1.setToolTipText("ambient light falling threshold in lux");
        this.cspnDklFalling2.setToolTipText("ambient light falling threshold in lux");
        this.cspnDklFalling3.setToolTipText("ambient light falling threshold in lux");
        this.cspnDklRising1.setToolTipText("ambient light rising threshold in lux");
        this.cspnDklRising2.setToolTipText("ambient light rising threshold in lux");
        this.cspnDklRising3.setToolTipText("ambient light rising threshold in lux");
        this.cspnDklDelay1.setToolTipText("delay time in ms");
        this.cspnDklDelay2.setToolTipText("delay time in ms");
        this.cspnDklDelay3.setToolTipText("delay time in ms");
        this.cspnDklFalling1.setSelection(40);
        this.cspnDklFalling2.setSelection(40);
        this.cspnDklFalling3.setSelection(40);
        this.cspnDklRising1.setSelection(60);
        this.cspnDklRising2.setSelection(60);
        this.cspnDklRising3.setSelection(60);
        this.cspnDklDelay1.setSelection(200);
        this.cspnDklDelay2.setSelection(200);
        this.cspnDklDelay3.setSelection(200);
        Composite cmpsOkCancel = new Composite((Composite)this.shell, 0);
        cmpsOkCancel.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.horizontalSpacing = 10;
        gridLayout.verticalSpacing = 10;
        cmpsOkCancel.setLayout((Layout)gridLayout);
        Button btnOk = new Button(cmpsOkCancel, 0);
        GridData gd_btnOk = new GridData(131072, 0x1000000, true, false, 1, 1);
        btnOk.setLayoutData((Object)gd_btnOk);
        gd_btnOk.widthHint = GuiUtils.getButtonWidth((Control)this.shell);
        btnOk.setText("OK");
        btnOk.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DynamicKeyboardLightingConfiguration.this.save();
            }
        });
        Button btnCancel = new Button(cmpsOkCancel, 0);
        GridData gd_btnCancel = new GridData(4, 0x1000000, false, false, 1, 1);
        btnCancel.setLayoutData((Object)gd_btnCancel);
        gd_btnCancel.widthHint = GuiUtils.getButtonWidth((Control)this.shell);
        btnCancel.setText("Cancel");
        btnCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DynamicKeyboardLightingConfiguration.this.shell.close();
            }
        });
        ((GridData)this.cspnDklFalling1.getLayoutData()).minimumWidth = longSpinnerMinWidth = (int)((double)GuiUtils.getButtonWidth((Control)this.shell) * 1.5);
        ((GridData)this.cspnDklRising1.getLayoutData()).minimumWidth = longSpinnerMinWidth;
        ((GridData)this.cspnDklDelay1.getLayoutData()).minimumWidth = longSpinnerMinWidth;
        ((GridData)this.cspnDklFalling2.getLayoutData()).minimumWidth = longSpinnerMinWidth;
        ((GridData)this.cspnDklRising2.getLayoutData()).minimumWidth = longSpinnerMinWidth;
        ((GridData)this.cspnDklDelay2.getLayoutData()).minimumWidth = longSpinnerMinWidth;
        ((GridData)this.cspnDklFalling3.getLayoutData()).minimumWidth = longSpinnerMinWidth;
        ((GridData)this.cspnDklRising3.getLayoutData()).minimumWidth = longSpinnerMinWidth;
        ((GridData)this.cspnDklDelay3.getLayoutData()).minimumWidth = longSpinnerMinWidth;
        ((GridData)lblDklFalling1.getLayoutData()).minimumWidth = longSpinnerMinWidth;
        ((GridData)lblDklFalling2.getLayoutData()).minimumWidth = longSpinnerMinWidth;
        ((GridData)lblDklFalling3.getLayoutData()).minimumWidth = longSpinnerMinWidth;
        ((GridData)lblDklRising1.getLayoutData()).minimumWidth = longSpinnerMinWidth;
        ((GridData)lblDklRising2.getLayoutData()).minimumWidth = longSpinnerMinWidth;
        ((GridData)lblDklRising3.getLayoutData()).minimumWidth = longSpinnerMinWidth;
        ((GridData)lblDklDelay1.getLayoutData()).minimumWidth = longSpinnerMinWidth;
        ((GridData)lblDklDelay2.getLayoutData()).minimumWidth = longSpinnerMinWidth;
        ((GridData)lblDklDelay3.getLayoutData()).minimumWidth = longSpinnerMinWidth;
        this.shell.setSize(this.shell.computeSize(-1, -1));
        this.shell.setLocation(GuiUtils.getMiddleLocation(this.shell, this.display));
    }

    public int getChildrenCheckboxSelectedDataAsInt(Composite parentControl) {
        Control[] child = parentControl.getChildren();
        int ret = 0;
        for (Control control : child) {
            if (control.getClass() != Button.class || (control.getStyle() & 0x20) <= 0 && (control.getStyle() & 0x10) <= 0 || !((Button)control).getSelection()) continue;
            int value = (Integer)control.getData();
            ret |= value;
        }
        return ret;
    }

    public void setSubCheckboxSelection(Composite parentControl, boolean selection) {
        Control[] child;
        for (Control control : child = parentControl.getChildren()) {
            if (control.getClass() != Button.class || (control.getStyle() & 0x20) <= 0 && (control.getStyle() & 0x10) <= 0) continue;
            ((Button)control).setSelection(selection);
        }
    }

    public void setChildrenEnable(Composite parentControl, boolean isEnabled) {
        Control[] child;
        for (Control control : child = parentControl.getChildren()) {
            if (!(control instanceof Button) || (control.getStyle() & 0x20) <= 0 && (control.getStyle() & 0x10) <= 0) continue;
            control.setEnabled(isEnabled);
        }
    }

    public ArrayList<Integer> getSupportPlmModeIds() {
        ArrayList<Payload> payloads = null;
        ArrayList<LidModeConfigurationPayload.TableEntry> tableEntries = null;
        ArrayList<Integer> supportPlmModeIds = new ArrayList<Integer>();
        if (this._dataStore.getCurrentDevice() == null) {
            return supportPlmModeIds;
        }
        ArrayList<Sensor> sensors = this._dataStore.getCurrentDevice().getSensors();
        for (Sensor sensor : sensors) {
            if (sensor.getLuid().getSensorTypeId() != 768) continue;
            payloads = sensor.getPayloads();
            break;
        }
        if (payloads == null) {
            return supportPlmModeIds;
        }
        for (Payload payload : payloads) {
            if (payload.getClass() != LidModeConfigurationPayload.class) continue;
            tableEntries = ((LidModeConfigurationPayload)payload).getTableEntries();
            break;
        }
        if (tableEntries == null) {
            return supportPlmModeIds;
        }
        for (LidModeConfigurationPayload.TableEntry entry : tableEntries) {
            supportPlmModeIds.add(entry.modeId);
        }
        return supportPlmModeIds;
    }

    public void save() {
        boolean newConfiguration = false;
        if (this.cspnDklRising1.getSelection() < this.cspnDklFalling1.getSelection()) {
            GuiUtils.ShowErrorMessage(this.shell, "Invalid Values", "The falling threshold 0 cannot be higher than the rising threshold 0.");
            return;
        }
        if (this.cspnDklRising2.getSelection() < this.cspnDklFalling2.getSelection()) {
            GuiUtils.ShowErrorMessage(this.shell, "Invalid Values", "The falling threshold 1 cannot be higher than the rising threshold 1.");
            return;
        }
        if (this.cspnDklRising3.getSelection() < this.cspnDklFalling3.getSelection()) {
            GuiUtils.ShowErrorMessage(this.shell, "Invalid Values", "The falling threshold 2 cannot be higher than the rising threshold 2.");
            return;
        }
        if (this.cspnDklRising2.getSelection() < this.cspnDklRising1.getSelection()) {
            GuiUtils.ShowErrorMessage(this.shell, "Invalid Values", "The rising threshold 1 cannot be lower than the rising threshold 0.");
            return;
        }
        if (this.cspnDklRising3.getSelection() < this.cspnDklRising2.getSelection()) {
            GuiUtils.ShowErrorMessage(this.shell, "Invalid Values", "The rising threshold 2 cannot be lower than the rising threshold 1.");
            return;
        }
        if (this.cspnDklFalling2.getSelection() < this.cspnDklFalling1.getSelection()) {
            GuiUtils.ShowErrorMessage(this.shell, "Invalid Values", "The falling threshold 1 cannot be lower than the falling threshold 0.");
            return;
        }
        if (this.cspnDklFalling3.getSelection() < this.cspnDklFalling2.getSelection()) {
            GuiUtils.ShowErrorMessage(this.shell, "Invalid Values", "The falling threshold 2 cannot be lower than the falling threshold 1.");
            return;
        }
        if (this.cspnDklRising1.getSelection() == this.cspnDklRising2.getSelection() && this.cspnDklFalling1.getSelection() == this.cspnDklFalling2.getSelection() && this.cspnDklDelay1.getSelection() != this.cspnDklDelay2.getSelection()) {
            GuiUtils.ShowErrorMessage(this.shell, "Invalid Values", "The delay threshold 0 and delay threshold 1 must be same when rasing threshold and failling threshold are same in Dynamic Keyboard Lighting Threshold 0 and Dynamic Keyboard Lighting Threshold 1");
            return;
        }
        if (this._payload == null) {
            this._payload = new DynamicKeyboardLightingPayload();
            newConfiguration = true;
        }
        if (this.chkDisableAlwaysOn.getSelection()) {
            this._payload.setDisableAlwaysOn(1);
        } else {
            this._payload.setDisableAlwaysOn(0);
        }
        if (!this.chkPlmModeIdGroup.getSelection()) {
            this._payload.setPlmModeId(-1);
        } else {
            this._payload.setPlmModeId(this.getChildrenCheckboxSelectedDataAsInt((Composite)this.grpPlmModeId));
        }
        this._payload.setFallingThreshold1(this.cspnDklFalling1.getSelection());
        this._payload.setFallingThreshold2(this.cspnDklFalling2.getSelection());
        this._payload.setFallingThreshold3(this.cspnDklFalling3.getSelection());
        this._payload.setRisingThreshold1(this.cspnDklRising1.getSelection());
        this._payload.setRisingThreshold2(this.cspnDklRising2.getSelection());
        this._payload.setRisingThreshold3(this.cspnDklRising3.getSelection());
        this._payload.setDelay1(this.cspnDklDelay1.getSelection());
        this._payload.setDelay2(this.cspnDklDelay2.getSelection());
        this._payload.setDelay3(this.cspnDklDelay3.getSelection());
        if (newConfiguration) {
            if (this._sensor != null) {
                this._sensor.addPayload(this._payload);
            }
            if (this.parent != null) {
                this.parent.addNewConfiguration(this._payload);
            }
        }
        this._modified = false;
        if (this.parent != null) {
            this.parent.setModified();
        }
        this.shell.close();
    }

    @Override
    public int getGpioCount() {
        return 0;
    }

    @Override
    public int[] getGpioSelectionIndices() {
        return null;
    }

    @Override
    public HashMap<String, String> getLineValues(int lineIndex) {
        return null;
    }

    @Override
    public void addGpioToTable(String purposeID, String pinNumber, String modelGpio) {
    }

    @Override
    public void updateGpioLine(int lineIndex, HashMap<String, String> values) {
    }

    @Override
    public Shell getShell() {
        return null;
    }

    @Override
    public void setModified() {
    }
}

