/*
 * Decompiled with CFR 0.152.
 */
package pdtEditor.gui.configuration;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.wb.swt.SWTResourceManager;
import pdtEditor.DataStore;
import pdtEditor.InformationStore;
import pdtEditor.PdtFile;
import pdtEditor.Sensor;
import pdtEditor.gui.GuiUtils;
import pdtEditor.gui.InterruptsModifierOpener;
import pdtEditor.gui.SensorModifier;
import pdtEditor.gui.configuration.DynamicSarConfigurationModifier;
import pdtEditor.gui.configuration.LidModeConfiguration;
import pdtEditor.payloads.Payload;
import pdtEditor.payloads.configurations.DynamicSarConfigurationPayload;
import pdtEditor.payloads.configurations.LidModeConfigurationPayload;

public class DynamicSarConfiguration
implements InterruptsModifierOpener {
    protected Shell shell;
    private Display display;
    private SensorModifier parent;
    private boolean _modified = false;
    private InformationStore infoStore = null;
    private DynamicSarConfiguration _thisInstance = this;
    private Sensor _sensor = null;
    private DataStore _dataStore;
    private DynamicSarConfigurationPayload _payload;
    Combo cmbAntennaAPositionId;
    Combo cmbAntennaBPositionId;
    Button chkAntennaA;
    Button chkAntennaB;
    Button btnAntennaAAddConfig;
    Button btnAntennaAEditConfig;
    Button btnAntennaADeleteConfig;
    Button btnAntennaBAddConfig;
    Button btnAntennaBEditConfig;
    Button btnAntennaBDeleteConfig;
    Button btnSaveAndClose;
    Button btnCancel;
    Table tblAntennaAConfig;
    Table tblAntennaBConfig;

    public static void main(String[] args) {
        try {
            DynamicSarConfiguration window = new DynamicSarConfiguration(null, null, null);
            PdtFile pdtFile = new PdtFile("");
            pdtFile.setPath(null);
            DataStore.getInstance().addPdtFile(pdtFile);
            window.open();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public DynamicSarConfiguration(SensorModifier parentWindow, DynamicSarConfigurationPayload payload, Sensor sensor) {
        this.parent = parentWindow;
        this._dataStore = DataStore.getInstance();
        this._payload = payload;
        this.getSupportPlmModeIds();
    }

    protected void createContents() {
        this.shell = new Shell(65760);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent arg0) {
                if (DynamicSarConfiguration.this._modified) {
                    MessageBox messageBox = new MessageBox(DynamicSarConfiguration.this.shell, 296);
                    messageBox.setText("Closing The Configuration Window");
                    messageBox.setMessage("Some changes will be lost. Are you sure that you want to continue?");
                    if (messageBox.open() != 32) {
                        arg0.doit = false;
                        return;
                    }
                }
            }
        });
        this.shell.setImage(SWTResourceManager.getImage(LidModeConfiguration.class, "/resources/Intel.ico"));
        this.shell.setText("Dynamic Sar Configuration");
        GuiUtils.setGridLayoutToComposite((Composite)this.shell, 1);
        Composite cmpAntennaA = GuiUtils.addCompositeToComposite((Composite)this.shell, 4, 16384, 0x1000000, false, false, 1, 1, 1);
        FormLayout cmpAntennaALayout = new FormLayout();
        cmpAntennaA.setLayout((Layout)cmpAntennaALayout);
        this.chkAntennaA = new Button(cmpAntennaA, 32);
        this.chkAntennaA.setText("Antenna A");
        this.chkAntennaA.setSelection(true);
        FormData frmChkDataAntennaA = new FormData();
        this.chkAntennaA.setLayoutData((Object)frmChkDataAntennaA);
        frmChkDataAntennaA.left = new FormAttachment();
        frmChkDataAntennaA.left.offset = 8;
        this.chkAntennaA.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!DynamicSarConfiguration.this.chkAntennaA.getSelection()) {
                    DynamicSarConfiguration.this.cmbAntennaAPositionId.deselectAll();
                    DynamicSarConfiguration.this.tblAntennaAConfig.removeAll();
                    DynamicSarConfiguration.this.btnAntennaAEditConfig.setEnabled(false);
                    DynamicSarConfiguration.this.btnAntennaADeleteConfig.setEnabled(false);
                    if (DynamicSarConfiguration.this._payload != null) {
                        ((DynamicSarConfiguration)DynamicSarConfiguration.this)._payload.getAntennaAConfig().conditionList.clear();
                        ((DynamicSarConfiguration)DynamicSarConfiguration.this)._payload.getAntennaAConfig().postion = 255;
                    }
                } else {
                    DynamicSarConfiguration.this.cmbAntennaAPositionId.select(0);
                }
                DynamicSarConfiguration.this.cmbAntennaAPositionId.setEnabled(DynamicSarConfiguration.this.chkAntennaA.getSelection());
                DynamicSarConfiguration.this.tblAntennaAConfig.setEnabled(DynamicSarConfiguration.this.chkAntennaA.getSelection());
                DynamicSarConfiguration.this.btnAntennaAAddConfig.setEnabled(DynamicSarConfiguration.this.chkAntennaA.getSelection());
            }
        });
        Group grpAntennaA = new Group(cmpAntennaA, 4);
        FormData frmDataGrpAntennaA = new FormData();
        GridLayout grpAntennaALayout = new GridLayout(1, true);
        grpAntennaA.setLayout((Layout)grpAntennaALayout);
        grpAntennaA.setLayoutData((Object)frmDataGrpAntennaA);
        Composite cmpAntennaAPosition = GuiUtils.addCompositeToComposite((Composite)grpAntennaA, 0, 16384, 0x1000000, false, false, 1, 1, 2);
        int originMargin = ((GridLayout)cmpAntennaAPosition.getLayout()).marginHeight;
        ((GridLayout)cmpAntennaAPosition.getLayout()).marginHeight = 0;
        ((GridLayout)cmpAntennaAPosition.getLayout()).marginTop = originMargin;
        ((GridLayout)cmpAntennaAPosition.getLayout()).marginWidth = 0;
        GuiUtils.addLabelToComposite("Position:", cmpAntennaAPosition, 0, 16384, 0x1000000, true, true, 1, 1);
        this.cmbAntennaAPositionId = GuiUtils.addComboToComposite(cmpAntennaAPosition, 12, 16384, 0x1000000, false, false, 1, 1);
        this.cmbAntennaAPositionId.add("Top");
        this.cmbAntennaAPositionId.add("Side");
        this.cmbAntennaAPositionId.add("Hinge");
        this.cmbAntennaAPositionId.add("Base");
        this.cmbAntennaAPositionId.select(0);
        TableViewer tbvAntennaA = new TableViewer((Composite)grpAntennaA, 67586);
        this.tblAntennaAConfig = tbvAntennaA.getTable();
        this.tblAntennaAConfig.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.tblAntennaAConfig.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                int itemsSelected = DynamicSarConfiguration.this.tblAntennaAConfig.getSelectionCount();
                if (itemsSelected == 1) {
                    DynamicSarConfiguration.this.btnAntennaAEditConfig.setEnabled(true);
                    DynamicSarConfiguration.this.btnAntennaADeleteConfig.setEnabled(true);
                } else {
                    DynamicSarConfiguration.this.btnAntennaAEditConfig.setEnabled(false);
                    if (itemsSelected > 1) {
                        DynamicSarConfiguration.this.btnAntennaADeleteConfig.setEnabled(true);
                    } else {
                        DynamicSarConfiguration.this.btnAntennaADeleteConfig.setEnabled(false);
                    }
                }
            }
        });
        this.tblAntennaAConfig.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent arg0) {
                DynamicSarConfiguration.this.editConfigurationTableItem(DynamicSarConfiguration.this.tblAntennaAConfig);
            }
        });
        this.tblAntennaAConfig.setLayoutData((Object)new GridData(4, 4, false, false, 3, 1));
        this.tblAntennaAConfig.setHeaderVisible(true);
        this.tblAntennaAConfig.setLinesVisible(true);
        ControlAdapter resizeColHandler = new ControlAdapter(){

            public void controlResized(ControlEvent arg0) {
                if (((TableColumn)arg0.getSource()).getWidth() < 50) {
                    ((TableColumn)arg0.getSource()).setWidth(50);
                }
            }
        };
        TableViewerColumn tvcAntennaAPlmModeId = new TableViewerColumn(tbvAntennaA, 0);
        final TableColumn tblclmnAntennaAPlmModeId = tvcAntennaAPlmModeId.getColumn();
        tblclmnAntennaAPlmModeId.addControlListener((ControlListener)resizeColHandler);
        tblclmnAntennaAPlmModeId.setText("PLM Mode ID");
        TableViewerColumn tvcAntennaADmd = new TableViewerColumn(tbvAntennaA, 0);
        final TableColumn tblclmnAntennaADmd = tvcAntennaADmd.getColumn();
        tblclmnAntennaADmd.addControlListener((ControlListener)resizeColHandler);
        tblclmnAntennaADmd.setText("Dmd");
        TableViewerColumn tvcAntennaAIndex = new TableViewerColumn(tbvAntennaA, 0);
        final TableColumn tblclmnAntennaAIndex = tvcAntennaAIndex.getColumn();
        tblclmnAntennaAIndex.addControlListener((ControlListener)resizeColHandler);
        tblclmnAntennaAIndex.setText("Index");
        this.tblAntennaAConfig.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                int oneWidth = DynamicSarConfiguration.this.tblAntennaAConfig.getClientArea().width / 3;
                tblclmnAntennaAPlmModeId.setWidth(oneWidth);
                tblclmnAntennaADmd.setWidth(oneWidth);
                tblclmnAntennaAIndex.setWidth(oneWidth);
            }
        });
        ((GridData)this.tblAntennaAConfig.getLayoutData()).heightHint = GuiUtils.getPixelSizeHeight((Control)this.tblAntennaAConfig) * 10;
        ((GridData)this.tblAntennaAConfig.getLayoutData()).widthHint = GuiUtils.getPixelSizeWidth((Control)this.tblAntennaAConfig) * 80;
        Composite cmpAntennaAButtons = GuiUtils.addCompositeToComposite((Composite)grpAntennaA, 4, 131072, 0x1000000, false, false, 1, 1, 3);
        ((GridLayout)cmpAntennaAButtons.getLayout()).marginHeight = 0;
        ((GridLayout)cmpAntennaAButtons.getLayout()).marginWidth = 0;
        this.btnAntennaAAddConfig = new Button(cmpAntennaAButtons, 0);
        GridData gd_btnAddEntry = new GridData(131072, 4, true, false, 1, 1);
        gd_btnAddEntry.widthHint = GuiUtils.getButtonWidth((Control)grpAntennaA);
        this.btnAntennaAAddConfig.setText("Add");
        this.btnAntennaAAddConfig.setLayoutData((Object)gd_btnAddEntry);
        this.btnAntennaAAddConfig.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                DynamicSarConfiguration.this.tblAntennaAConfig.setSelection(new int[0]);
                new DynamicSarConfigurationModifier(DynamicSarConfiguration.this._thisInstance, DynamicSarConfiguration.this.getSupportPlmModeIds(), null, DynamicSarConfiguration.this.tblAntennaAConfig).open();
            }
        });
        this.btnAntennaAEditConfig = new Button(cmpAntennaAButtons, 0);
        GridData gd_btnAntennaAEditEntry = new GridData(131072, 0x1000000, false, false, 1, 1);
        gd_btnAntennaAEditEntry.widthHint = GuiUtils.getButtonWidth((Control)grpAntennaA);
        this.btnAntennaAEditConfig.setLayoutData((Object)gd_btnAntennaAEditEntry);
        this.btnAntennaAEditConfig.setEnabled(false);
        this.btnAntennaAEditConfig.setText("Edit");
        this.btnAntennaAEditConfig.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                DynamicSarConfiguration.this.editConfigurationTableItem(DynamicSarConfiguration.this.tblAntennaAConfig);
            }
        });
        this.btnAntennaADeleteConfig = new Button(cmpAntennaAButtons, 0);
        this.btnAntennaADeleteConfig.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        GridData gd_btnAntennaADeleteEntry = new GridData(4, 0x1000000, false, false, 1, 1);
        gd_btnAntennaADeleteEntry.widthHint = GuiUtils.getButtonWidth((Control)grpAntennaA);
        this.btnAntennaADeleteConfig.setText("Delete");
        this.btnAntennaADeleteConfig.setLayoutData((Object)gd_btnAntennaADeleteEntry);
        this.btnAntennaADeleteConfig.setEnabled(false);
        this.btnAntennaADeleteConfig.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                int[] selectedIndices = DynamicSarConfiguration.this.tblAntennaAConfig.getSelectionIndices();
                if (selectedIndices.length > 0) {
                    DynamicSarConfiguration.this.tblAntennaAConfig.remove(selectedIndices);
                }
                DynamicSarConfiguration.this.btnAntennaAEditConfig.setEnabled(false);
                DynamicSarConfiguration.this.btnAntennaADeleteConfig.setEnabled(false);
                DynamicSarConfiguration.this.refreshButtonsAfterConfNumChange();
                DynamicSarConfiguration.this.setModified();
            }
        });
        Composite cmpAntennaB = new Composite((Composite)this.shell, 4);
        FormLayout cmpAntennaBLayout = new FormLayout();
        cmpAntennaB.setLayout((Layout)cmpAntennaBLayout);
        this.chkAntennaB = new Button(cmpAntennaB, 32);
        this.chkAntennaB.setText("Antenna B");
        this.chkAntennaB.setSelection(true);
        FormData frmChkAntennaB = new FormData();
        this.chkAntennaB.setLayoutData((Object)frmChkAntennaB);
        frmChkAntennaB.left = new FormAttachment();
        frmChkAntennaB.left.offset = 8;
        this.chkAntennaB.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!DynamicSarConfiguration.this.chkAntennaB.getSelection()) {
                    DynamicSarConfiguration.this.cmbAntennaBPositionId.deselectAll();
                    DynamicSarConfiguration.this.tblAntennaBConfig.removeAll();
                    DynamicSarConfiguration.this.btnAntennaBEditConfig.setEnabled(false);
                    DynamicSarConfiguration.this.btnAntennaBDeleteConfig.setEnabled(false);
                    if (DynamicSarConfiguration.this._payload != null) {
                        ((DynamicSarConfiguration)DynamicSarConfiguration.this)._payload.getAntennaBConfig().conditionList.clear();
                        ((DynamicSarConfiguration)DynamicSarConfiguration.this)._payload.getAntennaBConfig().postion = 255;
                    }
                } else {
                    DynamicSarConfiguration.this.cmbAntennaBPositionId.select(0);
                }
                DynamicSarConfiguration.this.cmbAntennaBPositionId.setEnabled(DynamicSarConfiguration.this.chkAntennaB.getSelection());
                DynamicSarConfiguration.this.tblAntennaBConfig.setEnabled(DynamicSarConfiguration.this.chkAntennaB.getSelection());
                DynamicSarConfiguration.this.btnAntennaBAddConfig.setEnabled(DynamicSarConfiguration.this.chkAntennaB.getSelection());
            }
        });
        Group grpAntennaB = new Group(cmpAntennaB, 4);
        FormData frmDataGrpAntennaB = new FormData();
        GridLayout grpAntennaBLayout = new GridLayout(1, false);
        grpAntennaB.setLayout((Layout)grpAntennaBLayout);
        grpAntennaB.setLayoutData((Object)frmDataGrpAntennaB);
        Composite cmpAntennaBPosition = GuiUtils.addCompositeToComposite((Composite)grpAntennaB, 0, 16384, 0x1000000, false, false, 1, 1, 2);
        ((GridLayout)cmpAntennaBPosition.getLayout()).marginHeight = 0;
        ((GridLayout)cmpAntennaBPosition.getLayout()).marginTop = originMargin;
        ((GridLayout)cmpAntennaBPosition.getLayout()).marginWidth = 0;
        GuiUtils.addLabelToComposite("Position:", cmpAntennaBPosition, 0, 16384, 0x1000000, false, false, 1, 1);
        this.cmbAntennaBPositionId = GuiUtils.addComboToComposite(cmpAntennaBPosition, 12, 4, 16384, true, false, 1, 1);
        this.cmbAntennaBPositionId.add("Top");
        this.cmbAntennaBPositionId.add("Side");
        this.cmbAntennaBPositionId.add("Hinge");
        this.cmbAntennaBPositionId.add("Base");
        this.cmbAntennaBPositionId.select(0);
        TableViewer tbvAntennaB = new TableViewer((Composite)grpAntennaB, 67586);
        this.tblAntennaBConfig = tbvAntennaB.getTable();
        this.tblAntennaBConfig.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.tblAntennaBConfig.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                int itemsSelected = DynamicSarConfiguration.this.tblAntennaBConfig.getSelectionCount();
                if (itemsSelected == 1) {
                    DynamicSarConfiguration.this.btnAntennaBEditConfig.setEnabled(true);
                    DynamicSarConfiguration.this.btnAntennaBDeleteConfig.setEnabled(true);
                } else {
                    DynamicSarConfiguration.this.btnAntennaBEditConfig.setEnabled(false);
                    if (itemsSelected > 1) {
                        DynamicSarConfiguration.this.btnAntennaBDeleteConfig.setEnabled(true);
                    } else {
                        DynamicSarConfiguration.this.btnAntennaBDeleteConfig.setEnabled(false);
                    }
                }
            }
        });
        this.tblAntennaBConfig.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent arg0) {
                DynamicSarConfiguration.this.editConfigurationTableItem(DynamicSarConfiguration.this.tblAntennaBConfig);
            }
        });
        this.tblAntennaBConfig.setLayoutData((Object)new GridData(4, 4, false, false, 3, 1));
        this.tblAntennaBConfig.setHeaderVisible(true);
        this.tblAntennaBConfig.setLinesVisible(true);
        TableViewerColumn tvcAntennaBPlmModeId = new TableViewerColumn(tbvAntennaB, 0);
        final TableColumn tblclmnAntennaBPlmModeId = tvcAntennaBPlmModeId.getColumn();
        tblclmnAntennaBPlmModeId.addControlListener((ControlListener)resizeColHandler);
        tblclmnAntennaBPlmModeId.setText("PLM Mode ID");
        TableViewerColumn tvcAntennaBDmd = new TableViewerColumn(tbvAntennaB, 0);
        final TableColumn tblclmnAntennaBDmd = tvcAntennaBDmd.getColumn();
        tblclmnAntennaBDmd.addControlListener((ControlListener)resizeColHandler);
        tblclmnAntennaBDmd.setText("Dmd");
        TableViewerColumn tvcAntennaBIndex = new TableViewerColumn(tbvAntennaB, 0);
        final TableColumn tblclmnAntennaBIndex = tvcAntennaBIndex.getColumn();
        tblclmnAntennaBIndex.addControlListener((ControlListener)resizeColHandler);
        tblclmnAntennaBIndex.setText("Index");
        this.tblAntennaBConfig.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                int oneWidth = DynamicSarConfiguration.this.tblAntennaBConfig.getClientArea().width / 3;
                tblclmnAntennaBPlmModeId.setWidth(oneWidth);
                tblclmnAntennaBDmd.setWidth(oneWidth);
                tblclmnAntennaBIndex.setWidth(oneWidth);
            }
        });
        ((GridData)this.tblAntennaBConfig.getLayoutData()).heightHint = GuiUtils.getPixelSizeHeight((Control)this.tblAntennaBConfig) * 10;
        ((GridData)this.tblAntennaBConfig.getLayoutData()).widthHint = GuiUtils.getPixelSizeWidth((Control)this.tblAntennaBConfig) * 80;
        Composite cmpAntennaBButtons = GuiUtils.addCompositeToComposite((Composite)grpAntennaB, 4, 131072, 0x1000000, false, false, 1, 1, 3);
        ((GridLayout)cmpAntennaBButtons.getLayout()).marginHeight = 0;
        ((GridLayout)cmpAntennaBButtons.getLayout()).marginWidth = 0;
        this.btnAntennaBAddConfig = new Button(cmpAntennaBButtons, 0);
        GridData gd_btnAntennaBAddEntry = new GridData(131072, 4, true, false, 1, 1);
        gd_btnAntennaBAddEntry.widthHint = GuiUtils.getButtonWidth((Control)grpAntennaB);
        this.btnAntennaBAddConfig.setText("Add");
        this.btnAntennaBAddConfig.setLayoutData((Object)gd_btnAntennaBAddEntry);
        this.btnAntennaBAddConfig.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                DynamicSarConfiguration.this.tblAntennaBConfig.setSelection(new int[0]);
                new DynamicSarConfigurationModifier(DynamicSarConfiguration.this._thisInstance, DynamicSarConfiguration.this.getSupportPlmModeIds(), null, DynamicSarConfiguration.this.tblAntennaBConfig).open();
            }
        });
        this.btnAntennaBEditConfig = new Button(cmpAntennaBButtons, 0);
        GridData gd_btnAntennaBEditEntry = new GridData(131072, 0x1000000, false, false, 1, 1);
        gd_btnAntennaBEditEntry.widthHint = GuiUtils.getButtonWidth((Control)grpAntennaB);
        this.btnAntennaBEditConfig.setLayoutData((Object)gd_btnAntennaBEditEntry);
        this.btnAntennaBEditConfig.setEnabled(false);
        this.btnAntennaBEditConfig.setText("Edit");
        this.btnAntennaBEditConfig.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                DynamicSarConfiguration.this.editConfigurationTableItem(DynamicSarConfiguration.this.tblAntennaBConfig);
            }
        });
        this.btnAntennaBDeleteConfig = new Button(cmpAntennaBButtons, 0);
        this.btnAntennaBDeleteConfig.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        GridData gd_btnAntennaBDeleteEntry = new GridData(4, 0x1000000, false, false, 1, 1);
        gd_btnAntennaBDeleteEntry.widthHint = GuiUtils.getButtonWidth((Control)grpAntennaB);
        this.btnAntennaBDeleteConfig.setText("Delete");
        this.btnAntennaBDeleteConfig.setLayoutData((Object)gd_btnAntennaBDeleteEntry);
        this.btnAntennaBDeleteConfig.setEnabled(false);
        this.btnAntennaBDeleteConfig.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                int[] selectedIndices = DynamicSarConfiguration.this.tblAntennaBConfig.getSelectionIndices();
                if (selectedIndices.length > 0) {
                    DynamicSarConfiguration.this.tblAntennaBConfig.remove(selectedIndices);
                }
                DynamicSarConfiguration.this.btnAntennaBEditConfig.setEnabled(false);
                DynamicSarConfiguration.this.btnAntennaBDeleteConfig.setEnabled(false);
                DynamicSarConfiguration.this.refreshButtonsAfterConfNumChange();
                DynamicSarConfiguration.this.setModified();
            }
        });
        Composite cmpButtons = new Composite((Composite)this.shell, 0);
        cmpButtons.setLayoutData((Object)new GridData(4, 4, true, false, 3, 1));
        GridLayout gridLayoutButtonComposite = new GridLayout(2, false);
        gridLayoutButtonComposite.marginHeight = 0;
        gridLayoutButtonComposite.marginWidth = 0;
        cmpButtons.setLayout((Layout)gridLayoutButtonComposite);
        this.btnSaveAndClose = new Button(cmpButtons, 0);
        GridData gd_btnSaveAndClose = new GridData(131072, 4, true, false, 1, 1);
        gd_btnSaveAndClose.widthHint = GuiUtils.getButtonWidth((Control)cmpButtons);
        this.btnSaveAndClose.setLayoutData((Object)gd_btnSaveAndClose);
        this.btnSaveAndClose.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                DynamicSarConfiguration.this.saveData();
            }
        });
        this.btnSaveAndClose.setText("Save and Close");
        this.btnCancel = new Button(cmpButtons, 0);
        GridData gd_btnCancel = new GridData(131072, 0x1000000, false, false, 1, 1);
        gd_btnCancel.widthHint = GuiUtils.getButtonWidth((Control)cmpButtons);
        this.btnCancel.setLayoutData((Object)gd_btnCancel);
        this.btnCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                DynamicSarConfiguration.this.shell.close();
            }
        });
        this.btnCancel.setText("Cancel");
        this.shell.setSize(this.shell.computeSize(-1, -1));
        this.shell.setLocation(GuiUtils.getMiddleLocation(this.shell, this.display));
    }

    public void open() {
        this.display = Display.getDefault();
        this.createContents();
        try {
            this.infoStore = InformationStore.getInstance();
        }
        catch (Exception e) {
            MessageBox messageBox = new MessageBox(this.shell, 513);
            messageBox.setText("Cannot load file");
            messageBox.setMessage("Cannot load the sensor definitions file - the file is missing or damaged. Aborting.");
            messageBox.open();
            return;
        }
        this.fillData();
        this.shell.open();
        this.shell.layout();
        while (!this.shell.isDisposed()) {
            if (this.display.readAndDispatch()) continue;
            this.display.sleep();
        }
    }

    public void fillData() {
        String[] data;
        String plmModeId;
        StringBuffer sbPlmModeId;
        if (this._payload == null) {
            return;
        }
        this.tblAntennaAConfig.removeAll();
        this.tblAntennaBConfig.removeAll();
        ArrayList<DynamicSarConfigurationPayload.ConditionTable> antennaAcondtionList = this._payload.getAntennaAConfig().conditionList;
        ArrayList<DynamicSarConfigurationPayload.ConditionTable> antennaBcondtionList = this._payload.getAntennaBConfig().conditionList;
        if (this._payload.getAntennaAConfig().postion != 255) {
            this.cmbAntennaAPositionId.select(this._payload.getAntennaAConfig().postion);
        }
        if (this._payload.getAntennaBConfig().postion != 255) {
            this.cmbAntennaBPositionId.select(this._payload.getAntennaBConfig().postion);
        }
        for (DynamicSarConfigurationPayload.ConditionTable condition : antennaAcondtionList) {
            sbPlmModeId = new StringBuffer();
            plmModeId = "";
            if (condition.plmModeId == -1) {
                plmModeId = "Not Available";
            } else {
                for (int i = 0; i < 32; ++i) {
                    if ((1 << i & condition.plmModeId) <= 0) continue;
                    sbPlmModeId.append(i).append(",");
                }
                if (sbPlmModeId.length() > 0) {
                    plmModeId = sbPlmModeId.substring(0, sbPlmModeId.length() - 1);
                }
            }
            data = new String[]{plmModeId, this.getDmdStatusTextByValue(condition.dmdStatus), String.valueOf(condition.indexNumber)};
            this.addConfigurationRow(this.tblAntennaAConfig, data, condition);
        }
        for (DynamicSarConfigurationPayload.ConditionTable condition : antennaBcondtionList) {
            sbPlmModeId = new StringBuffer();
            plmModeId = "";
            if (condition.plmModeId == -1) {
                plmModeId = "Not Available";
            } else {
                for (int i = 0; i < 32; ++i) {
                    if ((1 << i & condition.plmModeId) <= 0) continue;
                    sbPlmModeId.append(i).append(",");
                }
                if (sbPlmModeId.length() > 0) {
                    plmModeId = sbPlmModeId.substring(0, sbPlmModeId.length() - 1);
                }
            }
            data = new String[]{plmModeId, this.getDmdStatusTextByValue(condition.dmdStatus), String.valueOf(condition.indexNumber)};
            this.addConfigurationRow(this.tblAntennaBConfig, data, condition);
        }
        if (this._payload.getAntennaAConfig().postion == 255 && antennaAcondtionList.size() == 0) {
            this.chkAntennaA.setSelection(false);
            this.chkAntennaA.notifyListeners(13, new Event());
        }
        if (this._payload.getAntennaBConfig().postion == 255 && antennaBcondtionList.size() == 0) {
            this.chkAntennaB.setSelection(false);
            this.chkAntennaB.notifyListeners(13, new Event());
        }
    }

    public void addConfigurationRow(Table configTable, String[] data, DynamicSarConfigurationPayload.ConditionTable condition) {
        TableItem item = new TableItem(configTable, 0);
        item.setText(data);
        item.setData((Object)condition);
        this.refreshButtonsAfterConfNumChange();
    }

    public String getDmdStatusTextByValue(int status) {
        String statusText = "";
        switch (status) {
            case 1: {
                statusText = "Not On Table";
                break;
            }
            case 0: {
                statusText = "On Table";
                break;
            }
            case 255: {
                statusText = "Not Care";
                break;
            }
        }
        return statusText;
    }

    public ArrayList<Integer> getSupportPlmModeIds() {
        ArrayList<Payload> payloads = null;
        ArrayList<LidModeConfigurationPayload.TableEntry> tableEntries = null;
        ArrayList<Integer> supportPlmModeIds = new ArrayList<Integer>();
        if (this._dataStore.getCurrentDevice() == null) {
            return supportPlmModeIds;
        }
        ArrayList<Sensor> sensors = this._dataStore.getCurrentDevice().getSensors();
        for (Sensor sensor : sensors) {
            if (sensor.getLuid().getSensorTypeId() != 768) continue;
            payloads = sensor.getPayloads();
            break;
        }
        if (payloads == null) {
            return supportPlmModeIds;
        }
        for (Payload payload : payloads) {
            if (payload.getClass() != LidModeConfigurationPayload.class) continue;
            tableEntries = ((LidModeConfigurationPayload)payload).getTableEntries();
            break;
        }
        if (tableEntries == null) {
            return supportPlmModeIds;
        }
        for (LidModeConfigurationPayload.TableEntry entry : tableEntries) {
            supportPlmModeIds.add(entry.modeId);
        }
        return supportPlmModeIds;
    }

    public void addConfigurationRow(String[] data, Table tblConfig, DynamicSarConfigurationPayload.ConditionTable condition) {
        TableItem item = new TableItem(tblConfig, 0);
        item.setText(data);
        item.setData((Object)condition);
        this.refreshButtonsAfterConfNumChange();
    }

    public void refreshButtonsAfterConfNumChange() {
        if (this.tblAntennaAConfig.getItemCount() < 1 && this.tblAntennaBConfig.getItemCount() < 1) {
            this.btnSaveAndClose.setEnabled(false);
        } else {
            this.btnSaveAndClose.setEnabled(true);
        }
        if (this.tblAntennaAConfig.getItemCount() >= 15) {
            this.btnAntennaAAddConfig.setEnabled(false);
        } else {
            this.btnAntennaAAddConfig.setEnabled(true);
        }
        if (this.tblAntennaBConfig.getItemCount() >= 15) {
            this.btnAntennaBAddConfig.setEnabled(false);
        } else {
            this.btnAntennaBAddConfig.setEnabled(true);
        }
    }

    public void checkNewConfiguration(Table configTable, String[] data) {
        for (int i = 0; i < configTable.getItemCount(); ++i) {
            if (configTable.getSelectionIndex() == i || !configTable.getItem(i).getText(0).equals(data[0]) || !configTable.getItem(i).getText(1).equals(data[1]) || !configTable.getItem(i).getText(2).equals(data[2])) continue;
            throw new RuntimeException("The configuration table cannot contain two entries with the same PLM id, DMD and index.");
        }
    }

    public void editConfigurationTableItem(Table configTable) {
        TableItem[] selectedItems = configTable.getSelection();
        if (selectedItems.length != 1) {
            return;
        }
        new DynamicSarConfigurationModifier(this._thisInstance, this.getSupportPlmModeIds(), selectedItems[0], configTable).open();
    }

    public void saveData() {
        DynamicSarConfigurationPayload.ConditionTable condition;
        TableItem configTableItem;
        int i;
        boolean newConfiguration = false;
        if (this._payload == null) {
            this._payload = new DynamicSarConfigurationPayload();
            newConfiguration = true;
        }
        if (this.chkAntennaA.getSelection()) {
            this._payload.getAntennaAConfig().postion = this.cmbAntennaAPositionId.getSelectionIndex();
            ArrayList<DynamicSarConfigurationPayload.ConditionTable> conditionAList = new ArrayList<DynamicSarConfigurationPayload.ConditionTable>();
            for (i = 0; i < this.tblAntennaAConfig.getItemCount(); ++i) {
                configTableItem = this.tblAntennaAConfig.getItem(i);
                condition = (DynamicSarConfigurationPayload.ConditionTable)configTableItem.getData();
                conditionAList.add(condition);
            }
            this._payload.getAntennaAConfig().conditionList = conditionAList;
        }
        if (this.chkAntennaB.getSelection()) {
            this._payload.getAntennaBConfig().postion = this.cmbAntennaBPositionId.getSelectionIndex();
            ArrayList<DynamicSarConfigurationPayload.ConditionTable> conditionBList = new ArrayList<DynamicSarConfigurationPayload.ConditionTable>();
            for (i = 0; i < this.tblAntennaBConfig.getItemCount(); ++i) {
                configTableItem = this.tblAntennaBConfig.getItem(i);
                condition = (DynamicSarConfigurationPayload.ConditionTable)configTableItem.getData();
                conditionBList.add(condition);
            }
            this._payload.getAntennaBConfig().conditionList = conditionBList;
        }
        if (newConfiguration) {
            if (this._sensor != null) {
                this._sensor.addPayload(this._payload);
            }
            if (this.parent != null) {
                this.parent.addNewConfiguration(this._payload);
            }
        }
        this._modified = false;
        if (this.parent != null) {
            this.parent.setModified();
        }
        this.shell.close();
    }

    @Override
    public int getGpioCount() {
        return 0;
    }

    @Override
    public int[] getGpioSelectionIndices() {
        return null;
    }

    @Override
    public HashMap<String, String> getLineValues(int lineIndex) {
        return null;
    }

    @Override
    public void addGpioToTable(String purposeID, String pinNumber, String modelGpio) {
    }

    @Override
    public void updateGpioLine(int lineIndex, HashMap<String, String> values) {
    }

    @Override
    public Shell getShell() {
        return null;
    }

    @Override
    public void setModified() {
    }
}

