/*
 * Decompiled with CFR 0.152.
 */
package pdtEditor.gui.configuration;

import java.util.ArrayList;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.wb.swt.SWTResourceManager;
import pdtEditor.gui.GuiUtils;
import pdtEditor.gui.configuration.HingeAngleConfiguration;
import pdtEditor.gui.configuration.LidModeConfigurationModifier;
import pdtEditor.payloads.configurations.HingeAngleConfigurationPayload;
import resources.CustomSpinner;

public class HingeAngleConfigurationModifier {
    private static final int ANGLE_OUTPUT_MAX_VALUE = 360;
    private static final int ANGLE_OUTPUT_MIN_VALUE = -1;
    protected Shell shlEditConfigurationValues;
    private Display display;
    private HingeAngleConfiguration _parent;
    private TableItem _currentItem = null;
    ArrayList<HingeAngleConfigurationPayload.HallConfig> _hallConfigs = null;
    ArrayList<Combo> _hallConfigComboList = new ArrayList();
    private CustomSpinner mode;
    private CustomSpinner entryAngle;
    private CustomSpinner t1Delta;
    private CustomSpinner exitAngle;
    private CustomSpinner t2Delta;
    private CustomSpinner Th;

    public static void main(String[] args) {
        try {
            HingeAngleConfigurationModifier window = new HingeAngleConfigurationModifier(null, null, null);
            window.open();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public HingeAngleConfigurationModifier(HingeAngleConfiguration parent, TableItem currentItem, ArrayList<HingeAngleConfigurationPayload.HallConfig> hallConfigs) {
        this._parent = parent;
        this._currentItem = currentItem;
        this._hallConfigs = hallConfigs;
    }

    public void open() {
        this.display = Display.getDefault();
        this.createContents();
        this.fillData();
        this.shlEditConfigurationValues.open();
        this.shlEditConfigurationValues.layout();
        while (!this.shlEditConfigurationValues.isDisposed()) {
            if (this.display.readAndDispatch()) continue;
            this.display.sleep();
        }
    }

    public void fillData() {
        if (this._currentItem == null) {
            return;
        }
        this.mode.setSelection(Integer.valueOf(this._currentItem.getText(0)));
        this.entryAngle.setSelection(Integer.valueOf(this._currentItem.getText(1)));
        this.exitAngle.setSelection(Integer.valueOf(this._currentItem.getText(2)));
        this.t1Delta.setSelection(Integer.valueOf(this._currentItem.getText(3)));
        this.t2Delta.setSelection(Integer.valueOf(this._currentItem.getText(4)));
        this.Th.setSelection(Integer.valueOf(this._currentItem.getText(5)));
        for (int i = 0; i < this._hallConfigComboList.size(); ++i) {
            for (int j = 0; j < this._hallConfigComboList.get(i).getItemCount(); ++j) {
                if (!this._hallConfigComboList.get(i).getItem(j).equals(this._currentItem.getText(6 + i))) continue;
                this._hallConfigComboList.get(i).select(j);
            }
        }
    }

    public void save() {
        if (this.entryAngle.getSelection() > this.exitAngle.getSelection()) {
            GuiUtils.ShowErrorMessage(this.shlEditConfigurationValues, "Invalid Angle Values", "The entry angle's value cannot be higher than the exit angle's value.");
            return;
        }
        ArrayList<String> temp = new ArrayList<String>();
        temp.add(this.mode.getText());
        temp.add(this.entryAngle.getText());
        temp.add(this.exitAngle.getText());
        temp.add(this.t1Delta.getText());
        temp.add(this.t2Delta.getText());
        temp.add(this.Th.getText());
        for (int i = 0; i < this._hallConfigComboList.size(); ++i) {
            temp.add(this._hallConfigComboList.get(i).getText());
        }
        String[] data = new String[]{};
        data = temp.toArray(data);
        if (this._currentItem == null) {
            this._parent.addHingeAngleLine(data);
        } else {
            this._currentItem.setText(data);
        }
        this._parent.setModified();
        this.shlEditConfigurationValues.close();
    }

    protected void createContents() {
        int longWidth;
        this.shlEditConfigurationValues = new Shell(65760);
        this.shlEditConfigurationValues.setImage(SWTResourceManager.getImage(LidModeConfigurationModifier.class, "/resources/Intel.ico"));
        this.shlEditConfigurationValues.setText("Edit Configuration Values");
        this.shlEditConfigurationValues.setLayout((Layout)new GridLayout(2, false));
        Group group = new Group((Composite)this.shlEditConfigurationValues, 0);
        group.setLayout((Layout)new GridLayout(2, false));
        group.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        GuiUtils.addLabelToComposite("Angle Output:", (Composite)group, 0, 16384, 0x1000000, true, true, 1, 1);
        this.mode = GuiUtils.addCustomSpinnerToComposite(360, this.shlEditConfigurationValues, (Composite)group, 2048, 16384, 0x1000000, true, false, 1, 1);
        this.mode.setMinimum(-1);
        GuiUtils.addLabelToComposite("Entry Angle:", (Composite)group, 0, 16384, 0x1000000, true, true, 1, 1);
        this.entryAngle = GuiUtils.addCustomSpinnerToComposite(360, this.shlEditConfigurationValues, (Composite)group, 2048, 16384, 0x1000000, true, false, 1, 1);
        this.entryAngle.setMinimum(-1);
        GuiUtils.addLabelToComposite("Exit Angle:", (Composite)group, 0, 16384, 0x1000000, true, true, 1, 1);
        this.exitAngle = GuiUtils.addCustomSpinnerToComposite(360, this.shlEditConfigurationValues, (Composite)group, 2048, 16384, 0x1000000, true, false, 1, 1);
        this.exitAngle.setMinimum(-1);
        GuiUtils.addLabelToComposite("Entry Angle Tolerance:", (Composite)group, 0, 16384, 0x1000000, true, true, 1, 1);
        this.t1Delta = GuiUtils.addCustomSpinnerToComposite(360, this.shlEditConfigurationValues, (Composite)group, 2048, 16384, 0x1000000, true, false, 1, 1);
        this.t1Delta.setMinimum(-1);
        GuiUtils.addLabelToComposite("Exit Angle Tolerance:", (Composite)group, 0, 16384, 0x1000000, true, true, 1, 1);
        this.t2Delta = GuiUtils.addCustomSpinnerToComposite(360, this.shlEditConfigurationValues, (Composite)group, 2048, 16384, 0x1000000, true, false, 1, 1);
        this.t2Delta.setMinimum(-1);
        GuiUtils.addLabelToComposite("Time Hysteresis:", (Composite)group, 0, 16384, 0x1000000, true, true, 1, 1);
        this.Th = GuiUtils.addCustomSpinnerToComposite((int)Math.pow(2.0, 16.0) - 1, this.shlEditConfigurationValues, (Composite)group, 2052, 16384, 0x1000000, true, false, 1, 1);
        for (int i = 0; i < this._hallConfigs.size(); ++i) {
            String headText = this._hallConfigs.get((int)i).sensorName + "(" + this._hallConfigs.get((int)i).instanceId + "):";
            GuiUtils.addLabelToComposite(headText, (Composite)group, 4, 16384, 0x1000000, true, false, 1, 1);
            Combo cboHallConfig = GuiUtils.addComboToComposite((Composite)group, 8, 4, 0x1000000, true, false, 1, 1);
            cboHallConfig.add("Inactive");
            cboHallConfig.add("Active");
            cboHallConfig.add("Not Applicable");
            cboHallConfig.select(2);
            this._hallConfigComboList.add(cboHallConfig);
        }
        Button btnOk = new Button((Composite)this.shlEditConfigurationValues, 0);
        GridData gd_btnOk = new GridData(131072, 0x1000000, true, false, 1, 1);
        gd_btnOk.widthHint = GuiUtils.getButtonWidth((Control)this.shlEditConfigurationValues);
        btnOk.setLayoutData((Object)gd_btnOk);
        btnOk.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                HingeAngleConfigurationModifier.this.save();
            }
        });
        btnOk.setText("OK");
        Button btnCancel = new Button((Composite)this.shlEditConfigurationValues, 0);
        GridData gd_btnCancel = new GridData(4, 0x1000000, false, false, 1, 1);
        gd_btnCancel.widthHint = GuiUtils.getButtonWidth((Control)this.shlEditConfigurationValues);
        btnCancel.setLayoutData((Object)gd_btnCancel);
        btnCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                HingeAngleConfigurationModifier.this.shlEditConfigurationValues.close();
            }
        });
        btnCancel.setText("Cancel");
        ((GridData)this.mode.getLayoutData()).widthHint = longWidth = GuiUtils.getButtonWidth((Control)this.shlEditConfigurationValues) * 3 / 2;
        ((GridData)this.entryAngle.getLayoutData()).widthHint = longWidth;
        ((GridData)this.exitAngle.getLayoutData()).widthHint = longWidth;
        ((GridData)this.t1Delta.getLayoutData()).widthHint = longWidth;
        ((GridData)this.t2Delta.getLayoutData()).widthHint = longWidth;
        ((GridData)this.Th.getLayoutData()).widthHint = longWidth;
        this.shlEditConfigurationValues.setSize(this.shlEditConfigurationValues.computeSize(-1, -1));
        this.shlEditConfigurationValues.setLocation(GuiUtils.getMiddleLocation(this.shlEditConfigurationValues, this.display));
    }
}

