/*
 * Decompiled with CFR 0.152.
 */
package pdtEditor.gui.configuration;

import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wb.swt.SWTResourceManager;
import pdtEditor.Sensor;
import pdtEditor.gui.GuiUtils;
import pdtEditor.gui.SensorModifier;
import pdtEditor.payloads.configurations.HingeConfigurationPayload;
import resources.CustomSpinner;

public class HingeConfiguration {
    private HingeConfigurationPayload _payload = null;
    private Sensor _sensor = null;
    protected Shell shlHinge;
    private Display display;
    private SensorModifier _parent;
    GuiUtils.WindowProperties _properties = new GuiUtils.WindowProperties(){

        @Override
        protected void onModification() {
        }
    };
    private Button btnDisableOn;
    private Button btnSensitivity;
    private CustomSpinner spnSensitivity;
    private CustomSpinner cspnTabletModeAngle;

    public static void main(String[] args) {
        try {
            HingeConfiguration window = new HingeConfiguration(null, null, null);
            window.open();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public HingeConfiguration(SensorModifier parent, HingeConfigurationPayload payload, Sensor sensor) {
        this._payload = payload;
        this._sensor = sensor;
        this._parent = parent;
    }

    public void open() {
        this.display = Display.getDefault();
        this.createContents();
        this.fillData();
        this.shlHinge.open();
        this.shlHinge.layout();
        while (!this.shlHinge.isDisposed()) {
            if (this.display.readAndDispatch()) continue;
            this.display.sleep();
        }
    }

    public void fillData() {
        if (this._payload != null) {
            this.btnDisableOn.setSelection(this._payload.isDisableOnConnectedStandby());
            this.btnSensitivity.setSelection(!this._payload.isDisableOnConnectedStandby());
            this.spnSensitivity.setEnabled(!this._payload.isDisableOnConnectedStandby());
            this.spnSensitivity.setSelection(this._payload.getSensitivityOnConnectedStandby() == 65535 ? 0 : this._payload.getSensitivityOnConnectedStandby());
            this.cspnTabletModeAngle.setSelection(this._payload.getTabletModeAngle());
        }
        this._properties.setModified(false);
    }

    public void saveData() {
        HingeConfigurationPayload payload = this._payload;
        boolean newConfiguration = false;
        if (payload == null) {
            payload = new HingeConfigurationPayload();
            newConfiguration = true;
        }
        payload.setDisableOnConnectedStandby(this.btnDisableOn.getSelection());
        payload.setSensitivityOnConnectedStandby(this.spnSensitivity.isEnabled() ? this.spnSensitivity.getSelection() : 65535);
        payload.setTabletModeAngle(this.cspnTabletModeAngle.getSelection());
        this._payload = payload;
        if (newConfiguration) {
            this._parent.addNewConfiguration(this._payload);
        }
        this._properties.setModified(false);
        this._parent.setModified();
        this.shlHinge.close();
    }

    protected void createContents() {
        int longSpinnerMinWidth;
        this.shlHinge = new Shell(65632);
        this.shlHinge.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent arg0) {
                if (HingeConfiguration.this._properties.isModified()) {
                    MessageBox messageBox = new MessageBox(HingeConfiguration.this.shlHinge, 296);
                    messageBox.setText("Closing The Configuration Window");
                    messageBox.setMessage("Some changes will be lost. Are you sure that you want to continue?");
                    if (messageBox.open() != 32) {
                        arg0.doit = false;
                        return;
                    }
                }
            }
        });
        this.shlHinge.setImage(SWTResourceManager.getImage(HingeConfiguration.class, "/resources/Intel.ico"));
        this.shlHinge.setText("Hinge Configuration");
        this.shlHinge.setLayout((Layout)new GridLayout(2, false));
        Group grpFlags = new Group((Composite)this.shlHinge, 0);
        grpFlags.setLayoutData((Object)new GridData(4, 0x1000000, true, true, 2, 1));
        grpFlags.setText("Connected Standby");
        grpFlags.setLayout((Layout)new GridLayout(3, false));
        this.btnDisableOn = new Button((Composite)grpFlags, 16);
        this.btnDisableOn.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 3, 1));
        this.btnDisableOn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HingeConfiguration.this._properties.setModified(true);
            }
        });
        this.btnDisableOn.setToolTipText("While in Connected Standby mode, disable the accelerometer that reports to this sensor, to save on power consumption.");
        this.btnDisableOn.setText("Disable accelerometer");
        this.btnSensitivity = new Button((Composite)grpFlags, 16);
        this.btnSensitivity.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 1, 1));
        this.btnSensitivity.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HingeConfiguration.this.spnSensitivity.setEnabled(HingeConfiguration.this.btnSensitivity.getSelection());
                HingeConfiguration.this._properties.setModified(true);
            }
        });
        this.btnSensitivity.setToolTipText("While in Connected Standby mode, change the sensitivity of the accelerometer that reports to this sensor, to save on power consumption.");
        this.btnSensitivity.setText("Change accelerometer sensitivity to");
        this.btnSensitivity.setSelection(false);
        this.spnSensitivity = new CustomSpinner((Composite)grpFlags, 2048, this.shlHinge);
        this.spnSensitivity.setMinimum(0);
        this.spnSensitivity.setMaximum(4000);
        this.spnSensitivity.setToolTipText("Enter the sensitivity of the accelerometer, in mg0.");
        this.spnSensitivity.setSelection(0);
        this.spnSensitivity.setEnabled(false);
        GridData gd_spnSensitivity = new GridData(4, 0x1000000, false, false, 1, 1);
        gd_spnSensitivity.widthHint = GuiUtils.getButtonWidth((Control)this.shlHinge) / 2;
        this.spnSensitivity.setLayoutData(gd_spnSensitivity);
        this.spnSensitivity.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                HingeConfiguration.this._properties.setModified(true);
            }
        });
        Label lblAfterSensitivity = new Label((Composite)grpFlags, 0);
        lblAfterSensitivity.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblAfterSensitivity.setToolTipText("While in Connected Standby mode, change the sensitivity of the accelerometer that reports to this sensor, to save on power consumption.");
        lblAfterSensitivity.setText("mg0");
        lblAfterSensitivity.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent arg0) {
                HingeConfiguration.this.btnDisableOn.setSelection(!HingeConfiguration.this.btnDisableOn.getSelection());
                HingeConfiguration.this.btnSensitivity.setSelection(!HingeConfiguration.this.btnSensitivity.getSelection());
                HingeConfiguration.this.spnSensitivity.setEnabled(HingeConfiguration.this.btnSensitivity.getSelection());
                HingeConfiguration.this._properties.setModified(true);
            }
        });
        Group grpTablet = GuiUtils.addGroupToComposite("", (Composite)this.shlHinge, 0, 4, 0x1000000, true, true, 2, 1, 2);
        GuiUtils.addLabelToComposite("Tablet mode angle:", (Composite)grpTablet, 0, 4, 0x1000000, true, true, 1, 1);
        this.cspnTabletModeAngle = GuiUtils.addCustomSpinnerToComposite(360, this.shlHinge, (Composite)grpTablet, 2048, 4, 0x1000000, true, true, 1, 1);
        this.cspnTabletModeAngle.setSelection(360);
        Button btnSaveAndClose = new Button((Composite)this.shlHinge, 0);
        GridData gd_btnSaveAndClose = new GridData(131072, 0x1000000, true, false, 1, 1);
        gd_btnSaveAndClose.widthHint = GuiUtils.getButtonWidth((Control)this.shlHinge);
        btnSaveAndClose.setLayoutData((Object)gd_btnSaveAndClose);
        btnSaveAndClose.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                HingeConfiguration.this.saveData();
            }
        });
        btnSaveAndClose.setText("Save and Close");
        Button btnCancel = new Button((Composite)this.shlHinge, 0);
        GridData gd_btnCancel = new GridData(4, 0x1000000, false, false, 1, 1);
        gd_btnCancel.widthHint = GuiUtils.getButtonWidth((Control)this.shlHinge);
        btnCancel.setLayoutData((Object)gd_btnCancel);
        btnCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                HingeConfiguration.this.shlHinge.close();
            }
        });
        btnCancel.setText("Cancel");
        ((GridData)this.cspnTabletModeAngle.getLayoutData()).minimumWidth = longSpinnerMinWidth = (int)((double)GuiUtils.getButtonWidth((Control)this.shlHinge) * 1.5);
        this.shlHinge.setSize(this.shlHinge.computeSize(-1, -1));
        this.shlHinge.setLocation(GuiUtils.getMiddleLocation(this.shlHinge, this.display));
    }
}

