/*
 * Decompiled with CFR 0.152.
 */
package pdtEditor.gui.configuration;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wb.swt.SWTResourceManager;
import pdtEditor.DataStore;
import pdtEditor.InformationStore;
import pdtEditor.PdtFile;
import pdtEditor.Sensor;
import pdtEditor.gui.GuiUtils;
import pdtEditor.gui.InterruptsModifierOpener;
import pdtEditor.gui.SensorModifier;
import pdtEditor.gui.configuration.LidModeConfigurationModifier;
import pdtEditor.payloads.Payload;
import pdtEditor.payloads.configurations.HumanPresenceConfigurationPayload;
import pdtEditor.payloads.configurations.LidModeConfigurationPayload;
import resources.CustomSpinner;

public class HumanPresenceConfiguration
implements InterruptsModifierOpener {
    protected Shell shell;
    private Display display;
    private SensorModifier parent;
    private boolean _modified = false;
    private DataStore _dataStore;
    private InformationStore infoStore = null;
    private HumanPresenceConfigurationPayload _payload;
    private ArrayList<Integer> modeIdList = new ArrayList();
    private static String wakeOnPresenceAttentiveTooltip = "Determines whether the ISH will wake the system when a face is present and attentive or just when any face is detected, even if not attentive.";
    private static String wakeOnPresenceMinNoTooltip = "Specifies the amount of Not Present time that must transpire before the ISH will assert the user is no longer present.  Used to avoid spurious system wakes and re-authentication attempts.";
    private static String wakeOnPresenceUserTooltip = "Specifies the maximum required distance of the closest face (primary user) before the ISH will initiate a system wake.";
    private static String wakeOnFaceBbxSizeTooltip = "Specifies the minimum width of bounding box that can wake on face.";
    private static String wakeOnMotionUsingIshTooltip = "Specifies whether the ISH should employ the Time of Flight [ToF] sensor as the Wake on Motion [WoM] source.  If selected, and a ToF is present, the ISH will arm the ToF and place CVF into a non-WoM PAUSE state during S0ix entry.  Otherwise the ISH will arm CVF for WoM.";
    private static String livenessThresholdTooltip = "Specifies the threshold that is used to detect the face liveness to provide the basic ability to differentiate between real humans and counterfeits such as photos, statues, etc. that may reside in the imaging sensor\u2019s field of view.";
    CustomSpinner spnWakeDistance;
    CustomSpinner spnWakeOnPresenceMinNo;
    CustomSpinner spnWakeOnPresenceUser;
    CustomSpinner spnWakeOnFaceBbxSize;
    CustomSpinner spnLiveDetectThreshold;
    CustomSpinner spnHingeLow;
    CustomSpinner spnHingeHigh;
    Button chkPlmModeIdGroup;
    Button chkWakeOnPresenceAttentive;
    Button chkWakeOnMotionUsingIsh;
    Button chkWake;
    Group grpPlmModeId;
    private static final int DEFAULT_PLM_ROW_CONTROL_COUNT = 6;
    private static final int DEFAULT_PLM_ROW_COUNT = 1;

    public static void main(String[] args) {
        try {
            HumanPresenceConfiguration window = new HumanPresenceConfiguration(null, null, null);
            PdtFile pdtFile = new PdtFile("");
            pdtFile.setPath(null);
            DataStore.getInstance().addPdtFile(pdtFile);
            window.open();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void open() {
        this.display = Display.getDefault();
        this.createContents();
        try {
            this.infoStore = InformationStore.getInstance();
        }
        catch (Exception e) {
            MessageBox messageBox = new MessageBox(this.shell, 513);
            messageBox.setText("Cannot load file");
            messageBox.setMessage("Cannot load the sensor definitions file - the file is missing or damaged. Aborting.");
            messageBox.open();
            return;
        }
        this.fillData();
        this.shell.open();
        this.shell.layout();
        while (!this.shell.isDisposed()) {
            if (this.display.readAndDispatch()) continue;
            this.display.sleep();
        }
    }

    public HumanPresenceConfiguration(SensorModifier parentWindow, HumanPresenceConfigurationPayload payload, Sensor sensor) {
        this.parent = parentWindow;
        this._payload = payload;
        this._dataStore = DataStore.getInstance();
        this.modeIdList = this.getSupportPlmModeIds();
    }

    protected void createContents() {
        this.shell = new Shell(65760);
        this.shell.setImage(SWTResourceManager.getImage(LidModeConfigurationModifier.class, "/resources/Intel.ico"));
        this.shell.setText("Human Presence Configuration");
        this.shell.setLayout((Layout)new GridLayout(1, false));
        Composite cmpWake = GuiUtils.addCompositeToComposite((Composite)this.shell, 4, 16384, 0x1000000, false, false, 1, 1, 1);
        FormLayout cmpWakeLayout = new FormLayout();
        cmpWake.setLayout((Layout)cmpWakeLayout);
        this.chkWake = new Button(cmpWake, 32);
        this.chkWake.setText("Wake");
        this.chkWake.setSelection(true);
        FormData frmChkDataWake = new FormData();
        this.chkWake.setLayoutData((Object)frmChkDataWake);
        frmChkDataWake.left = new FormAttachment();
        frmChkDataWake.left.offset = 8;
        this.chkWake.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!HumanPresenceConfiguration.this.chkWake.getSelection()) {
                    HumanPresenceConfiguration.this.spnWakeDistance.setSelection(1000);
                    HumanPresenceConfiguration.this.spnWakeOnPresenceMinNo.setSelection(5000);
                    HumanPresenceConfiguration.this.spnWakeOnPresenceUser.setSelection(2000);
                    HumanPresenceConfiguration.this.spnWakeOnFaceBbxSize.setSelection(20);
                    HumanPresenceConfiguration.this.chkWakeOnPresenceAttentive.setSelection(HumanPresenceConfigurationPayload.WAKE_ON_PRESENCE_ATTENTIVE);
                    HumanPresenceConfiguration.this.chkWakeOnMotionUsingIsh.setSelection(HumanPresenceConfigurationPayload.WAKE_ON_MOTION_USING_ISH);
                }
                HumanPresenceConfiguration.this.spnWakeDistance.setEnabled(HumanPresenceConfiguration.this.chkWake.getSelection());
                HumanPresenceConfiguration.this.spnWakeOnPresenceMinNo.setEnabled(HumanPresenceConfiguration.this.chkWake.getSelection());
                HumanPresenceConfiguration.this.spnWakeOnPresenceUser.setEnabled(HumanPresenceConfiguration.this.chkWake.getSelection());
                HumanPresenceConfiguration.this.spnWakeOnFaceBbxSize.setEnabled(HumanPresenceConfiguration.this.chkWake.getSelection());
                HumanPresenceConfiguration.this.chkWakeOnPresenceAttentive.setEnabled(HumanPresenceConfiguration.this.chkWake.getSelection());
                HumanPresenceConfiguration.this.chkWakeOnMotionUsingIsh.setEnabled(HumanPresenceConfiguration.this.chkWake.getSelection());
            }
        });
        Group grpWake = new Group(cmpWake, 4);
        FormData frmDataGrpWake = new FormData();
        GridLayout grpWakeLayout = new GridLayout(3, false);
        grpWake.setLayout((Layout)grpWakeLayout);
        grpWake.setLayoutData((Object)frmDataGrpWake);
        GuiUtils.addLabelToComposite("Wake Distance", (Composite)grpWake, 4, 16384, 0x1000000, false, false, 1, 1);
        this.spnWakeDistance = GuiUtils.addCustomSpinnerToComposite(2000, this.shell, (Composite)grpWake, 2048, 16384, 0x1000000, false, false, 1, 1);
        this.spnWakeDistance.setMinimum(1);
        this.spnWakeDistance.setSelection(1000);
        GuiUtils.addLabelToComposite("mm", (Composite)grpWake, 4, 16384, 0x1000000, false, false, 1, 1);
        GuiUtils.addLabelToComposite("Wake On Presence Min No Presence", (Composite)grpWake, 4, 16384, 0x1000000, false, false, 1, 1);
        this.spnWakeOnPresenceMinNo = GuiUtils.addCustomSpinnerToComposite(5000, this.shell, (Composite)grpWake, 2048, 16384, 0x1000000, false, false, 1, 1);
        this.spnWakeOnPresenceMinNo.setMinimum(1);
        this.spnWakeOnPresenceMinNo.setSelection(5000);
        this.spnWakeOnPresenceMinNo.setToolTipText(wakeOnPresenceMinNoTooltip);
        GuiUtils.addLabelToComposite("ms", (Composite)grpWake, 4, 16384, 0x1000000, false, false, 1, 1);
        GuiUtils.addLabelToComposite("Wake On Presence User Distance", (Composite)grpWake, 4, 16384, 0x1000000, false, false, 1, 1);
        this.spnWakeOnPresenceUser = GuiUtils.addCustomSpinnerToComposite(5000, this.shell, (Composite)grpWake, 2048, 16384, 0x1000000, false, false, 1, 1);
        this.spnWakeOnPresenceUser.setMinimum(1);
        this.spnWakeOnPresenceUser.setSelection(2000);
        this.spnWakeOnPresenceUser.setToolTipText(wakeOnPresenceUserTooltip);
        GuiUtils.addLabelToComposite("mm", (Composite)grpWake, 4, 16384, 0x1000000, false, false, 1, 1);
        GuiUtils.addLabelToComposite("Wake On Face BBX Size", (Composite)grpWake, 4, 16384, 0x1000000, false, false, 1, 1);
        this.spnWakeOnFaceBbxSize = GuiUtils.addCustomSpinnerToComposite(320, this.shell, (Composite)grpWake, 2048, 16384, 0x1000000, false, false, 1, 1);
        this.spnWakeOnFaceBbxSize.setMinimum(0);
        this.spnWakeOnFaceBbxSize.setSelection(20);
        this.spnWakeOnFaceBbxSize.setToolTipText(wakeOnFaceBbxSizeTooltip);
        GuiUtils.addLabelToComposite("pixel", (Composite)grpWake, 4, 16384, 0x1000000, false, false, 1, 1);
        this.chkWakeOnPresenceAttentive = GuiUtils.addButtonToComposite("Wake On Presence Attentive", wakeOnPresenceAttentiveTooltip, (Composite)grpWake, 32, 16384, 0x1000000, false, false, 1, 1);
        this.chkWakeOnPresenceAttentive.setSelection(HumanPresenceConfigurationPayload.WAKE_ON_PRESENCE_ATTENTIVE);
        this.chkWakeOnMotionUsingIsh = GuiUtils.addButtonToComposite("Wake On Motion Using ISH", wakeOnMotionUsingIshTooltip, (Composite)grpWake, 32, 16384, 0x1000000, false, false, 2, 1);
        this.chkWakeOnMotionUsingIsh.setSelection(HumanPresenceConfigurationPayload.WAKE_ON_MOTION_USING_ISH);
        Group grpHingeAngle = GuiUtils.addGroupToComposite("Hinge Angle", (Composite)this.shell, 4, 16384, 0x1000000, false, false, 1, 1, 2);
        GuiUtils.addLabelToComposite("Low", (Composite)grpHingeAngle, 4, 16384, 0x1000000, false, false, 1, 1);
        this.spnHingeLow = GuiUtils.addCustomSpinnerToComposite(360, this.shell, (Composite)grpHingeAngle, 2048, 16384, 0x1000000, true, true, 1, 1);
        GuiUtils.addLabelToComposite("High", (Composite)grpHingeAngle, 4, 16384, 0x1000000, false, false, 1, 1);
        this.spnHingeHigh = GuiUtils.addCustomSpinnerToComposite(360, this.shell, (Composite)grpHingeAngle, 2048, 16384, 0x1000000, true, true, 1, 1);
        this.spnHingeHigh.setSelection(360);
        Composite cmpPlmModelId = new Composite((Composite)this.shell, 4);
        FormLayout cmpPlmModeIdLayout = new FormLayout();
        cmpPlmModelId.setLayout((Layout)cmpPlmModeIdLayout);
        cmpPlmModelId.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.chkPlmModeIdGroup = new Button(cmpPlmModelId, 32);
        this.chkPlmModeIdGroup.setText("PLM Mode ID");
        FormData formData = new FormData();
        this.chkPlmModeIdGroup.setLayoutData((Object)formData);
        formData.left = new FormAttachment();
        formData.left.offset = 8;
        this.grpPlmModeId = new Group(cmpPlmModelId, 4);
        FormData grpPlmModeIdGroupData = new FormData();
        GridLayout plmModeIdGroupLayout = new GridLayout(6, true);
        plmModeIdGroupLayout.verticalSpacing = 15;
        plmModeIdGroupLayout.horizontalSpacing = 15;
        this.grpPlmModeId.setLayout((Layout)plmModeIdGroupLayout);
        if (this.modeIdList == null || this.modeIdList.size() == 0) {
            this.chkPlmModeIdGroup.setSelection(false);
            this.chkPlmModeIdGroup.setEnabled(false);
            Button tempButton = new Button(cmpPlmModelId, 32);
            tempButton.setText("1");
            tempButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
            grpPlmModeIdGroupData.width = 6 * tempButton.computeSize((int)-1, (int)-1).x + plmModeIdGroupLayout.horizontalSpacing * 6 + 2 * plmModeIdGroupLayout.marginWidth;
            grpPlmModeIdGroupData.height = 1 * tempButton.computeSize((int)-1, (int)-1).y + plmModeIdGroupLayout.verticalSpacing * 1 + 2 * plmModeIdGroupLayout.marginHeight;
            tempButton.dispose();
        } else {
            if (this.modeIdList.size() < 6) {
                Button tempButton = new Button(cmpPlmModelId, 32);
                tempButton.setText("1");
                tempButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
                grpPlmModeIdGroupData.width = 6 * tempButton.computeSize((int)-1, (int)-1).x + plmModeIdGroupLayout.horizontalSpacing * 6 + 2 * plmModeIdGroupLayout.marginWidth;
                tempButton.dispose();
            }
            this.chkPlmModeIdGroup.setSelection(true);
            for (int i = 0; i < this.modeIdList.size(); ++i) {
                Button addBtn = new Button((Composite)this.grpPlmModeId, 32);
                addBtn.setText(this.modeIdList.get(i).toString());
                addBtn.setData((Object)(1 << this.modeIdList.get(i)));
                addBtn.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
            }
        }
        this.grpPlmModeId.setLayoutData((Object)grpPlmModeIdGroupData);
        this.chkPlmModeIdGroup.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!HumanPresenceConfiguration.this.chkPlmModeIdGroup.getSelection()) {
                    HumanPresenceConfiguration.this.setSubCheckboxSelection((Composite)HumanPresenceConfiguration.this.grpPlmModeId, false);
                    HumanPresenceConfiguration.this.setChildrenEnable((Composite)HumanPresenceConfiguration.this.grpPlmModeId, false);
                } else {
                    HumanPresenceConfiguration.this.setChildrenEnable((Composite)HumanPresenceConfiguration.this.grpPlmModeId, true);
                }
            }
        });
        Group grpLiveness = GuiUtils.addGroupToComposite("", (Composite)this.shell, 4, 16384, 0x1000000, false, false, 1, 1, 3);
        GuiUtils.addLabelToComposite("Liveness Detection Threshold", (Composite)grpLiveness, 4, 16384, 0x1000000, false, false, 1, 1);
        this.spnLiveDetectThreshold = GuiUtils.addCustomSpinnerToComposite(5000, this.shell, (Composite)grpLiveness, 2048, 16384, 0x1000000, false, false, 1, 1);
        this.spnLiveDetectThreshold.setMinimum(0);
        this.spnLiveDetectThreshold.setSelection(5);
        this.spnLiveDetectThreshold.setToolTipText(livenessThresholdTooltip);
        GuiUtils.addLabelToComposite("pixel", (Composite)grpLiveness, 4, 16384, 0x1000000, true, false, 1, 1);
        Composite cmpsOkCancel = new Composite((Composite)this.shell, 0);
        cmpsOkCancel.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.horizontalSpacing = 10;
        gridLayout.verticalSpacing = 10;
        cmpsOkCancel.setLayout((Layout)gridLayout);
        Button btnOk = new Button(cmpsOkCancel, 0);
        GridData gd_btnOk = new GridData(131072, 0x1000000, true, false, 1, 1);
        btnOk.setLayoutData((Object)gd_btnOk);
        gd_btnOk.widthHint = GuiUtils.getButtonWidth((Control)this.shell);
        btnOk.setText("OK");
        btnOk.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HumanPresenceConfiguration.this.save();
            }
        });
        Button btnCancel = new Button(cmpsOkCancel, 0);
        GridData gd_btnCancel = new GridData(4, 0x1000000, false, false, 1, 1);
        btnCancel.setLayoutData((Object)gd_btnCancel);
        gd_btnCancel.widthHint = GuiUtils.getButtonWidth((Control)this.shell);
        btnCancel.setText("Cancel");
        btnCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HumanPresenceConfiguration.this.shell.close();
            }
        });
        grpHingeAngle.computeSize(-1, -1);
        int shortSpinnerMinWidth = (int)((double)GuiUtils.getButtonWidth((Control)this.shell) * 0.75);
        int longSpinnerMinWidth = (int)((double)GuiUtils.getButtonWidth((Control)this.shell) * 1.5);
        ((GridData)this.spnWakeDistance.getLayoutData()).widthHint = shortSpinnerMinWidth;
        ((GridData)this.spnWakeOnPresenceMinNo.getLayoutData()).widthHint = shortSpinnerMinWidth;
        ((GridData)this.spnWakeOnPresenceUser.getLayoutData()).widthHint = shortSpinnerMinWidth;
        ((GridData)this.spnWakeOnFaceBbxSize.getLayoutData()).widthHint = shortSpinnerMinWidth;
        ((GridData)this.spnHingeLow.getLayoutData()).widthHint = longSpinnerMinWidth;
        ((GridData)this.spnHingeHigh.getLayoutData()).widthHint = longSpinnerMinWidth;
        ((GridData)this.spnLiveDetectThreshold.getLayoutData()).widthHint = shortSpinnerMinWidth;
        int groupMaxWidth = Math.max(grpWake.computeSize((int)-1, (int)-1).x, this.grpPlmModeId.computeSize((int)-1, (int)-1).x);
        groupMaxWidth = Math.max(groupMaxWidth, grpHingeAngle.computeSize((int)-1, (int)-1).x);
        groupMaxWidth = Math.max(groupMaxWidth, grpLiveness.computeSize((int)-1, (int)-1).x);
        grpLiveness.computeSize(-1, -1);
        grpPlmModeIdGroupData.width = groupMaxWidth;
        frmDataGrpWake.width = groupMaxWidth;
        ((GridData)grpHingeAngle.getLayoutData()).widthHint = groupMaxWidth;
        ((GridData)grpLiveness.getLayoutData()).widthHint = groupMaxWidth;
        this.shell.setSize(this.shell.computeSize(-1, -1));
        this.shell.setLocation(GuiUtils.getMiddleLocation(this.shell, this.display));
    }

    public void fillData() {
        if (this._payload == null) {
            return;
        }
        this.spnWakeDistance.setSelection(this._payload.wakeDistance);
        this.chkWake.setSelection(this._payload.wakeEnable);
        this.chkWake.notifyListeners(13, new Event());
        this.spnHingeLow.setSelection(this._payload.hingeAngleLow);
        this.spnHingeHigh.setSelection(this._payload.hingeAngleHigh);
        if (this._payload.plmModeId == -1) {
            this.chkPlmModeIdGroup.setSelection(false);
            this.chkPlmModeIdGroup.notifyListeners(13, new Event());
        } else {
            this.chkPlmModeIdGroup.setSelection(true);
            this.setChildrenCheckboxBySelectedData((Composite)this.grpPlmModeId, this._payload.plmModeId);
        }
        this.chkWakeOnPresenceAttentive.setSelection(this._payload.wakeOnPresenceAttentive);
        this.chkWakeOnMotionUsingIsh.setSelection(this._payload.wakeOnMotionUsingIsh);
        this.spnWakeOnPresenceMinNo.setSelection(this._payload.wakeOnPresenceMinNoPresence);
        this.spnWakeOnPresenceUser.setSelection(this._payload.wakeOnPresenceUserDistance);
        this.spnWakeOnFaceBbxSize.setSelection(this._payload.wakeOnFaceBbxDistance);
        this.spnLiveDetectThreshold.setSelection(this._payload.livenessDetectionThreshold);
    }

    public void save() {
        boolean newConfiguration = false;
        if (this._payload == null) {
            this._payload = new HumanPresenceConfigurationPayload();
            newConfiguration = true;
        }
        this._payload.wakeEnable = this.chkWake.getSelection();
        this._payload.wakeDistance = this._payload.wakeEnable ? this.spnWakeDistance.getSelection() : 1000;
        this._payload.hingeAngleHigh = this.spnHingeHigh.getSelection();
        this._payload.hingeAngleLow = this.spnHingeLow.getSelection();
        this._payload.plmModeId = this.getChildrenCheckboxSelectedDataAsInt((Composite)this.grpPlmModeId);
        this._payload.wakeOnPresenceMinNoPresence = this.spnWakeOnPresenceMinNo.getSelection();
        this._payload.wakeOnPresenceUserDistance = this.spnWakeOnPresenceUser.getSelection();
        this._payload.wakeOnFaceBbxDistance = this.spnWakeOnFaceBbxSize.getSelection();
        this._payload.wakeOnMotionUsingIsh = this.chkWakeOnMotionUsingIsh.getSelection();
        this._payload.wakeOnPresenceAttentive = this.chkWakeOnPresenceAttentive.getSelection();
        this._payload.livenessDetectionThreshold = this.spnLiveDetectThreshold.getSelection();
        if (newConfiguration && this.parent != null) {
            this.parent.addNewConfiguration(this._payload);
        }
        this._modified = false;
        if (this.parent != null) {
            this.parent.setModified();
        }
        this.shell.close();
    }

    public void setChildrenCheckboxBySelectedData(Composite parentControl, int data) {
        Control[] child = parentControl.getChildren();
        boolean ret = false;
        for (Control control : child) {
            if (control.getClass() != Button.class || (control.getStyle() & 0x20) <= 0) continue;
            int bitValue = (Integer)control.getData();
            if ((bitValue & data) > 0) {
                ((Button)control).setSelection(true);
                continue;
            }
            ((Button)control).setSelection(false);
        }
    }

    public int getChildrenCheckboxSelectedDataAsInt(Composite parentControl) {
        Control[] child = parentControl.getChildren();
        int ret = 0;
        for (Control control : child) {
            if (control.getClass() != Button.class || (control.getStyle() & 0x20) <= 0 && (control.getStyle() & 0x10) <= 0 || !((Button)control).getSelection()) continue;
            int value = (Integer)control.getData();
            ret |= value;
        }
        if (ret == 0) {
            ret = -1;
        }
        return ret;
    }

    public void setSubCheckboxSelection(Composite parentControl, boolean selection) {
        Control[] child;
        for (Control control : child = parentControl.getChildren()) {
            if (control.getClass() != Button.class || (control.getStyle() & 0x20) <= 0 && (control.getStyle() & 0x10) <= 0) continue;
            ((Button)control).setSelection(selection);
        }
    }

    public void setChildrenEnable(Composite parentControl, boolean isEnabled) {
        Control[] child;
        for (Control control : child = parentControl.getChildren()) {
            if (!(control instanceof Button) || (control.getStyle() & 0x20) <= 0 && (control.getStyle() & 0x10) <= 0) continue;
            control.setEnabled(isEnabled);
        }
    }

    public ArrayList<Integer> getSupportPlmModeIds() {
        ArrayList<Payload> payloads = null;
        ArrayList<LidModeConfigurationPayload.TableEntry> tableEntries = null;
        ArrayList<Integer> supportPlmModeIds = new ArrayList<Integer>();
        if (this._dataStore.getCurrentDevice() == null) {
            return supportPlmModeIds;
        }
        ArrayList<Sensor> sensors = this._dataStore.getCurrentDevice().getSensors();
        for (Sensor sensor : sensors) {
            if (sensor.getLuid().getSensorTypeId() != 768) continue;
            payloads = sensor.getPayloads();
            break;
        }
        if (payloads == null) {
            return supportPlmModeIds;
        }
        for (Payload payload : payloads) {
            if (payload.getClass() != LidModeConfigurationPayload.class) continue;
            tableEntries = ((LidModeConfigurationPayload)payload).getTableEntries();
            break;
        }
        if (tableEntries == null) {
            return supportPlmModeIds;
        }
        for (LidModeConfigurationPayload.TableEntry entry : tableEntries) {
            supportPlmModeIds.add(entry.modeId);
        }
        return supportPlmModeIds;
    }

    @Override
    public int getGpioCount() {
        return 0;
    }

    @Override
    public int[] getGpioSelectionIndices() {
        return null;
    }

    @Override
    public HashMap<String, String> getLineValues(int lineIndex) {
        return null;
    }

    @Override
    public void addGpioToTable(String purposeID, String pinNumber, String modelGpio) {
    }

    @Override
    public void updateGpioLine(int lineIndex, HashMap<String, String> values) {
    }

    @Override
    public Shell getShell() {
        return null;
    }

    @Override
    public void setModified() {
    }
}

