/*
 * Decompiled with CFR 0.152.
 */
package pdtEditor.gui.configuration;

import java.util.ArrayList;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.wb.swt.SWTResourceManager;
import pdtEditor.gui.GuiUtils;
import pdtEditor.gui.configuration.LidModeConfiguration;
import pdtEditor.payloads.configurations.LidModeConfigurationPayload;
import resources.CustomSpinner;

public class LidModeConfigurationModifier {
    private static final int ANGLE_MAXIMAL_VALUE = 360;
    protected Shell shlEditConfigurationValues;
    private Display display;
    private LidModeConfiguration _parent;
    private TableItem _currentItem = null;
    ArrayList<LidModeConfigurationPayload.PlmHallConfig> _hallConfigs = null;
    ArrayList<Combo> _hallConfigComboList = new ArrayList();
    private CustomSpinner mode;
    private CustomSpinner entryAngle;
    private CustomSpinner t1Delta;
    private CustomSpinner exitAngle;
    private CustomSpinner t2Delta;
    private CustomSpinner Th;
    private CustomSpinner lcdDirection;
    private Label lblTDelta;
    private Label lblTh;
    private Label lblTh_1;
    private Label lblLcdDirection;
    private Label lblModeId;
    private Label lblEntryAngle;
    private Label lblExitAngle;
    private static final int MIN_MODE_VALUE = 1;

    public static void main(String[] args) {
        try {
            LidModeConfigurationModifier window = new LidModeConfigurationModifier(null, null, null);
            window.open();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public LidModeConfigurationModifier(LidModeConfiguration parent, TableItem currentItem, ArrayList<LidModeConfigurationPayload.PlmHallConfig> hallConfigs) {
        this._parent = parent;
        this._currentItem = currentItem;
        this._hallConfigs = hallConfigs;
    }

    public void open() {
        this.display = Display.getDefault();
        this.createContents();
        this.fillData();
        this.shlEditConfigurationValues.open();
        this.shlEditConfigurationValues.layout();
        while (!this.shlEditConfigurationValues.isDisposed()) {
            if (this.display.readAndDispatch()) continue;
            this.display.sleep();
        }
    }

    public void fillData() {
        if (this._currentItem == null) {
            return;
        }
        this.mode.setSelection(Integer.valueOf(this._currentItem.getText(0)));
        this.entryAngle.setSelection(Integer.valueOf(this._currentItem.getText(1)));
        this.exitAngle.setSelection(Integer.valueOf(this._currentItem.getText(2)));
        this.t1Delta.setSelection(Integer.valueOf(this._currentItem.getText(3)));
        this.t2Delta.setSelection(Integer.valueOf(this._currentItem.getText(4)));
        this.Th.setSelection(Integer.valueOf(this._currentItem.getText(5)));
        this.lcdDirection.setSelection(Integer.valueOf(this._currentItem.getText(6)));
        for (int i = 0; i < this._hallConfigComboList.size(); ++i) {
            for (int j = 0; j < this._hallConfigComboList.get(i).getItemCount(); ++j) {
                if (!this._hallConfigComboList.get(i).getItem(j).equals(this._currentItem.getText(7 + i))) continue;
                this._hallConfigComboList.get(i).select(j);
            }
        }
    }

    public void save() {
        if (this.entryAngle.getSelection() > this.exitAngle.getSelection()) {
            MessageBox messageBox = new MessageBox(this.shlEditConfigurationValues, 513);
            messageBox.setText("Invalid Angle Values");
            messageBox.setMessage("The entry angle's value cannot be higher than the exit angle's value.");
            messageBox.open();
            return;
        }
        ArrayList<String> temp = new ArrayList<String>();
        temp.add(this.mode.getText());
        temp.add(this.entryAngle.getText());
        temp.add(this.exitAngle.getText());
        temp.add(this.t1Delta.getText());
        temp.add(this.t2Delta.getText());
        temp.add(this.Th.getText());
        temp.add(this.lcdDirection.getText());
        for (int i = 0; i < this._hallConfigComboList.size(); ++i) {
            temp.add(this._hallConfigComboList.get(i).getText());
        }
        String[] data = new String[]{};
        data = temp.toArray(data);
        try {
            this._parent.checkNewConfiguration(data);
        }
        catch (Exception e) {
            MessageBox messageBox = new MessageBox(this.shlEditConfigurationValues, 513);
            messageBox.setText("Invalid Configuration");
            messageBox.setMessage(e.getMessage());
            messageBox.open();
            return;
        }
        if (this._currentItem == null) {
            this._parent.addConfigurationLine(data);
        } else {
            this._currentItem.setText(data);
        }
        this._parent.setModified();
        this.shlEditConfigurationValues.close();
    }

    protected void createContents() {
        this.shlEditConfigurationValues = new Shell(65760);
        this.shlEditConfigurationValues.setImage(SWTResourceManager.getImage(LidModeConfigurationModifier.class, "/resources/Intel.ico"));
        this.shlEditConfigurationValues.setText("Edit Configuration Values");
        this.shlEditConfigurationValues.setLayout((Layout)new GridLayout(2, false));
        Group group = new Group((Composite)this.shlEditConfigurationValues, 0);
        group.setLayout((Layout)new GridLayout(2, false));
        group.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.lblModeId = new Label((Composite)group, 0);
        this.lblModeId.setText("Mode ID:");
        this.mode = new CustomSpinner((Composite)group, 2048, this.shlEditConfigurationValues);
        this.mode.setMinimum(1);
        this.mode.setMaximum((int)Math.pow(2.0, 8.0) - 1);
        GridData gd_mode = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_mode.widthHint = GuiUtils.getButtonWidth((Control)this.shlEditConfigurationValues) * 3 / 2;
        this.mode.setLayoutData(gd_mode);
        this.lblEntryAngle = new Label((Composite)group, 0);
        this.lblEntryAngle.setText("Entry Angle:");
        this.entryAngle = new CustomSpinner((Composite)group, 2048, this.shlEditConfigurationValues);
        this.entryAngle.setMaximum(360);
        GridData gd_entryAngle = new GridData(4, 0x1000000, true, false, 1, 1);
        this.entryAngle.setLayoutData(gd_entryAngle);
        this.lblExitAngle = new Label((Composite)group, 0);
        this.lblExitAngle.setText("Exit Angle:");
        this.exitAngle = new CustomSpinner((Composite)group, 2048, this.shlEditConfigurationValues);
        this.exitAngle.setMaximum(360);
        GridData gd_exitAngle = new GridData(4, 0x1000000, true, false, 1, 1);
        this.exitAngle.setLayoutData(gd_exitAngle);
        this.lblTDelta = new Label((Composite)group, 0);
        this.lblTDelta.setText("Entry Angle Tolerance:");
        this.t1Delta = new CustomSpinner((Composite)group, 2048, this.shlEditConfigurationValues);
        this.t1Delta.setMaximum(360);
        GridData gd_t1Delta = new GridData(4, 0x1000000, true, false, 1, 1);
        this.t1Delta.setLayoutData(gd_t1Delta);
        this.lblTh = new Label((Composite)group, 0);
        this.lblTh.setText("Exit Angle Tolerance:");
        this.t2Delta = new CustomSpinner((Composite)group, 2048, this.shlEditConfigurationValues);
        this.t2Delta.setMaximum(360);
        GridData gd_t2Delta = new GridData(4, 0x1000000, true, false, 1, 1);
        this.t2Delta.setLayoutData(gd_t2Delta);
        this.lblTh_1 = new Label((Composite)group, 0);
        this.lblTh_1.setText("Time Hysteresis:");
        this.Th = new CustomSpinner((Composite)group, 2048, this.shlEditConfigurationValues);
        this.Th.setMaximum((int)Math.pow(2.0, 16.0) - 1);
        GridData gd_Th = new GridData(4, 0x1000000, true, false, 1, 1);
        this.Th.setLayoutData(gd_Th);
        this.lblLcdDirection = new Label((Composite)group, 0);
        this.lblLcdDirection.setText("LCD Direction:");
        this.lcdDirection = new CustomSpinner((Composite)group, 2048, this.shlEditConfigurationValues);
        this.lcdDirection.setMaximum(5);
        GridData gd_lcdDirection = new GridData(4, 0x1000000, true, false, 1, 1);
        this.lcdDirection.setLayoutData(gd_lcdDirection);
        for (int i = 0; i < this._hallConfigs.size(); ++i) {
            String headText = this._hallConfigs.get((int)i).sensorName + "(" + this._hallConfigs.get((int)i).instanceId + "):";
            GuiUtils.addLabelToComposite(headText, (Composite)group, 4, 16384, 0x1000000, true, false, 1, 1);
            Combo cboHallConfig = GuiUtils.addComboToComposite((Composite)group, 8, 4, 0x1000000, true, false, 1, 1);
            cboHallConfig.add("Inactive");
            cboHallConfig.add("Active");
            cboHallConfig.add("Not Applicable");
            cboHallConfig.select(2);
            this._hallConfigComboList.add(cboHallConfig);
        }
        Button btnOk = new Button((Composite)this.shlEditConfigurationValues, 0);
        GridData gd_btnOk = new GridData(131072, 0x1000000, true, false, 1, 1);
        gd_btnOk.widthHint = GuiUtils.getButtonWidth((Control)this.shlEditConfigurationValues);
        btnOk.setLayoutData((Object)gd_btnOk);
        btnOk.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                LidModeConfigurationModifier.this.save();
            }
        });
        btnOk.setText("OK");
        Button btnCancel = new Button((Composite)this.shlEditConfigurationValues, 0);
        GridData gd_btnCancel = new GridData(4, 0x1000000, false, false, 1, 1);
        gd_btnCancel.widthHint = GuiUtils.getButtonWidth((Control)this.shlEditConfigurationValues);
        btnCancel.setLayoutData((Object)gd_btnCancel);
        btnCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                LidModeConfigurationModifier.this.shlEditConfigurationValues.close();
            }
        });
        btnCancel.setText("Cancel");
        this.shlEditConfigurationValues.setSize(this.shlEditConfigurationValues.computeSize(-1, -1));
        this.shlEditConfigurationValues.setLocation(GuiUtils.getMiddleLocation(this.shlEditConfigurationValues, this.display));
    }
}

