/*
 * Decompiled with CFR 0.152.
 */
package pdtEditor.gui.configuration;

import java.util.ArrayList;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.wb.swt.SWTResourceManager;
import pdtEditor.InformationStore;
import pdtEditor.gui.GuiUtils;
import pdtEditor.gui.configuration.LidModeActionModifier;
import pdtEditor.gui.configuration.LidModeConfiguration;
import pdtEditor.payloads.configurations.LidModeConfigurationPayload;
import resources.CustomSpinner;

public class LidModeHallConfiguration {
    protected Shell shell;
    private Display display;
    private LidModeConfiguration _parent;
    private TableItem _currentItem = null;
    private InformationStore infoStore = null;
    private int _selectedIndex;
    Combo cboSensorType;
    CustomSpinner cspnInstanceId;

    public static void main(String[] args) {
        try {
            LidModeHallConfiguration window = new LidModeHallConfiguration(null, null, 0);
            window.open();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public LidModeHallConfiguration(LidModeConfiguration parent, TableItem currentItem, int index) {
        this._parent = parent;
        this._currentItem = currentItem;
        this._selectedIndex = index;
    }

    public void open() {
        this.display = Display.getDefault();
        try {
            this.infoStore = InformationStore.getInstance();
        }
        catch (Exception e) {
            MessageBox messageBox = new MessageBox(this.shell, 513);
            messageBox.setText("Cannot load file");
            messageBox.setMessage("Cannot load the sensor definitions file - the file is missing or damaged. Aborting.");
            messageBox.open();
            return;
        }
        this.createContents();
        this.fillData();
        this.shell.open();
        this.shell.layout();
        while (!this.shell.isDisposed()) {
            if (this.display.readAndDispatch()) continue;
            this.display.sleep();
        }
    }

    public void fillData() {
        if (this._currentItem == null) {
            return;
        }
        for (int i = 0; i < this.cboSensorType.getItemCount(); ++i) {
            if (!this.cboSensorType.getItem(i).equals(this._currentItem.getText(0))) continue;
            this.cboSensorType.select(i);
        }
        this.cspnInstanceId.setSelection(Integer.valueOf(this._currentItem.getText(1)));
    }

    public void save() {
        if (this.cboSensorType.getText().length() == 0) {
            GuiUtils.ShowErrorMessage(this.shell, "Sensor type Is Missing", "The 'Sensor Type' field has not been set");
            return;
        }
        try {
            this._parent.checkHallConfigValues(Integer.valueOf(this.cspnInstanceId.getText()), this.cboSensorType.getText());
        }
        catch (Exception e) {
            GuiUtils.ShowErrorMessage(this.shell, "Value Mismatch", e.getMessage());
            return;
        }
        if (this._currentItem == null) {
            this._parent.addHallConfig(Integer.valueOf(this.cspnInstanceId.getText()), this.cboSensorType.getText());
        } else {
            this._parent.editHallConfig(Integer.valueOf(this.cspnInstanceId.getText()), this.cboSensorType.getText(), this._selectedIndex);
        }
        this._parent.setModified();
        this.shell.close();
    }

    protected void createContents() {
        int longSpinnerMinWidth;
        this.shell = new Shell(65760);
        this.shell.setImage(SWTResourceManager.getImage(LidModeActionModifier.class, "/resources/Intel.ico"));
        this.shell.setText("Edit Hall Configuration");
        this.shell.setLayout((Layout)new GridLayout(2, false));
        Group group = new Group((Composite)this.shell, 0);
        group.setLayout((Layout)new GridLayout(2, false));
        group.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        GuiUtils.addLabelToComposite("Sensor Type:", (Composite)group, 4, 16384, 0x1000000, true, false, 1, 1);
        this.cboSensorType = GuiUtils.addComboToComposite((Composite)group, 8, 4, 0x1000000, true, false, 1, 1);
        GuiUtils.addLabelToComposite("Instance ID:", (Composite)group, 4, 16384, 0x1000000, true, false, 1, 1);
        this.cspnInstanceId = GuiUtils.addCustomSpinnerToComposite(Integer.MAX_VALUE, this.shell, (Composite)group, 2048, 4, 0x1000000, true, false, 1, 1);
        this.cspnInstanceId.setMinimum(0);
        ArrayList<LidModeConfigurationPayload.PlmSupportSensorType> supportSensorTypes = this.infoStore.getAllPlmSupportSensorTypes();
        for (LidModeConfigurationPayload.PlmSupportSensorType supportSensorType : supportSensorTypes) {
            this.cboSensorType.add(supportSensorType.sensorName);
        }
        Button btnOk = new Button((Composite)this.shell, 0);
        GridData gd_btnOk = new GridData(131072, 4, true, false, 1, 1);
        gd_btnOk.widthHint = GuiUtils.getButtonWidth((Control)this.shell);
        btnOk.setLayoutData((Object)gd_btnOk);
        btnOk.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                LidModeHallConfiguration.this.save();
            }
        });
        btnOk.setText("OK");
        Button btnCancel = new Button((Composite)this.shell, 0);
        GridData gd_btnCancel = new GridData(131072, 0x1000000, false, false, 1, 1);
        gd_btnCancel.widthHint = GuiUtils.getButtonWidth((Control)this.shell);
        btnCancel.setLayoutData((Object)gd_btnCancel);
        btnCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                LidModeHallConfiguration.this.shell.close();
            }
        });
        btnCancel.setText("Cancel");
        ((GridData)this.cboSensorType.getLayoutData()).minimumWidth = longSpinnerMinWidth = (int)((double)GuiUtils.getButtonWidth((Control)this.shell) * 1.5);
        ((GridData)this.cspnInstanceId.getLayoutData()).minimumWidth = longSpinnerMinWidth;
        this.shell.setSize(this.shell.computeSize(-1, -1));
        this.shell.setLocation(GuiUtils.getMiddleLocation(this.shell, this.display));
    }
}

