/*
 * Decompiled with CFR 0.152.
 */
package pdtEditor.payloads;

import binTools.BinReader;
import binTools.BinWriter;
import binTools.Common;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import pdtEditor.InformationStore;
import pdtEditor.Sensor;
import pdtEditor.payloads.BusPayloadI2c;
import pdtEditor.payloads.BusPayloadI3c;
import pdtEditor.payloads.BusPayloadSpi;
import pdtEditor.payloads.BusPayloadUart;
import pdtEditor.payloads.Payload;
import pdtEditor.validation.Validator;

public abstract class BusPayload
implements Payload {
    public static final int BUS_INSTANCE_FIELD_SIZE = 1;
    public static final int BUS_ADDRESS_FIELD_SIZE = 1;
    public static final int BUS_INSTANCE_FIELD_MAX_VALUE = (int)Math.pow(2.0, 8.0) - 1;
    public static final int BUS_ADDRESS_FIELD_MAX_VALUE = 255;
    public static final int INFO_ID = 0;
    public static final int GALILEO_BUS_INSTANCE = 0;
    public static final int SIMICS_BUS_INSTANCE = 1;
    private int _busType;
    private int _busIndex;
    private int _busAddress;
    private int _busSpeed;

    public BusPayload(int busType, int busIndex, int busAddress, int busSpeed) {
        this._busType = busType;
        this._busIndex = busIndex;
        this._busAddress = busAddress;
        this._busSpeed = busSpeed;
    }

    public static BusPayload newBusPayload(BinReader reader, Element payloadXmlNode) {
        int busType = reader.readNewField((String)"BusType", (int)1, (boolean)false, (Node)payloadXmlNode).value;
        switch (busType) {
            case 0: {
                return new BusPayloadI2c(reader, payloadXmlNode);
            }
            case 1: {
                return new BusPayloadUart(reader, payloadXmlNode);
            }
            case 2: {
                return new BusPayloadSpi(reader, payloadXmlNode);
            }
            case 3: {
                return new BusPayloadI3c(reader, payloadXmlNode);
            }
        }
        throw new UnsupportedOperationException("Invalid bus type value.");
    }

    protected BusPayload(BinReader reader, Element payloadXmlNode) {
        this._busIndex = reader.readNewField((String)"BusIndex", (int)1, (boolean)false, (Node)payloadXmlNode).value;
        this._busAddress = reader.readNewField((String)"BusAddress", (int)1, (boolean)false, (Node)payloadXmlNode).value;
        this._busSpeed = reader.readNewField((String)"BusSpeed", (int)1, (boolean)false, (Node)payloadXmlNode).value;
    }

    public BusPayload(BusPayload other) {
        this._busType = other._busType;
        this._busIndex = other._busIndex;
        this._busAddress = other._busAddress;
        this._busSpeed = other._busSpeed;
    }

    @Override
    public boolean equals(Object arg0) {
        if (arg0 == null || !(arg0 instanceof BusPayload)) {
            return false;
        }
        BusPayload other = (BusPayload)arg0;
        return this._busType == other._busType && this._busIndex == other._busIndex && this._busSpeed == other._busSpeed && this._busAddress == other._busAddress;
    }

    @Override
    public abstract BusPayload clone();

    @Override
    public void writeToPdt(BinWriter writer, Element parent) {
        writer.addComment("Bus Information", parent);
        writer.writeNewField("InfoId", 1, 0, (Node)parent);
        writer.writeNewField("Reserved", 1, 0, (Node)parent);
        Common.Field payloadDataLength = writer.writeNewField("DataLength", 2, 0, (Node)parent);
        writer.addSizeCounter(payloadDataLength);
        this.writeBusData(writer, parent);
        writer.removeSizeCounter(payloadDataLength);
    }

    public void writeFirstBusFields(BinWriter writer, Element parent) {
        writer.writeNewField("BusType", 1, this._busType, (Node)parent);
        writer.writeNewField("BusIndex", 1, this._busIndex, (Node)parent);
        writer.writeNewField("BusAddress", 1, this._busAddress, (Node)parent);
        writer.writeNewField("BusSpeed", 1, this._busSpeed, (Node)parent);
    }

    public abstract void writeBusData(BinWriter var1, Element var2);

    public int getBusType() {
        return this._busType;
    }

    public String getBusTypeName() {
        try {
            return InformationStore.getInstance().getBusTypeName(this._busType);
        }
        catch (Exception e) {
            return String.valueOf(this._busType);
        }
    }

    public void setBusType(int busType) {
        this._busType = busType;
    }

    public int getBusIndex() {
        return this._busIndex;
    }

    public void setBusIndex(int busIndex) {
        this._busIndex = busIndex;
    }

    public int getBusAddress() {
        return this._busAddress;
    }

    public String getHexBusAddress() {
        return Integer.toHexString(this._busAddress);
    }

    public String getFormatedHexBusAddress() {
        return "0x" + this.getHexBusAddress();
    }

    public void setBusAddress(int busAddress) {
        this._busAddress = busAddress;
    }

    public void setHexBusAddress(String busAddressHex) {
        try {
            int value = Integer.parseInt(busAddressHex, 16);
            if (value < 0 || value > 255) {
                throw new NumberFormatException();
            }
            this._busAddress = value;
        }
        catch (NumberFormatException e) {
            throw new NumberFormatException("The bus address must be a hexadecimal number in the range [0, " + Integer.toHexString(255) + "].");
        }
    }

    public int getBusSpeed() {
        return this._busSpeed;
    }

    public void setBusSpeed(int busSpeed) {
        this._busSpeed = busSpeed;
    }

    public abstract boolean isEnableRtsCts();

    public abstract boolean isCsNative();

    public abstract int getCsPin();

    public abstract boolean isIbiEnable();

    public abstract int getIbiPurpose();

    @Override
    public void checkValidity(Validator validator, Sensor sensor) {
    }

    public int hashCode() {
        return super.hashCode();
    }
}

