/*
 * Decompiled with CFR 0.152.
 */
package pdtEditor.payloads;

import binTools.BinReader;
import binTools.BinWriter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import pdtEditor.payloads.BusPayload;

public class BusPayloadI3c
extends BusPayload {
    public static final int BUS_TYPE = 3;
    public static final int DYNAMIC_ADDRESS_SIZE = 6;
    public static final String DYNAMIC_ADDRESS_PATTERN = "^[\\da-fA-F]{12}$";
    private int _addressType;
    private String _dynamicAddress = "000000000000";
    private boolean _ibiEnable = false;
    private int _ibiPurpose = 0;

    public BusPayloadI3c(int busIndex, int busAddress, int busSpeed, int addressType, String dynamicAddress, boolean ibiEnable, int ibiPurpose) throws Exception {
        super(3, busIndex, busAddress, busSpeed);
        Pattern pattern = Pattern.compile(DYNAMIC_ADDRESS_PATTERN);
        Matcher matcher = pattern.matcher(dynamicAddress);
        if (!matcher.matches()) {
            throw new Exception("The dynamic address must be 6 hexadecimal number in the range [0, " + Integer.toHexString(255) + "].");
        }
        this._addressType = addressType;
        this._dynamicAddress = dynamicAddress;
        this._ibiEnable = ibiEnable;
        this._ibiPurpose = ibiPurpose;
    }

    protected BusPayloadI3c(BinReader reader, Element payloadXmlNode) {
        super(reader, payloadXmlNode);
        this.setBusType(3);
        this._addressType = reader.readNewField((String)"AddressType", (int)1, (boolean)false, (Node)payloadXmlNode).value;
        byte[] dynamicAddressArray = reader.readBytes(6, "DynamicAddress", payloadXmlNode);
        for (int i = 0; i < dynamicAddressArray.length / 2; ++i) {
            byte temp = dynamicAddressArray[i];
            dynamicAddressArray[i] = dynamicAddressArray[dynamicAddressArray.length - i - 1];
            dynamicAddressArray[dynamicAddressArray.length - i - 1] = temp;
        }
        this._dynamicAddress = BinWriter.bytesToHex(dynamicAddressArray);
        this._ibiEnable = reader.readNewField((String)"IbiEnable", (int)1, (boolean)false, (Node)payloadXmlNode).value == 1;
        this._ibiPurpose = reader.readNewField((String)"IbiPurpose", (int)1, (boolean)false, (Node)payloadXmlNode).value;
    }

    public BusPayloadI3c(BusPayloadI3c other) {
        super(other);
        this._addressType = other._addressType;
        this._dynamicAddress = other._dynamicAddress;
        this._ibiEnable = other._ibiEnable;
        this._ibiPurpose = other._ibiPurpose;
    }

    @Override
    public void writeBusData(BinWriter writer, Element parent) {
        byte[] dynamicAddressBytes = BusPayloadI3c.convertHexStringToBytes(this._dynamicAddress);
        for (int i = 0; i < dynamicAddressBytes.length / 2; ++i) {
            byte temp = dynamicAddressBytes[i];
            dynamicAddressBytes[i] = dynamicAddressBytes[dynamicAddressBytes.length - i - 1];
            dynamicAddressBytes[dynamicAddressBytes.length - i - 1] = temp;
        }
        this.writeFirstBusFields(writer, parent);
        this.setBusType(3);
        writer.writeNewField("AddressType", 1, this._addressType, (Node)parent);
        writer.writerBinaryField("DynamicAddress", dynamicAddressBytes, parent);
        writer.writeNewField("IbiEnable", 1, this._ibiEnable ? 1 : 0, (Node)parent);
        writer.writeNewField("IbiPurpose", 1, this._ibiPurpose, (Node)parent);
    }

    public static byte[] convertHexStringToBytes(String hex) {
        byte[] rtnData = new byte[hex.length() / 2];
        for (int i = 0; i < rtnData.length; ++i) {
            rtnData[i] = (byte)(Character.digit(hex.charAt(i * 2), 16) << 4 | Character.digit(hex.charAt(i * 2 + 1), 16));
        }
        return rtnData;
    }

    @Override
    public BusPayload clone() {
        return new BusPayloadI3c(this);
    }

    @Override
    public boolean equals(Object arg0) {
        if (arg0 == null || !(arg0 instanceof BusPayloadI3c)) {
            return false;
        }
        BusPayloadI3c other = (BusPayloadI3c)arg0;
        if (!(this._dynamicAddress == null && other._dynamicAddress == null || this._dynamicAddress != null && this._dynamicAddress.equals(other._dynamicAddress))) {
            return false;
        }
        return super.equals(other) && this._addressType == other._addressType && this._ibiEnable == other._ibiEnable && this._ibiPurpose == other._ibiPurpose;
    }

    @Override
    public boolean isEnableRtsCts() {
        return false;
    }

    @Override
    public boolean isCsNative() {
        return false;
    }

    @Override
    public int getCsPin() {
        return 0;
    }

    public void setAddressType(int addressType) {
        this._addressType = addressType;
    }

    public void setDynamicAddress(String dynamicAddress) {
        Pattern pattern = Pattern.compile(DYNAMIC_ADDRESS_PATTERN);
        Matcher matcher = pattern.matcher(dynamicAddress);
        if (!matcher.matches()) {
            throw new RuntimeException("The dynamic address must be 6 hexadecimal numbers in the range [0, " + Integer.toHexString(255) + "].");
        }
        this._dynamicAddress = dynamicAddress;
    }

    public int getAddressType() {
        return this._addressType;
    }

    public String getDynamicAddress() {
        return this._dynamicAddress;
    }

    @Override
    public boolean isIbiEnable() {
        return this._ibiEnable;
    }

    public void setIbiEnable(boolean ibiEnable) {
        this._ibiEnable = ibiEnable;
    }

    @Override
    public int getIbiPurpose() {
        return this._ibiPurpose;
    }

    public void setIbiPurpose(int ibiPurpose) {
        this._ibiPurpose = ibiPurpose;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

