/*
 * Decompiled with CFR 0.152.
 */
package pdtEditor.payloads.calibrations;

import binTools.BinWriter;
import java.io.File;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import pdtEditor.DataStore;
import pdtEditor.Luid;
import pdtEditor.payloads.Payload;

public abstract class CalibrationPayload
implements Payload {
    public static final int INFO_ID = 2;
    public static final int FORMAT_ID_FIELD_SIZE = 1;
    public static final int FORMAT_ID_MAX_VALUE = (int)Math.pow(2.0, 8.0) - 1;
    public static final int VERSION_FIELD_SIZE = 1;
    public static final int VERSION_MAX_VALUE = (int)Math.pow(2.0, 8.0) - 1;
    public static final int CUSTOM_RANGE_MIN_FORMATID = 128;
    public static final int CALIBRATION_TYPE = 0;
    public static final int CONFIGURATION_TYPE = 1;
    private static Document _calibrationDefFile = null;

    public CalibrationPayload() {
    }

    public CalibrationPayload(CalibrationPayload other) {
    }

    public CalibrationPayload(Node payloadXmlNode) {
    }

    @Override
    public abstract CalibrationPayload clone();

    public abstract String getCalibrationFormatString();

    public abstract String getCalibrationDataString();

    @Override
    public void writeToPdt(BinWriter writer, Element parent) {
        writer.addComment("Calibration", parent);
        writer.writeNewField("InfoId", 1, 2, (Node)parent);
        writer.writeNewField("Reserved", 1, 0, (Node)parent);
    }

    public static ArrayList<PayloadFormatInfo> getCalibrationType(Luid luid, int formatId, boolean ignorePdtFormat) {
        ArrayList<Integer> supportedFormatIds = null;
        if (formatId >= 0) {
            supportedFormatIds = new ArrayList<Integer>();
            supportedFormatIds.add(formatId);
        }
        return CalibrationPayload.getCalibrationType(luid, supportedFormatIds, ignorePdtFormat);
    }

    public static ArrayList<PayloadFormatInfo> getCalibrationType(Luid luid, ArrayList<Integer> supportedFormatIds, boolean ignorePdtFormat) {
        ArrayList<PayloadFormatInfo> res = new ArrayList<PayloadFormatInfo>();
        try {
            Element rootElement;
            if (_calibrationDefFile == null) {
                DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
                File srcXmlFile = new File("calibration_definitions.xml");
                _calibrationDefFile = dBuilder.parse(srcXmlFile);
            }
            if (!(rootElement = _calibrationDefFile.getDocumentElement()).getNodeName().equals("ish")) {
                throw new Exception("Currupted calibration definitions XML file");
            }
            NodeList sections = rootElement.getChildNodes();
            for (int i = 0; i < sections.getLength(); ++i) {
                int dataType;
                Node section = sections.item(i);
                if (!(section instanceof Element)) continue;
                Element sectionElement = (Element)section;
                String sectionName = sectionElement.getAttribute("type");
                if (sectionName.equals("Calibrations")) {
                    dataType = 0;
                } else if (sectionName.equals("Configurations")) {
                    dataType = 1;
                } else {
                    throw new Exception("Unrecognized section type name: " + sectionName);
                }
                NodeList nodes = section.getChildNodes();
                for (int j = 0; j < nodes.getLength(); ++j) {
                    NamedNodeMap attributes = nodes.item(j).getAttributes();
                    if (attributes == null) continue;
                    int sensorType = Integer.valueOf(attributes.getNamedItem("sensorType").getTextContent());
                    int physical = Integer.valueOf(attributes.getNamedItem("physical").getTextContent());
                    int calibratedFlag = -1;
                    int formatidVal = Integer.valueOf(attributes.getNamedItem("formatid").getTextContent());
                    int minPdtFormat = 0;
                    if (!ignorePdtFormat && attributes.getNamedItem("minPdtFormat") != null) {
                        minPdtFormat = Integer.valueOf(attributes.getNamedItem("minPdtFormat").getTextContent());
                    }
                    if (attributes.getNamedItem("calibratedFlag") != null) {
                        calibratedFlag = Integer.valueOf(attributes.getNamedItem("calibratedFlag").getTextContent());
                    }
                    if (DataStore.getInstance().getPdtFormatVersion() < minPdtFormat || sensorType != luid.getSensorTypeId() || physical == 1 != luid.getIsPhysical() || calibratedFlag != -1 && calibratedFlag == 1 != luid.getIsCalibrated() || supportedFormatIds != null && !supportedFormatIds.contains(formatidVal)) continue;
                    Node modelIdAtt = attributes.getNamedItem("modelID");
                    if (modelIdAtt != null) {
                        String modelId = attributes.getNamedItem("modelID").getTextContent();
                        boolean modelIsDifferentThanGiven = false;
                        if (modelId != null) {
                            int modelIdVal;
                            if (modelId.startsWith("~")) {
                                modelIdVal = Integer.valueOf(modelId.substring(1));
                                modelIsDifferentThanGiven = true;
                            } else {
                                modelIdVal = Integer.valueOf(modelId);
                            }
                            if (!modelIsDifferentThanGiven == (luid.getSensorSubTypeId() != modelIdVal)) continue;
                        }
                    }
                    int newFormat = Integer.valueOf(nodes.item(j).getTextContent());
                    boolean skipCurrFormat = false;
                    for (PayloadFormatInfo formatInfo : res) {
                        if (formatInfo.dataType != dataType || formatInfo.format != newFormat) continue;
                        skipCurrFormat = true;
                        break;
                    }
                    if (skipCurrFormat) continue;
                    res.add(new PayloadFormatInfo(dataType, newFormat));
                }
            }
        }
        catch (Exception e) {
            String errorText = "Error while trying to determaine the calibration type of a sensor. . Sensor Type = " + luid.getSensorTypeId() + "  isPhysical=" + luid.getIsPhysical() + (supportedFormatIds != null ? " formatIds=" + supportedFormatIds : "") + ".";
            e.printStackTrace();
            Exception ex = new Exception(errorText);
            ex.setStackTrace(e.getStackTrace());
            throw new RuntimeException(ex);
        }
        res.add(new PayloadFormatInfo(0, 9999));
        return res;
    }

    public static class PayloadFormatInfo {
        public int dataType;
        public int format;

        public PayloadFormatInfo(int dataType, int format) {
            this.dataType = dataType;
            this.format = format;
        }
    }
}

