/*
 * Decompiled with CFR 0.152.
 */
package pdtEditor.payloads.calibrations;

import Jama.Matrix;
import binTools.BinReader;
import binTools.BinWriter;
import binTools.Common;
import java.util.ArrayList;
import java.util.HashMap;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import pdtEditor.CalibrationParser;
import pdtEditor.DataStore;
import pdtEditor.Sensor;
import pdtEditor.exceptions.FeatureNotSupportedYetException;
import pdtEditor.gui.calibration.GeneralCalibrationEditor;
import pdtEditor.payloads.calibrations.CalibrationPayload;
import pdtEditor.validation.Fixer;
import pdtEditor.validation.Issue;
import pdtEditor.validation.Validator;

public class GeneralCalibrationPayload
extends CalibrationPayload {
    public static final int CALIBRATION_TYPE = 0;
    public static final int LATEST_FORMAT_ID = 0;
    public static final String CALIBRATION_FORMAT_STRING = "Intel 3D Motion Sensor Calibration";
    private static final String CALIBRATION_DATA_STRING = "Relevant data";
    public static final int MATRIX_CELL_ABS_MAX_VALUE = 10;
    private static final double SCALE_FACTOR_SIZE = 2.0;
    private static final double SCALE_FACTOR_MAX_VALUE = Math.pow(2.0, 15.0) - 1.0;
    private int _version = 0;
    private int _formatID = 0;
    private HashMap<String, Integer> _offset = new HashMap();
    private HashMap<String, Integer> _matrix = new HashMap();
    private int _scaleFactor;
    private int _axisMapping;
    private HashMap<String, Integer> _axisMappingTable = new HashMap();
    private ArrayList<Byte> _vendorDefinedData = new ArrayList();

    public GeneralCalibrationPayload() {
    }

    public GeneralCalibrationPayload(GeneralCalibrationPayload other) {
        super(other);
        this._formatID = other._formatID;
        this._version = other._version;
        for (String key : other._offset.keySet()) {
            this._offset.put(key, other._offset.get(key));
        }
        for (String key : other._matrix.keySet()) {
            this._matrix.put(key, other._matrix.get(key));
        }
        this._scaleFactor = other._scaleFactor;
        this._axisMapping = other._axisMapping;
        for (String key : other._axisMappingTable.keySet()) {
            this._axisMappingTable.put(key, other._axisMappingTable.get(key));
        }
        for (Byte value : other._vendorDefinedData) {
            this._vendorDefinedData.add(value);
        }
    }

    public GeneralCalibrationPayload(int formatId, BinReader reader, Node payloadXmlNode) throws FeatureNotSupportedYetException {
        super(payloadXmlNode);
        byte[] venDefinedData;
        this._formatID = formatId;
        if (this._formatID > 0) {
            throw new FeatureNotSupportedYetException(this);
        }
        this._version = reader.readNewField((String)"Version", (int)1, (boolean)false, (Node)payloadXmlNode).value;
        Element scalingElement = reader.readNewField((String)"Scaling", (Node)payloadXmlNode).xmlElement;
        Element offsetElement = reader.readNewField((String)"Offset", (Node)scalingElement).xmlElement;
        this._offset.put("OffsetX", reader.readNewField((String)"OffsetX", (int)4, (boolean)true, (Node)offsetElement).value);
        this._offset.put("OffsetY", reader.readNewField((String)"OffsetY", (int)4, (boolean)true, (Node)offsetElement).value);
        this._offset.put("OffsetZ", reader.readNewField((String)"OffsetZ", (int)4, (boolean)true, (Node)offsetElement).value);
        Element matrixElement = reader.readNewField((String)"Matrix", (Node)scalingElement).xmlElement;
        this._matrix.put("Mat11", reader.readNewField((String)"Mat11", (int)2, (boolean)true, (Node)matrixElement).value);
        this._matrix.put("Mat12", reader.readNewField((String)"Mat12", (int)2, (boolean)true, (Node)matrixElement).value);
        this._matrix.put("Mat13", reader.readNewField((String)"Mat13", (int)2, (boolean)true, (Node)matrixElement).value);
        this._matrix.put("Mat21", reader.readNewField((String)"Mat21", (int)2, (boolean)true, (Node)matrixElement).value);
        this._matrix.put("Mat22", reader.readNewField((String)"Mat22", (int)2, (boolean)true, (Node)matrixElement).value);
        this._matrix.put("Mat23", reader.readNewField((String)"Mat23", (int)2, (boolean)true, (Node)matrixElement).value);
        this._matrix.put("Mat31", reader.readNewField((String)"Mat31", (int)2, (boolean)true, (Node)matrixElement).value);
        this._matrix.put("Mat32", reader.readNewField((String)"Mat32", (int)2, (boolean)true, (Node)matrixElement).value);
        this._matrix.put("Mat33", reader.readNewField((String)"Mat33", (int)2, (boolean)true, (Node)matrixElement).value);
        this.setScaleFactor(reader.readNewField((String)"ScaleFactor", (int)2, (boolean)true, (Node)matrixElement).value);
        Element axisMappingElement = reader.readNewField((String)"AxisMapping", (Node)scalingElement).xmlElement;
        this._axisMapping = reader.readNewField((String)"AxisMapping", (int)4, (boolean)true, (Node)axisMappingElement).value;
        this._axisMappingTable.put("XX", this.getAxisMappingValue(0));
        this._axisMappingTable.put("XY", this.getAxisMappingValue(1));
        this._axisMappingTable.put("XZ", this.getAxisMappingValue(2));
        this._axisMappingTable.put("YX", this.getAxisMappingValue(3));
        this._axisMappingTable.put("YY", this.getAxisMappingValue(4));
        this._axisMappingTable.put("YZ", this.getAxisMappingValue(5));
        this._axisMappingTable.put("ZX", this.getAxisMappingValue(6));
        this._axisMappingTable.put("ZY", this.getAxisMappingValue(7));
        this._axisMappingTable.put("ZZ", this.getAxisMappingValue(8));
        int vendorDefSize = reader.readNewField((String)"VendorDefinedSize", (int)2, (boolean)false, (Node)scalingElement).value;
        byte[] byArray = venDefinedData = reader.readBytes(vendorDefSize, "VendorDefinedData", scalingElement);
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            Byte b = byArray[i];
            this._vendorDefinedData.add(b);
        }
    }

    @Override
    public boolean equals(Object arg0) {
        if (arg0 == null || !(arg0 instanceof GeneralCalibrationPayload)) {
            return false;
        }
        GeneralCalibrationPayload other = (GeneralCalibrationPayload)arg0;
        return this._formatID == other._formatID && this._version == other._version && (this._offset == null && other._offset == null || this._offset != null && this._offset.equals(other._offset)) && (this._matrix == null && other._matrix == null || this._matrix != null && this._matrix.equals(other._matrix)) && this._scaleFactor == other._scaleFactor && this._axisMapping == other._axisMapping && (this._axisMappingTable == null && other._axisMappingTable == null || this._axisMappingTable != null && this._axisMappingTable.equals(other._axisMappingTable)) && (this._vendorDefinedData == null && other._vendorDefinedData == null || this._vendorDefinedData != null && this._vendorDefinedData.equals(other._vendorDefinedData));
    }

    @Override
    public GeneralCalibrationPayload clone() {
        return new GeneralCalibrationPayload(this);
    }

    @Override
    public void writeToPdt(BinWriter writer, Element parent) {
        super.writeToPdt(writer, parent);
        Common.Field payloadDataLength = writer.writeNewField("DataLength", 2, 0, (Node)parent);
        writer.addSizeCounter(payloadDataLength);
        writer.writeNewField("FormatId", 1, this._formatID, (Node)parent);
        writer.writeNewField("Version", 1, this._version, (Node)parent);
        Element scalingElement = writer.writeNewField((String)"Scaling", (Node)parent).xmlElement;
        Element offsetElement = writer.writeNewField((String)"Offset", (Node)scalingElement).xmlElement;
        writer.writeNewField("OffsetX", 4, this._offset.getOrDefault("OffsetX", 0), (Node)offsetElement);
        writer.writeNewField("OffsetY", 4, this._offset.getOrDefault("OffsetY", 0), (Node)offsetElement);
        writer.writeNewField("OffsetZ", 4, this._offset.getOrDefault("OffsetZ", 0), (Node)offsetElement);
        Element matrixElement = writer.writeNewField((String)"Matrix", (Node)scalingElement).xmlElement;
        writer.writeNewField("Mat11", 2, this._matrix.getOrDefault("Mat11", 0), (Node)matrixElement);
        writer.writeNewField("Mat12", 2, this._matrix.getOrDefault("Mat12", 0), (Node)matrixElement);
        writer.writeNewField("Mat13", 2, this._matrix.getOrDefault("Mat13", 0), (Node)matrixElement);
        writer.writeNewField("Mat21", 2, this._matrix.getOrDefault("Mat21", 0), (Node)matrixElement);
        writer.writeNewField("Mat22", 2, this._matrix.getOrDefault("Mat22", 0), (Node)matrixElement);
        writer.writeNewField("Mat23", 2, this._matrix.getOrDefault("Mat23", 0), (Node)matrixElement);
        writer.writeNewField("Mat31", 2, this._matrix.getOrDefault("Mat31", 0), (Node)matrixElement);
        writer.writeNewField("Mat32", 2, this._matrix.getOrDefault("Mat32", 0), (Node)matrixElement);
        writer.writeNewField("Mat33", 2, this._matrix.getOrDefault("Mat33", 0), (Node)matrixElement);
        writer.writeNewField("ScaleFactor", 2, this._scaleFactor, (Node)matrixElement);
        Element axisMappingElement = writer.writeNewField((String)"AxisMapping", (Node)scalingElement).xmlElement;
        writer.writeNewField("AxisMapping", 4, this._axisMapping, (Node)axisMappingElement);
        writer.addComment("XX=" + this._axisMappingTable.getOrDefault("XX", 0), axisMappingElement);
        writer.addComment("XY=" + this._axisMappingTable.getOrDefault("XY", 0), axisMappingElement);
        writer.addComment("XZ=" + this._axisMappingTable.getOrDefault("XZ", 0), axisMappingElement);
        writer.addComment("YX=" + this._axisMappingTable.getOrDefault("YX", 0), axisMappingElement);
        writer.addComment("YY=" + this._axisMappingTable.getOrDefault("YY", 0), axisMappingElement);
        writer.addComment("YZ=" + this._axisMappingTable.getOrDefault("YZ", 0), axisMappingElement);
        writer.addComment("ZX=" + this._axisMappingTable.getOrDefault("ZX", 0), axisMappingElement);
        writer.addComment("ZY=" + this._axisMappingTable.getOrDefault("ZY", 0), axisMappingElement);
        writer.addComment("ZZ=" + this._axisMappingTable.getOrDefault("ZZ", 0), axisMappingElement);
        writer.writeNewField("VendorDefinedSize", 2, this._vendorDefinedData.size(), (Node)parent);
        writer.writerBinaryField("VendorDefinedData", this._vendorDefinedData, parent);
        writer.removeSizeCounter(payloadDataLength);
    }

    public void setDataFromXalibrationXML(Element calibrationData) {
        Element axisMappingElement = (Element)DataStore.getChildNodeByName(calibrationData, "AxisMapping");
        HashMap<String, Integer> axisMappingTable = new HashMap<String, Integer>();
        try {
            axisMappingTable.put("XX", Integer.valueOf(DataStore.getChildNodeByName(axisMappingElement, "XX").getTextContent()));
            axisMappingTable.put("XY", Integer.valueOf(DataStore.getChildNodeByName(axisMappingElement, "XY").getTextContent()));
            axisMappingTable.put("XZ", Integer.valueOf(DataStore.getChildNodeByName(axisMappingElement, "XZ").getTextContent()));
            axisMappingTable.put("YX", Integer.valueOf(DataStore.getChildNodeByName(axisMappingElement, "YX").getTextContent()));
            axisMappingTable.put("YY", Integer.valueOf(DataStore.getChildNodeByName(axisMappingElement, "YY").getTextContent()));
            axisMappingTable.put("YZ", Integer.valueOf(DataStore.getChildNodeByName(axisMappingElement, "YZ").getTextContent()));
            axisMappingTable.put("ZX", Integer.valueOf(DataStore.getChildNodeByName(axisMappingElement, "ZX").getTextContent()));
            axisMappingTable.put("ZY", Integer.valueOf(DataStore.getChildNodeByName(axisMappingElement, "ZY").getTextContent()));
            axisMappingTable.put("ZZ", Integer.valueOf(DataStore.getChildNodeByName(axisMappingElement, "ZZ").getTextContent()));
        }
        catch (NumberFormatException e) {
            System.err.println("Corrupted axis mapping information");
            throw e;
        }
        this.setAxisMapping(axisMappingTable);
        Node matrixElement = DataStore.getChildNodeByName(calibrationData, "Matrix");
        try {
            this._matrix.put("Mat11", Integer.valueOf(DataStore.getChildNodeByName(matrixElement, "Mat11").getTextContent()));
            this._matrix.put("Mat12", Integer.valueOf(DataStore.getChildNodeByName(matrixElement, "Mat12").getTextContent()));
            this._matrix.put("Mat13", Integer.valueOf(DataStore.getChildNodeByName(matrixElement, "Mat13").getTextContent()));
            this._matrix.put("Mat21", Integer.valueOf(DataStore.getChildNodeByName(matrixElement, "Mat21").getTextContent()));
            this._matrix.put("Mat22", Integer.valueOf(DataStore.getChildNodeByName(matrixElement, "Mat22").getTextContent()));
            this._matrix.put("Mat23", Integer.valueOf(DataStore.getChildNodeByName(matrixElement, "Mat23").getTextContent()));
            this._matrix.put("Mat31", Integer.valueOf(DataStore.getChildNodeByName(matrixElement, "Mat31").getTextContent()));
            this._matrix.put("Mat32", Integer.valueOf(DataStore.getChildNodeByName(matrixElement, "Mat32").getTextContent()));
            this._matrix.put("Mat33", Integer.valueOf(DataStore.getChildNodeByName(matrixElement, "Mat33").getTextContent()));
            this.setScaleFactor(Integer.valueOf(DataStore.getChildNodeByName(matrixElement, "ScaleFactor").getTextContent()));
        }
        catch (NumberFormatException e) {
            System.err.println("Corrupted matrix information");
            throw e;
        }
        Node offsetElement = DataStore.getChildNodeByName(calibrationData, "Offset");
        try {
            this._offset.put("OffsetX", Integer.valueOf(DataStore.getChildNodeByName(offsetElement, "OffsetX").getTextContent()));
            this._offset.put("OffsetY", Integer.valueOf(DataStore.getChildNodeByName(offsetElement, "OffsetY").getTextContent()));
            this._offset.put("OffsetZ", Integer.valueOf(DataStore.getChildNodeByName(offsetElement, "OffsetZ").getTextContent()));
        }
        catch (NumberFormatException e) {
            System.err.println("Corrupted offset information");
            throw e;
        }
        if (calibrationData.getElementsByTagName("VendorData").getLength() > 0) {
            try {
                Element dataElement = (Element)DataStore.getChildNodeByName(calibrationData, "VendorData");
                if (dataElement != null) {
                    ArrayList<Byte> vendorData = CalibrationParser.getBinaryData(dataElement);
                    this._vendorDefinedData.clear();
                    for (Byte b : vendorData) {
                        this._vendorDefinedData.add(b);
                    }
                }
            }
            catch (Exception e) {
                System.err.println("Corrupted vendor data");
                throw new RuntimeException(e);
            }
        }
    }

    public static boolean isValidAxisMapping(Matrix matrix) {
        return !(matrix.norm1() > 1.0) && !(matrix.normInf() > 1.0);
    }

    public static boolean isValidScalingMatrix(Matrix matrix) {
        return !(matrix.det() <= 0.1);
    }

    public HashMap<String, Double> getFractionalMatrix() {
        HashMap<String, Double> matrix = new HashMap<String, Double>();
        double scaleFactor = this._scaleFactor != 0 ? (double)this._scaleFactor : 1.0;
        for (String key : this._matrix.keySet()) {
            matrix.put(key, (double)this._matrix.get(key).intValue() / scaleFactor);
        }
        return matrix;
    }

    public void setFractionalMatrix(HashMap<String, Double> matrix) {
        double maxAbsVal = -1.7976931348623157E308;
        for (String key : matrix.keySet()) {
            double value = Math.abs(matrix.get(key));
            if (!(value > maxAbsVal)) continue;
            maxAbsVal = value;
        }
        double divider = Math.max(1.0, maxAbsVal);
        this._scaleFactor = (int)Math.floor((SCALE_FACTOR_MAX_VALUE - divider / 2.0) / divider);
        for (String key : matrix.keySet()) {
            this._matrix.put(key, (int)Math.round(matrix.get(key) * (double)this._scaleFactor));
        }
    }

    private int getAxisMappingValue(int index) {
        int val = (this._axisMapping & 3 << index * 2) >> index * 2;
        if (val > 1) {
            return -1 * val % 2;
        }
        return val;
    }

    public HashMap<String, Integer> getOffset() {
        return this._offset;
    }

    public void setOffset(HashMap<String, Integer> offset) {
        this._offset = offset;
    }

    public HashMap<String, Integer> getMatrix() {
        return this._matrix;
    }

    public void setMatrix(HashMap<String, Integer> matrix) {
        this._matrix = matrix;
    }

    public HashMap<String, Integer> getAxisMappingTable() {
        return this._axisMappingTable;
    }

    public void setAxisMappingTable(HashMap<String, Integer> axisMappingTable) {
        this._axisMappingTable = axisMappingTable;
    }

    public int getScaleFactor() {
        return this._scaleFactor;
    }

    public void setScaleFactor(int scaleFactor) {
        this._scaleFactor = scaleFactor;
    }

    public int getAxisMapping() {
        return this._axisMapping;
    }

    public void setAxisMapping(int axisMapping) {
        String binaryStr = Integer.toBinaryString(axisMapping);
        this._axisMappingTable.put("XX", Integer.valueOf(binaryStr.substring(binaryStr.length() - 2, binaryStr.length())));
        this._axisMappingTable.put("XY", Integer.valueOf(binaryStr.substring(binaryStr.length() - 4, binaryStr.length() - 2)));
        this._axisMappingTable.put("XZ", Integer.valueOf(binaryStr.substring(binaryStr.length() - 6, binaryStr.length() - 4)));
        this._axisMappingTable.put("YX", Integer.valueOf(binaryStr.substring(binaryStr.length() - 8, binaryStr.length() - 6)));
        this._axisMappingTable.put("YY", Integer.valueOf(binaryStr.substring(binaryStr.length() - 10, binaryStr.length() - 8)));
        this._axisMappingTable.put("YZ", Integer.valueOf(binaryStr.substring(binaryStr.length() - 12, binaryStr.length() - 10)));
        this._axisMappingTable.put("ZX", Integer.valueOf(binaryStr.substring(binaryStr.length() - 14, binaryStr.length() - 12)));
        this._axisMappingTable.put("ZY", Integer.valueOf(binaryStr.substring(binaryStr.length() - 16, binaryStr.length() - 14)));
        this._axisMappingTable.put("ZZ", Integer.valueOf(binaryStr.substring(binaryStr.length() - 18, binaryStr.length() - 16)));
        this._axisMapping = axisMapping;
    }

    private String getValueOfAxisMapping(int value) {
        switch (value) {
            case 1: {
                return "01";
            }
            case 0: {
                return "00";
            }
            case -1: {
                return "11";
            }
        }
        throw new RuntimeException("Unxpected value of axis mapping bits");
    }

    public void setAxisMapping(HashMap<String, Integer> axisMappingTable) {
        String binaryStr = "";
        binaryStr = binaryStr + this.getValueOfAxisMapping(axisMappingTable.getOrDefault("ZZ", 0));
        binaryStr = binaryStr + this.getValueOfAxisMapping(axisMappingTable.getOrDefault("ZY", 0));
        binaryStr = binaryStr + this.getValueOfAxisMapping(axisMappingTable.getOrDefault("ZX", 0));
        binaryStr = binaryStr + this.getValueOfAxisMapping(axisMappingTable.getOrDefault("YZ", 0));
        binaryStr = binaryStr + this.getValueOfAxisMapping(axisMappingTable.getOrDefault("YY", 0));
        binaryStr = binaryStr + this.getValueOfAxisMapping(axisMappingTable.getOrDefault("YX", 0));
        binaryStr = binaryStr + this.getValueOfAxisMapping(axisMappingTable.getOrDefault("XZ", 0));
        binaryStr = binaryStr + this.getValueOfAxisMapping(axisMappingTable.getOrDefault("XY", 0));
        binaryStr = binaryStr + this.getValueOfAxisMapping(axisMappingTable.getOrDefault("XX", 0));
        this._axisMappingTable = axisMappingTable;
        this._axisMapping = Integer.parseInt(binaryStr, 2);
    }

    public ArrayList<Byte> getVendorDefinedData() {
        return this._vendorDefinedData;
    }

    public void setVendorDefinedData(ArrayList<Byte> vendorDefinedData) {
        this._vendorDefinedData = vendorDefinedData;
    }

    public int getVersion() {
        return this._version;
    }

    public void setVersion(int version) {
        this._version = version;
    }

    public int getFormatID() {
        return this._formatID;
    }

    public void setFormatID(int formatID) {
        this._formatID = formatID;
    }

    @Override
    public String getCalibrationFormatString() {
        return CALIBRATION_FORMAT_STRING;
    }

    @Override
    public String getCalibrationDataString() {
        return CALIBRATION_DATA_STRING;
    }

    @Override
    public void checkValidity(Validator validator, Sensor sensor) {
        double[][] axisMapMatrixValues;
        HashMap<String, Double> fractionValues;
        double[][] matrixValues;
        if (this._matrix != null && this._matrix.size() > 0 && !GeneralCalibrationPayload.isValidScalingMatrix(new Matrix((double[][])(matrixValues = new double[][]{{(fractionValues = this.getFractionalMatrix()).getOrDefault("Mat11", 0.0), fractionValues.getOrDefault("Mat12", 0.0), fractionValues.getOrDefault("Mat13", 0.0)}, {fractionValues.getOrDefault("Mat21", 0.0), fractionValues.getOrDefault("Mat22", 0.0), fractionValues.getOrDefault("Mat23", 0.0)}, {fractionValues.getOrDefault("Mat31", 0.0), fractionValues.getOrDefault("Mat32", 0.0), fractionValues.getOrDefault("Mat33", 0.0)}})))) {
            Issue issue = new Issue(Issue.IssueType.CRITICAL, sensor);
            issue.setMessage("The scaling and rotation matrix used in this sensor\u2019s calibration data is likely invalid.");
            issue.description = "This sensor uses an Intel-provided calibration format that makes use of the output of Intel\u2019s Calibration Tool to scale and rotate the sensor data. The values that you have provided could not have been outputted by the Calibration Tool, and will probably result in loss of data.";
            final GeneralCalibrationPayload thisObject = this;
            issue.fixer = new Fixer(sensor, issue){

                @Override
                public String getFixDescription() {
                    return "Double-click this issue to open the Calibration Modifier window, where you can input the correct matrix values.";
                }

                @Override
                public void fix() {
                    new GeneralCalibrationEditor(null, thisObject, this._sensor).open();
                }
            };
            validator.addIssue(issue);
        }
        if (this._axisMappingTable != null && this._axisMappingTable.size() > 0 && !GeneralCalibrationPayload.isValidAxisMapping(new Matrix((double[][])(axisMapMatrixValues = new double[][]{{this._axisMappingTable.get("XX").intValue(), this._axisMappingTable.get("XY").intValue(), this._axisMappingTable.get("XZ").intValue()}, {this._axisMappingTable.get("YX").intValue(), this._axisMappingTable.get("YY").intValue(), this._axisMappingTable.get("YZ").intValue()}, {this._axisMappingTable.get("ZX").intValue(), this._axisMappingTable.get("ZY").intValue(), this._axisMappingTable.get("ZZ").intValue()}})))) {
            Issue issue = new Issue(Issue.IssueType.CRITICAL, sensor);
            issue.setMessage("The axis mapping matrix used in this sensor\u2019s calibration data is not valid.");
            issue.description = "This sensor uses an Intel-provided calibration format that uses a matrix to map its axes to the correct orientation. Each row and column in this matrix must contain two elements equal to 0 and one element equal to 1 or -1. If the axis mapping is not corrected, you will lose sensor data.";
            final GeneralCalibrationPayload thisObject = this;
            issue.fixer = new Fixer(sensor, issue){

                @Override
                public String getFixDescription() {
                    return "Double-click this issue to open the Calibration Modifier window, where you can correct the matrix values.";
                }

                @Override
                public void fix() {
                    new GeneralCalibrationEditor(null, thisObject, this._sensor).open();
                }
            };
            validator.addIssue(issue);
        }
    }

    public int hashCode() {
        return super.hashCode();
    }
}

