/*
 * Decompiled with CFR 0.152.
 */
package pdtEditor.payloads.calibrations;

import binTools.BinReader;
import binTools.BinWriter;
import binTools.Common;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import pdtEditor.Sensor;
import pdtEditor.exceptions.FeatureNotSupportedYetException;
import pdtEditor.payloads.calibrations.CalibrationPayload;
import pdtEditor.validation.Validator;

public class OnTableDetectionCalibrationPayload
extends CalibrationPayload {
    public static final int CALIBRATION_TYPE = 5;
    public static final int LATEST_FORMAT_ID = 1;
    public static final double ENTER_THRESHOLD_DEFAULT_VALUE = 1.5;
    public static final double EXIT_THRESHOLD_BASE_DEFAULT_VALUE = 5.0;
    public static final double EXIT_THRESHOLD_MAX_DEFAULT_VALUE = 15.0;
    public static final double STEP_FACTOR_DEFAULT_VALUE = 0.002;
    public static final short ENTER_HYSTERESIS_DEFAULT_VALUE = 20;
    public static final short EXIT_HYSTERESIS_DEFAULT_VALUE = 0;
    public static final String CALIBRATION_FORMAT_STRING = "On Table Detection Calibration";
    private static final String CALIBRATION_DATA_STRING = "Relevant data";
    private static final double EPSILON = 1.0E-6;
    private double _enterThresh = 1.5;
    private double _exitThreshBase = 5.0;
    private double _exitThreshMax = 15.0;
    private double _stepFactor = 0.002;
    private short _enterHysteresis = (short)20;
    private short _exitHysteresis = 0;
    private int _formatID = 1;
    private int _version = 0;

    public int getFormatID() {
        return this._formatID;
    }

    public void setFormatID(int _formatID) {
        this._formatID = _formatID;
    }

    public int getVersion() {
        return this._version;
    }

    public void setVersion(int _version) {
        this._version = _version;
    }

    public double getEnterThresh() {
        return this._enterThresh;
    }

    public void setEnterThresh(double _enterThresh) {
        this._enterThresh = _enterThresh;
    }

    public double getExitThreshBase() {
        return this._exitThreshBase;
    }

    public void setExitThreshBase(double _exitThreshBase) {
        this._exitThreshBase = _exitThreshBase;
    }

    public double getExitThreshMax() {
        return this._exitThreshMax;
    }

    public void setExitThreshMax(double _exitThreshMax) {
        this._exitThreshMax = _exitThreshMax;
    }

    public double getStepFactor() {
        return this._stepFactor;
    }

    public void setStepFactor(double _stepFactor) {
        this._stepFactor = _stepFactor;
    }

    public short getEnterHysteresis() {
        return this._enterHysteresis;
    }

    public void setEnterHysteresis(short _enterHysteresis) {
        this._enterHysteresis = _enterHysteresis;
    }

    public short getExitHysteresis() {
        return this._exitHysteresis;
    }

    public void setExitHysteresis(short _exitHysteresis) {
        this._exitHysteresis = _exitHysteresis;
    }

    public OnTableDetectionCalibrationPayload() {
    }

    public OnTableDetectionCalibrationPayload(OnTableDetectionCalibrationPayload other) {
        super(other);
        this._formatID = other._formatID;
        this._version = other._version;
        this._enterThresh = other._enterThresh;
        this._exitThreshBase = other._exitThreshBase;
        this._exitThreshMax = other._exitThreshMax;
        this._stepFactor = other._stepFactor;
        this._enterHysteresis = other._enterHysteresis;
        this._exitHysteresis = other._exitHysteresis;
    }

    public OnTableDetectionCalibrationPayload(int formatId, BinReader reader, Node payloadXmlNode) throws FeatureNotSupportedYetException {
        super(payloadXmlNode);
        this._formatID = formatId;
        if (this._formatID < 1) {
            throw new UnsupportedOperationException("On Table Detection Calibration has an old, unsupported, format.");
        }
        if (this._formatID > 1) {
            throw new FeatureNotSupportedYetException(this);
        }
        this._version = reader.readNewField((String)"Version", (int)1, (boolean)false, (Node)payloadXmlNode).value;
        Element configuration = reader.readNewField((String)"OnTableDetectionConfiguration", (Node)payloadXmlNode).xmlElement;
        this._enterThresh = (float)reader.readNewField((String)"EnterThresh", (int)4, (boolean)false, (Node)configuration).value / 10000.0f;
        this._exitThreshBase = (float)reader.readNewField((String)"ExitThreshBase", (int)4, (boolean)false, (Node)configuration).value / 10000.0f;
        this._exitThreshMax = (float)reader.readNewField((String)"ExitThreshMax", (int)4, (boolean)false, (Node)configuration).value / 10000.0f;
        this._stepFactor = (float)reader.readNewField((String)"StepFactor", (int)4, (boolean)false, (Node)configuration).value / 10000.0f;
        this._enterHysteresis = (short)reader.readNewField((String)"EnterHysteresis", (int)2, (boolean)false, (Node)configuration).value;
        this._exitHysteresis = (short)reader.readNewField((String)"ExitHysteresis", (int)2, (boolean)false, (Node)configuration).value;
    }

    @Override
    public OnTableDetectionCalibrationPayload clone() {
        return new OnTableDetectionCalibrationPayload(this);
    }

    @Override
    public void writeToPdt(BinWriter writer, Element parent) {
        super.writeToPdt(writer, parent);
        Common.Field payloadDataLength = writer.writeNewField("DataLength", 2, 0, (Node)parent);
        writer.addSizeCounter(payloadDataLength);
        writer.writeNewField("FormatId", 1, this._formatID, (Node)parent);
        writer.writeNewField("Version", 1, this._version, (Node)parent);
        Element configuration = writer.writeNewField((String)"OnTableDetectionConfiguration", (Node)parent).xmlElement;
        writer.writeNewField("EnterThresh", 4, (int)(this._enterThresh * 10000.0), (Node)configuration);
        writer.writeNewField("ExitThreshBase", 4, (int)(this._exitThreshBase * 10000.0), (Node)configuration);
        writer.writeNewField("ExitThreshMax", 4, (int)(this._exitThreshMax * 10000.0), (Node)configuration);
        writer.writeNewField("StepFactor", 4, (int)(this._stepFactor * 10000.0), (Node)configuration);
        writer.writeNewField("EnterHysteresis", 2, this._enterHysteresis, (Node)configuration);
        writer.writeNewField("ExitHysteresis", 2, this._exitHysteresis, (Node)configuration);
        writer.removeSizeCounter(payloadDataLength);
    }

    @Override
    public boolean equals(Object arg0) {
        if (arg0 == null || !(arg0 instanceof OnTableDetectionCalibrationPayload)) {
            return false;
        }
        OnTableDetectionCalibrationPayload other = (OnTableDetectionCalibrationPayload)arg0;
        return this._formatID == other._formatID && this._version == other._version && Math.abs(this._enterThresh - other._enterThresh) < 1.0E-6 && Math.abs(this._exitThreshBase - other._exitThreshBase) < 1.0E-6 && Math.abs(this._exitThreshMax - other._exitThreshMax) < 1.0E-6 && Math.abs(this._stepFactor - other._stepFactor) < 1.0E-6 && this._enterHysteresis == other._enterHysteresis && this._exitHysteresis == other._exitHysteresis;
    }

    @Override
    public void checkValidity(Validator validator, Sensor sensor) {
    }

    @Override
    public String getCalibrationFormatString() {
        return CALIBRATION_FORMAT_STRING;
    }

    @Override
    public String getCalibrationDataString() {
        return CALIBRATION_DATA_STRING;
    }

    public int hashCode() {
        return super.hashCode();
    }
}

