/*
 * Decompiled with CFR 0.152.
 */
package pdtEditor.payloads.calibrations;

import binTools.BinReader;
import binTools.BinWriter;
import binTools.Common;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import pdtEditor.DataStore;
import pdtEditor.Sensor;
import pdtEditor.exceptions.FeatureNotSupportedYetException;
import pdtEditor.payloads.calibrations.AgmVirtualCalibrationPayload;
import pdtEditor.validation.Validator;

public class VirtualMagCalibrationPayload
extends AgmVirtualCalibrationPayload {
    public static final int CALIBRATION_TYPE = 4;
    public static final String CALIBRATION_FORMAT_STRING = "Calibrated Magnetometer Calibration";
    private static final String CALIBRATION_DATA_STRING = "Relevant data";
    public static final int LATEST_FORMAT_ID = 1;
    public static final int MINIMAL_PDT_FORMAT_VERSION = 4;
    private static final int NOISE_DEFAULT_VALUE = 5000;
    public static final int OFFSET_INDEX_DEFAULT_VALUE = 0;
    private static final int[][] OFFSET_DEFAULT_VALUE = new int[][]{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}};
    private int _formatID = 1;
    private int _version;
    private int _sensorInBase;
    private int _lidAngle;
    private int _noise = 5000;

    public VirtualMagCalibrationPayload() {
    }

    public VirtualMagCalibrationPayload(VirtualMagCalibrationPayload other) {
        super(other);
        this._formatID = other._formatID;
        this._version = other._version;
        this._sensorInBase = other._sensorInBase;
        this._lidAngle = other._lidAngle;
        this._noise = other._noise;
    }

    public VirtualMagCalibrationPayload(int formatId, BinReader reader, Node payloadXmlNode) throws FeatureNotSupportedYetException {
        super(payloadXmlNode);
        this.checkPdtFormat();
        this._formatID = formatId;
        if (this._formatID > 1) {
            throw new FeatureNotSupportedYetException(this);
        }
        this._version = reader.readNewField((String)"Version", (int)1, (boolean)false, (Node)payloadXmlNode).value;
        Element virtualMagCalibrationElement = reader.readNewField((String)"VirtualMagCalibration", (Node)payloadXmlNode).xmlElement;
        this._noise = reader.readNewField((String)"Noise", (int)4, (boolean)false, (Node)virtualMagCalibrationElement).value;
        this._sensorInBase = reader.readNewField((String)"SensorInBase", (int)1, (boolean)false, (Node)virtualMagCalibrationElement).value;
        this._lidAngle = reader.readNewField((String)"LidAngle", (int)2, (boolean)false, (Node)virtualMagCalibrationElement).value;
        reader.readNewField("OffsetIndex", 1, false, virtualMagCalibrationElement);
        reader.readNewField("Offset0X", 4, false, virtualMagCalibrationElement);
        reader.readNewField("Offset0Y", 4, false, virtualMagCalibrationElement);
        reader.readNewField("Offset0Z", 4, false, virtualMagCalibrationElement);
        reader.readNewField("Offset1X", 4, false, virtualMagCalibrationElement);
        reader.readNewField("Offset1Y", 4, false, virtualMagCalibrationElement);
        reader.readNewField("Offset1Z", 4, false, virtualMagCalibrationElement);
        reader.readNewField("Offset2X", 4, false, virtualMagCalibrationElement);
        reader.readNewField("Offset2Y", 4, false, virtualMagCalibrationElement);
        reader.readNewField("Offset2Z", 4, false, virtualMagCalibrationElement);
    }

    @Override
    public boolean equals(Object arg0) {
        if (arg0 == null || !(arg0 instanceof VirtualMagCalibrationPayload)) {
            return false;
        }
        VirtualMagCalibrationPayload other = (VirtualMagCalibrationPayload)arg0;
        return this._formatID == other._formatID && this._version == other._version && this._sensorInBase == other._sensorInBase && this._lidAngle == other._lidAngle && this._noise == other._noise;
    }

    @Override
    public VirtualMagCalibrationPayload clone() {
        return new VirtualMagCalibrationPayload(this);
    }

    private void checkPdtFormat() {
        if (DataStore.getInstance().getPdtFormatVersion() < 4) {
            throw new UnsupportedOperationException("The 'Calibrated Magnetometer Calibration' calibration is supported in PDT format version 4 and above.");
        }
    }

    @Override
    public void writeToPdt(BinWriter writer, Element parent) {
        super.writeToPdt(writer, parent);
        Common.Field payloadDataLength = writer.writeNewField("DataLength", 2, 0, (Node)parent);
        writer.addSizeCounter(payloadDataLength);
        writer.writeNewField("FormatId", 1, this._formatID, (Node)parent);
        writer.writeNewField("Version", 1, this._version, (Node)parent);
        Element virtualMagCalibrationElement = writer.writeNewField((String)"VirtualGyroCalibration", (Node)parent).xmlElement;
        writer.writeNewField("Noise", 4, this._noise, (Node)virtualMagCalibrationElement);
        writer.writeNewField("SensorInBase", 1, this._sensorInBase, (Node)virtualMagCalibrationElement);
        writer.writeNewField("LidAngle", 2, this._lidAngle, (Node)virtualMagCalibrationElement);
        writer.writeNewField("OffsetIndex", 1, 0, (Node)virtualMagCalibrationElement);
        writer.writeNewField("Offset0X", 4, OFFSET_DEFAULT_VALUE[0][0], (Node)virtualMagCalibrationElement);
        writer.writeNewField("Offset0Y", 4, OFFSET_DEFAULT_VALUE[0][1], (Node)virtualMagCalibrationElement);
        writer.writeNewField("Offset0Z", 4, OFFSET_DEFAULT_VALUE[0][2], (Node)virtualMagCalibrationElement);
        writer.writeNewField("Offset1X", 4, OFFSET_DEFAULT_VALUE[1][0], (Node)virtualMagCalibrationElement);
        writer.writeNewField("Offset1Y", 4, OFFSET_DEFAULT_VALUE[1][1], (Node)virtualMagCalibrationElement);
        writer.writeNewField("Offset1Z", 4, OFFSET_DEFAULT_VALUE[1][2], (Node)virtualMagCalibrationElement);
        writer.writeNewField("Offset2X", 4, OFFSET_DEFAULT_VALUE[2][0], (Node)virtualMagCalibrationElement);
        writer.writeNewField("Offset2Y", 4, OFFSET_DEFAULT_VALUE[2][1], (Node)virtualMagCalibrationElement);
        writer.writeNewField("Offset2Z", 4, OFFSET_DEFAULT_VALUE[2][2], (Node)virtualMagCalibrationElement);
        writer.removeSizeCounter(payloadDataLength);
    }

    @Override
    public String getCalibrationFormatString() {
        return CALIBRATION_FORMAT_STRING;
    }

    @Override
    public String getCalibrationDataString() {
        return CALIBRATION_DATA_STRING;
    }

    @Override
    public int getFormatID() {
        return this._formatID;
    }

    @Override
    public void setFormatID(int formatID) {
        this._formatID = formatID;
    }

    @Override
    public int getVersion() {
        return this._version;
    }

    @Override
    public void setVersion(int version) {
        this._version = version;
    }

    @Override
    public boolean getSensorInBase() {
        return this._sensorInBase == 1;
    }

    @Override
    public void setSensorInBase(boolean sensorInBase) {
        this._sensorInBase = sensorInBase ? 1 : 0;
    }

    @Override
    public int getLidAngle() {
        return this._lidAngle;
    }

    @Override
    public void setLidAngle(int lidAngle) {
        this._lidAngle = lidAngle;
    }

    @Override
    public void setWhiteNoise(int whiteNoise) {
        this._noise = whiteNoise;
    }

    @Override
    public void checkValidity(Validator validator, Sensor sensor) {
    }

    public int hashCode() {
        return super.hashCode();
    }
}

