/*
 * Decompiled with CFR 0.152.
 */
package pdtEditor.payloads.configurations;

import binTools.BinReader;
import binTools.BinWriter;
import binTools.Common;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import pdtEditor.Sensor;
import pdtEditor.exceptions.FeatureNotSupportedYetException;
import pdtEditor.payloads.configurations.ConfigurationPayload;
import pdtEditor.validation.Validator;

public class EcConfigurationPayload
extends ConfigurationPayload {
    public static final int CONFIGURATION_TYPE = 101;
    public static final String CALIBRATION_FORMAT_STRING = "Embedded Control Configuration";
    private static final int LATEST_FORMAT_ID = 0;
    public static final int LINK_PROTOCOL_TYPE_DEFAULT_VALUE = 0;
    public static final int LINK_PROTOCOL_VERSION_DEFAULT_VALUE = 1;
    public static final int SENSOR_PROTOCOL_TYPE_DEFAULT_VALUE = 0;
    public static final int SENSOR_PROTOCOL_VERSION_DEFAULT_VALUE = 1;
    public static final int MAX_FRAGMENT_SIZE_DEFAULT_VALUE = 64;
    public static final int RESERVED1_DEFAULT_VALUE = 0;
    public static final int FLAGS_DEFAULT_VALUE = 0;
    public static final int RETRY_TIMEOUT_MS_DEFAULT_VALUE = 100;
    public static final int MAX_MSG_SIZE_DEFAULT_VALUE = 64;
    public static final int RESERVED2_DEFAULT_VALUE = 0;
    public static final int RESERVED3_DEFAULT_VALUE = 0;
    public static final long SSP_FLAGS_DEFAULT_VALUE = 0x80000000L;
    public static final int CONFIG_SIZE_DEFAULT_VALUE = 8;
    public static final int NUMBER_OF_SENSOR_CONFIGS_DEFAULT_VALUE = 1;
    public static final int SENSOR_FLAG_DEFAULT_VALUE = 0;
    public static final int SENSOR_INSTANCE_ID_DEFAULT_VALUE = 0;
    public static final int RESERVED4_DEFAULT_VALUE = 0;
    public static final int RESERVED5_DEFAULT_VALUE = 0;
    public static final int ON_TABLE_DETECTION_SENSOR_TYPE = 769;
    public static final String ON_TABLE_DETECTION_STRING = "On Table Detection";
    public static final int PLM_SENSOR_TYPE = 768;
    public static final String PLM_STRING = "PLM";
    public static final int DYNAMIC_KEYBOARD_LIGHTING_SENSOR_TYPE = 777;
    public static final String DYNAMIC_KEYBOARD_LIGHTING_SENSOR_STRING = "Dynamic Keyboard Lighting";
    private int _formatID = 0;
    private int _version = 0;
    private int _sensor_type = 0;

    public EcConfigurationPayload() {
    }

    public EcConfigurationPayload(EcConfigurationPayload other) {
        super(other);
        this._formatID = other._formatID;
        this._version = other._version;
        this._sensor_type = other._sensor_type;
    }

    public EcConfigurationPayload(int formatId, BinReader reader, Node payloadXmlNode) throws FeatureNotSupportedYetException {
        super(payloadXmlNode);
        this._formatID = formatId;
        if (this._formatID > 0) {
            throw new FeatureNotSupportedYetException(this);
        }
        this._version = reader.readNewField((String)"Version", (int)1, (boolean)false, (Node)payloadXmlNode).value;
        Element configuration = reader.readNewField((String)"EciCalibration", (Node)payloadXmlNode).xmlElement;
        reader.readNewField("linkProtocolType", 1, false, configuration);
        reader.readNewField("linkProtocolVersion", 1, false, configuration);
        reader.readNewField("sensorsProtocolType", 1, false, configuration);
        reader.readNewField("sensorsProtocolVersion", 1, false, configuration);
        reader.readNewField("maxFragmentSize", 1, false, configuration);
        reader.readNewField("reserved1", 1, false, configuration);
        reader.readNewField("flags", 1, false, configuration);
        reader.readNewField("retryTimeoutMs", 2, false, configuration);
        reader.readNewField("maxMsgSize", 2, false, configuration);
        reader.readNewField("reserved2", 1, false, configuration);
        reader.readNewField("reserved3", 1, false, configuration);
        reader.readNewField("sspFlags", 4, false, configuration);
        reader.readNewField("configSize", 2, false, configuration);
        reader.readNewField("numberOfSensorConfigs", 2, false, configuration);
        this._sensor_type = reader.readNewField((String)"sensorType", (int)2, (boolean)false, (Node)configuration).value;
        reader.readNewField("sensorFlag", 1, false, configuration);
        reader.readNewField("sensorInstanceId", 1, false, configuration);
        reader.readNewField("reserved4", 2, false, configuration);
        reader.readNewField("reserved5", 2, false, configuration);
    }

    @Override
    public boolean equals(Object arg0) {
        if (arg0 == null || !(arg0 instanceof EcConfigurationPayload)) {
            return false;
        }
        EcConfigurationPayload other = (EcConfigurationPayload)arg0;
        return this._formatID == other._formatID && this._version == other._version;
    }

    @Override
    public EcConfigurationPayload clone() {
        return new EcConfigurationPayload(this);
    }

    @Override
    public void writeToPdt(BinWriter writer, Element parent) {
        super.writeToPdt(writer, parent);
        Common.Field payloadDataLength = writer.writeNewField("DataLength", 2, 0, (Node)parent);
        writer.addSizeCounter(payloadDataLength);
        writer.writeNewField("FormatId", 1, this._formatID, (Node)parent);
        writer.writeNewField("Version", 1, this._version, (Node)parent);
        Element configuration = writer.writeNewField((String)"EciCalibration", (Node)parent).xmlElement;
        writer.writeNewField("linkProtocolType", 1, 0, (Node)configuration);
        writer.writeNewField("linkProtocolVersion", 1, 1, (Node)configuration);
        writer.writeNewField("sensorsProtocolType", 1, 0, (Node)configuration);
        writer.writeNewField("sensorsProtocolVersion", 1, 1, (Node)configuration);
        writer.writeNewField("maxFragmentSize", 1, 64, (Node)configuration);
        writer.writeNewField("reserved1", 1, 0, (Node)configuration);
        writer.writeNewField("flags", 1, 0, (Node)configuration);
        writer.writeNewField("retryTimeoutMs", 2, 100, (Node)configuration);
        writer.writeNewField("maxMsgSize", 2, 64, (Node)configuration);
        writer.writeNewField("reserved2", 1, 0, (Node)configuration);
        writer.writeNewField("reserved3", 1, 0, (Node)configuration);
        writer.writeNewField("sspFlags", 4, 0x80000000L, (Node)configuration);
        writer.writeNewField("configSize", 2, 8, (Node)configuration);
        writer.writeNewField("numberOfSensorConfigs", 2, 1, (Node)configuration);
        writer.writeNewField("sensorType", 2, this._sensor_type, (Node)configuration);
        writer.writeNewField("sensorFlag", 1, 0, (Node)configuration);
        writer.writeNewField("sensorInstanceId", 1, 0, (Node)configuration);
        writer.writeNewField("reserved4", 2, 0, (Node)configuration);
        writer.writeNewField("reserved5", 2, 0, (Node)configuration);
        writer.removeSizeCounter(payloadDataLength);
    }

    @Override
    public String getConfigurationFormatString() {
        return CALIBRATION_FORMAT_STRING;
    }

    @Override
    public String getConfigurationDataString() {
        return "";
    }

    @Override
    public boolean controllsBusData() {
        return true;
    }

    @Override
    public boolean controllsGpioData() {
        return false;
    }

    @Override
    public void checkValidity(Validator validator, Sensor sensor) {
    }

    public int hashCode() {
        return super.hashCode();
    }

    public int getSensorType() {
        return this._sensor_type;
    }

    public void setSensorType(int _sensor_type) {
        this._sensor_type = _sensor_type;
    }
}

