/*
 * Decompiled with CFR 0.152.
 */
package pdtEditor.payloads.configurations;

import binTools.BinReader;
import binTools.BinWriter;
import binTools.Common;
import java.util.ArrayList;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import pdtEditor.InformationStore;
import pdtEditor.Sensor;
import pdtEditor.exceptions.FeatureNotSupportedYetException;
import pdtEditor.payloads.configurations.ConfigurationPayload;
import pdtEditor.validation.Validator;

public class HingeAngleConfigurationPayload
extends ConfigurationPayload {
    public static final String CALIBRATION_FORMAT_STRING = "Hinge Angle Configuration";
    public static final int CONFIGURATION_TYPE = 111;
    private static final int LATEST_FORMAT_ID = 0;
    public static final int MIN_ROWS_IN_CONF_TABLE = 1;
    public static final int MAX_ROWS_IN_CONF_TABLE = 15;
    public static final int ANGLE_OUTPUT_FIELD_SIZE = 2;
    public static final int ANGLE_FIELD_SIZE = 2;
    public static final int ANGLE1_TOLERANCE_FIELD_SIZE = 2;
    public static final int ANGLE2_TOLERANCE_SIZE = 2;
    public static final int TIME_HYSTERSIS_FIELD_SIZE = 2;
    public static final int HALL_STATE_FIELD_SIZE = 1;
    public static final int HALL_CONFIG_SENSOR_TYPE_SIZE = 2;
    public static final int HALL_CONFIG_INSTANCE_ID_SIZE = 1;
    public static final int PLM_HALL_STATE_INACTIVE_VALUE = 0;
    public static final int PLM_HALL_STATE_ACTIVE_VALUE = 1;
    public static final int PLM_HALL_STATE_NOT_APPLICABLE_VALUE = 255;
    public static final String PLM_HALL_STATE_INACTIVE_STRING = "Inactive";
    public static final String PLM_HALL_STATE_ACTIVE_STRING = "Active";
    public static final String PLM_HALL_STATE_NOT_APPLICABLE_STRING = "Not Applicable";
    private int _formatID = 0;
    private int _version;
    private InformationStore infoStore = null;
    private ArrayList<HingeAngleConfig> _hingeAngleConfigs = new ArrayList();
    private ArrayList<HallConfig> _hallConfigs = new ArrayList();

    public HingeAngleConfigurationPayload() {
    }

    public HingeAngleConfigurationPayload(HingeAngleConfigurationPayload other) {
        super(other);
        this._formatID = other._formatID;
        this._version = other._version;
        if (other._hingeAngleConfigs != null) {
            for (HingeAngleConfig hingeAngleConfig : other._hingeAngleConfigs) {
                this._hingeAngleConfigs.add(hingeAngleConfig);
            }
        } else {
            this._hingeAngleConfigs = new ArrayList();
        }
        if (other._hallConfigs != null) {
            for (HallConfig hallConfig : other._hallConfigs) {
                this._hallConfigs.add(hallConfig);
            }
        } else {
            this._hallConfigs = new ArrayList();
        }
    }

    public HingeAngleConfigurationPayload(int formatId, BinReader reader, Node payloadXmlNode) throws FeatureNotSupportedYetException {
        super(payloadXmlNode);
        try {
            this.infoStore = InformationStore.getInstance();
        }
        catch (Exception e) {
            return;
        }
        this._formatID = formatId;
        if (this._formatID > 0) {
            throw new FeatureNotSupportedYetException(this);
        }
        this._version = reader.readNewField((String)"Version", (int)1, (boolean)false, (Node)payloadXmlNode).value;
        Element configurationElement = reader.readNewField((String)"HingeAngleConfiguration", (Node)payloadXmlNode).xmlElement;
        int configTableRows = reader.readNewField((String)"NumConfigurationRows", (int)1, (boolean)false, (Node)configurationElement).value;
        for (int i = 1; i <= configTableRows; ++i) {
            Element configurationRowElement = reader.readNewField((String)new StringBuilder().append((String)"ConfigurationRow").append((int)i).toString(), (Node)configurationElement).xmlElement;
            HingeAngleConfig hingeAngleConfig = new HingeAngleConfig();
            hingeAngleConfig.angleOutput = reader.readNewField((String)"AngleOutput", (int)2, (boolean)true, (Node)configurationRowElement).value;
            hingeAngleConfig.entryAngle = reader.readNewField((String)"EntryAngle", (int)2, (boolean)true, (Node)configurationRowElement).value;
            hingeAngleConfig.t1Delta = reader.readNewField((String)"EntryAngleTolerance", (int)2, (boolean)true, (Node)configurationRowElement).value;
            hingeAngleConfig.exitAngle = reader.readNewField((String)"ExitAngle", (int)2, (boolean)true, (Node)configurationRowElement).value;
            hingeAngleConfig.t2Delta = reader.readNewField((String)"ExitAngleTolerance", (int)2, (boolean)true, (Node)configurationRowElement).value;
            hingeAngleConfig.th = reader.readNewField((String)"TimeHysteresis", (int)2, (boolean)false, (Node)configurationRowElement).value;
            for (int j = 1; j <= hingeAngleConfig.hallStates.length; ++j) {
                hingeAngleConfig.hallStates[j - 1] = reader.readNewField((String)new StringBuilder().append((String)"HallState").append((int)j).toString(), (int)1, (boolean)false, (Node)configurationRowElement).value;
            }
            this._hingeAngleConfigs.add(hingeAngleConfig);
        }
        int numsHallConfigs = reader.readNewField((String)"NumHallConfigs", (int)1, (boolean)false, (Node)configurationElement).value;
        for (int i = 1; i <= numsHallConfigs; ++i) {
            Element hallConfigRowElement = reader.readNewField((String)new StringBuilder().append((String)"HallConfig").append((int)i).toString(), (Node)configurationElement).xmlElement;
            HallConfig hallConfig = new HallConfig();
            hallConfig.sensorType = reader.readNewField((String)"SensorType", (int)2, (boolean)false, (Node)hallConfigRowElement).value;
            hallConfig.instanceId = reader.readNewField((String)"InstanceId", (int)1, (boolean)false, (Node)hallConfigRowElement).value;
            hallConfig.sensorName = this.infoStore.getPlmSupportSensorTypeById((int)hallConfig.sensorType).sensorName;
            this._hallConfigs.add(hallConfig);
        }
    }

    @Override
    public void writeToPdt(BinWriter writer, Element parent) {
        int i;
        super.writeToPdt(writer, parent);
        Common.Field payloadDataLength = writer.writeNewField("DataLength", 2, 0, (Node)parent);
        writer.addSizeCounter(payloadDataLength);
        writer.writeNewField("FormatId", 1, this._formatID, (Node)parent);
        writer.writeNewField("Version", 1, this._version, (Node)parent);
        Element configurationElement = writer.writeNewField((String)"HingeAngleConfiguration", (Node)parent).xmlElement;
        writer.writeNewField("NumConfigurationRows", 1, this._hingeAngleConfigs.size(), (Node)configurationElement);
        for (i = 1; i <= this._hingeAngleConfigs.size(); ++i) {
            HingeAngleConfig hingeAngleConfig = this._hingeAngleConfigs.get(i - 1);
            Element configurationRowElement = writer.writeNewField((String)new StringBuilder().append((String)"ConfigurationRow").append((int)i).toString(), (Node)configurationElement).xmlElement;
            writer.writeNewField("AngleOutput", 2, hingeAngleConfig.angleOutput, (Node)configurationRowElement);
            writer.writeNewField("EntryAngle", 2, hingeAngleConfig.entryAngle, (Node)configurationRowElement);
            writer.writeNewField("EntryAngleTolerance", 2, hingeAngleConfig.t1Delta, (Node)configurationRowElement);
            writer.writeNewField("ExitAngle", 2, hingeAngleConfig.exitAngle, (Node)configurationRowElement);
            writer.writeNewField("ExitAngleTolerance", 2, hingeAngleConfig.t2Delta, (Node)configurationRowElement);
            writer.writeNewField("TimeHysteresis", 2, hingeAngleConfig.th, (Node)configurationRowElement);
            for (int j = 1; j <= hingeAngleConfig.hallStates.length; ++j) {
                writer.writeNewField("HallState" + j, 1, hingeAngleConfig.hallStates[j - 1], (Node)configurationRowElement);
            }
        }
        writer.writeNewField("NumHallConfigs", 1, this._hallConfigs.size(), (Node)configurationElement);
        for (i = 1; i <= this._hallConfigs.size(); ++i) {
            HallConfig hallConfig = this._hallConfigs.get(i - 1);
            Element hallConfigRowElement = writer.writeNewField((String)new StringBuilder().append((String)"HallConfig").append((int)i).toString(), (Node)configurationElement).xmlElement;
            writer.writeNewField("SensorType", 2, hallConfig.sensorType, (Node)hallConfigRowElement);
            writer.writeNewField("InstanceId", 1, hallConfig.instanceId, (Node)hallConfigRowElement);
        }
        writer.removeSizeCounter(payloadDataLength);
    }

    @Override
    public HingeAngleConfigurationPayload clone() {
        return new HingeAngleConfigurationPayload(this);
    }

    @Override
    public boolean equals(Object arg0) {
        if (arg0 == null || !(arg0 instanceof HingeAngleConfigurationPayload)) {
            return false;
        }
        HingeAngleConfigurationPayload other = (HingeAngleConfigurationPayload)arg0;
        return this._formatID == other._formatID && this._version == other._version && (this._hingeAngleConfigs == null && other._hingeAngleConfigs == null || this._hingeAngleConfigs != null && this._hingeAngleConfigs.equals(other._hingeAngleConfigs)) && (this._hallConfigs == null && other._hallConfigs == null || this._hallConfigs != null && this._hallConfigs.equals(other._hallConfigs));
    }

    @Override
    public void checkValidity(Validator validator, Sensor sensor) {
    }

    @Override
    public String getConfigurationFormatString() {
        return CALIBRATION_FORMAT_STRING;
    }

    @Override
    public String getConfigurationDataString() {
        return "";
    }

    @Override
    public boolean controllsBusData() {
        return false;
    }

    @Override
    public boolean controllsGpioData() {
        return false;
    }

    public ArrayList<HingeAngleConfig> getHingeAngleConfigs() {
        return this._hingeAngleConfigs;
    }

    public void setHingeAngleConfigs(ArrayList<HingeAngleConfig> hingeAngleConfigs) {
        this._hingeAngleConfigs = hingeAngleConfigs;
    }

    public ArrayList<HallConfig> getHallConfigs() {
        return this._hallConfigs;
    }

    public void setHallConfigs(ArrayList<HallConfig> hallConfigs) {
        this._hallConfigs = hallConfigs;
    }

    public static class HallConfig {
        public int sensorType;
        public String sensorName;
        public int instanceId;

        public boolean equals(Object arg0) {
            if (arg0 == null || !(arg0 instanceof HallConfig)) {
                return false;
            }
            HallConfig other = (HallConfig)arg0;
            return this.sensorType == other.sensorType && this.sensorName == other.sensorName && this.instanceId == other.instanceId;
        }
    }

    public static class HallSupportSensorType {
        public int sensorType;
        public String sensorName;
    }

    public static class HingeAngleConfig {
        public int angleOutput;
        public int entryAngle;
        public int exitAngle;
        public int t1Delta;
        public int t2Delta;
        public int th;
        public int[] hallStates = new int[]{255, 255, 255, 255, 255, 255};

        public boolean equals(Object arg0) {
            if (arg0 == null || !(arg0 instanceof HingeAngleConfig)) {
                return false;
            }
            HingeAngleConfig other = (HingeAngleConfig)arg0;
            return this.angleOutput == other.angleOutput && this.entryAngle == other.entryAngle && this.exitAngle == other.exitAngle && this.t1Delta == other.t1Delta && this.t2Delta == other.t2Delta && this.th == other.th;
        }

        public int hashCode() {
            return super.hashCode();
        }
    }
}

