/*
 * Decompiled with CFR 0.152.
 */
package pdtEditor.payloads.configurations;

import binTools.BinReader;
import binTools.BinWriter;
import binTools.Common;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import pdtEditor.Sensor;
import pdtEditor.exceptions.FeatureNotSupportedYetException;
import pdtEditor.payloads.configurations.ConfigurationPayload;
import pdtEditor.validation.Validator;

public class HingeConfigurationPayload
extends ConfigurationPayload {
    public static final int CONFIGURATION_TYPE = 105;
    public static final String CONFIGURATION_FORMAT_STRING = "Hinge Configuration";
    private static final int LATEST_FORMAT_ID = 2;
    public static final int SENSITIVITY_MIN_VALUE = 0;
    public static final int SENSITIVITY_MAX_VALUE = 4000;
    public static final int SENSITIVITY_NO_VALUE = 65535;
    private int _formatID = 2;
    private int _version = 0;
    private boolean _disableOnConnectedStandby = true;
    private int _sensitivityOnConnectedStandby = 0;
    private int _tabletModeAngle = 360;

    public HingeConfigurationPayload() {
    }

    public HingeConfigurationPayload(HingeConfigurationPayload other) {
        super(other);
        this._formatID = other._formatID;
        this._version = other._version;
        this._disableOnConnectedStandby = other._disableOnConnectedStandby;
        this._sensitivityOnConnectedStandby = other._sensitivityOnConnectedStandby;
        this._tabletModeAngle = other._tabletModeAngle;
    }

    public HingeConfigurationPayload(int formatId, BinReader reader, Node payloadXmlNode) throws FeatureNotSupportedYetException {
        super(payloadXmlNode);
        this._formatID = formatId;
        if (this._formatID < 2) {
            throw new UnsupportedOperationException("Hinge Configuration has an old, unsupported, format.");
        }
        if (this._formatID > 2) {
            throw new FeatureNotSupportedYetException(this);
        }
        this._version = reader.readNewField((String)"Version", (int)1, (boolean)false, (Node)payloadXmlNode).value;
        Element configuration = reader.readNewField((String)"HingeConfiguration", (Node)payloadXmlNode).xmlElement;
        this._disableOnConnectedStandby = reader.readNewField((String)"DisableOnConnectedStandby", (int)1, (boolean)false, (Node)configuration).value == 1;
        this._sensitivityOnConnectedStandby = reader.readNewField((String)"SensitivityOnConnectedStandby", (int)2, (boolean)false, (Node)configuration).value;
        this._tabletModeAngle = reader.readNewField((String)"TabletModeAngle", (int)2, (boolean)false, (Node)configuration).value;
    }

    @Override
    public boolean equals(Object arg0) {
        if (arg0 == null || !(arg0 instanceof HingeConfigurationPayload)) {
            return false;
        }
        HingeConfigurationPayload other = (HingeConfigurationPayload)arg0;
        return this._formatID == other._formatID && this._version == other._version && this._disableOnConnectedStandby == other._disableOnConnectedStandby && this._sensitivityOnConnectedStandby == other._sensitivityOnConnectedStandby;
    }

    @Override
    public HingeConfigurationPayload clone() {
        return new HingeConfigurationPayload(this);
    }

    @Override
    public void writeToPdt(BinWriter writer, Element parent) {
        super.writeToPdt(writer, parent);
        Common.Field payloadDataLength = writer.writeNewField("DataLength", 2, 0, (Node)parent);
        writer.addSizeCounter(payloadDataLength);
        writer.writeNewField("FormatId", 1, this._formatID, (Node)parent);
        writer.writeNewField("Version", 1, this._version, (Node)parent);
        Element configuration = writer.writeNewField((String)"HingeConfiguration", (Node)parent).xmlElement;
        writer.writeNewField("DisableOnConnectedStandby", 1, this._disableOnConnectedStandby ? 1 : 0, (Node)configuration);
        writer.writeNewField("SensitivityOnConnectedStandby", 2, this._sensitivityOnConnectedStandby, (Node)configuration);
        writer.writeNewField("TabletModeAngle", 2, this._tabletModeAngle, (Node)configuration);
        writer.removeSizeCounter(payloadDataLength);
    }

    @Override
    public String getConfigurationFormatString() {
        return CONFIGURATION_FORMAT_STRING;
    }

    @Override
    public String getConfigurationDataString() {
        return "";
    }

    @Override
    public boolean controllsBusData() {
        return false;
    }

    @Override
    public boolean controllsGpioData() {
        return false;
    }

    public boolean isDisableOnConnectedStandby() {
        return this._disableOnConnectedStandby;
    }

    public void setDisableOnConnectedStandby(boolean disableOnConnectedStandby) {
        this._disableOnConnectedStandby = disableOnConnectedStandby;
    }

    public int getSensitivityOnConnectedStandby() {
        return this._sensitivityOnConnectedStandby;
    }

    public void setSensitivityOnConnectedStandby(int sensitivityOnConnectedStandby) {
        this._sensitivityOnConnectedStandby = sensitivityOnConnectedStandby;
    }

    public int getTabletModeAngle() {
        return this._tabletModeAngle;
    }

    public void setTabletModeAngle(int tabletModeAngle) {
        this._tabletModeAngle = tabletModeAngle;
    }

    @Override
    public void checkValidity(Validator validator, Sensor sensor) {
    }

    public int hashCode() {
        return super.hashCode();
    }
}

