/*
 * Decompiled with CFR 0.152.
 */
package pdtEditor.payloads.configurations;

import binTools.BinReader;
import binTools.BinWriter;
import binTools.Common;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import pdtEditor.Sensor;
import pdtEditor.exceptions.FeatureNotSupportedYetException;
import pdtEditor.payloads.configurations.ConfigurationPayload;
import pdtEditor.validation.Validator;

public class HumanPresenceConfigurationPayload
extends ConfigurationPayload {
    public static final int CONFIGURATION_TYPE = 108;
    public static final String CONFIGURATION_FORMAT_STRING = "Human Presence Configuration";
    public static final int PLM_MODE_ID_NOT_AVAILABLE_VALUE = -1;
    public static final int WAKE_ENABLE_ENABLE_VALUE = 1;
    public static final int WAKE_ENABLE_DISABLE_VALUE = 0;
    public static final int WAKE_ON_PRESENCE_ATTENTIVE_ENABLE_VALUE = 1;
    public static final int WAKE_ON_PRESENCE_ATTENTIVE_DISABLE_VALUE = 0;
    public static final int WAKE_ON_MOTION_USING_ISH_ENABLE_VALUE = 1;
    public static final int WAKE_ON_MOTION_USING_ISH_DISABLE_VALUE = 0;
    public static final int PLM_MODE_ID_FIELD_SIZE = 4;
    public static final int WAKE_ENABLE_FIELD_SIZE = 1;
    public static final int WAKE_DISTANCE_FIELD_SIZE = 4;
    public static final int HINGE_HIGH_FIELD_SIZE = 2;
    public static final int HINGE_LOW_FIELD_SIZE = 2;
    public static final int WAKE_ON_PRESENCE_ATTENTIVE_SIZE = 1;
    public static final int WAKE_ON_PRESENCE_MIN_NO_PRESENCE_SIZE = 4;
    public static final int WAKE_ON_PRESENCE_USER_DISTANCE_SIZE = 4;
    public static final int WAKE_ON_FACE_BBX_SIZE = 2;
    public static final int WAKE_ON_MOTION_USING_ISH_SIZE = 1;
    public static final int LIVENESS_DETECTION_THRESHOLD_SIZE = 1;
    public static final int WAKE_DISTANCE_DEFAULT_VALUE = 1000;
    public static final int WAKE_ON_PRESENCE_MIN_NO_DEFAULT_VALUE = 5000;
    public static final int WAKE_PRESENCE_USER_DEFAULT_VALUE = 2000;
    public static final int WAKE_ON_FACE_BBX_SIZE_DEFAULT_VALUE = 20;
    public static final int LIVENESS_DETECTION_THRESHOLD_DEFAULT_VALUE = 5;
    public static boolean WAKE_ON_PRESENCE_ATTENTIVE = true;
    public static boolean WAKE_ON_MOTION_USING_ISH = false;
    private static final int LATEST_FORMAT_ID = 1;
    private int _formatID = 1;
    private int _version;
    public boolean wakeEnable;
    public int wakeDistance;
    public int hingeAngleLow;
    public int hingeAngleHigh;
    public int plmModeId;
    public boolean wakeOnPresenceAttentive;
    public int wakeOnPresenceMinNoPresence;
    public int wakeOnPresenceUserDistance;
    public int wakeOnFaceBbxDistance;
    public boolean wakeOnMotionUsingIsh;
    public int livenessDetectionThreshold;

    public HumanPresenceConfigurationPayload() {
    }

    public HumanPresenceConfigurationPayload(HumanPresenceConfigurationPayload src) {
        this.wakeEnable = src.wakeEnable;
        this.wakeDistance = src.wakeDistance;
        this.hingeAngleLow = src.hingeAngleLow;
        this.hingeAngleHigh = src.hingeAngleHigh;
        this.plmModeId = src.plmModeId;
        this.wakeOnPresenceAttentive = src.wakeOnPresenceAttentive;
        this.wakeOnPresenceMinNoPresence = src.wakeOnPresenceMinNoPresence;
        this.wakeOnPresenceUserDistance = src.wakeOnPresenceUserDistance;
        this.wakeOnFaceBbxDistance = src.wakeOnFaceBbxDistance;
        this.wakeOnMotionUsingIsh = src.wakeOnMotionUsingIsh;
        this.livenessDetectionThreshold = src.livenessDetectionThreshold;
    }

    public HumanPresenceConfigurationPayload(int formatId, BinReader reader, Node payloadXmlNode) throws FeatureNotSupportedYetException {
        super(payloadXmlNode);
        this._formatID = formatId;
        if (this._formatID > 1) {
            throw new FeatureNotSupportedYetException(this);
        }
        this._version = reader.readNewField((String)"Version", (int)1, (boolean)false, (Node)payloadXmlNode).value;
        Element configurationElement = reader.readNewField((String)"HumanPresenceConfiguration", (Node)payloadXmlNode).xmlElement;
        int wakeEnableValue = reader.readNewField((String)"WakeEnable", (int)1, (boolean)false, (Node)configurationElement).value;
        this.wakeEnable = wakeEnableValue == 1;
        this.wakeDistance = reader.readNewField((String)"WakeDistance", (int)4, (boolean)false, (Node)configurationElement).value;
        this.hingeAngleLow = reader.readNewField((String)"HingeAngleLow", (int)2, (boolean)false, (Node)configurationElement).value;
        this.hingeAngleHigh = reader.readNewField((String)"HingeAngleHigh", (int)2, (boolean)false, (Node)configurationElement).value;
        this.plmModeId = reader.readNewField((String)"PlmModeID", (int)4, (boolean)false, (Node)configurationElement).value;
        if (formatId == 0) {
            this.wakeOnPresenceAttentive = WAKE_ON_PRESENCE_ATTENTIVE;
            this.wakeOnPresenceMinNoPresence = 5000;
            this.wakeOnPresenceUserDistance = 2000;
            this.wakeOnFaceBbxDistance = 20;
            this.wakeOnMotionUsingIsh = WAKE_ON_MOTION_USING_ISH;
            this.livenessDetectionThreshold = 5;
        } else {
            int wakeOnPresenceAttentiveValue = reader.readNewField((String)"WakeOnPresenceAttentive", (int)1, (boolean)false, (Node)configurationElement).value;
            this.wakeOnPresenceAttentive = wakeOnPresenceAttentiveValue == 1;
            this.wakeOnPresenceMinNoPresence = reader.readNewField((String)"wakeOnPresenceMinNoPresence", (int)4, (boolean)false, (Node)configurationElement).value;
            this.wakeOnPresenceUserDistance = reader.readNewField((String)"wakeOnPresenceUserDistance", (int)4, (boolean)false, (Node)configurationElement).value;
            this.wakeOnFaceBbxDistance = reader.readNewField((String)"wakeOnFaceBbxDistance", (int)2, (boolean)false, (Node)configurationElement).value;
            int wakeOnMotionUsingIshValue = reader.readNewField((String)"wakeOnMotionUsingIsh", (int)1, (boolean)false, (Node)configurationElement).value;
            this.wakeOnMotionUsingIsh = wakeOnMotionUsingIshValue == 1;
            this.livenessDetectionThreshold = reader.readNewField((String)"livenessDetectionThreshold", (int)1, (boolean)false, (Node)configurationElement).value;
        }
    }

    @Override
    public void writeToPdt(BinWriter writer, Element parent) {
        super.writeToPdt(writer, parent);
        Common.Field payloadDataLength = writer.writeNewField("DataLength", 2, 0, (Node)parent);
        int wakeEnableValue = this.wakeEnable ? 1 : 0;
        int wakeOnMotionUsingIshValue = this.wakeOnMotionUsingIsh ? 1 : 0;
        int wakeOnPresenceAttentiveValue = this.wakeOnPresenceAttentive ? 1 : 0;
        this._formatID = 1;
        writer.addSizeCounter(payloadDataLength);
        writer.writeNewField("FormatId", 1, this._formatID, (Node)parent);
        writer.writeNewField("Version", 1, this._version, (Node)parent);
        Element rootElement = writer.writeNewField((String)"HumanPresenceConfiguration", (Node)parent).xmlElement;
        writer.writeNewField("WakeEnable", 1, wakeEnableValue, (Node)rootElement);
        writer.writeNewField("WakeDistance", 4, this.wakeDistance, (Node)rootElement);
        writer.writeNewField("HingeAngleLow", 2, this.hingeAngleLow, (Node)rootElement);
        writer.writeNewField("HingeAngleHigh", 2, this.hingeAngleHigh, (Node)rootElement);
        writer.writeNewField("PlmModeID", 4, this.plmModeId, (Node)rootElement);
        writer.writeNewField("WakeOnPresenceAttentive", 1, wakeOnPresenceAttentiveValue, (Node)rootElement);
        writer.writeNewField("wakeOnPresenceMinNoPresence", 4, this.wakeOnPresenceMinNoPresence, (Node)rootElement);
        writer.writeNewField("wakeOnPresenceUserDistance", 4, this.wakeOnPresenceUserDistance, (Node)rootElement);
        writer.writeNewField("wakeOnFaceBbxDistance", 2, this.wakeOnFaceBbxDistance, (Node)rootElement);
        writer.writeNewField("wakeOnMotionUsingIsh", 1, wakeOnMotionUsingIshValue, (Node)rootElement);
        writer.writeNewField("livenessDetectionThreshold", 1, this.livenessDetectionThreshold, (Node)rootElement);
        writer.removeSizeCounter(payloadDataLength);
    }

    public boolean isWakeEnable() {
        return this.wakeEnable;
    }

    public void setWakeEnable(boolean wakeEnable) {
        this.wakeEnable = wakeEnable;
    }

    public int getWakeDistance() {
        return this.wakeDistance;
    }

    public void setWakeDistance(int wakeDistance) {
        this.wakeDistance = wakeDistance;
    }

    public int getHingeAngleLow() {
        return this.hingeAngleLow;
    }

    public void setHingeAngleLow(int hingeAngleLow) {
        this.hingeAngleLow = hingeAngleLow;
    }

    public int getHingeAngleHigh() {
        return this.hingeAngleHigh;
    }

    public void setHingeAngleHigh(int hingeAngleHigh) {
        this.hingeAngleHigh = hingeAngleHigh;
    }

    public int getPlmModeId() {
        return this.plmModeId;
    }

    public void setPlmModeId(int plmModeId) {
        this.plmModeId = plmModeId;
    }

    @Override
    public void checkValidity(Validator validator, Sensor sensor) {
    }

    @Override
    public ConfigurationPayload clone() {
        return new HumanPresenceConfigurationPayload(this);
    }

    @Override
    public String getConfigurationFormatString() {
        return CONFIGURATION_FORMAT_STRING;
    }

    @Override
    public String getConfigurationDataString() {
        return "";
    }

    @Override
    public boolean controllsBusData() {
        return false;
    }

    @Override
    public boolean controllsGpioData() {
        return false;
    }
}

