/*
 * Decompiled with CFR 0.152.
 */
package pdtEditor.payloads.configurations;

import binTools.BinReader;
import binTools.BinWriter;
import binTools.Common;
import java.util.ArrayList;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import pdtEditor.InformationStore;
import pdtEditor.Sensor;
import pdtEditor.exceptions.FeatureNotSupportedYetException;
import pdtEditor.payloads.configurations.ConfigurationPayload;
import pdtEditor.validation.Validator;

public class LidModeConfigurationPayload
extends ConfigurationPayload {
    public static final int CONFIGURATION_TYPE = 100;
    public static final String CALIBRATION_FORMAT_STRING = "Platform Lid Mode Configuration";
    private static final int LATEST_FORMAT_ID = 1;
    public static final int MODE_ID_FIELD_SIZE = 1;
    public static final int ANGLE_FIELD_SIZE = 2;
    public static final int ANGLE1_TOLERANCE_FIELD_SIZE = 2;
    public static final int ANGLE2_TOLERANCE_SIZE = 2;
    public static final int TIME_HYSTERSIS_FIELD_SIZE = 2;
    public static final int LCD_DIRECTION_FIELD_SIZE = 1;
    public static final int HALL_STATE_FIELD_SIZE = 1;
    public static final int HALL_CONFIG_SENSOR_TYPE_SIZE = 2;
    public static final int HALL_CONFIG_INSTANCE_ID_SIZE = 1;
    public static final int ANGLE_MAX_VALUE = (int)Math.pow(2.0, 16.0) - 1;
    public static final int ACTION_MODEID_FILED_SIZE = 1;
    public static final int ACTION_GPIO_PURPOSE_ID_FIELD_SIZE = 1;
    public static final int ACTION_VALUE_FIELD_SIZE = 1;
    public static final int MIN_ROWS_IN_CONF_TABLE = 1;
    public static final int MAX_ROWS_IN_CONF_TABLE = 15;
    public static final int MAX_ROWS_IN_GPIO_TABLE = 15;
    public static final int MAX_ROWS_IN_ACTION_TABLE = 64;
    public static final int MAX_ROWS_IN_HALL_CONFIG_TABLE = 6;
    public static final int LCD_DIRECTION_MAX_VALUE = 5;
    public static final int PLM_HALL_STATE_INACTIVE_VALUE = 0;
    public static final int PLM_HALL_STATE_ACTIVE_VALUE = 1;
    public static final int PLM_HALL_STATE_NOT_APPLICABLE_VALUE = 255;
    public static final String PLM_HALL_STATE_INACTIVE_STRING = "Inactive";
    public static final String PLM_HALL_STATE_ACTIVE_STRING = "Active";
    public static final String PLM_HALL_STATE_NOT_APPLICABLE_STRING = "Not Applicable";
    private InformationStore infoStore = null;
    private int _formatID = 1;
    private int _version;
    private ArrayList<TableEntry> _tableEntries = new ArrayList();
    private ArrayList<ActionEntry> _actionEntries = new ArrayList();
    private ArrayList<PlmHallConfig> _plmHallConfigs = new ArrayList();

    public LidModeConfigurationPayload() {
    }

    public LidModeConfigurationPayload(LidModeConfigurationPayload other) {
        super(other);
        this._formatID = other._formatID;
        this._version = other._version;
        if (other._tableEntries != null) {
            for (TableEntry tableEntry : other._tableEntries) {
                this._tableEntries.add(tableEntry);
            }
        } else {
            this._tableEntries = new ArrayList();
        }
        if (other._actionEntries != null) {
            for (ActionEntry byteData : other._actionEntries) {
                this._actionEntries.add(byteData);
            }
        } else {
            this._actionEntries = new ArrayList();
        }
        if (other._plmHallConfigs != null) {
            for (PlmHallConfig hallConfig : other._plmHallConfigs) {
                this._plmHallConfigs.add(hallConfig);
            }
        } else {
            this._plmHallConfigs = new ArrayList();
        }
    }

    public LidModeConfigurationPayload(int formatId, BinReader reader, Node payloadXmlNode) throws FeatureNotSupportedYetException {
        super(payloadXmlNode);
        int i;
        try {
            this.infoStore = InformationStore.getInstance();
        }
        catch (Exception e) {
            return;
        }
        this._formatID = formatId;
        if (this._formatID > 1) {
            throw new FeatureNotSupportedYetException(this);
        }
        this._version = reader.readNewField((String)"Version", (int)1, (boolean)false, (Node)payloadXmlNode).value;
        Element configurationElement = reader.readNewField((String)"LidModeConfiguration", (Node)payloadXmlNode).xmlElement;
        int configTableRows = reader.readNewField((String)"NumConfigurationRows", (int)1, (boolean)false, (Node)configurationElement).value;
        int numActionRows = reader.readNewField((String)"NumActionRows", (int)1, (boolean)false, (Node)configurationElement).value;
        for (i = 1; i <= configTableRows; ++i) {
            Element configurationRowElement = reader.readNewField((String)new StringBuilder().append((String)"ConfigurationRow").append((int)i).toString(), (Node)configurationElement).xmlElement;
            TableEntry tableEntry = new TableEntry();
            tableEntry.modeId = reader.readNewField((String)"ModeID", (int)1, (boolean)false, (Node)configurationRowElement).value;
            tableEntry.entryAngle = reader.readNewField((String)"EntryAngle", (int)2, (boolean)false, (Node)configurationRowElement).value;
            tableEntry.t1Delta = reader.readNewField((String)"EntryAngleTolerance", (int)2, (boolean)false, (Node)configurationRowElement).value;
            tableEntry.exitAngle = reader.readNewField((String)"ExitAngle", (int)2, (boolean)false, (Node)configurationRowElement).value;
            tableEntry.t2Delta = reader.readNewField((String)"ExitAngleTolerance", (int)2, (boolean)false, (Node)configurationRowElement).value;
            tableEntry.th = reader.readNewField((String)"TimeHysteresis", (int)2, (boolean)false, (Node)configurationRowElement).value;
            tableEntry.lcdDirection = reader.readNewField((String)"LcdDirection", (int)1, (boolean)false, (Node)configurationRowElement).value;
            if (this._formatID >= 1) {
                for (int j = 1; j <= tableEntry.hallStates.length; ++j) {
                    tableEntry.hallStates[j - 1] = reader.readNewField((String)new StringBuilder().append((String)"HallState").append((int)j).toString(), (int)1, (boolean)false, (Node)configurationRowElement).value;
                }
            }
            this._tableEntries.add(tableEntry);
        }
        for (i = 1; i <= numActionRows; ++i) {
            Element actionRowElement = reader.readNewField((String)new StringBuilder().append((String)"ActionRow").append((int)i).toString(), (Node)configurationElement).xmlElement;
            ActionEntry actionEntry = new ActionEntry();
            actionEntry.mode = reader.readNewField((String)"ModeId", (int)1, (boolean)false, (Node)actionRowElement).value;
            actionEntry.gpioPurposeId = reader.readNewField((String)"Purpose", (int)1, (boolean)false, (Node)actionRowElement).value;
            actionEntry.value = reader.readNewField((String)"Value", (int)1, (boolean)false, (Node)actionRowElement).value;
            this._actionEntries.add(actionEntry);
        }
        if (this._formatID >= 1) {
            int numsHallConfigs = reader.readNewField((String)"NumHallConfigs", (int)1, (boolean)false, (Node)configurationElement).value;
            for (int i2 = 1; i2 <= numsHallConfigs; ++i2) {
                Element hallConfigRowElement = reader.readNewField((String)new StringBuilder().append((String)"HallConfig").append((int)i2).toString(), (Node)configurationElement).xmlElement;
                PlmHallConfig hallConfig = new PlmHallConfig();
                hallConfig.sensorType = reader.readNewField((String)"SensorType", (int)2, (boolean)false, (Node)hallConfigRowElement).value;
                hallConfig.instanceId = reader.readNewField((String)"InstanceId", (int)1, (boolean)false, (Node)hallConfigRowElement).value;
                hallConfig.sensorName = this.infoStore.getPlmSupportSensorTypeById((int)hallConfig.sensorType).sensorName;
                this._plmHallConfigs.add(hallConfig);
            }
        }
    }

    @Override
    public boolean equals(Object arg0) {
        if (arg0 == null || !(arg0 instanceof LidModeConfigurationPayload)) {
            return false;
        }
        LidModeConfigurationPayload other = (LidModeConfigurationPayload)arg0;
        return this._formatID == other._formatID && this._version == other._version && (this._tableEntries == null && other._tableEntries == null || this._tableEntries != null && this._tableEntries.equals(other._tableEntries)) && (this._actionEntries == null && other._actionEntries == null || this._actionEntries != null && this._actionEntries.equals(other._actionEntries));
    }

    @Override
    public LidModeConfigurationPayload clone() {
        return new LidModeConfigurationPayload(this);
    }

    @Override
    public void writeToPdt(BinWriter writer, Element parent) {
        int i;
        super.writeToPdt(writer, parent);
        Common.Field payloadDataLength = writer.writeNewField("DataLength", 2, 0, (Node)parent);
        writer.addSizeCounter(payloadDataLength);
        writer.writeNewField("FormatId", 1, this._formatID, (Node)parent);
        writer.writeNewField("Version", 1, this._version, (Node)parent);
        Element configurationElement = writer.writeNewField((String)"LidModeConfiguration", (Node)parent).xmlElement;
        writer.writeNewField("NumConfigurationRows", 1, this._tableEntries.size(), (Node)configurationElement);
        writer.writeNewField("NumActionRows", 1, this._actionEntries.size(), (Node)configurationElement);
        for (i = 1; i <= this._tableEntries.size(); ++i) {
            TableEntry tableEntry = this._tableEntries.get(i - 1);
            Element configurationRowElement = writer.writeNewField((String)new StringBuilder().append((String)"ConfigurationRow").append((int)i).toString(), (Node)configurationElement).xmlElement;
            writer.writeNewField("ModeID", 1, tableEntry.modeId, (Node)configurationRowElement);
            writer.writeNewField("EntryAngle", 2, tableEntry.entryAngle, (Node)configurationRowElement);
            writer.writeNewField("EntryAngleTolerance", 2, tableEntry.t1Delta, (Node)configurationRowElement);
            writer.writeNewField("ExitAngle", 2, tableEntry.exitAngle, (Node)configurationRowElement);
            writer.writeNewField("ExitAngleTolerance", 2, tableEntry.t2Delta, (Node)configurationRowElement);
            writer.writeNewField("TimeHysteresis", 2, tableEntry.th, (Node)configurationRowElement);
            writer.writeNewField("LcdDirection", 1, tableEntry.lcdDirection, (Node)configurationRowElement);
            if (this._formatID < 1) continue;
            for (int j = 1; j <= tableEntry.hallStates.length; ++j) {
                writer.writeNewField("HallState" + j, 1, tableEntry.hallStates[j - 1], (Node)configurationRowElement);
            }
        }
        for (i = 1; i <= this._actionEntries.size(); ++i) {
            ActionEntry actionEntry = this._actionEntries.get(i - 1);
            Element actionRowElement = writer.writeNewField((String)new StringBuilder().append((String)"ActionRow").append((int)i).toString(), (Node)configurationElement).xmlElement;
            writer.writeNewField("ModeId", 1, actionEntry.mode, (Node)actionRowElement);
            writer.writeNewField("Purpose", 1, actionEntry.gpioPurposeId, (Node)actionRowElement);
            writer.writeNewField("Value", 1, actionEntry.value, (Node)actionRowElement);
        }
        if (this._formatID >= 1) {
            writer.writeNewField("NumHallConfigs", 1, this._plmHallConfigs.size(), (Node)configurationElement);
            for (i = 1; i <= this._plmHallConfigs.size(); ++i) {
                PlmHallConfig hallConfig = this._plmHallConfigs.get(i - 1);
                Element hallConfigRowElement = writer.writeNewField((String)new StringBuilder().append((String)"HallConfig").append((int)i).toString(), (Node)configurationElement).xmlElement;
                writer.writeNewField("SensorType", 2, hallConfig.sensorType, (Node)hallConfigRowElement);
                writer.writeNewField("InstanceId", 1, hallConfig.instanceId, (Node)hallConfigRowElement);
            }
        }
        writer.removeSizeCounter(payloadDataLength);
    }

    public void setTableEntries(ArrayList<TableEntry> data) {
        this._tableEntries = data;
    }

    public ArrayList<TableEntry> getTableEntries() {
        return this._tableEntries;
    }

    public void setActionEntries(ArrayList<ActionEntry> data) {
        this._actionEntries = data;
    }

    public ArrayList<ActionEntry> getActionEntries() {
        return this._actionEntries;
    }

    public void addTableEntry(TableEntry tableEntry) {
        this._tableEntries.add(tableEntry);
    }

    public void setPlmHallConfig(ArrayList<PlmHallConfig> hallConfigs) {
        this._plmHallConfigs = hallConfigs;
    }

    public ArrayList<PlmHallConfig> getPlmHallConfig() {
        return this._plmHallConfigs;
    }

    public void addPlmHallConfig(PlmHallConfig hallConfig) {
        this._plmHallConfigs.add(hallConfig);
    }

    @Override
    public String getConfigurationFormatString() {
        return CALIBRATION_FORMAT_STRING;
    }

    @Override
    public String getConfigurationDataString() {
        return "";
    }

    public int getFormatID() {
        return this._formatID;
    }

    public void setFormatID(int formatID) {
        this._formatID = formatID;
    }

    public int getVersion() {
        return this._version;
    }

    public void setVersion(int version) {
        this._version = version;
    }

    @Override
    public boolean controllsBusData() {
        return false;
    }

    @Override
    public boolean controllsGpioData() {
        return true;
    }

    @Override
    public void checkValidity(Validator validator, Sensor sensor) {
    }

    public int hashCode() {
        return super.hashCode();
    }

    public static class PlmHallConfig {
        public int sensorType;
        public String sensorName;
        public int instanceId;
    }

    public static class PlmSupportSensorType {
        public int sensorType;
        public String sensorName;
    }

    public static class ActionEntry {
        public int mode;
        public int gpioPurposeId;
        public int value;

        public boolean equals(Object arg0) {
            if (arg0 == null || !(arg0 instanceof ActionEntry)) {
                return false;
            }
            ActionEntry other = (ActionEntry)arg0;
            return this.mode == other.mode && this.gpioPurposeId == other.gpioPurposeId && this.value == other.value;
        }

        public int hashCode() {
            return super.hashCode();
        }
    }

    public static class ActionInfo {
        public String name;
        public int value;
        public boolean needGpio;
    }

    public static class TableEntry {
        public int modeId;
        public int entryAngle;
        public int exitAngle;
        public int t1Delta;
        public int t2Delta;
        public int th;
        public int lcdDirection;
        public int[] hallStates = new int[]{255, 255, 255, 255, 255, 255};

        public boolean equals(Object arg0) {
            if (arg0 == null || !(arg0 instanceof TableEntry)) {
                return false;
            }
            TableEntry other = (TableEntry)arg0;
            return this.modeId == other.modeId && this.entryAngle == other.entryAngle && this.exitAngle == other.exitAngle && this.t1Delta == other.t1Delta && this.t2Delta == other.t2Delta && this.th == other.th && this.lcdDirection == other.lcdDirection;
        }

        public int hashCode() {
            return super.hashCode();
        }
    }
}

