/*
 * Decompiled with CFR 0.152.
 */
package resources;

import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;

public class CustomSpinner {
    private Spinner _spinner;
    private Shell _parentShell;
    private int _lastValidInput;
    private int _lastInput;

    public CustomSpinner(Composite arg0, int arg1, Shell parentShell) {
        this._spinner = new Spinner(arg0, arg1);
        this._parentShell = parentShell;
        this._lastValidInput = this._spinner.getMinimum();
        this._lastInput = this._spinner.getMinimum();
        this._spinner.addKeyListener(new KeyListener(){

            private void onInput() {
                String lastText = CustomSpinner.this._spinner.getText();
                try {
                    CustomSpinner.this._lastInput = Integer.valueOf(lastText);
                }
                catch (Exception e) {
                    CustomSpinner.this._lastInput = Integer.MAX_VALUE;
                }
            }

            public void keyReleased(KeyEvent arg0) {
                this.onInput();
            }

            public void keyPressed(KeyEvent arg0) {
            }
        });
        this._spinner.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent arg0) {
                if (CustomSpinner.this._lastInput < CustomSpinner.this._spinner.getMinimum() || CustomSpinner.this._lastInput > CustomSpinner.this._spinner.getMaximum()) {
                    CustomSpinner.this._spinner.setSelection(CustomSpinner.this._lastValidInput);
                    CustomSpinner.this._lastInput = CustomSpinner.this._lastValidInput;
                    MessageBox messageBox = new MessageBox(CustomSpinner.this._parentShell, 33);
                    messageBox.setText("Invalid Value");
                    messageBox.setMessage("The field's value must be in the range [" + CustomSpinner.this._spinner.getMinimum() + "," + CustomSpinner.this._spinner.getMaximum() + "]. The value has been replaced by the last valid value.");
                    messageBox.open();
                    CustomSpinner.this._spinner.setFocus();
                    return;
                }
                if (!String.valueOf(CustomSpinner.this._spinner.getSelection()).equals(CustomSpinner.this._spinner.getText())) {
                    CustomSpinner.this._spinner.setSelection(Integer.valueOf(CustomSpinner.this._spinner.getText()).intValue());
                }
                CustomSpinner.this._lastValidInput = CustomSpinner.this._lastInput;
            }

            public void focusGained(FocusEvent arg0) {
            }
        });
    }

    public void addModifyListener(ModifyListener arg0) {
        this._spinner.addModifyListener(arg0);
    }

    public void setMaximum(int i) {
        this._spinner.setMaximum(i);
    }

    public void setMinimum(int i) {
        this._spinner.setMinimum(i);
        this._spinner.setSelection(i);
        this._lastValidInput = i;
        this._lastInput = i;
    }

    public void setBounds(int i, int j, int k, int l) {
        this._spinner.setBounds(i, j, k, l);
    }

    public int getSelection() {
        return this._spinner.getSelection();
    }

    public void setSelection(int selection) {
        this._lastValidInput = selection;
        this._lastInput = selection;
        this._spinner.setSelection(selection);
    }

    public String getText() {
        return this._spinner.getText();
    }

    public void setEnabled(boolean b) {
        this._spinner.setEnabled(b);
    }

    public void setFont(Font font) {
        this._spinner.setFont(font);
    }

    public Spinner getBasicSpinner() {
        return this._spinner;
    }

    public void setBackground(Color bgrdColor) {
        this._spinner.setBackground(bgrdColor);
    }

    public void setFocus() {
        this._spinner.setFocus();
    }

    public boolean isEnabled() {
        return this._spinner.isEnabled();
    }

    public void setToolTipText(String text) {
        this._spinner.setToolTipText(text);
    }

    public void setLayoutData(Object layoutData) {
        this._spinner.setLayoutData(layoutData);
    }

    public Object getLayoutData() {
        return this._spinner.getLayoutData();
    }
}

