/*
 * Decompiled with CFR 0.152.
 */
package manager;

import java.lang.reflect.Method;
import java.util.prefs.Preferences;
import manager.utils.JREVersion;

public class WinRegistry {
    public static final int SUCCESS = 0;
    private static final int READ = 131097;
    public static final int HKEY_CURRENT_USER = -2147483647;
    public static final int HKEY_LOCAL_MACHINE = -2147483646;
    private static Method mOpenKey;
    private static Method mQueryValueEx;
    private static Method mCloseKey;

    static {
        try {
            Class<?> uClass = Preferences.userRoot().getClass();
            mOpenKey = uClass.getDeclaredMethod("WindowsRegOpenKey", Integer.TYPE, byte[].class, Integer.TYPE);
            mOpenKey.setAccessible(true);
            mQueryValueEx = uClass.getDeclaredMethod("WindowsRegQueryValueEx", Integer.TYPE, byte[].class);
            mQueryValueEx.setAccessible(true);
            mCloseKey = uClass.getDeclaredMethod("WindowsRegCloseKey", Integer.TYPE);
            mCloseKey.setAccessible(true);
        }
        catch (NoSuchMethodException uClass) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String readString(int hkey, String key, String valueName) throws Exception {
        if (JREVersion.isJava8()) {
            return WinRegistry.readStringInJRE8(hkey, key, valueName);
        }
        if (JREVersion.isJava11()) {
            return WinRegistry.readStringInJRE11(hkey, valueName, valueName);
        }
        throw new Exception("Can not read reg: " + valueName + "due to incompability of your JRE version.");
    }

    private static String readStringInJRE11(int hkey, String key, String valueName) throws Exception {
        try {
            if (hkey == -2147483646) {
                return System.getenv(valueName);
            }
            if (hkey == -2147483647) {
                return System.getenv(valueName);
            }
            throw new IllegalArgumentException("hkey=" + hkey);
        }
        catch (Exception e) {
            throw new Exception("The " + valueName + " environment variable is missing.");
        }
    }

    private static String readStringInJRE8(int hkey, String key, String valueName) throws Exception {
        try {
            if (hkey == -2147483646) {
                return WinRegistry.read(Preferences.systemRoot(), hkey, key, valueName);
            }
            if (hkey == -2147483647) {
                return WinRegistry.read(Preferences.userRoot(), hkey, key, valueName);
            }
            throw new IllegalArgumentException("hkey=" + hkey);
        }
        catch (Exception e) {
            throw new Exception("The " + valueName + " environment variable is missing.");
        }
    }

    private static String read(Preferences root, int hkey, String key, String value) throws Exception {
        int[] handles = (int[])mOpenKey.invoke((Object)root, new Integer(hkey), WinRegistry.toCstr(key), new Integer(131097));
        if (handles[1] != 0) {
            return null;
        }
        byte[] valb = (byte[])mQueryValueEx.invoke((Object)root, new Integer(handles[0]), WinRegistry.toCstr(value));
        mCloseKey.invoke((Object)root, new Integer(handles[0]));
        return valb != null ? new String(valb).trim() : null;
    }

    private static byte[] toCstr(String ss) {
        byte[] ret = new byte[ss.length() + 1];
        int i = 0;
        while (i < ss.length()) {
            ret[i] = (byte)ss.charAt(i);
            ++i;
        }
        ret[ss.length()] = 0;
        return ret;
    }
}

