/*
 * Decompiled with CFR 0.152.
 */
package manager.common;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import manager.common.BiMap;
import manager.configure.Platform;
import manager.utils.ManagerEnums;
import manager.utils.ManagerFileUtils;
import manager.utils.ManagerXMLUtils;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class SensorsDefinitionsMapping {
    private static SensorsDefinitionsMapping instance = null;
    private static HashMap<Platform, BiMap<Integer, String>> physicalSensorTypesDefinitions;
    private static HashMap<Platform, BiMap<Integer, String>> virtualSensorTypesDefinitions;
    private static HashMap<Platform, BiMap<Integer, String>> vendorsDefinitions;
    private static HashMap<Platform, BiMap<Integer, BiMap<Integer, BiMap<Integer, String>>>> modelsDefinitions;
    private static HashMap<Platform, ArrayList<String>> fieldIdsDefinitions;
    private static HashMap<Platform, ArrayList<String>> unitsDefinitions;
    private static HashMap<Platform, HashMap<String, String>> callbackDefinitions;
    private static BiMap<Integer, String> physicalMinTypesDefinitions;

    public static SensorsDefinitionsMapping getInstance() {
        if (instance == null) {
            instance = new SensorsDefinitionsMapping();
            physicalSensorTypesDefinitions = new HashMap();
            virtualSensorTypesDefinitions = new HashMap();
            vendorsDefinitions = new HashMap();
            modelsDefinitions = new HashMap();
            fieldIdsDefinitions = new HashMap();
            unitsDefinitions = new HashMap();
            callbackDefinitions = new HashMap();
        }
        return instance;
    }

    public BiMap<Integer, String> getPhysicalSensorTypesDefinitions(Platform platform) throws Exception {
        BiMap<Integer, String> ret;
        if (physicalSensorTypesDefinitions.get(platform) == null) {
            this.loadPhysicalSensorTypesDefinitions(platform);
        }
        if ((ret = physicalSensorTypesDefinitions.get(platform)) == null) {
            return new BiMap<Integer, String>();
        }
        return ret;
    }

    public BiMap<Integer, String> getVirtualSensorTypesDefinitions(Platform platform) throws Exception {
        BiMap<Integer, String> ret;
        if (virtualSensorTypesDefinitions.get(platform) == null) {
            this.loadVirtualSensorTypesDefinitions(platform);
        }
        if ((ret = virtualSensorTypesDefinitions.get(platform)) == null) {
            return new BiMap<Integer, String>();
        }
        return ret;
    }

    public BiMap<Integer, String> getPhysicalMinTypesDefinitions() throws Exception {
        if (physicalMinTypesDefinitions == null) {
            this.loadPhysicalMinTypesDefinitions();
        }
        return physicalMinTypesDefinitions;
    }

    public BiMap<Integer, String> getVendorsDefinitions(Platform platform) throws Exception {
        BiMap<Integer, String> ret;
        if (vendorsDefinitions.get(platform) == null) {
            this.loadVendorsDefinitions(platform);
        }
        if ((ret = vendorsDefinitions.get(platform)) == null) {
            return new BiMap<Integer, String>();
        }
        return ret;
    }

    public BiMap<Integer, String> getModelsByVendorAndType(String vendorName, String typeName, boolean onlyPhysical, Platform platform) throws Exception {
        BiMap<Integer, String> ret = new BiMap<Integer, String>();
        if (vendorName != null && typeName != null && !vendorName.isEmpty() && !typeName.isEmpty()) {
            int typeId;
            int vendorId;
            try {
                Integer vid = SensorsDefinitionsMapping.getInstance().getVendorsDefinitions(platform).getBackward(vendorName);
                vendorId = vid == null ? Integer.parseInt(vendorName) : vid;
            }
            catch (Exception ex) {
                throw new Exception("Unrecognized vendor.");
            }
            try {
                Integer tid;
                typeId = onlyPhysical ? ((tid = SensorsDefinitionsMapping.getInstance().getPhysicalSensorTypesDefinitions(platform).getBackward(typeName)) == null ? Integer.parseInt(typeName) : tid) : ((tid = SensorsDefinitionsMapping.getInstance().getVirtualSensorTypesDefinitions(platform).getBackward(typeName)) == null ? Integer.parseInt(typeName) : tid);
            }
            catch (Exception ex) {
                throw new Exception("Unrecognized sensor type.");
            }
            BiMap<Integer, BiMap<Integer, BiMap<Integer, String>>> generalList = this.getModelsDefinitions(onlyPhysical, platform);
            BiMap<Integer, BiMap<Integer, String>> currentVendorList = generalList.getForward(vendorId);
            if (currentVendorList != null) {
                ret = currentVendorList.getForward(typeId);
            }
        }
        if (ret != null) {
            return ret;
        }
        return new BiMap<Integer, String>();
    }

    public BiMap<Integer, BiMap<Integer, BiMap<Integer, String>>> getModelsDefinitions(boolean onlyPhysical, Platform platform) throws Exception {
        BiMap<Integer, BiMap<Integer, BiMap<Integer, String>>> ret;
        if (modelsDefinitions.get(platform) == null) {
            this.loadModelsDefinitions(onlyPhysical, platform);
        }
        if ((ret = modelsDefinitions.get(platform)) == null) {
            return new BiMap<Integer, BiMap<Integer, BiMap<Integer, String>>>();
        }
        return ret;
    }

    public ArrayList<String> getFieldIdsDefinitions(Platform platform) throws Exception {
        if (fieldIdsDefinitions.get(platform) == null) {
            this.loadFieldIdsDefinitions(platform);
        }
        return fieldIdsDefinitions.get(platform);
    }

    public ArrayList<String> getUnitsDefinitions(Platform platform) throws Exception {
        if (unitsDefinitions.get(platform) == null) {
            this.loadUnitsDefinitions(platform);
        }
        return unitsDefinitions.get(platform);
    }

    public HashMap<String, String> getCallbacksDefinitions(Platform platform) throws Exception {
        HashMap<String, String> ret;
        if (callbackDefinitions.get(platform) == null) {
            this.loadCallbacksDefinitions(platform);
        }
        if ((ret = callbackDefinitions.get(platform)) == null) {
            return new HashMap<String, String>();
        }
        return ret;
    }

    private void loadPhysicalSensorTypesDefinitions(Platform platform) throws Exception {
        BiMap<Integer, String> sensorTypesDefinitionsTemp = new BiMap<Integer, String>();
        NodeList intelSensorTypesList = ManagerXMLUtils.getXMLElements(ManagerFileUtils.getIntelSensorDefinitionsFilePath(platform), "SensorType");
        int i = 0;
        while (i < intelSensorTypesList.getLength()) {
            Element sensorType = (Element)intelSensorTypesList.item(i);
            if (sensorType.getAttribute("flag") != null && sensorType.getAttribute("flag").equals(ManagerEnums.ObjectTypes.PHYSICAL.name())) {
                sensorTypesDefinitionsTemp.put(Integer.parseInt(sensorType.getAttribute("SensorTypeId")), sensorType.getAttribute("Name"));
            }
            ++i;
        }
        this.getUserPhysicalTypes(sensorTypesDefinitionsTemp);
        physicalSensorTypesDefinitions.put(platform, sensorTypesDefinitionsTemp);
    }

    private void getUserPhysicalTypes(BiMap<Integer, String> sensorTypesDefinitionsTemp) throws Exception {
        if (new File(ManagerFileUtils.getUserSensorDefinitionsFilePath()).exists()) {
            NodeList userSensorTypesList = ManagerXMLUtils.getXMLElements(ManagerFileUtils.getUserSensorDefinitionsFilePath(), "SensorType");
            int i = 0;
            while (i < userSensorTypesList.getLength()) {
                Element sensorType = (Element)userSensorTypesList.item(i);
                if (sensorType.getAttribute("flag") != null && sensorType.getAttribute("flag").equals(ManagerEnums.ObjectTypes.PHYSICAL.name())) {
                    sensorTypesDefinitionsTemp.put(Integer.parseInt(sensorType.getAttribute("SensorTypeId")), sensorType.getAttribute("Name"));
                }
                ++i;
            }
        }
    }

    private void loadVirtualSensorTypesDefinitions(Platform platform) throws Exception {
        BiMap<Integer, String> sensorTypesDefinitionsTemp = new BiMap<Integer, String>();
        NodeList intelSensorTypesList = ManagerXMLUtils.getXMLElements(ManagerFileUtils.getIntelSensorDefinitionsFilePath(platform), "SensorType");
        int i = 0;
        while (i < intelSensorTypesList.getLength()) {
            Element sensorType = (Element)intelSensorTypesList.item(i);
            if (sensorType.getAttribute("flag") != null && (sensorType.getAttribute("flag").equals(ManagerEnums.ObjectTypes.PHYSICAL.name()) || sensorType.getAttribute("flag").equals(ManagerEnums.ObjectTypes.VIRTUAL.name()))) {
                sensorTypesDefinitionsTemp.put(Integer.parseInt(sensorType.getAttribute("SensorTypeId")), sensorType.getAttribute("Name"));
            }
            ++i;
        }
        if (new File(ManagerFileUtils.getUserSensorDefinitionsFilePath()).exists()) {
            NodeList userSensorTypesList = ManagerXMLUtils.getXMLElements(ManagerFileUtils.getUserSensorDefinitionsFilePath(), "SensorType");
            int i2 = 0;
            while (i2 < userSensorTypesList.getLength()) {
                Element sensorType = (Element)userSensorTypesList.item(i2);
                if (sensorType.getAttribute("flag") != null && (sensorType.getAttribute("flag").equals(ManagerEnums.ObjectTypes.PHYSICAL.name()) || sensorType.getAttribute("flag").equals(ManagerEnums.ObjectTypes.VIRTUAL.name()))) {
                    sensorTypesDefinitionsTemp.put(Integer.parseInt(sensorType.getAttribute("SensorTypeId")), sensorType.getAttribute("Name"));
                }
                ++i2;
            }
        }
        virtualSensorTypesDefinitions.put(platform, sensorTypesDefinitionsTemp);
    }

    private void loadPhysicalMinTypesDefinitions() throws Exception {
        physicalMinTypesDefinitions = new BiMap();
        physicalMinTypesDefinitions.put(17, "BIOMETRIC_PRESENCE");
        physicalMinTypesDefinitions.put(49, "ENVIRONMENTAL_ATMOSPHERIC_PRESSURE");
        physicalMinTypesDefinitions.put(50, "ENVIRONMENTAL_HUMIDITY");
        physicalMinTypesDefinitions.put(51, "ENVIRONMENTAL_TEMPERATURE");
        physicalMinTypesDefinitions.put(527, "INTEL_MOTION_MAGNETOMETER_3D");
        physicalMinTypesDefinitions.put(65, "LIGHT_AMBIENTLIGHT");
        physicalMinTypesDefinitions.put(115, "MOTION_ACCELEROMETER_3D");
        physicalMinTypesDefinitions.put(118, "MOTION_GYROMETER_3D");
        physicalMinTypesDefinitions.put(228, "OTHER_HEALTH_MONITOR");
        this.getUserPhysicalTypes(physicalMinTypesDefinitions);
    }

    private void loadVendorsDefinitions(Platform platform) throws Exception {
        BiMap<Integer, String> vendorsDefinitionsTemp = new BiMap<Integer, String>();
        NodeList intelVendorsList = ManagerXMLUtils.getXMLElements(ManagerFileUtils.getIntelSensorDefinitionsFilePath(platform), "Vendor");
        int i = 0;
        while (i < intelVendorsList.getLength()) {
            Element vendor = (Element)intelVendorsList.item(i);
            vendorsDefinitionsTemp.put(Integer.parseInt(vendor.getAttribute("VendorId")), vendor.getAttribute("VendorName"));
            ++i;
        }
        if (new File(ManagerFileUtils.getUserSensorDefinitionsFilePath()).exists()) {
            NodeList userVendorsList = ManagerXMLUtils.getXMLElements(ManagerFileUtils.getUserSensorDefinitionsFilePath(), "Vendor");
            int i2 = 0;
            while (i2 < userVendorsList.getLength()) {
                Element vendor = (Element)userVendorsList.item(i2);
                vendorsDefinitionsTemp.put(Integer.parseInt(vendor.getAttribute("VendorId")), vendor.getAttribute("VendorName"));
                ++i2;
            }
        }
        vendorsDefinitions.put(platform, vendorsDefinitionsTemp);
    }

    private void loadModelsDefinitions(boolean onlyPhysical, Platform platform) throws Exception {
        BiMap modelsDefinitionsTemp = new BiMap();
        NodeList vendorsList = ManagerXMLUtils.getXMLElements(ManagerFileUtils.getIntelSensorDefinitionsFilePath(platform), "Vendor");
        int i = 0;
        while (i < vendorsList.getLength()) {
            Element vendor = (Element)vendorsList.item(i);
            BiMap types = new BiMap();
            NodeList typesList = vendor.getElementsByTagName("SensorType");
            int j = 0;
            while (j < typesList.getLength()) {
                Element type = (Element)typesList.item(j);
                BiMap<Integer, String> models = new BiMap<Integer, String>();
                NodeList modelsList = type.getElementsByTagName("Model");
                int k = 0;
                while (k < modelsList.getLength()) {
                    Element model = (Element)modelsList.item(k);
                    if (!model.getAttribute("ModelName").isEmpty() && (onlyPhysical && Boolean.parseBoolean(model.getAttribute("isPhysical")) || !onlyPhysical)) {
                        models.put(Integer.parseInt(model.getAttribute("ModelId")), model.getAttribute("ModelName"));
                    }
                    ++k;
                }
                types.put(Integer.parseInt(type.getAttribute("SensorTypeId")), models);
                ++j;
            }
            modelsDefinitionsTemp.put(Integer.parseInt(vendor.getAttribute("VendorId")), types);
            ++i;
        }
        modelsDefinitions.put(platform, modelsDefinitionsTemp);
    }

    private void loadFieldIdsDefinitions(Platform platform) throws Exception {
        ArrayList<String> fieldIdsDefinitionsTemp = new ArrayList<String>();
        NodeList fieldIdsList = ManagerXMLUtils.getXMLElements(ManagerFileUtils.getIntelSensorDefinitionsFilePath(platform), "Usage");
        int i = 0;
        while (i < fieldIdsList.getLength()) {
            fieldIdsDefinitionsTemp.add(fieldIdsList.item(i).getTextContent());
            ++i;
        }
        fieldIdsDefinitions.put(platform, fieldIdsDefinitionsTemp);
    }

    private void loadUnitsDefinitions(Platform platform) throws Exception {
        ArrayList<String> unitsDefinitionsTemp = new ArrayList<String>();
        NodeList unitsList = ManagerXMLUtils.getXMLElements(ManagerFileUtils.getIntelSensorDefinitionsFilePath(platform), "Unit");
        int i = 0;
        while (i < unitsList.getLength()) {
            unitsDefinitionsTemp.add(unitsList.item(i).getTextContent());
            ++i;
        }
        unitsDefinitions.put(platform, unitsDefinitionsTemp);
    }

    private void loadCallbacksDefinitions(Platform platform) throws Exception {
        HashMap<String, String> callbacksDefinitionsTemp = new HashMap<String, String>();
        NodeList callbacksList = ManagerXMLUtils.getXMLElements(ManagerFileUtils.getIntelSensorDefinitionsFilePath(platform), "Callback");
        int i = 0;
        while (i < callbacksList.getLength()) {
            Element callback = (Element)callbacksList.item(i);
            callbacksDefinitionsTemp.put(callback.getAttribute("Name"), callback.getAttribute("Prototype"));
            ++i;
        }
        callbackDefinitions.put(platform, callbacksDefinitionsTemp);
    }

    public ArrayList<Integer> getIntelImplementedFormats(String typeId, ManagerEnums.ObjectTypes objectType, Platform platform) throws Exception {
        if (objectType == ManagerEnums.ObjectTypes.PHYSICAL || objectType == ManagerEnums.ObjectTypes.VIRTUAL) {
            boolean isPhysical = objectType == ManagerEnums.ObjectTypes.PHYSICAL;
            ArrayList<Integer> intelImplementedFormats = new ArrayList<Integer>();
            NodeList calibrationSensorTypes = ManagerXMLUtils.getXMLElements(ManagerFileUtils.getIntelSensorDefinitionsFilePath(platform), "CalibrationFormats", "CalibrationSensorType");
            if (calibrationSensorTypes != null) {
                int i = 0;
                while (i < calibrationSensorTypes.getLength()) {
                    if (calibrationSensorTypes.item(i).getAttributes().getNamedItem("SensorTypeId").getNodeValue().equals(typeId) && (calibrationSensorTypes.item(i).getAttributes().getNamedItem("physical") == null || calibrationSensorTypes.item(i).getAttributes().getNamedItem("physical").getNodeValue().equals(isPhysical ? "1" : "0"))) {
                        NodeList formatIds = ((Element)calibrationSensorTypes.item(i)).getElementsByTagName("FormatId");
                        int j = 0;
                        while (j < formatIds.getLength()) {
                            intelImplementedFormats.add(Integer.parseInt(formatIds.item(j).getTextContent()));
                            ++j;
                        }
                    }
                    ++i;
                }
            }
            return intelImplementedFormats;
        }
        return new ArrayList<Integer>();
    }

    public void addSensorType(Integer typeId, String typeName, ManagerEnums.ObjectTypes objectType, Platform platform) throws Exception {
        for (Platform plat : virtualSensorTypesDefinitions.keySet()) {
            BiMap<Integer, String> virtualDefs = this.getVirtualSensorTypesDefinitions(plat);
            if (virtualDefs == null) continue;
            virtualDefs.put(typeId, typeName);
        }
        if (objectType == ManagerEnums.ObjectTypes.PHYSICAL) {
            for (Platform plat : physicalSensorTypesDefinitions.keySet()) {
                BiMap<Integer, String> physicalDefs = this.getPhysicalSensorTypesDefinitions(plat);
                if (physicalDefs == null) continue;
                physicalDefs.put(typeId, typeName);
            }
            this.getPhysicalMinTypesDefinitions().put(typeId, typeName);
        }
    }

    public void addVendor(Integer vendorId, String vendorName, Platform platform) throws Exception {
        for (Platform plat : vendorsDefinitions.keySet()) {
            BiMap<Integer, String> vendorDefs = this.getVendorsDefinitions(plat);
            if (vendorDefs == null) continue;
            vendorDefs.put(vendorId, vendorName);
        }
    }

    public void removeSensorType(Integer typeId, String typeName, ManagerEnums.ObjectTypes objectType, Platform platform) throws Exception {
        for (Platform plat : virtualSensorTypesDefinitions.keySet()) {
            BiMap<Integer, String> virtualDefs = this.getVirtualSensorTypesDefinitions(plat);
            if (virtualDefs == null) continue;
            virtualDefs.remove(typeId, typeName);
        }
        if (objectType == ManagerEnums.ObjectTypes.PHYSICAL) {
            for (Platform plat : physicalSensorTypesDefinitions.keySet()) {
                BiMap<Integer, String> physicalDefs = this.getPhysicalSensorTypesDefinitions(plat);
                if (physicalDefs == null) continue;
                physicalDefs.remove(typeId, typeName);
            }
            this.getPhysicalMinTypesDefinitions().remove(typeId, typeName);
        }
    }

    public void removeVendor(Integer vendorId, String vendorName, Platform platform) throws Exception {
        for (Platform plat : vendorsDefinitions.keySet()) {
            BiMap<Integer, String> vendorDefs = this.getVendorsDefinitions(plat);
            if (vendorDefs == null) continue;
            vendorDefs.remove(vendorId, vendorName);
        }
    }

    public static String getSensorTypeById(int typeId, ManagerEnums.ObjectTypes objectType, Platform platform) {
        String typeName;
        try {
            typeName = objectType == ManagerEnums.ObjectTypes.PHYSICAL ? SensorsDefinitionsMapping.getInstance().getPhysicalSensorTypesDefinitions(platform).getForward(typeId) : SensorsDefinitionsMapping.getInstance().getVirtualSensorTypesDefinitions(platform).getForward(typeId);
        }
        catch (Exception e) {
            typeName = Integer.toString(typeId);
        }
        return typeName;
    }

    public static String getVendorNameById(int vendorId, ManagerEnums.ObjectTypes objectType, Platform platfrom) {
        try {
            String vendorName = SensorsDefinitionsMapping.getInstance().getVendorsDefinitions(platfrom).getForward(vendorId);
            return vendorName;
        }
        catch (Exception e) {
            return Integer.toString(vendorId);
        }
    }

    public static String getModelNameById(int modelId, ManagerEnums.ObjectTypes objectType, Platform platfrom) {
        return "";
    }
}

