/*
 * Decompiled with CFR 0.152.
 */
package manager.utils;

import java.util.ArrayList;

public class ManagerEnums {

    public static enum AppType {
        EC("Embedded controller template", "apply to embedded controller application");

        private String friendlyName;
        private String desc;

        private AppType(String friendlyName, String desc) {
            this.friendlyName = friendlyName;
            this.desc = desc;
        }

        public static AppType getValueByFriendlyName(String friendlyName) {
            AppType[] appTypeArray = AppType.values();
            int n = appTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                AppType type = appTypeArray[n2];
                if (type.getFriendlyName().toLowerCase().equals(friendlyName.toLowerCase())) {
                    return type;
                }
                ++n2;
            }
            return null;
        }

        public String getFriendlyName() {
            return this.friendlyName;
        }

        public String getDesc() {
            return this.desc;
        }

        public static String[] getFriendlyNames() {
            ArrayList<String> names = new ArrayList<String>();
            AppType[] appTypeArray = AppType.values();
            int n = appTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                AppType at = appTypeArray[n2];
                names.add(at.getFriendlyName());
                ++n2;
            }
            return names.toArray(new String[names.size()]);
        }
    }

    public static enum BuildErrorTypes {
        SUCCESS(0),
        MISSING_SENSOR(1),
        MISSING_DEPENDENCY(2),
        UNKNOWN(3);

        private int value;

        private BuildErrorTypes(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static BuildErrorTypes getValueByName(String name) {
            BuildErrorTypes[] buildErrorTypesArray = BuildErrorTypes.values();
            int n = buildErrorTypesArray.length;
            int n2 = 0;
            while (n2 < n) {
                BuildErrorTypes type = buildErrorTypesArray[n2];
                if (type.name().toLowerCase().equals(name.toLowerCase())) {
                    return type;
                }
                ++n2;
            }
            return null;
        }
    }

    public static enum BuildReason {
        BUILD,
        REBUILD,
        RUN,
        EXPORT,
        EDIT_PDT,
        BATCH_BUILD,
        INSTALL,
        SINGLE_BUILD,
        BATCH_INSTALL,
        BATCH_EXPORT,
        UNKNOWN;

    }

    public static enum BusTypes {
        I2C(0),
        UART(1),
        SPI(2);

        private int value;

        private BusTypes(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static BusTypes getValueByName(String name) {
            BusTypes[] busTypesArray = BusTypes.values();
            int n = busTypesArray.length;
            int n2 = 0;
            while (n2 < n) {
                BusTypes bus = busTypesArray[n2];
                if (bus.name().toLowerCase().equals(name.toLowerCase())) {
                    return bus;
                }
                ++n2;
            }
            return null;
        }
    }

    public static enum CompilationMode {
        Debug(0, "Debug"),
        Release(1, "Release");

        private int value;
        private String friendlyName;

        private CompilationMode(int value, String friendlyName) {
            this.value = value;
            this.friendlyName = friendlyName;
        }

        public int getValue() {
            return this.value;
        }

        public String getFriendlyName() {
            return this.friendlyName;
        }

        public static CompilationMode getValueByName(String name) {
            CompilationMode[] compilationModeArray = CompilationMode.values();
            int n = compilationModeArray.length;
            int n2 = 0;
            while (n2 < n) {
                CompilationMode conf = compilationModeArray[n2];
                if (conf.name().toLowerCase().equals(name.toLowerCase())) {
                    return conf;
                }
                ++n2;
            }
            return null;
        }
    }

    public static enum ComponentName {
        SENSOR("sensor"),
        LIBRARY("library"),
        SENSORS("sensors"),
        LIBRARIES("libraries"),
        APP("app"),
        APPS("apps");

        private String friendlyName;

        private ComponentName(String friendlyName) {
            this.friendlyName = friendlyName;
        }

        public static ComponentName getValueByFriendlyName(String friendlyName) {
            ComponentName[] componentNameArray = ComponentName.values();
            int n = componentNameArray.length;
            int n2 = 0;
            while (n2 < n) {
                ComponentName name = componentNameArray[n2];
                if (name.getFriendlyName().toLowerCase().equals(friendlyName.toLowerCase())) {
                    return name;
                }
                ++n2;
            }
            return null;
        }

        public String getFriendlyName() {
            return this.friendlyName;
        }
    }

    public static enum ComponentOwner {
        INTEL("Intel"),
        THIRD_PARTY("Third Party"),
        USER("User"),
        THIRD_PARTY_PACKAGE("Third Party Package");

        private String friendlyName;

        private ComponentOwner(String friendlyName) {
            this.friendlyName = friendlyName;
        }

        public static ComponentOwner getValueByFriendlyName(String friendlyName) {
            ComponentOwner[] componentOwnerArray = ComponentOwner.values();
            int n = componentOwnerArray.length;
            int n2 = 0;
            while (n2 < n) {
                ComponentOwner owner = componentOwnerArray[n2];
                if (owner.getFriendlyName().toLowerCase().equals(friendlyName.toLowerCase())) {
                    return owner;
                }
                ++n2;
            }
            return null;
        }

        public String getFriendlyName() {
            return this.friendlyName;
        }

        public Boolean isThirdParty() {
            if (this == THIRD_PARTY) {
                return true;
            }
            return false;
        }

        public Boolean isThirdPartyPackage() {
            if (this == THIRD_PARTY_PACKAGE) {
                return true;
            }
            return false;
        }
    }

    public static enum Configurations {
        AUTO(0, "ALGO_REPORTER_CONFIG_AUTO_CONFIG"),
        FORWARD(1, "ALGO_REPORTER_CONFIG_FWD_CONFIG"),
        MANUAL(2, "");

        private int value;
        String fwName;

        private Configurations(int value, String fwName) {
            this.value = value;
            this.fwName = fwName;
        }

        public int getValue() {
            return this.value;
        }

        public String getFwName() {
            return this.fwName;
        }

        public static Configurations getValueByName(String name) {
            Configurations[] configurationsArray = Configurations.values();
            int n = configurationsArray.length;
            int n2 = 0;
            while (n2 < n) {
                Configurations config = configurationsArray[n2];
                if (config.name().toLowerCase().equals(name.toLowerCase())) {
                    return config;
                }
                ++n2;
            }
            return null;
        }

        public static String[] getNames() {
            ArrayList<String> names = new ArrayList<String>();
            Configurations[] configurationsArray = Configurations.values();
            int n = configurationsArray.length;
            int n2 = 0;
            while (n2 < n) {
                Configurations config = configurationsArray[n2];
                names.add(config.name());
                ++n2;
            }
            return names.toArray(new String[names.size()]);
        }

        public static Configurations getConfigurationByValue(int value) {
            Configurations[] configurationsArray = Configurations.values();
            int n = configurationsArray.length;
            int n2 = 0;
            while (n2 < n) {
                Configurations config = configurationsArray[n2];
                if (config.value == value) {
                    return config;
                }
                ++n2;
            }
            return null;
        }
    }

    public static enum ConnectionType {
        NETWORK,
        ADB;


        public static ConnectionType getValueByName(String name) {
            ConnectionType[] connectionTypeArray = ConnectionType.values();
            int n = connectionTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                ConnectionType type = connectionTypeArray[n2];
                if (type.name().toLowerCase().equals(name.toLowerCase())) {
                    return type;
                }
                ++n2;
            }
            return null;
        }
    }

    public static enum DependencyTypes {
        MANDATORY(0),
        IF_AVAILABLE(1),
        IF_STREAMING(2);

        private int value;

        private DependencyTypes(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static DependencyTypes getValueByName(String name) {
            DependencyTypes[] dependencyTypesArray = DependencyTypes.values();
            int n = dependencyTypesArray.length;
            int n2 = 0;
            while (n2 < n) {
                DependencyTypes dependency = dependencyTypesArray[n2];
                if (dependency.name().toLowerCase().equals(name.toLowerCase())) {
                    return dependency;
                }
                ++n2;
            }
            return null;
        }

        public static String[] getNames() {
            ArrayList<String> names = new ArrayList<String>();
            DependencyTypes[] dependencyTypesArray = DependencyTypes.values();
            int n = dependencyTypesArray.length;
            int n2 = 0;
            while (n2 < n) {
                DependencyTypes dependency = dependencyTypesArray[n2];
                names.add(dependency.name());
                ++n2;
            }
            return names.toArray(new String[names.size()]);
        }

        public static DependencyTypes getDependencyByValue(int value) {
            DependencyTypes[] dependencyTypesArray = DependencyTypes.values();
            int n = dependencyTypesArray.length;
            int n2 = 0;
            while (n2 < n) {
                DependencyTypes dependency = dependencyTypesArray[n2];
                if (dependency.value == value) {
                    return dependency;
                }
                ++n2;
            }
            return null;
        }
    }

    public static enum ExecutionEnvironments {
        SIMICS(0, "Simics", "simics"),
        GALILEO_FULL(1, "Galileo Full", "galileo"),
        GALILEO_LITE(2, "Galileo Lite", "galileo"),
        SILICON(3, "Silicon", "silicon");

        private int value;
        private String frienlyName;
        private String PDTExName;

        private ExecutionEnvironments(int value, String friendlyName, String PDTExName) {
            this.value = value;
            this.frienlyName = friendlyName;
            this.PDTExName = PDTExName;
        }

        public int getValue() {
            return this.value;
        }

        public String getPDTExName() {
            return this.PDTExName;
        }

        public String getFriendlyName() {
            return this.frienlyName;
        }

        public static ExecutionEnvironments getValueByName(String name) {
            ExecutionEnvironments[] executionEnvironmentsArray = ExecutionEnvironments.values();
            int n = executionEnvironmentsArray.length;
            int n2 = 0;
            while (n2 < n) {
                ExecutionEnvironments env = executionEnvironmentsArray[n2];
                if (env.name().toLowerCase().equals(name.toLowerCase())) {
                    return env;
                }
                ++n2;
            }
            return null;
        }

        public static ExecutionEnvironments getValueByPDTExName(String PDTExName) {
            ExecutionEnvironments[] executionEnvironmentsArray = ExecutionEnvironments.values();
            int n = executionEnvironmentsArray.length;
            int n2 = 0;
            while (n2 < n) {
                ExecutionEnvironments env = executionEnvironmentsArray[n2];
                if (env.PDTExName.toLowerCase().equals(PDTExName.toLowerCase())) {
                    return env;
                }
                ++n2;
            }
            return null;
        }

        public static ExecutionEnvironments getValueByFriendlyName(String name) {
            ExecutionEnvironments[] executionEnvironmentsArray = ExecutionEnvironments.values();
            int n = executionEnvironmentsArray.length;
            int n2 = 0;
            while (n2 < n) {
                ExecutionEnvironments env = executionEnvironmentsArray[n2];
                if (env.frienlyName.toLowerCase().equals(name.toLowerCase())) {
                    return env;
                }
                ++n2;
            }
            return null;
        }

        public static String[] getFriendlyNames() {
            ArrayList<String> names = new ArrayList<String>();
            ExecutionEnvironments[] executionEnvironmentsArray = ExecutionEnvironments.values();
            int n = executionEnvironmentsArray.length;
            int n2 = 0;
            while (n2 < n) {
                ExecutionEnvironments env = executionEnvironmentsArray[n2];
                names.add(env.getFriendlyName());
                ++n2;
            }
            return names.toArray(new String[names.size()]);
        }
    }

    public static enum FieldTypes {
        INT8(0),
        INT16(1),
        INT32(2),
        UINT8(3),
        UINT16(4),
        UINT32(5);

        private int value;

        private FieldTypes(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static FieldTypes getValueByName(String name) {
            FieldTypes[] fieldTypesArray = FieldTypes.values();
            int n = fieldTypesArray.length;
            int n2 = 0;
            while (n2 < n) {
                FieldTypes fieldType = fieldTypesArray[n2];
                if (fieldType.name().toLowerCase().equals(name.toLowerCase())) {
                    return fieldType;
                }
                ++n2;
            }
            return null;
        }

        public static String[] getNames() {
            ArrayList<String> names = new ArrayList<String>();
            FieldTypes[] fieldTypesArray = FieldTypes.values();
            int n = fieldTypesArray.length;
            int n2 = 0;
            while (n2 < n) {
                FieldTypes fieldType = fieldTypesArray[n2];
                names.add(fieldType.name());
                ++n2;
            }
            return names.toArray(new String[names.size()]);
        }

        public static FieldTypes getFieldTypeByValue(int value) {
            FieldTypes[] fieldTypesArray = FieldTypes.values();
            int n = fieldTypesArray.length;
            int n2 = 0;
            while (n2 < n) {
                FieldTypes type = fieldTypesArray[n2];
                if (type.value == value) {
                    return type;
                }
                ++n2;
            }
            return null;
        }
    }

    public static enum FlagValues {
        DEFINE_IN_PDT(2, "Define in PDT"),
        YES(0, "Yes"),
        NO(1, "No");

        private int value;
        String friendlyName;

        private FlagValues(int value, String friendlyName) {
            this.value = value;
            this.friendlyName = friendlyName;
        }

        public int getValue() {
            return this.value;
        }

        public static FlagValues getValueByName(String name) {
            FlagValues[] flagValuesArray = FlagValues.values();
            int n = flagValuesArray.length;
            int n2 = 0;
            while (n2 < n) {
                FlagValues type = flagValuesArray[n2];
                if (type.name().toLowerCase().equals(name.toLowerCase())) {
                    return type;
                }
                ++n2;
            }
            return null;
        }

        public static FlagValues getValueByFriendlyName(String friendlyName) {
            FlagValues[] flagValuesArray = FlagValues.values();
            int n = flagValuesArray.length;
            int n2 = 0;
            while (n2 < n) {
                FlagValues type = flagValuesArray[n2];
                if (type.friendlyName.toLowerCase().equals(friendlyName.toLowerCase())) {
                    return type;
                }
                ++n2;
            }
            return null;
        }

        public String getFriendlyName() {
            return this.friendlyName;
        }

        public static String[] getFriendlyNames() {
            ArrayList<String> names = new ArrayList<String>();
            FlagValues[] flagValuesArray = FlagValues.values();
            int n = flagValuesArray.length;
            int n2 = 0;
            while (n2 < n) {
                FlagValues version = flagValuesArray[n2];
                names.add(version.getFriendlyName());
                ++n2;
            }
            return names.toArray(new String[names.size()]);
        }
    }

    public static enum Flags {
        SC_LUID_FLAG_NONE(0, "NONE", ""),
        SC_LUID_FLAG_CALIBRATED(1, "CALIBRATED", ""),
        SC_LUID_FLAG_PHYSICAL(2, "PHYSICAL", ""),
        SC_LUID_FLAG_MS_EXT(3, "MS_EXT", ""),
        SC_LUID_FLAG_ANDROID_EXT(4, "ANDROID_EXT", ""),
        SC_LUID_FLAG_SYNTHETIC(5, "SYNTHETIC", ""),
        reserved(6, "reserved", ""),
        SC_LUID_FLAG_NOT_EXPSOED(7, "NOT_EXPSOED", "SC_DESC_FLAG_NOT_EXPOSED"),
        SC_LUID_FLAG_CUSTOM(8, "CUSTOM", "SC_DESC_FLAG_HID_CUSTOM_SENSOR");

        private int value;
        String friendlyName;
        String descriptorName;

        private Flags(int value, String friendlyName, String descriptorName) {
            this.value = value;
            this.friendlyName = friendlyName;
            this.descriptorName = descriptorName;
        }

        public int getValue() {
            return this.value;
        }

        public String getFriendlyName() {
            return this.friendlyName;
        }

        public String getDescriptorName() {
            return this.descriptorName;
        }

        public static Flags getValueByName(String name) {
            Flags[] flagsArray = Flags.values();
            int n = flagsArray.length;
            int n2 = 0;
            while (n2 < n) {
                Flags flag = flagsArray[n2];
                if (flag.name().toLowerCase().equals(name.toLowerCase())) {
                    return flag;
                }
                ++n2;
            }
            return null;
        }
    }

    public static enum MessageTypes {
        INFORMATION,
        ERROR,
        QUESTION,
        WARNING;

    }

    public static enum NAMING_ERROR {
        OK,
        IDENTIFIER_IS_EMPTY,
        IDENTIFIER_STARTS_WITH_DIGIT,
        IDENTIFIER_STARTS_WITH_ILLEGAL_CHAR,
        IDENTIFIER_CONTAINS_DIGIT,
        IDENTIFIER_IS_RESERVED_WORD,
        PACKAGE_STARTS_OR_ENDS_WITH_DOT,
        INTEL_RESERVED_PACKAGE_NAME,
        IDENTIFIER_CONTAINS_NOT_LETTER_DIGIT;

        boolean _toSplit = false;

        public void setToSplit(boolean toSplit) {
            this._toSplit = toSplit;
        }

        public String toString() {
            String res = "";
            switch (this) {
                case OK: {
                    res = "OK";
                    break;
                }
                case IDENTIFIER_IS_EMPTY: {
                    res = "must not be empty.";
                    break;
                }
                case IDENTIFIER_IS_RESERVED_WORD: {
                    res = "must not be a reserved word.";
                    break;
                }
                case IDENTIFIER_STARTS_WITH_ILLEGAL_CHAR: {
                    res = "must not start" + (this._toSplit ? "\n" : " ") + "with an illegal character.";
                    break;
                }
                case IDENTIFIER_STARTS_WITH_DIGIT: {
                    res = "must not start" + (this._toSplit ? "\n" : " ") + "with a digit.";
                    break;
                }
                case IDENTIFIER_CONTAINS_NOT_LETTER_DIGIT: {
                    res = "must contain only" + (this._toSplit ? "\n" : " ") + "alphanumeric characters.";
                    break;
                }
                default: {
                    return res;
                }
            }
            return res;
        }
    }

    public static enum ObjectTypes {
        PHYSICAL(0, "Physical"),
        VIRTUAL(1, "Virtual"),
        LIBRARY(2, "Library");

        private int value;
        String friendlyName;

        private ObjectTypes(int value, String friendlyName) {
            this.value = value;
            this.friendlyName = friendlyName;
        }

        public int getValue() {
            return this.value;
        }

        public static ObjectTypes getValueByName(String name) {
            ObjectTypes[] objectTypesArray = ObjectTypes.values();
            int n = objectTypesArray.length;
            int n2 = 0;
            while (n2 < n) {
                ObjectTypes type = objectTypesArray[n2];
                if (type.name().toLowerCase().equals(name.toLowerCase())) {
                    return type;
                }
                ++n2;
            }
            return null;
        }

        public static ObjectTypes getValueByFriendlyName(String friendlyName) {
            ObjectTypes[] objectTypesArray = ObjectTypes.values();
            int n = objectTypesArray.length;
            int n2 = 0;
            while (n2 < n) {
                ObjectTypes type = objectTypesArray[n2];
                if (type.friendlyName.toLowerCase().equals(friendlyName.toLowerCase())) {
                    return type;
                }
                ++n2;
            }
            return null;
        }

        public String getFriendlyName() {
            return this.friendlyName;
        }
    }

    public static enum OutputFileType {
        PDT("PDT", ""),
        PDT_NVAR("NVAR package (PDT + trace)", ""),
        ELF(".elf file", ".elf"),
        MAP(".map file", ".map"),
        IMAGE("Image", ".bin"),
        IMAGE_COMPRESSED("Compressed image", ".bin");

        private String friendlyName;
        private String extension;

        private OutputFileType(String friendlyName, String extension) {
            this.friendlyName = friendlyName;
            this.extension = extension;
        }

        public static OutputFileType getValueByFriendlyName(String friendlyName) {
            OutputFileType[] outputFileTypeArray = OutputFileType.values();
            int n = outputFileTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                OutputFileType type = outputFileTypeArray[n2];
                if (type.getFriendlyName().toLowerCase().equals(friendlyName.toLowerCase())) {
                    return type;
                }
                ++n2;
            }
            return null;
        }

        public static OutputFileType getValueByName(String name) {
            OutputFileType[] outputFileTypeArray = OutputFileType.values();
            int n = outputFileTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                OutputFileType type = outputFileTypeArray[n2];
                if (type.name().toLowerCase().equals(name.toLowerCase())) {
                    return type;
                }
                ++n2;
            }
            return null;
        }

        public String getFriendlyName() {
            return this.friendlyName;
        }

        public String getExtension() {
            return this.extension;
        }
    }

    public static enum PathDialogTarget {
        Include,
        Object,
        BuildScript,
        ComponentLocation,
        OutputPath;

    }

    public static enum PathSaveOption {
        PROJECT(0, "Project"),
        WORKSPACE(1, "Workspace"),
        FULL(2, "Root");

        private int value;
        private String name;

        public String getName() {
            return this.name;
        }

        private PathSaveOption(int val, String name) {
            this.value = val;
            this.name = name;
        }

        public static PathSaveOption getSaveOptionByValue(int val) {
            PathSaveOption[] pathSaveOptionArray = PathSaveOption.values();
            int n = pathSaveOptionArray.length;
            int n2 = 0;
            while (n2 < n) {
                PathSaveOption option = pathSaveOptionArray[n2];
                if (option.value == val) {
                    return option;
                }
                ++n2;
            }
            return null;
        }

        public static PathSaveOption getValueByName(String name) {
            PathSaveOption[] pathSaveOptionArray = PathSaveOption.values();
            int n = pathSaveOptionArray.length;
            int n2 = 0;
            while (n2 < n) {
                PathSaveOption pathSaveOption = pathSaveOptionArray[n2];
                if (pathSaveOption.name.toLowerCase().equals(name.toLowerCase())) {
                    return pathSaveOption;
                }
                ++n2;
            }
            return null;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum PdtMode {
        Manual(1, "Manual selection"),
        Platform(2, "One per compilation environment");

        private int value;
        private String friendlyName;

        private PdtMode(int value, String friendlyName) {
            this.value = value;
            this.friendlyName = friendlyName;
        }

        public int getValue() {
            return this.value;
        }

        public String getFriendlyName() {
            return this.friendlyName;
        }

        public static PdtMode getValueByName(String name) {
            PdtMode[] pdtModeArray = PdtMode.values();
            int n = pdtModeArray.length;
            int n2 = 0;
            while (n2 < n) {
                PdtMode pdtMode = pdtModeArray[n2];
                if (pdtMode.name().toLowerCase().equals(name.toLowerCase())) {
                    return pdtMode;
                }
                ++n2;
            }
            return null;
        }
    }

    public static enum ProjectType {
        FDK("FDK"),
        USER("User");

        private String friendlyName;

        private ProjectType(String friendlyName) {
            this.friendlyName = friendlyName;
        }

        public static ProjectType getValueByFriendlyName(String friendlyName) {
            ProjectType[] projectTypeArray = ProjectType.values();
            int n = projectTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                ProjectType type = projectTypeArray[n2];
                if (type.getFriendlyName().toLowerCase().equals(friendlyName.toLowerCase())) {
                    return type;
                }
                ++n2;
            }
            return null;
        }

        public String getFriendlyName() {
            return this.friendlyName;
        }
    }

    public static enum ReporterFlags {
        BEST(0, "Best (Calibrated if available; Physical otherwise)"),
        CALIBRATED(1, "Calibrated - Calibrated Data"),
        PHYSICAL(2, "Physical - Raw Data");

        private int value;
        private String friendlyName;

        private ReporterFlags(int value, String friendlyName) {
            this.value = value;
            this.friendlyName = friendlyName;
        }

        public int getValue() {
            return this.value;
        }

        public String getFriendlyName() {
            return this.friendlyName;
        }

        public static ReporterFlags getValueByName(String name) {
            ReporterFlags[] reporterFlagsArray = ReporterFlags.values();
            int n = reporterFlagsArray.length;
            int n2 = 0;
            while (n2 < n) {
                ReporterFlags reporterFlag = reporterFlagsArray[n2];
                if (reporterFlag.name().toLowerCase().equals(name.toLowerCase())) {
                    return reporterFlag;
                }
                ++n2;
            }
            return null;
        }

        public static ReporterFlags getValueByFriendlyName(String friendlyName) {
            ReporterFlags[] reporterFlagsArray = ReporterFlags.values();
            int n = reporterFlagsArray.length;
            int n2 = 0;
            while (n2 < n) {
                ReporterFlags reporterFlag = reporterFlagsArray[n2];
                if (reporterFlag.friendlyName.toLowerCase().equals(friendlyName.toLowerCase())) {
                    return reporterFlag;
                }
                ++n2;
            }
            return null;
        }

        public static String[] getNames() {
            ArrayList<String> names = new ArrayList<String>();
            ReporterFlags[] reporterFlagsArray = ReporterFlags.values();
            int n = reporterFlagsArray.length;
            int n2 = 0;
            while (n2 < n) {
                ReporterFlags reporterFlag = reporterFlagsArray[n2];
                names.add(reporterFlag.name());
                ++n2;
            }
            return names.toArray(new String[names.size()]);
        }

        public static String[] getFriendlyNames() {
            ArrayList<String> friendlyNames = new ArrayList<String>();
            ReporterFlags[] reporterFlagsArray = ReporterFlags.values();
            int n = reporterFlagsArray.length;
            int n2 = 0;
            while (n2 < n) {
                ReporterFlags reporterFlag = reporterFlagsArray[n2];
                friendlyNames.add(reporterFlag.friendlyName);
                ++n2;
            }
            return friendlyNames.toArray(new String[friendlyNames.size()]);
        }
    }

    public static enum ReportingMode {
        STREAMING(0, "Streaming"),
        EVENT(1, "Event Driven"),
        STATE(2, "State Driven");

        private int value;
        String friendlyName;

        private ReportingMode(int value, String friendlyName) {
            this.value = value;
            this.friendlyName = friendlyName;
        }

        public int getValue() {
            return this.value;
        }

        public static ReportingMode getValueByFriendlyName(String name) {
            ReportingMode[] reportingModeArray = ReportingMode.values();
            int n = reportingModeArray.length;
            int n2 = 0;
            while (n2 < n) {
                ReportingMode type = reportingModeArray[n2];
                if (type.friendlyName.toLowerCase().equals(name.toLowerCase())) {
                    return type;
                }
                ++n2;
            }
            return null;
        }

        public static String[] getFriendlyNames() {
            ArrayList<String> names = new ArrayList<String>();
            ReportingMode[] reportingModeArray = ReportingMode.values();
            int n = reportingModeArray.length;
            int n2 = 0;
            while (n2 < n) {
                ReportingMode mode = reportingModeArray[n2];
                names.add(mode.getFriendlyName());
                ++n2;
            }
            return names.toArray(new String[names.size()]);
        }

        public String getFriendlyName() {
            return this.friendlyName;
        }
    }

    public static enum SensitivityTypes {
        UINT8(0, 8),
        UINT16(1, 16),
        UINT24(2, 24),
        UINT32(3, 32);

        private int value;
        private int bits;

        private SensitivityTypes(int value, int bits) {
            this.value = value;
            this.bits = bits;
        }

        public int getValue() {
            return this.value;
        }

        public int getBits() {
            return this.bits;
        }

        public static SensitivityTypes getValueByName(String name) {
            SensitivityTypes[] sensitivityTypesArray = SensitivityTypes.values();
            int n = sensitivityTypesArray.length;
            int n2 = 0;
            while (n2 < n) {
                SensitivityTypes sensitivityType = sensitivityTypesArray[n2];
                if (sensitivityType.name().toLowerCase().equals(name.toLowerCase())) {
                    return sensitivityType;
                }
                ++n2;
            }
            return null;
        }

        public static String[] getNames() {
            ArrayList<String> names = new ArrayList<String>();
            SensitivityTypes[] sensitivityTypesArray = SensitivityTypes.values();
            int n = sensitivityTypesArray.length;
            int n2 = 0;
            while (n2 < n) {
                SensitivityTypes sensitivityType = sensitivityTypesArray[n2];
                names.add(sensitivityType.name());
                ++n2;
            }
            return names.toArray(new String[names.size()]);
        }

        public static SensitivityTypes getSensitivityTypeByValue(int value) {
            SensitivityTypes[] sensitivityTypesArray = SensitivityTypes.values();
            int n = sensitivityTypesArray.length;
            int n2 = 0;
            while (n2 < n) {
                SensitivityTypes sensitivityTtype = sensitivityTypesArray[n2];
                if (sensitivityTtype.value == value) {
                    return sensitivityTtype;
                }
                ++n2;
            }
            return null;
        }
    }

    public static enum SensorAttributes {
        EVENT_DRIVEN(0, "Event-driven"),
        STATE_DRIVEN(1, "State-driven"),
        WAKE_FROM_CS(2, "Wake from CS"),
        ALWAYS_ON(3, "Always On"),
        OVERRIDE_SENSOR_STRINGS(4, "Overridable Strings");

        private int value;
        private String friendlyName;

        private SensorAttributes(int value, String friendlyName) {
            this.value = value;
            this.friendlyName = friendlyName;
        }

        public int getValue() {
            return this.value;
        }

        public String getFriendlyName() {
            return this.friendlyName;
        }

        public static SensorAttributes getValueByName(String name) {
            SensorAttributes[] sensorAttributesArray = SensorAttributes.values();
            int n = sensorAttributesArray.length;
            int n2 = 0;
            while (n2 < n) {
                SensorAttributes att = sensorAttributesArray[n2];
                if (att.name().toLowerCase().equals(name.toLowerCase())) {
                    return att;
                }
                ++n2;
            }
            return null;
        }

        public static String[] getFriendlyNames() {
            ArrayList<String> names = new ArrayList<String>();
            SensorAttributes[] sensorAttributesArray = SensorAttributes.values();
            int n = sensorAttributesArray.length;
            int n2 = 0;
            while (n2 < n) {
                SensorAttributes att = sensorAttributesArray[n2];
                names.add(att.getFriendlyName());
                ++n2;
            }
            return names.toArray(new String[names.size()]);
        }

        public static String[] getNames() {
            ArrayList<String> names = new ArrayList<String>();
            SensorAttributes[] sensorAttributesArray = SensorAttributes.values();
            int n = sensorAttributesArray.length;
            int n2 = 0;
            while (n2 < n) {
                SensorAttributes att = sensorAttributesArray[n2];
                names.add(att.name());
                ++n2;
            }
            return names.toArray(new String[names.size()]);
        }

        public static SensorAttributes getSensorAttributeByValue(int value) {
            SensorAttributes[] sensorAttributesArray = SensorAttributes.values();
            int n = sensorAttributesArray.length;
            int n2 = 0;
            while (n2 < n) {
                SensorAttributes att = sensorAttributesArray[n2];
                if (att.value == value) {
                    return att;
                }
                ++n2;
            }
            return null;
        }
    }

    public static enum SettingsPrompt {
        Yes(0),
        No(1),
        Prompt(2);

        private int value;

        private SettingsPrompt(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum SystemEvents {
        WORKITEM_RESULT(1, "Work Item Result"),
        TIMER_EXPIRED(2, "Timer Expired");

        private int value;
        private String friendlyName;

        private SystemEvents(int value, String friendlyName) {
            this.value = value;
            this.friendlyName = friendlyName;
        }

        public int getValue() {
            return this.value;
        }

        public String getFriendlyName() {
            return this.friendlyName;
        }

        public static SystemEvents getValueByName(String name) {
            SystemEvents[] systemEventsArray = SystemEvents.values();
            int n = systemEventsArray.length;
            int n2 = 0;
            while (n2 < n) {
                SystemEvents event = systemEventsArray[n2];
                if (event.name().toLowerCase().equals(name.toLowerCase())) {
                    return event;
                }
                ++n2;
            }
            return null;
        }

        public static String[] getFriendlyNames() {
            ArrayList<String> names = new ArrayList<String>();
            SystemEvents[] systemEventsArray = SystemEvents.values();
            int n = systemEventsArray.length;
            int n2 = 0;
            while (n2 < n) {
                SystemEvents event = systemEventsArray[n2];
                names.add(event.getFriendlyName());
                ++n2;
            }
            return names.toArray(new String[names.size()]);
        }

        public static String[] getNames() {
            ArrayList<String> names = new ArrayList<String>();
            SystemEvents[] systemEventsArray = SystemEvents.values();
            int n = systemEventsArray.length;
            int n2 = 0;
            while (n2 < n) {
                SystemEvents event = systemEventsArray[n2];
                names.add(event.name());
                ++n2;
            }
            return names.toArray(new String[names.size()]);
        }

        public static SystemEvents getSystemEventByValue(int value) {
            SystemEvents[] systemEventsArray = SystemEvents.values();
            int n = systemEventsArray.length;
            int n2 = 0;
            while (n2 < n) {
                SystemEvents event = systemEventsArray[n2];
                if (event.value == value) {
                    return event;
                }
                ++n2;
            }
            return null;
        }
    }

    public static enum TroubleshooterCriticalLevel {
        Undefined(3),
        Critical(2),
        Medium(1),
        Low(0);

        private int value;

        private TroubleshooterCriticalLevel(int val) {
            this.value = val;
        }

        public int getValue() {
            return this.value;
        }

        public static TroubleshooterCriticalLevel getValueByNum(int num) {
            TroubleshooterCriticalLevel[] troubleshooterCriticalLevelArray = TroubleshooterCriticalLevel.values();
            int n = troubleshooterCriticalLevelArray.length;
            int n2 = 0;
            while (n2 < n) {
                TroubleshooterCriticalLevel level = troubleshooterCriticalLevelArray[n2];
                if (level.value == num) {
                    return level;
                }
                ++n2;
            }
            return null;
        }
    }

    public static enum TroubleshooterImpact {
        RUNNING,
        DEBUGGING,
        COMPILATION,
        DOC;

    }

    public static enum VersionField {
        MajorVersion("MAJOR"),
        MinorVersion("MINOR"),
        FwRangeVersion("FW_RANGE"),
        FdkBuildVersion("BUILD");

        private String name;

        private VersionField(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

