/*
 * Decompiled with CFR 0.152.
 */
package manager.utils;

import java.io.File;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.ArrayList;
import manager.utils.ManagerFileUtils;

public class ManagerExternalLibraryUtils {
    public static void importStaticLibrary(String libraryPath, String destPath, String gccLocation) throws Exception {
        File targetDir = new File(destPath);
        if (!targetDir.exists()) {
            targetDir.mkdir();
        }
        File source = new File(libraryPath);
        File newAFile = new File(String.valueOf(targetDir.getPath()) + "/" + source.getName());
        if (newAFile.exists()) {
            newAFile.delete();
        }
        Files.copy(source.toPath(), newAFile.toPath(), new CopyOption[0]);
        int res = -1;
        String arPath = String.valueOf(gccLocation) + "/bin/i486-elf-ar.exe";
        Process process = Runtime.getRuntime().exec(String.valueOf(arPath) + " x " + newAFile.getAbsolutePath(), null, new File(targetDir.getAbsolutePath()));
        res = process.waitFor();
        if (res != 0) {
            throw new Exception("Failed to load the .a file");
        }
        newAFile.delete();
    }

    public static void exportStaticLibrary(String folderName, String libraryPath, String hFileSourcePath, String hFileName, String oFilesDirPath, ArrayList<String> oFileNames, String gccLocation) throws Exception {
        File newLibrary = new File(libraryPath);
        if (newLibrary.exists()) {
            newLibrary.delete();
        }
        int res = -1;
        String arPath = String.valueOf(gccLocation) + "/bin/i486-elf-ar.exe";
        String command = String.valueOf(arPath) + " cr " + "\"" + libraryPath + "\"";
        for (String fileName : oFileNames) {
            File ofFile = new File(String.valueOf(oFilesDirPath) + File.separator + fileName + ".o");
            if (!ofFile.exists()) {
                throw new Exception("No such file: " + ofFile.getAbsolutePath());
            }
            command = String.valueOf(command) + " \"" + ofFile.getAbsolutePath() + "\"";
        }
        Process process = Runtime.getRuntime().exec(command);
        res = process.waitFor();
        if (res != 0) {
            throw new Exception("Failed to create the .a file");
        }
        if (!hFileSourcePath.isEmpty()) {
            ManagerFileUtils.copyFile(new File(hFileSourcePath), new File(String.valueOf(folderName) + File.separator + hFileName + ".h"));
        }
    }
}

