/*
 * Decompiled with CFR 0.152.
 */
package manager.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Scanner;
import manager.common.PathDetails;
import manager.configure.Platform;
import manager.project.ISSProjectData;
import manager.utils.ManagerConfigs;
import manager.utils.ManagerEnums;
import manager.utils.ManagerUtils;
import manager.utils.ManagerXMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ManagerFileUtils {
    public static final String SENSORS_DEFINITIONS_FILE_NAME = "ISS_Sensor_Definitions.xml";
    public static final String BUILD_SETTINGS_FILE_NAME = "BuildSettings.txt";
    public static final String PROJECT_SETTINGS_FILE_NAME = "ISSProjectSettings.xml";
    public static final String PDTS_LOCATION_IN_PROJECT = "/bin/PDTs/";
    public static final String INSTALLED_SENSORS_FILE_NAME = "InstalledSensors.xml";
    public static final String APP_CONFIG_FILE_NAME = "config.xml";

    public static String getUserFDKDir() throws Exception {
        return ManagerUtils.getEnvVar("INTEL_ISS_FDK_USER_DATA");
    }

    public static String getFDKDir() throws Exception {
        return ManagerUtils.getEnvVar("INTEL_ISS_FDK");
    }

    public static String FDK_TOOLS_FOLDER() throws Exception {
        return String.valueOf(ManagerFileUtils.FDK_ECLIPSE_PLUGIN_FOLDER()) + "\\FDKTools\\";
    }

    public static String getUserEclipsePluginFolder() throws Exception {
        return String.valueOf(ManagerFileUtils.getUserFDKDir()) + "\\EclipsePlugin\\";
    }

    public static String getFDKInstalledSensorsFilePath() throws Exception {
        return String.valueOf(ManagerFileUtils.COMMON_INPUT_FOLDER()) + "\\FDKInstalledSensors.xml";
    }

    public static String getImageBuilderBatPath(boolean realPath) throws Exception {
        if (realPath) {
            return String.valueOf(ManagerFileUtils.getFDKDir()) + "\\Tools\\FDKImageBuilder\\FDKImageBuilder.bat";
        }
        return "<INTEL_ISS_FDK>\\Tools\\FDKImageBuilder\\FDKImageBuilder.bat";
    }

    public static String getJavaPath(boolean realPath) throws Exception {
        String javaPath = realPath ? ManagerUtils.getEnvVar("FDK_JAVA_HOME") : "<FDK_JAVA_HOME>";
        if (javaPath != null) {
            if (!javaPath.toLowerCase().endsWith("bin")) {
                javaPath = String.valueOf(javaPath) + "/bin";
            }
            javaPath = String.valueOf(javaPath) + "/";
        } else {
            javaPath = "";
        }
        return String.valueOf(javaPath) + "java.exe";
    }

    public static void createUserInstalledSensorsFolder() throws Exception {
        new File(ManagerFileUtils.getUserInstalledSensorsFolder()).mkdir();
        for (Platform platform : ManagerConfigs.getPlatforms()) {
            if (platform.isDeprecated()) continue;
            new File(ManagerFileUtils.getUserInstalledBinFolder(platform)).mkdirs();
            new File(ManagerFileUtils.getUserInstalledincludesFolder(platform)).mkdirs();
        }
        ManagerXMLUtils.createXMLFile(ManagerFileUtils.getUserInstalledSensorsFilePath(), "Sensors");
        Document doc = ManagerXMLUtils.getNewDocument();
        Element sensorsNode = doc.createElement("Sensors");
        for (Platform platform : ManagerConfigs.getPlatforms()) {
            if (platform.isDeprecated()) continue;
            Element platformElement = doc.createElement("Platform");
            platformElement.setAttribute("ISSVersion", platform.getName());
            sensorsNode.appendChild(platformElement);
        }
        doc.appendChild(sensorsNode);
        ManagerXMLUtils.createXMLFile(ManagerFileUtils.getUserInstalledSensorsFilePath(), doc);
    }

    public static String getFDKInstalledSensorsFilePath(Platform platform, String fdkToolsDir) throws Exception {
        return String.valueOf(ManagerFileUtils.FDK_TOOLS_VERSION_FOLDER(platform, fdkToolsDir, ManagerEnums.CompilationMode.Release)) + "\\KnownIntelSensors.xml";
    }

    public static String getKnownIntelSensorsFilePath(Platform platform, String fdkToolsDir, String version) throws Exception {
        return String.valueOf(fdkToolsDir) + "\\versions\\" + platform.getName() + "\\" + version + "\\KnownIntelSensors.xml";
    }

    public static String FDK_TOOLS_VERSION_FOLDER(Platform platform) throws Exception {
        return String.valueOf(ManagerFileUtils.FDK_TOOLS_FOLDER()) + "versions\\" + platform.getName();
    }

    public static String FDK_TOOLS_VERSION_FOLDER(Platform platform, String fdkToolsDir, ManagerEnums.CompilationMode mode) throws Exception {
        if (fdkToolsDir == null) {
            return ManagerFileUtils.FDK_TOOLS_VERSION_FOLDER(platform);
        }
        String ret = String.valueOf(fdkToolsDir) + "\\versions\\" + platform.getISSFolderName();
        if (mode == ManagerEnums.CompilationMode.Debug) {
            return String.valueOf(ret) + "_" + mode.getFriendlyName();
        }
        return ret;
    }

    public static String getUserInstalledSensorsFolder() throws Exception {
        return String.valueOf(ManagerFileUtils.getUserEclipsePluginFolder()) + "UserInstalledSensors";
    }

    public static String getUserInstalledSensorsFilePath() throws Exception {
        return ManagerFileUtils.getUserInstalledSensorsFilePath(ManagerFileUtils.getUserInstalledSensorsFolder());
    }

    public static String getUserInstalledSensorsFilePath(String installedFolder) throws Exception {
        return String.valueOf(installedFolder) + "\\" + INSTALLED_SENSORS_FILE_NAME;
    }

    public static String COMMON_INPUT_FOLDER() throws Exception {
        return String.valueOf(ManagerFileUtils.FDK_ECLIPSE_PLUGIN_FOLDER()) + "\\Input\\Common";
    }

    public static String FDK_ECLIPSE_PLUGIN_FOLDER() throws Exception {
        return String.valueOf(ManagerFileUtils.getFDKDir()) + "\\Tools\\EclipsePlugin";
    }

    public static String FDK_ECLIPSE_CONFIG_FOLDER() throws Exception {
        return String.valueOf(ManagerFileUtils.FDK_ECLIPSE_PLUGIN_FOLDER()) + "\\Configure";
    }

    public static String FDK_FULL_BUILD_SCRIPT() throws Exception {
        return String.valueOf(ManagerFileUtils.FDK_ECLIPSE_PLUGIN_FOLDER()) + "\\FullBuildTools.bat";
    }

    public static String FDK_SIMICS_FOLDER() throws Exception {
        return String.valueOf(ManagerFileUtils.getFDKDir()) + "\\Simulator";
    }

    public static String FDK_DEF_BUILD_SCRIPT() throws Exception {
        return String.valueOf(ManagerFileUtils.FDK_ECLIPSE_PLUGIN_FOLDER()) + "\\FDKTools.bat";
    }

    public static String getISSProjectSettingsFilePath(ISSProjectData projData) throws Exception {
        return String.valueOf(ManagerFileUtils.getProjectSettingsFolder(projData)) + "\\" + PROJECT_SETTINGS_FILE_NAME;
    }

    public static String getProjectSettingsFolder(ISSProjectData projData) {
        if (projData.getProjectType() == ManagerEnums.ProjectType.FDK) {
            return String.valueOf(projData.getProjectPath()) + "\\settings";
        }
        return String.valueOf(projData.getUserProjectLocation()) + "\\settings";
    }

    public static String DEFAULT_GCC_DIR() throws Exception {
        return String.valueOf(ManagerFileUtils.FDK_ECLIPSE_PLUGIN_FOLDER()) + "\\FDKTools\\BuildTools\\gcc";
    }

    public static String getPdtEditorFolderPath(Platform platform) throws Exception {
        return String.valueOf(ManagerFileUtils.getFDKDir()) + "\\Tools\\PDTEditor\\" + platform.getName();
    }

    public static String getIntelSensorDefinitionsFilePath(Platform platform) throws Exception {
        return String.valueOf(ManagerFileUtils.getPdtEditorFolderPath(platform)) + "\\" + SENSORS_DEFINITIONS_FILE_NAME;
    }

    public static String getUserSensorDefinitionsFilePath() throws Exception {
        return String.valueOf(ManagerFileUtils.getUserEclipsePluginFolder()) + "\\" + SENSORS_DEFINITIONS_FILE_NAME;
    }

    public static String VERSIONS_FILE() {
        return "versions.txt";
    }

    public static String FW_LIB_VERSION_FILE(Platform platform, String fm) throws Exception {
        return String.valueOf(ManagerFileUtils.FDK_TOOLS_VERSION_FOLDER(platform)) + "\\" + fm + "\\fragments\\fdk_lib_gen.mk";
    }

    public static String INCLUDE_FOLDER(Platform platform, String fm) throws Exception {
        return String.valueOf(ManagerFileUtils.FDK_TOOLS_VERSION_FOLDER(platform)) + "\\" + fm + "\\include";
    }

    public static String INTEL_SENSORS_FOLDER(Platform platform, String fm) throws Exception {
        return String.valueOf(ManagerFileUtils.FDK_TOOLS_VERSION_FOLDER(platform)) + "\\" + fm + "\\sensors";
    }

    public static String INTEL_ALGORITHMS_FOLDER(Platform platform, String fm) throws Exception {
        return String.valueOf(ManagerFileUtils.FDK_TOOLS_VERSION_FOLDER(platform)) + "\\" + fm + "\\algorithms";
    }

    public static String getGeneralSettingsFilePath() throws Exception {
        return String.valueOf(ManagerFileUtils.getUserEclipsePluginFolder()) + "GeneralSettings.xml";
    }

    public static String TEMPLATES_FOLDER() throws Exception {
        return String.valueOf(ManagerFileUtils.COMMON_INPUT_FOLDER()) + "\\templates";
    }

    public static String getUserInstalledBinFolder(Platform platform) throws Exception {
        return String.valueOf(ManagerFileUtils.getUserInstalledSensorsFolder()) + "\\bin\\" + platform.getName();
    }

    public static String getUserInstalledincludesFolder(Platform platform) throws Exception {
        return String.valueOf(ManagerFileUtils.getUserInstalledSensorsFolder()) + "\\includes\\" + platform.getName();
    }

    public static String getFDKFlagLibraryFolder() throws Exception {
        return String.valueOf(ManagerFileUtils.COMMON_INPUT_FOLDER()) + "\\FDKFlagsLibrary";
    }

    public static String getFDKFlagLibraryFilePath(Platform platform) throws Exception {
        return String.valueOf(ManagerFileUtils.getFDKFlagLibraryFolder()) + "\\" + platform.getName() + ".txt";
    }

    public static String getHostFwLoadFolder() throws Exception {
        return String.valueOf(ManagerFileUtils.COMMON_INPUT_FOLDER()) + "\\Host_Load_Fw";
    }

    public static String getHostFwLoadLicense() throws Exception {
        return String.valueOf(ManagerFileUtils.getHostFwLoadFolder()) + "\\HLF_license_agremeent.html";
    }

    public static HashMap<ManagerEnums.OutputFileType, PathDetails> getDefaultOrEmptyOutputPaths(Boolean empty, String projectPath, Platform platform, ManagerEnums.CompilationMode compilationMode) {
        HashMap<ManagerEnums.OutputFileType, PathDetails> outputPaths = new HashMap<ManagerEnums.OutputFileType, PathDetails>();
        String workspacePath = null;
        if (!empty.booleanValue()) {
            workspacePath = new File(projectPath).getParent();
        }
        PathDetails imagePathDetails = empty != false ? null : new PathDetails("bin\\" + platform.getName().toLowerCase() + "\\" + compilationMode.getFriendlyName() + "\\iss.bin", ManagerEnums.PathSaveOption.PROJECT, projectPath, workspacePath);
        outputPaths.put(ManagerEnums.OutputFileType.IMAGE, imagePathDetails);
        PathDetails imageCompressedPathDetails = empty != false ? null : new PathDetails("bin\\" + platform.getName().toLowerCase() + "\\" + compilationMode.getFriendlyName() + "\\issC.bin", ManagerEnums.PathSaveOption.PROJECT, projectPath, workspacePath);
        outputPaths.put(ManagerEnums.OutputFileType.IMAGE_COMPRESSED, imageCompressedPathDetails);
        PathDetails pdtPathDetails = empty != false ? null : new PathDetails((String.valueOf(PDTS_LOCATION_IN_PROJECT.replaceFirst("/", "")) + platform.getName() + "_PDT\\" + platform.getName() + "_PDT.bin").replace("/", "\\"), ManagerEnums.PathSaveOption.PROJECT, projectPath, workspacePath);
        outputPaths.put(ManagerEnums.OutputFileType.PDT, pdtPathDetails);
        PathDetails pdtNvarPathDetails = empty != false ? null : new PathDetails((String.valueOf(PDTS_LOCATION_IN_PROJECT.replaceFirst("/", "")) + platform.getName() + "_PDT\\" + platform.getName() + "_PDT_NVAR.bin").replace("/", "\\"), ManagerEnums.PathSaveOption.PROJECT, projectPath, workspacePath);
        outputPaths.put(ManagerEnums.OutputFileType.PDT_NVAR, pdtNvarPathDetails);
        boolean islkfOrTgl = platform.getName().equals("LKF") || platform.getName().equals("TGL");
        String mapName = islkfOrTgl ? "kernel.map" : "app0.map";
        String elfName = islkfOrTgl ? "kernel.elf" : "app0.elf";
        String prefix = "bin\\" + platform.getName().toLowerCase() + "\\" + compilationMode.getFriendlyName() + "\\";
        PathDetails mapPathDetails = empty != false ? null : new PathDetails(String.valueOf(prefix) + mapName, ManagerEnums.PathSaveOption.PROJECT, projectPath, workspacePath);
        outputPaths.put(ManagerEnums.OutputFileType.MAP, mapPathDetails);
        PathDetails elfPathDetails = empty != false ? null : new PathDetails(String.valueOf(prefix) + elfName, ManagerEnums.PathSaveOption.PROJECT, projectPath, workspacePath);
        outputPaths.put(ManagerEnums.OutputFileType.ELF, elfPathDetails);
        return outputPaths;
    }

    public static void writeFile(String fullPath, String content) throws Exception {
        PrintWriter writer = new PrintWriter(fullPath);
        writer.print(content);
        writer.close();
        File f = new File(fullPath);
        f.setReadOnly();
    }

    public static void createFolder(String path) throws Exception {
        File newSensorFolder = new File(path);
        if (!newSensorFolder.exists() && !newSensorFolder.mkdirs()) {
            throw new Exception("Could not create the folder.");
        }
    }

    public static boolean deleteFileOrDirectoryWithContent(File f) {
        boolean res = true;
        if (!f.isDirectory()) {
            if (f.exists()) {
                f.setWritable(true);
                System.gc();
                res = f.delete();
            }
            return res;
        }
        File[] files = f.listFiles();
        if (files != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isDirectory()) {
                    res = ManagerFileUtils.deleteFileOrDirectoryWithContent(file);
                } else {
                    f.setWritable(true);
                    System.gc();
                    res = file.delete();
                }
                ++n2;
            }
        }
        if (res) {
            f.setWritable(true);
            System.gc();
            res = f.delete();
        }
        return res;
    }

    public static boolean fastDeleteFileOrDirectory(File f) {
        boolean res = true;
        if (!f.isDirectory()) {
            if (f.exists() && !(res = f.delete())) {
                f.setWritable(true);
                System.gc();
                res = f.delete();
            }
            return res;
        }
        File[] files = f.listFiles();
        if (files != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isDirectory()) {
                    res = ManagerFileUtils.fastDeleteFileOrDirectory(file);
                } else {
                    res = file.delete();
                    if (!res) {
                        file.setWritable(true);
                        System.gc();
                        res = file.delete();
                    }
                }
                ++n2;
            }
        }
        if (res && !(res = f.delete())) {
            f.setWritable(true);
            System.gc();
            res = f.delete();
        }
        return res;
    }

    public static boolean renamePdtFiles(File newLocation, String oldName, String newName, boolean renameTheContaingFolder) {
        boolean res = true;
        File[] files = newLocation.listFiles();
        if (files != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (res) {
                    if (file.getName().equals(String.valueOf(oldName) + ".bin")) {
                        res = file.renameTo(new File(newLocation, String.valueOf(newName) + ".bin"));
                    } else if (file.getName().equals(String.valueOf(oldName) + "_NVAR.bin")) {
                        res = file.renameTo(new File(newLocation, String.valueOf(newName) + "_NVAR.bin"));
                    }
                }
                ++n2;
            }
        }
        if (res && renameTheContaingFolder && newLocation.getName().equals(oldName)) {
            res = newLocation.renameTo(new File(newLocation.getParent(), newName));
        }
        return res;
    }

    public static String readFile(File f) throws Exception {
        try {
            Scanner scanner = new Scanner(f);
            String text = scanner.useDelimiter("\\A").next();
            scanner.close();
            return text;
        }
        catch (FileNotFoundException e) {
            throw new Exception("Could not read the file. \n  " + (e != null && e.getMessage() != null ? "Exception: " + e.getMessage().replaceAll("\n  ", "\n    ") : ""));
        }
    }

    public static String readFile(String path) throws Exception {
        String source;
        File inputFile = new File(path);
        try (FileInputStream sourceStream = new FileInputStream(inputFile);){
            source = ManagerUtils.readStreamAsText(sourceStream);
        }
        return source;
    }

    public static ArrayList<String> getFilesListRecursive(File root) {
        ArrayList<String> filesList = new ArrayList<String>();
        File[] files = root.listFiles();
        if (files != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (!file.isDirectory()) {
                    filesList.add(file.getAbsolutePath());
                } else {
                    filesList.addAll(ManagerFileUtils.getFilesListRecursive(file));
                }
                ++n2;
            }
        }
        return filesList;
    }

    public static void copyFile(File suorceFile, File destFile) throws Exception {
        FileInputStream in = null;
        OutputStream out = null;
        try {
            try {
                int len;
                in = new FileInputStream(suorceFile);
                out = new FileOutputStream(destFile);
                byte[] buf = new byte[1024];
                while ((len = ((InputStream)in).read(buf)) > 0) {
                    out.write(buf, 0, len);
                }
            }
            catch (Exception e) {
                String error = ManagerUtils.parseException(e);
                throw new Exception("Could not copy the file. " + error);
            }
        }
        finally {
            try {
                if (in != null) {
                    ((InputStream)in).close();
                }
            }
            finally {
                if (out != null) {
                    out.close();
                }
            }
        }
    }

    public static void copyDirectory(File source, File dest) throws Exception {
        if (source.isDirectory()) {
            String[] children;
            if (!dest.exists()) {
                dest.mkdirs();
            }
            if ((children = source.list()) != null) {
                String[] stringArray = children;
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    String element = stringArray[n2];
                    ManagerFileUtils.copyDirectory(new File(source, element), new File(dest, element));
                    ++n2;
                }
            }
        } else {
            ManagerFileUtils.copyFile(source, dest);
        }
    }

    public static boolean supportFullBuild() {
        try {
            File fullBuildTool = new File(ManagerFileUtils.FDK_FULL_BUILD_SCRIPT());
            if (fullBuildTool.exists()) {
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public static boolean supportSimicsRun() {
        try {
            File SimicsFolder = new File(ManagerFileUtils.FDK_SIMICS_FOLDER());
            if (SimicsFolder.exists()) {
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public static boolean isAppFolder(String folderName, String projLocation) {
        String configFileS = ManagerFileUtils.getAppConfigFile(folderName, projLocation);
        if (configFileS == null || configFileS.isEmpty()) {
            return false;
        }
        File configFile = new File(configFileS);
        if (!configFile.exists()) {
            return false;
        }
        try {
            Document doc = ManagerXMLUtils.getXMLDocument(configFile);
            NodeList nl = doc.getElementsByTagName("ISSApplication");
            if (nl != null && nl.getLength() > 0) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static String getAppConfigFile(String folderName, String projLoc) {
        String folder = String.valueOf(projLoc) + File.separator + folderName;
        return String.valueOf(folder) + File.separator + APP_CONFIG_FILE_NAME;
    }

    public static String getFullBuildFw(Platform platform) throws Exception {
        return String.valueOf(ManagerFileUtils.FDK_TOOLS_VERSION_FOLDER(platform)) + File.separator + "FW";
    }

    public static String APP_TEMPLATES_FOLDER() throws Exception {
        return String.valueOf(ManagerFileUtils.COMMON_INPUT_FOLDER()) + File.separator + "app_templates";
    }

    public static String getPackageInstallLocation() {
        try {
            String file = String.valueOf(ManagerFileUtils.getUserFDKDir()) + File.separator + "package";
            if (!new File(file).exists()) {
                new File(file).mkdirs();
            }
            return file;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getTempFolder() {
        try {
            String filePath = String.valueOf(ManagerFileUtils.getUserFDKDir()) + File.separator + "temp";
            File file = new File(filePath);
            if (!file.exists()) {
                if (file.mkdirs()) {
                    return filePath;
                }
                throw new Exception("Can not create folder : " + filePath);
            }
            return filePath;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getInstallTempFolder() {
        return String.valueOf(ManagerFileUtils.getTempFolder()) + File.separator + "install";
    }

    public static String getExportTempFolder() {
        return String.valueOf(ManagerFileUtils.getTempFolder()) + File.separator + "export";
    }

    public static String getEncryptedFolder() throws Exception {
        File encryptedFolder = new File(String.valueOf(ManagerFileUtils.getUserFDKDir()) + File.separator + "Encyption");
        if (!encryptedFolder.exists()) {
            ManagerFileUtils.createFolderNotExist(encryptedFolder);
        }
        return encryptedFolder.getCanonicalPath();
    }

    public static String getPackageKeyFolderPath() throws Exception {
        return ManagerFileUtils.getPackageKeyFolder().getCanonicalPath();
    }

    public static File getPackageKeyFolder() throws Exception {
        File packageKeyFolder = new File(String.valueOf(ManagerFileUtils.getEncryptedFolder()) + File.separator + "packageKey");
        if (!packageKeyFolder.exists()) {
            ManagerFileUtils.createFolderNotExist(packageKeyFolder);
        }
        return packageKeyFolder;
    }

    private static String createFolderNotExist(File folder) {
        try {
            if (!folder.exists()) {
                ManagerFileUtils.createFolder(folder.getCanonicalPath());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return folder.getAbsolutePath();
    }
}

