/*
 * Decompiled with CFR 0.152.
 */
package manager.utils;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import manager.WinRegistry;
import manager.configure.Platform;
import manager.sensor.Sensor;
import manager.sensor.SensorDataWrapper;
import manager.utils.ManagerConfigs;
import manager.utils.ManagerEnums;
import manager.utils.ManagerFileUtils;

public class ManagerUtils {
    private static final Pattern IP_Pattern = Pattern.compile("^(([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.){3}([01]?\\d\\d?|2[0-4]\\d|25[0-5])$");
    private static String _fdkBuildVersion = "";

    public static boolean isValidIP(String ip) {
        return IP_Pattern.matcher(ip).matches();
    }

    public static boolean isHexadecimal(String text) {
        if (text.trim().isEmpty()) {
            return false;
        }
        try {
            int num = Integer.parseInt(text, 16);
            return num >= 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String getEnvVar(String varName) throws Exception {
        String envVar = WinRegistry.readString(-2147483647, "Environment", varName);
        if (envVar == null) {
            envVar = WinRegistry.readString(-2147483646, "Environment", varName);
        }
        if (envVar == null) {
            envVar = System.getenv(varName);
        }
        return envVar;
    }

    public static <T> ArrayList<T> sortSensorsHashMapByValues(ArrayList<T> sensorsList) {
        if (sensorsList == null || sensorsList.size() == 0) {
            return sensorsList;
        }
        Comparator<Sensor> compare = sensorsList.get(0) instanceof Sensor ? new Sensor.SensorComparator() : new SensorDataWrapper.DataWrapperComparator();
        ArrayList<T> copyOfSensorsList = new ArrayList<T>();
        ArrayList<Object> sortedSensorList = new ArrayList<Object>();
        copyOfSensorsList.addAll(sensorsList);
        ArrayList<String> mapKeys = new ArrayList<String>();
        ArrayList mapValuesOpened = new ArrayList();
        for (Object sensor : copyOfSensorsList) {
            if (sensor instanceof Sensor) {
                mapKeys.add(String.valueOf(((Sensor)sensor).getSensorData().getFileName()) + " " + (Object)((Object)((Sensor)sensor).getSensorData().getOwner()));
            } else if (sensor instanceof SensorDataWrapper) {
                mapKeys.add(String.valueOf(((SensorDataWrapper)sensor).getFileName()) + " " + (Object)((Object)((SensorDataWrapper)sensor).getOwner()));
            }
            mapValuesOpened.add(sensor);
        }
        Collections.sort(mapValuesOpened, compare);
        block1: for (Object val : mapValuesOpened) {
            boolean breakWhile = false;
            for (String key : mapKeys) {
                for (Object sensor : copyOfSensorsList) {
                    SensorDataWrapper sdw;
                    String mapKey = null;
                    if (sensor instanceof Sensor) {
                        sdw = ((Sensor)sensor).getSensorData();
                        mapKey = String.valueOf(sdw.getFileName()) + " " + (Object)((Object)sdw.getOwner());
                    } else {
                        sdw = (SensorDataWrapper)sensor;
                        mapKey = String.valueOf(sdw.getFileName()) + " " + (Object)((Object)sdw.getOwner());
                    }
                    if (!mapKey.equals(key) || compare.compare((Sensor)sensor, (Sensor)val) != 0) continue;
                    if (sensor instanceof Sensor) {
                        sortedSensorList.add(new Sensor(((Sensor)val).getSensorData()));
                    } else {
                        sortedSensorList.add(SensorDataWrapper.clone((SensorDataWrapper)val));
                    }
                    copyOfSensorsList.remove(sensor);
                    breakWhile = true;
                    break;
                }
                if (breakWhile) continue block1;
            }
        }
        return sortedSensorList;
    }

    public static String getArgValueFromArgs(String[] args, String argName, boolean hasValue) {
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            if (hasValue) {
                if (arg.toLowerCase().startsWith("-" + argName.toLowerCase() + "=")) {
                    return arg.substring(arg.indexOf("=") + 1);
                }
            } else if (arg.toLowerCase().startsWith("-" + argName.toLowerCase())) {
                return Boolean.TRUE.toString().toLowerCase();
            }
            ++n2;
        }
        if (hasValue) {
            return "";
        }
        return Boolean.FALSE.toString().toLowerCase();
    }

    private static String getVersionFieldFromDefaultVersionsFile(ManagerEnums.VersionField field) throws IOException, Exception {
        File f = new File(String.valueOf(ManagerFileUtils.getFDKDir()) + "\\" + ManagerFileUtils.VERSIONS_FILE());
        FileInputStream fs = new FileInputStream(f);
        BufferedReader buf = new BufferedReader(new InputStreamReader(new DataInputStream(fs)));
        String versionField = "";
        try {
            String line;
            while ((line = buf.readLine()) != null) {
                if (!line.contains(String.valueOf(field.getName()) + ":")) continue;
                versionField = line.replace(String.valueOf(field.getName()) + ":", "").trim();
                break;
            }
        }
        finally {
            if (fs != null) {
                fs.close();
            }
        }
        buf.close();
        return versionField;
    }

    public static String getDefaultBuildFdkVersion() throws IOException, Exception {
        if (_fdkBuildVersion.isEmpty()) {
            _fdkBuildVersion = ManagerUtils.getVersionFieldFromDefaultVersionsFile(ManagerEnums.VersionField.FdkBuildVersion);
        }
        return _fdkBuildVersion;
    }

    public static String getDefaultMajorFdkVersion() throws IOException, Exception {
        return ManagerUtils.getVersionFieldFromDefaultVersionsFile(ManagerEnums.VersionField.MajorVersion);
    }

    public static String getDefaultMinorFdkVersion() throws IOException, Exception {
        return ManagerUtils.getVersionFieldFromDefaultVersionsFile(ManagerEnums.VersionField.MinorVersion);
    }

    public static String getVersionFieldsMajorDotMinorDotFdk(Platform platform) {
        try {
            return String.valueOf(platform.getValue()) + "." + ManagerUtils.getDefaultBuildFdkVersion();
        }
        catch (Exception e) {
            return String.valueOf(platform.getValue()) + ".0";
        }
    }

    public static String getFdkVersion() throws IOException, Exception {
        return String.valueOf(ManagerUtils.getDefaultMajorFdkVersion()) + "." + ManagerUtils.getDefaultMinorFdkVersion() + "." + ManagerUtils.getVersionFieldFromDefaultVersionsFile(ManagerEnums.VersionField.FwRangeVersion) + "." + ManagerUtils.getDefaultBuildFdkVersion();
    }

    public static Platform getPlatformFromString(String platformString) {
        Platform platform;
        block5: {
            platform = null;
            if (platformString == null || platformString.isEmpty()) {
                return null;
            }
            try {
                platform = ManagerConfigs.getPlatformByName(platformString);
                if (platform == null && platformString.contains("\\")) {
                    String ss = platformString.substring(0, platformString.indexOf("\\"));
                    platform = ManagerConfigs.getPlatformByName(ss);
                }
                if (platform != null) break block5;
                List<Platform> platforms = ManagerConfigs.getPlatforms();
                for (Platform plat : platforms) {
                    String lowerPlat = plat.getISSFolderName().toLowerCase();
                    if (!platformString.toLowerCase().startsWith(lowerPlat)) continue;
                    platform = plat;
                    break;
                }
            }
            catch (NullPointerException e) {
                platform = new Platform(platformString.toUpperCase());
            }
        }
        return platform;
    }

    public static String replaceLast(String string, String toReplace, String replacement) {
        int index = string.lastIndexOf(toReplace);
        if (index < 0) {
            return string;
        }
        return String.valueOf(string.substring(0, index)) + replacement + string.substring(index + toReplace.length());
    }

    public static String replaceVarsInPath(String path, Platform platform) throws Exception {
        if (path == null) {
            return null;
        }
        String realPath = path.toLowerCase();
        realPath = realPath.replace("<" + "INTEL_ISS_FDK".toLowerCase() + ">", ManagerFileUtils.getFDKDir());
        realPath = realPath.replace("<" + "FDK_JAVA_HOME".toLowerCase() + ">", ManagerUtils.getEnvVar("FDK_JAVA_HOME"));
        realPath = realPath.replace("<" + "Platform".toLowerCase() + ">", platform.getName());
        return realPath;
    }

    public static ManagerEnums.NAMING_ERROR isLegalIdentifierString(String str, boolean enableSpace) {
        String[] badWords;
        if (str == null || str.length() == 0) {
            return ManagerEnums.NAMING_ERROR.IDENTIFIER_IS_EMPTY;
        }
        if (Character.isDigit(str.charAt(0))) {
            return ManagerEnums.NAMING_ERROR.IDENTIFIER_STARTS_WITH_DIGIT;
        }
        if (!Character.isJavaIdentifierStart(str.charAt(0))) {
            return ManagerEnums.NAMING_ERROR.IDENTIFIER_STARTS_WITH_ILLEGAL_CHAR;
        }
        int i = 0;
        while (i < str.length()) {
            char ch = str.charAt(i);
            if (!Character.isLetterOrDigit(ch) && ch != '_' && (!enableSpace || ch != ' ') || Character.getType(ch) == 4 || Character.getType(ch) == 5) {
                return ManagerEnums.NAMING_ERROR.IDENTIFIER_CONTAINS_NOT_LETTER_DIGIT;
            }
            ++i;
        }
        String[] stringArray = badWords = new String[]{"auto", "break", "case", "char", "continue", "default", "do", "double", "else", "entry", "extern", "float", "for", "goto", "if", "int", "long", "register", "return", "short", "sizeof", "static", "struct", "switch", "typedef", "union", "unsigned", "while", "enum", "void", "const", "signed", "volatile", "_Packed"};
        int n = badWords.length;
        int n2 = 0;
        while (n2 < n) {
            String badWord = stringArray[n2];
            if (str.equals(badWord)) {
                return ManagerEnums.NAMING_ERROR.IDENTIFIER_IS_RESERVED_WORD;
            }
            ++n2;
        }
        return ManagerEnums.NAMING_ERROR.OK;
    }

    public static String readStreamAsText(InputStream in) throws IOException {
        StringBuffer sb = new StringBuffer(8192);
        BufferedReader br = new BufferedReader(new InputStreamReader(in));
        String line = null;
        while ((line = br.readLine()) != null) {
            sb.append(String.valueOf(line) + "\n");
        }
        br.close();
        return sb.toString();
    }

    public static String[] convertStringsListToStringsArray(ArrayList<String> stringsList, boolean sortTheArrary) {
        if (stringsList != null) {
            int index = 0;
            Object[] stringsArray = new String[stringsList.size()];
            for (String str : stringsList) {
                stringsArray[index++] = str;
            }
            if (sortTheArrary) {
                Arrays.sort(stringsArray);
            }
            return stringsArray;
        }
        return null;
    }

    private static int countOccurrenceInString(String stringToSearch, String wholeString) {
        int lastIndex = 0;
        int count = 0;
        while (lastIndex != -1) {
            if ((lastIndex = wholeString.indexOf(stringToSearch, lastIndex)) == -1) continue;
            ++count;
            lastIndex += stringToSearch.length();
        }
        return count;
    }

    public static boolean isComment(String stringToSearch, String wholeString) {
        String[] lines = wholeString.split("\r\n|\r|\n");
        ArrayList<String> comments = new ArrayList<String>();
        Pattern pattern = Pattern.compile("//.*");
        Matcher matcher = pattern.matcher(wholeString);
        while (matcher.find()) {
            comments.add(matcher.group());
            wholeString = wholeString.replace(matcher.group(), "");
        }
        pattern = Pattern.compile("/\\*.*?\\*/", 40);
        matcher = pattern.matcher(wholeString);
        while (matcher.find()) {
            comments.add(matcher.group());
        }
        int countInOrigional = 0;
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (line.contains(stringToSearch)) {
                countInOrigional += ManagerUtils.countOccurrenceInString(stringToSearch, line);
            }
            ++n2;
        }
        int countInComments = 0;
        for (String comment : comments) {
            if (!comment.contains(stringToSearch)) continue;
            countInComments += ManagerUtils.countOccurrenceInString(stringToSearch, comment);
        }
        return countInOrigional <= countInComments;
    }

    public static String parseException(Exception e) {
        String ret = "\n  ";
        if (e != null && e.getMessage() != null) {
            ret = String.valueOf(ret) + "Exception: ";
            ret = String.valueOf(ret) + e.getMessage().replaceAll("\n  ", "\n    ");
        }
        return ret;
    }
}

